/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job;

import oracle.install.commons.base.util.job.JobAppProgressListener;
import oracle.install.commons.base.util.job.JobAppProgressListenerFactory;
import oracle.install.commons.base.util.job.JobApplicationEvent;
import oracle.install.commons.base.util.job.JobApplicationListener;
import oracle.install.commons.base.util.job.bean.JobContext;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Status;

public class JobAppProgressMonitor
implements JobApplicationListener {
    private static JobAppProgressMonitor instance;
    private Resource resource = Application.getInstance().getResource("oracle.install.commons.base.util.job.resource.JobApplicationStringResourceBundle");
    private JobAppProgressListener progressListener = JobAppProgressListenerFactory.getJobAppPgoressListener();

    public static JobAppProgressMonitor getInstance() {
        if (instance == null) {
            instance = new JobAppProgressMonitor();
        }
        return instance;
    }

    private JobAppProgressMonitor() {
    }

    @Override
    public void update(JobApplicationEvent e) {
        JobContext jobContext = e.getJobContext();
        if (e.getType() != null && jobContext != null) {
            switch ((JobApplicationEvent.Type)e.getType()) {
                case CHECKPOINT_COMPLETED: {
                    break;
                }
                case CHECKPOINT_STARTED: {
                    break;
                }
                case JOBS_EXECUTION_COMPLETED: {
                    break;
                }
                case JOBS_EXECUTION_STARTED: {
                    break;
                }
                case JOBS_LIST_MODIFIED: {
                    break;
                }
                case JOBS_LIST_POPULATED: {
                    break;
                }
                case JOBS_XML_GENERATED: {
                    break;
                }
                case JOBS_XML_LOADED: {
                    break;
                }
                case JOBS_XML_LOAD_STARTED: {
                    break;
                }
                case JOB_EXECUTED: {
                    if (jobContext.getCurrentJob() == null || this.progressListener == null) break;
                    Job currentJob = jobContext.getCurrentJob();
                    if (currentJob.getStatus() == Status.FAILED) {
                        this.progressListener.showStatus(this.resource.getString("JobAppProgressMonitor.jobfailed_status", "Execution of {0} failed", jobContext.getCurrentJob().getId()));
                        if (currentJob.getErrorMessages() == null) break;
                        ExceptionManager.advise(currentJob.getErrorMessages());
                        break;
                    }
                    this.progressListener.showStatus(this.resource.getString("JobAppProgressMonitor.jobcompleted_status", "Completed {0} job", jobContext.getCurrentJob().getId()));
                    break;
                }
                case JOB_STARTED: {
                    if (jobContext.getCurrentJob() == null || this.progressListener == null) break;
                    this.progressListener.showStatus(this.resource.getString("JobAppProgressMonitor.jobstarted_status", "Running {0} job", jobContext.getCurrentJob().getId()));
                    break;
                }
                case VARIABLES_LOADED: {
                    break;
                }
                case VARIABLES_LOAD_STARTED: {
                    break;
                }
            }
        }
    }
}

