/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.cli;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.cli.CommandLineArgHelpConstructor;
import oracle.install.commons.base.util.cli.CommandLineArgHelpConstructorImpl;
import oracle.install.commons.base.util.cli.CommandLineArgValidator;
import oracle.install.commons.base.util.cli.CommandLineArgValidatorImpl;
import oracle.install.commons.base.util.cli.CommandLineArgument;
import oracle.install.commons.base.util.cli.CommandLineArguments;

public class CommandLineArgumentHandler {
    private static final Logger logger = Logger.getLogger(CommandLineArgumentHandler.class.getName());
    public static CommandLineArgumentHandler instance;
    public static String supportedCommandLineArgsXML;
    private CommandLineArguments commandLineArguments = new CommandLineArguments();
    private CommandLineArgValidator validator;
    private CommandLineArgHelpConstructor helpManager;

    public static CommandLineArgumentHandler getInstance() {
        if (instance == null) {
            instance = new CommandLineArgumentHandler();
        }
        return instance;
    }

    public static void registerSupportedCommandtArgsXML(String xmlPath) {
        supportedCommandLineArgsXML = xmlPath;
    }

    public static String getSupportedCommandtArgsXML() {
        return supportedCommandLineArgsXML;
    }

    protected CommandLineArgumentHandler() {
        String helpManagerClassName;
        String validatorClassName = System.getProperty(CommandLineArgValidator.class.getName());
        if (validatorClassName != null) {
            try {
                Class<?> clazz = Class.forName(validatorClassName);
                this.validator = (CommandLineArgValidator)clazz.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to create instance of command line args validator class:" + validatorClassName);
            }
        } else {
            this.validator = new CommandLineArgValidatorImpl();
        }
        if ((helpManagerClassName = System.getProperty(CommandLineArgHelpConstructorImpl.class.getName())) != null) {
            try {
                Class<?> clazz = Class.forName(helpManagerClassName);
                this.helpManager = (CommandLineArgHelpConstructorImpl)clazz.newInstance();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to create instance of command line args help constructor class:" + validatorClassName);
            }
        } else {
            this.helpManager = new CommandLineArgHelpConstructorImpl();
        }
    }

    public void setContextId(String contextId) {
        this.commandLineArguments.setCurrentContextId(contextId);
    }

    public void processCommandLineArguemnts(String[] args) {
        this.processCommandLineArguments(Arrays.asList(args));
    }

    public void processCommandLineArguments(List<String> args) throws IllegalArgumentException {
        this.processCommandLineArguments(args, false);
    }

    public void processCommandLineArguments(List<String> args, boolean skipCLIValidation) throws IllegalArgumentException {
        this.commandLineArguments.setCurrentContextId(System.getProperty("application.commandline.currentContextId", null));
        this.commandLineArguments.load(args);
        if (skipCLIValidation) {
            return;
        }
        this.validator.validate(this.commandLineArguments);
        CommandLineArgument argument = this.commandLineArguments.getSupportedArg("contextId");
        if (null != argument) {
            this.commandLineArguments.setCurrentContextId(argument.getValue());
        }
    }

    public void showHelp(String[] args) {
        this.showHelp(Arrays.asList(args));
    }

    public void showHelp(List<String> args) {
        this.helpManager.showHelp(this.commandLineArguments, args);
    }

    public Map<String, String> getPassedActualArgumentsAsMap() {
        return this.commandLineArguments.getPassedActualSupportedArgs();
    }

    public Map<String, String> getPassedArgumentsAsMap() {
        return this.getPassedArgumentsAsMap(false);
    }

    public Map<String, String> getPassedArgumentsAsMap(boolean includeOnlySupportedArgs) {
        if (includeOnlySupportedArgs) {
            return this.commandLineArguments.getPassedSupportedArgs();
        }
        return this.commandLineArguments.getPassedArgumentsMap();
    }

    public String getArgumentValue(String argName) {
        return this.commandLineArguments.getArgumentValue(argName);
    }

    public List<String> getArgumentValue(String argName, boolean multiUsageValueArg) {
        return this.commandLineArguments.getArgumentValue(argName, multiUsageValueArg);
    }

    public boolean isArgumentPassed(String argName) {
        return this.commandLineArguments.isArgumentPassed(argName);
    }

    public void logCommandLineargs() {
        this.commandLineArguments.logCommandLineArguments();
    }

    public static void main(String[] args) {
        CommandLineArgumentHandler obj = new CommandLineArgumentHandler();
        obj.processCommandLineArguemnts(args);
        obj.showHelp(args);
    }
}

