/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.cli;

import java.util.ArrayList;
import java.util.List;
import oracle.install.commons.base.util.cli.CommandArgType;
import oracle.install.commons.base.util.cli.CommandLineArguments;

public class CommandLineArgHelper {
    public static boolean isCommandArgType(String argStr) {
        for (CommandArgType type : CommandArgType.values()) {
            if (!type.toString().equalsIgnoreCase(argStr)) continue;
            return true;
        }
        return false;
    }

    public static List<String> replaceArgPlaceHolders(List<String> argsToReplace, CommandLineArguments commandLineArguments) {
        if (argsToReplace != null) {
            ArrayList<String> replacedArgsList = new ArrayList<String>();
            for (String arg : argsToReplace) {
                if (arg == null || arg.isEmpty()) continue;
                if (arg.contains("|")) {
                    String[] alternativeArgs = arg.split("\\|");
                    if (alternativeArgs == null || alternativeArgs.length <= 0) continue;
                    StringBuffer resultingString = new StringBuffer();
                    for (String alternativeArg : alternativeArgs) {
                        String replacedString = CommandLineArgHelper.replaceArgPlaceHolder(alternativeArg, commandLineArguments);
                        if (replacedString == null || replacedString.isEmpty()) continue;
                        resultingString.append(replacedString);
                        resultingString.append("|");
                    }
                    String resultingArg = resultingString.toString();
                    if (resultingArg == null || resultingArg.isEmpty()) continue;
                    resultingArg = resultingArg.endsWith("|") ? resultingArg.substring(0, resultingArg.length()) : resultingArg;
                    replacedArgsList.add(resultingArg);
                    continue;
                }
                String replacedString = CommandLineArgHelper.replaceArgPlaceHolder(arg, commandLineArguments);
                if (replacedString == null || replacedString.isEmpty()) continue;
                replacedArgsList.add(replacedString);
            }
            return replacedArgsList;
        }
        return argsToReplace;
    }

    private static String replaceArgPlaceHolder(String argument, CommandLineArguments commandLineArguments) {
        if (argument != null && !argument.isEmpty() && CommandLineArgHelper.isCommandArgType(argument) && commandLineArguments != null) {
            if (CommandArgType.COMMAND.toString().equalsIgnoreCase(argument) && commandLineArguments.getCommandArgs() != null) {
                return CommandLineArgHelper.getStringRepresentationOfArgs(commandLineArguments.getCommandArgs());
            }
            if (CommandArgType.FLAG.toString().equalsIgnoreCase(argument) && commandLineArguments.getFlagArgs() != null) {
                return CommandLineArgHelper.getStringRepresentationOfArgs(commandLineArguments.getFlagArgs());
            }
            if (CommandArgType.OPTION.toString().equalsIgnoreCase(argument) && commandLineArguments.getOptionArgs() != null) {
                return CommandLineArgHelper.getStringRepresentationOfArgs(commandLineArguments.getOptionArgs());
            }
        }
        return argument;
    }

    private static String getStringRepresentationOfArgs(List<String> args) {
        if (args != null) {
            StringBuffer resultingArgStringBuffer = new StringBuffer("");
            for (String arg : args) {
                resultingArgStringBuffer.append(arg);
                resultingArgStringBuffer.append("|");
            }
            String resultingArg = resultingArgStringBuffer.toString();
            return resultingArg.endsWith("|") ? resultingArg.substring(0, resultingArg.length()) : resultingArg;
        }
        return "";
    }
}

