/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.launchpad;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.View;
import oracle.install.commons.base.launchpad.LaunchPad;
import oracle.install.commons.base.launchpad.SetupApp;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.exception.ExceptionManager;

class SetupAppInfoRenderer
extends JPanel {
    private JLabel lblIcon;
    private JLabel lblName;
    private JTextArea txtDescription;
    private SetupApp setupAppInfo;
    private CellRendererPane cellRendererPane = new CellRendererPane();
    private int cellspacing = 10;
    private int margin = 10;
    private boolean hovering;
    private Color hoverBackground;
    private Color hoverForeground;
    private Color background;
    private Color foreground;

    public SetupAppInfoRenderer(SetupApp setupAppInfo) {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setupAppInfo = setupAppInfo;
        this.setOpaque(true);
        this.lblIcon = new JLabel();
        this.lblIcon.setOpaque(true);
        this.lblName = new JLabel();
        this.lblName.setOpaque(true);
        SwingUtils.scaleFont(this.lblName, 0.1f);
        this.txtDescription = new JTextArea();
        this.txtDescription.setLineWrap(true);
        this.txtDescription.setWrapStyleWord(true);
        this.txtDescription.setOpaque(true);
        this.txtDescription.setBorder(BorderFactory.createEmptyBorder());
        this.txtDescription.setEditable(false);
        Application application = Application.getInstance();
        ImageIcon icon = application.getIcon(setupAppInfo.getId() + ".icon", new Object[0]);
        String name = application.getString(setupAppInfo.getId() + ".name", setupAppInfo.getId(), new Object[0]);
        String description = application.getString(setupAppInfo.getId() + ".description", setupAppInfo.getId(), new Object[0]);
        this.setBackground(this.txtDescription.getBackground());
        this.lblIcon.setIcon(icon);
        this.lblName.setText(name);
        this.txtDescription.setText(description);
        this.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SetupAppInfoRenderer.this.highlight(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                SetupAppInfoRenderer.this.highlight(false);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SetupAppInfoRenderer.this.isFocusOwner()) {
                    SetupAppInfoRenderer.this.highlight(true);
                } else {
                    SetupAppInfoRenderer.this.grabFocus();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SetupAppInfoRenderer.this.highlight(false);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                SetupAppInfoRenderer.this.launch();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                SetupAppInfoRenderer.this.grabFocus();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 38: {
                        SetupAppInfoRenderer.this.transferFocusBackward();
                        break;
                    }
                    case 40: {
                        SetupAppInfoRenderer.this.transferFocus();
                        break;
                    }
                    case 10: {
                        SetupAppInfoRenderer.this.launch();
                    }
                }
            }
        });
        this.background = UIManager.getColor("List.background");
        this.foreground = UIManager.getColor("List.foreground");
        this.hoverBackground = UIManager.getColor("List.selectionBackground");
        this.hoverForeground = UIManager.getColor("List.selectionForeground");
    }

    private void launch() {
        Thread t = new Thread(){

            @Override
            public void run() {
                Application application = Application.getInstance();
                if (application instanceof LaunchPad) {
                    LaunchPad launchPad = (LaunchPad)application;
                    try {
                        launchPad.launch(SetupAppInfoRenderer.this.setupAppInfo);
                    }
                    catch (Exception e) {
                        ExceptionManager.handle(e);
                    }
                }
            }
        };
        t.start();
    }

    private void highlight(boolean flag) {
        this.hovering = flag;
        this.repaint();
    }

    @Override
    public void doLayout() {
        Dimension parentSize = this.getParent().getSize();
        Dimension size = null;
        int width = parentSize.width - (2 * this.margin + this.cellspacing);
        Icon icon = this.lblIcon.getIcon();
        if (icon != null) {
            width -= icon.getIconWidth();
        }
        View view = this.txtDescription.getUI().getRootView(this.txtDescription);
        view.setSize(width, Float.MAX_VALUE);
        int height = (int)view.getPreferredSpan(1);
        Insets insets = this.txtDescription.getInsets();
        height = insets.top + insets.bottom + height;
        FontMetrics metrics = this.lblName.getFontMetrics(this.lblName.getFont());
        int labelHeight = metrics.getMaxAscent() + metrics.getMaxDescent() + metrics.getLeading();
        height += labelHeight;
        size = new Dimension(width, height += 2 * this.margin + this.cellspacing);
        super.setPreferredSize(size);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Rectangle area = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        if (this.hovering) {
            g2.setColor(this.hoverBackground);
            this.lblIcon.setBackground(this.hoverBackground);
            this.lblIcon.setForeground(this.hoverForeground);
            this.lblName.setBackground(this.hoverBackground);
            this.lblName.setForeground(this.hoverForeground);
            this.txtDescription.setBackground(this.hoverBackground);
            this.txtDescription.setForeground(this.hoverForeground);
        } else {
            g2.setColor(this.background);
            this.lblIcon.setBackground(this.background);
            this.lblIcon.setForeground(this.foreground);
            this.lblName.setBackground(this.background);
            this.lblName.setForeground(this.foreground);
            this.txtDescription.setBackground(this.background);
            this.txtDescription.setForeground(this.foreground);
        }
        g2.fill(area);
        int w = this.getWidth();
        int h = this.getHeight();
        Icon icon = this.lblIcon.getIcon();
        int ix = this.margin;
        int iy = this.margin;
        int iw = 0;
        int ih = 0;
        if (icon != null) {
            iw = icon.getIconWidth();
            ih = icon.getIconHeight();
            area = new Rectangle(ix, iy, iw, ih);
            this.cellRendererPane.paintComponent(g2, this.lblIcon, this, area);
        }
        FontMetrics metrics = g2.getFontMetrics();
        int lh = metrics.getMaxAscent() + metrics.getMaxDescent() + metrics.getLeading();
        int lw = w - (this.margin + iw + this.cellspacing);
        int lx = this.margin + iw + this.cellspacing;
        int ly = iy;
        area = new Rectangle(lx, ly, lw, lh);
        this.cellRendererPane.paintComponent(g2, this.lblName, this, area);
        int dx = lx;
        int dy = this.margin + lh + this.cellspacing;
        int dh = h - (this.margin + lh + this.cellspacing + this.margin);
        int dw = lw;
        area = new Rectangle(dx, dy, dw, dh);
        this.cellRendererPane.paintComponent(g2, this.txtDescription, this, area);
    }
}

