/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.activehelp;

import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.Timer;
import oracle.install.commons.activehelp.ActiveHelpIndicator;
import oracle.install.commons.activehelp.ActiveHelpRegistry;
import oracle.install.commons.activehelp.DefaultActiveHelpRegistry;
import oracle.install.commons.activehelp.HelpInfo;
import oracle.install.commons.util.Application;

public class ActiveHelpManager {
    private static ActiveHelpManager instance = null;
    private static final String KEY_BUBBLE_HELP_INFO = "oracle.install.commons.swing.bubblehelp.helpInfo";
    private static final int SHORTER_COMPONENT_HOVER_PERIOD = 375;
    private static final int LONGER_COMPONENT_HOVER_PERIOD = 3000;
    private Timer hoverTimer;
    private JComponent referer;
    private MouseListener mouseTracker = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent event) {
            ActiveHelpManager.this.referer = (JComponent)event.getSource();
            if (ActiveHelpManager.this.helpIndicator.isShowingHelp()) {
                ActiveHelpManager.this.hoverTimer.setInitialDelay(3000);
            } else {
                ActiveHelpManager.this.hoverTimer.setInitialDelay(375);
            }
            ActiveHelpManager.this.hoverTimer.start();
        }

        @Override
        public void mouseExited(MouseEvent event) {
            ActiveHelpManager.this.referer = null;
            ActiveHelpManager.this.hoverTimer.stop();
        }
    };
    private ActiveHelpIndicator helpIndicator;
    private ActiveHelpRegistry helpRegistry = new DefaultActiveHelpRegistry();

    public static ActiveHelpManager getInstance() {
        if (instance == null) {
            instance = new ActiveHelpManager();
        }
        return instance;
    }

    public static void registerComponent(JComponent component, String helpId) {
        ActiveHelpManager instance = ActiveHelpManager.getInstance();
        instance.register(component, helpId);
    }

    protected ActiveHelpManager() {
        this.helpIndicator = new ActiveHelpIndicator();
        this.hoverTimer = new Timer(375, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActiveHelpManager.this.showHelpIndicator();
            }
        });
        this.hoverTimer.setRepeats(false);
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if ("focusOwner".equals(prop)) {
                    Object component = e.getNewValue();
                    if (component != null && component instanceof JComponent) {
                        ActiveHelpManager.this.referer = (JComponent)component;
                        ActiveHelpManager.this.showHelpIndicator();
                    } else {
                        ActiveHelpManager.this.hideHelpIndicator();
                    }
                }
            }
        });
    }

    public ActiveHelpRegistry getHelpRegistry() {
        return this.helpRegistry;
    }

    public void setHelpRegistry(ActiveHelpRegistry helpRegistry) {
        this.helpRegistry = helpRegistry;
    }

    public void register(JComponent component, String helpId) {
        HelpInfo helpInfo;
        if (this.helpRegistry != null && (helpInfo = this.helpRegistry.getHelpInfo(helpId)) != null) {
            if (component instanceof JComboBox) {
                ComboBoxEditor editor;
                JComboBox comboBox = (JComboBox)component;
                comboBox.putClientProperty(KEY_BUBBLE_HELP_INFO, helpInfo);
                if (comboBox.isEditable() && (editor = comboBox.getEditor()) != null) {
                    component = (JComponent)editor.getEditorComponent();
                }
            } else if (component instanceof JSpinner) {
                JSpinner spinner = (JSpinner)component;
                spinner.putClientProperty(KEY_BUBBLE_HELP_INFO, helpInfo);
                JComponent editor = spinner.getEditor();
                if (editor != null) {
                    component = editor instanceof JSpinner.DefaultEditor ? ((JSpinner.DefaultEditor)editor).getTextField() : editor;
                }
            }
            component.putClientProperty(KEY_BUBBLE_HELP_INFO, helpInfo);
            component.addMouseListener(this.mouseTracker);
            Application application = Application.getInstance();
            application.registerComponentForHelp(component, helpId);
        }
    }

    public void unregister(JComponent component) {
        if (component != null) {
            component.putClientProperty(KEY_BUBBLE_HELP_INFO, null);
            component.removeMouseListener(this.mouseTracker);
            if (this.referer != null && component == this.referer) {
                this.hideHelpIndicator();
            }
        }
    }

    protected HelpInfo getHelpInfo(JComponent component) {
        HelpInfo info = null;
        if (component != null) {
            info = (HelpInfo)component.getClientProperty(KEY_BUBBLE_HELP_INFO);
        }
        return info;
    }

    protected void showHelpIndicator() {
        HelpInfo helpInfo;
        if (this.referer != null && this.referer.isShowing() && this.referer != this.helpIndicator.getReferer() && (helpInfo = this.getHelpInfo(this.referer)) != null) {
            this.helpIndicator.setReferer(this.referer);
            this.helpIndicator.setHelpInfo(helpInfo);
            this.helpIndicator.setVisible(true);
        }
    }

    protected void hideHelpIndicator() {
        this.helpIndicator.setVisible(false);
        this.helpIndicator.setHelpInfo(null);
        this.helpIndicator.setReferer(null);
    }

    public void attachTo(Window window) {
    }
}

