/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cluster.range.generator;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.library.util.cluster.range.enums.NodeGeneratorType;
import oracle.install.library.util.cluster.range.generator.NodeGenerator;

public class NodeSimpleRangeGenerator
extends NodeGenerator {
    private static final Logger logger = Logger.getLogger(NodeSimpleRangeGenerator.class.getName());
    private char startValue;
    private char endValue;
    private char currentValue;

    public NodeSimpleRangeGenerator(char startValue, char endValue, long period) {
        this(startValue, endValue);
        this.setGeneratorPeriod(period);
        logger.log(Level.INFO, MessageFormat.format("NodeSimpleRangeGenerator created for the range {0} to {1} with iteration period of {2}.", Character.valueOf(startValue), Character.valueOf(endValue), period));
    }

    public NodeSimpleRangeGenerator(char startValue, char endValue) {
        this.startValue = startValue;
        this.endValue = endValue;
        this.currentValue = this.startValue;
        this.setGeneratorType(NodeGeneratorType.SIMPLE_RANGE);
        logger.log(Level.INFO, MessageFormat.format("NodeSimpleRangeGenerator created for the range {0} to {1} with default iteration period.", Character.valueOf(startValue), Character.valueOf(endValue)));
    }

    @Override
    public boolean hasNext() {
        return this.currentValue != this.endValue + '\u0001';
    }

    public Character next() {
        ++this.iterationCounter;
        if (this.iterationCounter == this.getGeneratorPeriod()) {
            this.iterationCounter = 0L;
            char c = this.currentValue;
            this.currentValue = (char)(c + '\u0001');
            return Character.valueOf(c);
        }
        return Character.valueOf(this.currentValue);
    }

    @Override
    public void remove() {
    }

    @Override
    public long getLength() {
        return (long)this.endValue - (long)this.startValue + 1L;
    }

    @Override
    public void reset() {
        this.currentValue = this.startValue;
        this.iterationCounter = 0L;
    }
}

