/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;

public class UserEquivalenceValidation {
    public static final String UNKNOWN_HOST = "ping: unknown host ";
    public static final String SUCC_MSG = "SUCCESS";
    public static final String ERROR_SINGLE_NODE = "FAILURE";
    public static final String ERROR_MULTIPLE_NODES = "ERROR";
    private static String activeNodes = "";
    private static String inActiveNodes = "";

    public static String[] checkUserEquivalence(String[] nodeList) {
        ArrayList<String> RetMsg;
        block8: {
            ArrayList<String> upNodes = new ArrayList<String>();
            ArrayList<String> errNodes = new ArrayList<String>();
            RetMsg = new ArrayList<String>();
            String CurrNode = "";
            boolean flag = false;
            try {
                ClusterCmd Ccmd = new ClusterCmd();
                flag = Ccmd.validateUserEquivalence(nodeList);
                if (!flag) break block8;
                RetMsg.add(SUCC_MSG);
            }
            catch (ClusterException ce) {
                RetMsg.add(ERROR_SINGLE_NODE);
            }
            catch (RemoteFileOperationException rfoe) {
                int i;
                RetMsg.add(ERROR_MULTIPLE_NODES);
                for (i = 0; i < nodeList.length; ++i) {
                    CurrNode = nodeList[i];
                    try {
                        int status = rfoe.getStatus(CurrNode);
                        if (status == 0) {
                            flag = true;
                            upNodes.add(CurrNode);
                        }
                        if (status != 1 && status != 2) continue;
                        errNodes.add(CurrNode);
                        continue;
                    }
                    catch (NoSuchNodeException nsne) {
                        flag = false;
                        RetMsg.add(UNKNOWN_HOST);
                    }
                }
                int DownNodeSz = errNodes.size();
                if (DownNodeSz <= 0) break block8;
                for (i = 0; i < DownNodeSz; ++i) {
                    RetMsg.add((String)errNodes.get(i));
                }
            }
        }
        String[] RetAry = RetMsg.toArray(new String[RetMsg.size()]);
        return RetAry;
    }

    public static boolean ensureUserEquivalence(String[] args) {
        int i;
        String[] nodeList = new String[args.length];
        activeNodes = "";
        inActiveNodes = "";
        for (i = 0; i < args.length; ++i) {
            nodeList[i] = args[i];
            if (nodeList[i].indexOf(".") == -1) continue;
            nodeList[i] = nodeList[i].substring(0, nodeList[i].indexOf("."));
        }
        for (i = 0; i < nodeList.length; ++i) {
            String[] temp = new String[]{nodeList[i]};
            String[] tempRes = UserEquivalenceValidation.checkUserEquivalence(temp);
            if (tempRes[0].equals(SUCC_MSG)) {
                String nodeLowerCase;
                String activeNodesLowerCase = activeNodes.toLowerCase();
                if (activeNodesLowerCase.indexOf(nodeLowerCase = nodeList[i].toLowerCase()) != -1) continue;
                activeNodes = activeNodes + nodeList[i] + ",";
                continue;
            }
            inActiveNodes = inActiveNodes + nodeList[i] + ",";
        }
        if (activeNodes.length() != 0) {
            activeNodes = activeNodes.substring(0, activeNodes.length() - 1);
        }
        if (inActiveNodes.length() != 0) {
            inActiveNodes = inActiveNodes.substring(0, inActiveNodes.length() - 1);
            return false;
        }
        return true;
    }

    public String getUserSetupPath() {
        try {
            File tempFile = new File(".");
            String parent = tempFile.getCanonicalPath();
            String userSetupFile = parent + "/sshUserSetup.sh";
            File file = new File(userSetupFile);
            return file.getCanonicalPath();
        }
        catch (IOException io) {
            io.printStackTrace();
            return "";
        }
    }

    public String getActiveNodes() {
        return activeNodes;
    }

    public String getInactiveNodes() {
        return inActiveNodes;
    }
}

