/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.library.resource.StringResourceBundle;
import oracle.install.library.util.MachineInfo;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;

public class NTServiceInfo {
    private static Logger logger = Logger.getLogger(NTServiceInfo.class.getName());
    private static Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());

    public static String getRunningServices(String[] processList) {
        String serviceList = new String();
        String[] nodes = new String[]{MachineInfo.getInstance().getLocalMachineName()};
        try {
            ClusterWindows clusterWindows = new ClusterWindows();
            Application.showStatus((String)resource.getString("CHECKING_PROCESS", "Checking status of services...", new Object[0]));
            logger.log(Level.INFO, "***" + nodes[0] + "***");
            for (String process : processList) {
                Map servicesMap = clusterWindows.getServices4ImagePath(nodes, process);
                if (servicesMap == null) continue;
                for (String service : (List)servicesMap.get(nodes[0])) {
                    try {
                        if (clusterWindows.getServiceStateOnNode(service, nodes[0]) != 6) continue;
                        logger.log(Level.INFO, "Service " + service + " is running");
                        serviceList = serviceList + service + ",";
                    }
                    catch (ClusterException e) {
                        logger.log(Level.WARNING, "Service" + service + "is not running on this machine, getting exception.");
                    }
                }
            }
            Application.hideStatus();
        }
        catch (ClusterException e) {
            logger.log(Level.WARNING, "Getting ClusterException");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Getting ClusterOperationException");
        }
        return serviceList;
    }
}

