/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.net.support.SSHConnectivityDetails;
import oracle.install.commons.net.support.SSHSupportErrorCode;
import oracle.install.commons.net.support.SSHSupportManager;
import oracle.install.commons.net.support.SSHSupportManagerException;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.validator.CVUActionableValidationStatusMessage;
import oracle.install.library.asm.ACFSUtil;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.FileSystemInfo;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.Node;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.cluster.ClusterConfig;
import oracle.install.library.util.cvu.CVUHelper;
import oracle.install.library.util.cvu.CVUValidationException;

public abstract class GenericValidation {
    InstallException ie = new InstallException();
    private static Logger logger = Logger.getLogger(GenericValidation.class.getName());
    public static final int MINIMUM_PASSWORD_LEN = 8;
    public static final int MAXIMUM_PASSWORD_LEN = 30;

    public static boolean fileExists(String fName) {
        File givenFileObj = new File(fName);
        return givenFileObj.exists();
    }

    public static ValidationStatusMessage checkAbsolutePath(String input, String pathDesc) {
        ValidationStatusMessage msg = null;
        File f = new File(input);
        if (!f.isAbsolute()) {
            msg = new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_ABSOLUTE_PATH, new Object[]{pathDesc});
        }
        return msg;
    }

    public static List validateBadCharGetList(String badCharList, String inputValue) {
        ArrayList<Character> badCharListObj = new ArrayList<Character>();
        if (badCharList != null && inputValue != null) {
            for (int i = 0; i < badCharList.length(); ++i) {
                for (int j = 0; j < inputValue.length(); ++j) {
                    if (badCharList.codePointAt(i) != inputValue.codePointAt(j)) continue;
                    badCharListObj.add(Character.valueOf(badCharList.charAt(i)));
                }
            }
        }
        return badCharListObj;
    }

    public static StatusMessages<ValidationStatusMessage> validateComplexPassword(String password, String schemaUser) {
        StatusMessages msgs = new StatusMessages();
        String upperCaseMatch = ".*[A-Z].*";
        String lowerCaseMatch = ".*[a-z].*";
        String digitMatch = ".*[0-9].*";
        if (!(GenericValidation.isEmpty(password) || Pattern.matches(upperCaseMatch, password) && Pattern.matches(lowerCaseMatch, password) && Pattern.matches(digitMatch, password) && password.length() >= 8)) {
            msgs.add((StatusMessage)new ValidationStatusMessage((ErrorCode)oracle.install.library.resource.CommonErrorCode.PASSWORD_COMPLEXITY_ERR, new Object[]{schemaUser, "8"}));
        }
        return msgs;
    }

    public static ValidationStatusMessage validatePasswordLen(String password, String passwdDesc, int maxPasswdLen) {
        ValidationStatusMessage msg = null;
        if (password != null) {
            int length = password.length();
            if (length == 0) {
                msg = new ValidationStatusMessage((ErrorCode)oracle.install.library.resource.CommonErrorCode.PASSWORD_IS_EMPTY_ERR, new Object[]{passwdDesc});
            } else if (length > maxPasswdLen) {
                Integer i = new Integer(maxPasswdLen);
                msg = new ValidationStatusMessage((ErrorCode)oracle.install.library.resource.CommonErrorCode.PASSWORD_EXCEED_LENGTH_ERR, new Object[]{passwdDesc, i.toString()});
            }
        }
        return msg;
    }

    public static ValidationStatusMessage validatePasswdMatch(String password, String confirmPassword, String passwdDesc) {
        ValidationStatusMessage msg = null;
        if (password != null && confirmPassword.length() > 0 && !password.equals(confirmPassword)) {
            msg = new ValidationStatusMessage((ErrorCode)oracle.install.library.resource.CommonErrorCode.PASSWORDS_NOT_SAME_ERR, new Object[]{passwdDesc});
        }
        return msg;
    }

    public static ValidationStatusMessage validateForBadChars(String password, String badChars, String passwdDesc) {
        ValidationStatusMessage message = null;
        if (badChars.trim().length() == 0) {
            badChars = "!.@%^&*()+=\\|`~[{]};:'\",<>/?";
        }
        String badCharsFound = null;
        badCharsFound = GenericValidation.validateBadCharGetString(badChars, password);
        if (badCharsFound != null && !badChars.equals("")) {
            message = new ValidationStatusMessage((ErrorCode)oracle.install.library.resource.CommonErrorCode.PASSWORD_INVALID_ERR, new Object[]{passwdDesc});
        }
        return message;
    }

    public static String validateBadCharGetString(String badCharList, String inputValue) {
        StringBuffer badChars = new StringBuffer("");
        List listObj = GenericValidation.validateBadCharGetList(badCharList, inputValue);
        if (!listObj.isEmpty()) {
            badChars = new StringBuffer();
            Iterator itObj = listObj.iterator();
            while (itObj.hasNext()) {
                badChars.append(itObj.next());
            }
            logger.log(Level.INFO, "Bad Chars Found :" + badChars.toString());
        }
        if (badChars.length() == 0) {
            return null;
        }
        return badChars.toString();
    }

    public static boolean validateForEmptiness(String inputValue) {
        return inputValue == null || inputValue.trim().length() == 0;
    }

    public static long validateForFreeSpace(long requiredSpaceInMB, String dirPath) throws InstallException {
        logger.log(Level.INFO, "PATH has :==>" + System.getProperty("java.library.path"));
        try {
            long freeSpace = GenericValidation.getFreeSpace(dirPath);
            logger.log(Level.FINEST, "The required space in MB is : " + requiredSpaceInMB + " and the location " + dirPath + " has " + freeSpace + " space");
            if (freeSpace > requiredSpaceInMB) {
                return 0L;
            }
            if (freeSpace == requiredSpaceInMB) {
                return 1L;
            }
            return freeSpace - requiredSpaceInMB;
        }
        catch (Throwable t) {
            throw new InstallException(t);
        }
    }

    public static long getFreeSpace(String dirPath) throws InstallException {
        logger.log(Level.INFO, "PATH has :==>" + System.getProperty("java.library.path"));
        try {
            long freeSpace;
            String localDirPath = GenericValidation.getLastExistingParent(dirPath);
            ACFSUtil acfsUtil = ACFSUtil.getInstance();
            if (acfsUtil.isPathOnACFS(localDirPath)) {
                freeSpace = acfsUtil.getFreeSpace(FileInfo.getMountPoint(localDirPath)) / 0x100000L;
            } else {
                Integer intObj = FileSystemInfo.getInstance().getFreeSpace(localDirPath, new Boolean(true));
                freeSpace = intObj.longValue();
            }
            return freeSpace;
        }
        catch (Throwable t) {
            throw new InstallException(t);
        }
    }

    public static long validateForOracleBaseFreeSpace(long thresholdError, long thresholdWarning, String dirPath) throws InstallException {
        try {
            long freeSpace = GenericValidation.getFreeSpace(dirPath);
            if (freeSpace < thresholdError) {
                return -1L;
            }
            if (freeSpace >= thresholdError && freeSpace < thresholdWarning) {
                return 1L;
            }
            return 0L;
        }
        catch (Throwable t) {
            throw new InstallException(t);
        }
    }

    public static boolean validateFileForWritePermission(String inputFilePath) {
        boolean canWrite = false;
        if (inputFilePath != null && new File(inputFilePath).exists()) {
            canWrite = new File(inputFilePath).canWrite();
        }
        return canWrite;
    }

    public static boolean validateFileForReadPermission(String inputFilePath) {
        return new File(inputFilePath).canRead();
    }

    public static boolean validateEmailAddress(String inputEmailAddr) {
        String localPart = "[^@\\<\\>\\:\\;\\\"\\[\\]\\(\\)\\\\]*[\\w!#$%&'*+-/=?^_`{|}~]";
        String domainPart = "([\\w-]+\\.)+";
        String finalDomainPart = "[a-zA-Z]{1,}$";
        String emailPattern = localPart + "@" + domainPart + finalDomainPart;
        Pattern p = Pattern.compile(emailPattern);
        Matcher m = p.matcher(inputEmailAddr.trim());
        return m.matches();
    }

    public static boolean validateStartCharacter(String eligibleList, String inputStr) {
        boolean eligibleFirstChar = false;
        if (eligibleList != null && inputStr != null && inputStr.length() != 0) {
            for (int i = 0; i < eligibleList.length(); ++i) {
                if (eligibleList.codePointAt(i) != inputStr.codePointAt(0)) continue;
                eligibleFirstChar = true;
                break;
            }
        }
        return eligibleFirstChar;
    }

    public static boolean validateMultiByteChars(String hostname) {
        boolean valid = true;
        if (hostname != null && hostname.length() > 0) {
            for (char ch : hostname.toCharArray()) {
                if (ch <= '\u007f') continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    public static boolean isDirWritable(String dirPath) {
        return FileSystemInfo.getInstance().isDirWritable(dirPath);
    }

    public static boolean validateForSize(String strInputValue, int iMaxSize) {
        return strInputValue == null || strInputValue.length() > iMaxSize;
    }

    public static boolean validateIP(String strIP) {
        boolean valid = GenericValidation.validateIPV4(strIP);
        if (!valid) {
            valid = GenericValidation.validateIPV6(strIP);
        }
        return valid;
    }

    public static boolean validateIPV4(String strIP) {
        boolean bReturn = true;
        try {
            String[] strOctets = strIP.split("\\.");
            if (strOctets.length != 4) {
                bReturn = false;
            } else {
                for (int i = 0; i < 4 && bReturn; ++i) {
                    if (strOctets[i].length() < 1 || strOctets[i].length() > 3) {
                        bReturn = false;
                        continue;
                    }
                    int iValue = Integer.parseInt(strOctets[i]);
                    if (iValue >= 0 && iValue <= 255) continue;
                    bReturn = false;
                }
            }
        }
        catch (Exception e) {
            bReturn = false;
        }
        return bReturn;
    }

    public static boolean validateIPV6(String ip) {
        Pattern p;
        Matcher m;
        if (ip.length() < 3) {
            return ip == "::";
        }
        if (ip.indexOf(46) > 0) {
            int lastcolon = ip.lastIndexOf(58);
            if (!GenericValidation.validateIPV4(ip.substring(lastcolon + 1))) {
                return false;
            }
            ip = ip.substring(0, lastcolon) + ":0:0";
        }
        if (ip.indexOf("::") < 0 && (m = (p = Pattern.compile("\\A(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}\\z")).matcher(ip)).find()) {
            return true;
        }
        int colonCount = 0;
        Pattern p2 = Pattern.compile(":");
        Matcher m2 = p2.matcher(ip);
        while (m2.find()) {
            ++colonCount;
        }
        return colonCount < 8 && (m2 = (p2 = Pattern.compile("\\A((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)\\z")).matcher(ip)).find();
    }

    public static boolean isItDir(String dirPath) {
        File fileObj = new File(dirPath);
        return fileObj.isDirectory();
    }

    public static String getLastExistingParent(String inputPath) {
        if (inputPath != null && inputPath.length() > 0) {
            File f = new File(inputPath);
            if (f.exists() && f.isDirectory()) {
                return inputPath;
            }
            if (f != null && f.getParent() != null) {
                return GenericValidation.getLastExistingParent(f.getParent().toString());
            }
        }
        return null;
    }

    public static String getLongestExistingPath(String inputPath) {
        if (inputPath != null && inputPath.length() > 0) {
            File f = new File(inputPath);
            if (f.exists()) {
                return inputPath;
            }
            if (f != null && f.getParent() != null) {
                return GenericValidation.getLongestExistingPath(f.getParent().toString());
            }
        }
        return null;
    }

    public static StatusMessages<ValidationStatusMessage> validatePassword(String password, int nMaxLength, String passwdDesc) {
        int passlength;
        StatusMessages messages = new StatusMessages();
        if (password == null) {
            password = "";
        }
        if ((passlength = password.length()) == 0) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)oracle.install.library.resource.CommonErrorCode.PASSWORD_IS_EMPTY_ERR, new Object[]{passwdDesc}));
        }
        if (passlength > nMaxLength) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)oracle.install.library.resource.CommonErrorCode.PASSWORD_EXCEED_LENGTH_ERR, new Object[]{passwdDesc, nMaxLength}));
        }
        return messages;
    }

    public static boolean isEmpty(String text) {
        return text == null || text.trim().length() <= 0;
    }

    public static boolean isFilenameValid(String filename, String unsupportedCharacters) {
        boolean valid = true;
        if (filename != null && filename.length() > 0) {
            unsupportedCharacters = unsupportedCharacters == null ? "" : unsupportedCharacters;
            for (char ch : filename.toCharArray()) {
                if (ch <= '\u007f' && unsupportedCharacters.indexOf(ch) < 0) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    public static void validateForCVUFrameworkSetup(List<String> nodeList, StatusMessages<ValidationStatusMessage> messages) throws CVUValidationException {
        if (DriverHelper.isCVUEnabled() && nodeList != null && nodeList.size() > 0) {
            try {
                GenericValidation.validateForCVUFrameworkSetup(nodeList.toArray(new String[0]));
            }
            catch (CVUValidationException cvuex) {
                if (cvuex.getErrorCode() == oracle.install.library.resource.CommonErrorCode.CVU_FRAMEWORK_INITIALIZATION_FAILED_REMOTELY) {
                    messages.add((StatusMessage)new CVUActionableValidationStatusMessage((ErrorCode)oracle.install.library.resource.CommonErrorCode.ACTIONABLE_CVU_FRAMEWORK_INITIALIZATION_FAILED_REMOTELY, CVUHelper.getInstance().getResultSet(), CVUHelper.getInstance().getResultSet().getFailedNodes()));
                }
                throw cvuex;
            }
        }
    }

    public static void validateForCVUFrameworkSetup(String ... nodes) throws CVUValidationException {
        if (DriverHelper.isCVUEnabled()) {
            try {
                Application.showStatus((String)Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID").getString("CHECK_CVU_FRAMEWORK", "Verifying setup for installer validations", new Object[0]));
                VerificationResultSet resultSet = CVUHelper.getInstance().checkFrameworkSetup(nodes);
                if (resultSet != null && resultSet.getOverallStatus() != OverallStatus.SUCCESSFUL) {
                    if (nodes == null || nodes.length == 0) {
                        throw new CVUValidationException((ErrorCode)oracle.install.library.resource.CommonErrorCode.CVU_FRAMEWORK_INITIALIZATION_FAILED, new Object[0]);
                    }
                    if (resultSet.getFailedNodes() != null && resultSet.getFailedNodes().size() > 0) {
                        throw new CVUValidationException((ErrorCode)oracle.install.library.resource.CommonErrorCode.CVU_FRAMEWORK_INITIALIZATION_FAILED_REMOTELY, resultSet.getFailedNodes().toArray(new String[0]));
                    }
                }
            }
            catch (VerificationException e) {
                logger.log(Level.WARNING, ExceptionManager.getStackTrace((Throwable)e));
                throw new CVUValidationException((ErrorCode)oracle.install.library.resource.CommonErrorCode.CVU_FRAMEWORK_INITIALIZATION_FAILED, new Object[0]);
            }
        }
    }

    public static void validateSSHConnectivity(String[] nodes) throws ValidationException {
        if (PlatformInfo.getInstance().isWindows()) {
            return;
        }
        if (nodes != null && nodes.length > 0) {
            ArrayList<String> nodeList = new ArrayList<String>();
            for (String node : nodes) {
                nodeList.add(Node.getHostName(node, false));
            }
            nodes = nodeList.toArray(new String[0]);
            SSHSupportManager sshSupportManager = SSHSupportManager.getInstance();
            try {
                SSHConnectivityDetails sshConnectivityDetails = sshSupportManager.getSSHConnectivityDetails(nodes);
                if (!sshConnectivityDetails.isConfigurationComplete()) {
                    ErrorMessage errorMessage = sshConnectivityDetails.getOverallErrorMessage();
                    throw new ValidationException(errorMessage.getErrorInfo());
                }
            }
            catch (SSHSupportManagerException e) {
                ErrorCode errorCode = e.getErrorCode();
                if (errorCode == SSHSupportErrorCode.SETUP_CHECK_DISABLED) {
                    logger.log(Level.WARNING, "Passwordless SSH connectivity check disabled.");
                }
                if (errorCode == SSHSupportErrorCode.UNABLE_TO_GET_CONNECTIVITY_DETAILS) {
                    ExceptionManager.handle((Throwable)e);
                }
                throw new ValidationException((Throwable)e, (ErrorCode)SSHSupportErrorCode.PASSWORDLESS_SSH_CONNECTIVITY_NOT_SETUP, e.getSeverity(), new Object[0]);
            }
        }
    }

    public static void validateSSHConnectivity(ClusterConfig clusterConfig) throws ValidationException {
        List<String> publicNodeNames = clusterConfig.getPublicNodeNames(false);
        GenericValidation.validateSSHConnectivity(publicNodeNames.toArray(new String[0]));
    }

    public static boolean containsNonAsciiChars(String str) {
        if (str != null && !str.isEmpty()) {
            for (char c : str.toCharArray()) {
                if (c <= '\u007f') continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
    }
}

