/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.crs;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.library.util.InstallException;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;

public class WinCRSInfo {
    private static final Logger logger = Logger.getLogger(WinCRSInfo.class.getName());

    public static boolean regKeyExistsOnLocalNode(String key) throws InstallException {
        try {
            ClusterWindows clusterWindows = new ClusterWindows();
            return clusterWindows.regKeyExistsOnNode(key);
        }
        catch (ClusterException e) {
            throw new InstallException(e);
        }
    }

    public static void deleteRegKeyOnLocalNode(String key, String subKey) throws InstallException {
        ClusterWindows clusterWindows;
        try {
            clusterWindows = new ClusterWindows();
        }
        catch (ClusterException e) {
            logger.log(Level.INFO, "Exception from ClusterWindows constructor.", e);
            throw new InstallException(e);
        }
        if (clusterWindows != null) {
            logger.log(Level.INFO, "key: " + key);
            logger.log(Level.INFO, "subKey: " + subKey);
            try {
                clusterWindows.deleteRegKeyOnNode(key, subKey);
                logger.log(Level.INFO, "Called WinCRSInfo.deleteRegKeyOnNode");
            }
            catch (ClusterException e) {
                logger.log(Level.INFO, "Exception from ClusterWindows.deleteRegKeyOnNode.", e);
                throw new InstallException(e);
            }
        }
    }

    public static void deleteRegValueOnLocalNode(String key, String value) throws InstallException {
        ClusterWindows clusterWindows;
        try {
            clusterWindows = new ClusterWindows();
        }
        catch (ClusterException e) {
            logger.log(Level.INFO, "Exception from ClusterWindows constructor.", e);
            throw new InstallException(e);
        }
        if (clusterWindows != null) {
            logger.log(Level.INFO, "key: " + key);
            logger.log(Level.INFO, "value: " + value);
            try {
                clusterWindows.deleteRegValueOnNode(key, value);
                logger.log(Level.INFO, "Called WinCRSInfo.deleteRegValueOnNode");
            }
            catch (ClusterException e) {
                logger.log(Level.INFO, "Exception from ClusterWindows.deleteRegValueOnNode.", e);
                throw new InstallException(e);
            }
        }
    }
}

