/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.util.FileInfo;
import oracle.install.library.util.GenericValidation;

public class CreateGoldImageValidator
implements Validator {
    private static final Logger logger = Logger.getLogger(CreateGoldImageValidator.class.getName());

    public void validate(FlowContext flowContext) throws ValidationException {
        String sourceHome = null;
        String destinationLocation = null;
        CommandLineArgumentHandler cmdLineArgumentHandler = CommandLineArgumentHandler.getInstance();
        if (cmdLineArgumentHandler != null) {
            sourceHome = cmdLineArgumentHandler.isArgumentPassed("sourceHome") ? cmdLineArgumentHandler.getArgumentValue("sourceHome") : System.getProperty("ORACLE_HOME");
            if (cmdLineArgumentHandler.isArgumentPassed("destinationLocation")) {
                destinationLocation = cmdLineArgumentHandler.getArgumentValue("destinationLocation");
            }
        }
        this.validateSourceHome(sourceHome);
        this.validateDestinationLocation(destinationLocation, sourceHome);
    }

    public void validateSourceHome(String sourceHome) throws ValidationException {
        if (GenericValidation.isEmpty(sourceHome)) {
            throw new ValidationException((ErrorCode)CommonErrorCode.CREATEGOLDIMAGE_COMMON_SOURCE_HOME_PATH_EMPTY, new Object[0]);
        }
        File sourceHomeFile = new File(sourceHome);
        if (!sourceHomeFile.exists()) {
            throw new ValidationException((ErrorCode)CommonErrorCode.CREATEGOLDIMAGE_COMMON_SOURCE_HOME_NOT_EXISTS, new Object[]{sourceHome});
        }
        if (!sourceHomeFile.isDirectory()) {
            throw new ValidationException((ErrorCode)CommonErrorCode.CREATEGOLDIMAGE_COMMON_SOURCE_HOME_NOT_DIRECTORY, new Object[]{sourceHome});
        }
        if (!PlatformInfo.getInstance().isWindows()) {
            String currentUser = System.getProperty("user.name");
            if (currentUser != null && !currentUser.isEmpty()) {
                logger.info("Current user name: " + currentUser);
                ArrayList<String> filesWithDifOwner = FileInfo.getFilesWithDifferentOwner(sourceHome, currentUser);
                if (filesWithDifOwner != null && !filesWithDifOwner.isEmpty()) {
                    logger.warning("Following files from the source home are not owned by the current user: " + filesWithDifOwner.toString());
                }
            } else {
                logger.warning("Could not get the current user name.");
            }
        }
    }

    public void validateDestinationLocation(String destinationLocation, String sourceHome) throws ValidationException {
        if (GenericValidation.isEmpty(destinationLocation)) {
            throw new ValidationException((ErrorCode)CommonErrorCode.CREATEGOLDIMAGE_COMMON_DEST_LOC_PATH_EMPTY, new Object[0]);
        }
        String destLocLastExistingParent = FileInfo.getLastExistingParent(destinationLocation);
        File destLocLastExistParentFile = new File(destLocLastExistingParent);
        if (!destLocLastExistParentFile.canWrite()) {
            throw new ValidationException((ErrorCode)CommonErrorCode.CREATEGOLDIMAGE_COMMON_DEST_LOC_NOT_WRITABLE, new Object[]{destinationLocation});
        }
        long sourceSizeInBytes = -1L;
        try {
            sourceSizeInBytes = FileInfo.getFileSizeBytes(new File(sourceHome));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not determine the source home size.", e);
        }
        if (sourceSizeInBytes > 0L) {
            logger.info("Source Size bytes: " + sourceSizeInBytes);
            long sourceSizeInMB = sourceSizeInBytes / 1024L / 1024L;
            long requiredFreeSpace = sourceSizeInMB * 2L;
            boolean enoughSpace = true;
            try {
                enoughSpace = GenericValidation.validateForFreeSpace(requiredFreeSpace, destLocLastExistingParent) >= 0L;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not determine if the free space of the destination location was enough.", e);
            }
            if (!enoughSpace) {
                throw new ValidationException((ErrorCode)CommonErrorCode.CREATEGOLDIMAGE_COMMON_DEST_LOC_NOT_ENOUGH_FREE_SPACE, new Object[]{destinationLocation, requiredFreeSpace});
            }
        }
    }
}

