/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.driver;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;
import oracle.install.ivw.common.resource.CommonDialogLabelResID;
import oracle.install.library.resource.StringResourceBundle;
import oracle.install.library.util.MachineInfo;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;

public class VCRedToolJob
extends CompositeJob
implements Callable<Void>,
Retriable<Job> {
    private static final Logger logger = Logger.getLogger(VCRedToolJob.class.getName());
    private static final String vcredist_name = "vcredist_x64.exe";
    private String oracleHome;
    private List<String> clusterNodes;
    public static final Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());

    public VCRedToolJob(String oracleHome, List<String> clusterNodes) {
        super((Object)"vcred", null, 0.1f);
        this.setDescription(Application.getInstance().getString(ResourceURL.resURL((String)CommonDialogLabelResID.class.getName(), (String)"vcredToolJob.description"), "Setup VC Redistributable", new Object[0]));
        this.setRetryEnabled(true);
        this.setRequired(true);
        this.setRetriable(this);
        this.oracleHome = oracleHome;
        this.clusterNodes = clusterNodes;
    }

    private void call(boolean retry) throws Exception {
        this.setStatus(Status.INPROGRESS);
        String cmd = this.oracleHome + File.separator + "inventory" + File.separator + "Scripts" + File.separator + "ext" + File.separator + "bin" + File.separator + vcredist_name;
        ArrayList<String> args = new ArrayList<String>();
        args.add("/q");
        args.add("/norestart");
        String[] argsArr = args.toArray(new String[0]);
        this.clusterNodes = this.getClusterNodes();
        if (this.clusterNodes != null) {
            String localNode = null;
            ArrayList<String> remoteNodes = new ArrayList<String>();
            for (String node : this.clusterNodes) {
                if (localNode == null && MachineInfo.getInstance().isLocalHost(node)) {
                    localNode = node;
                    continue;
                }
                remoteNodes.add(node);
            }
            boolean succeeded = true;
            if (localNode != null) {
                ArrayList<String> command = new ArrayList<String>();
                command.add(cmd);
                command.addAll(args);
                ProcessBuilder pb = new ProcessBuilder(command);
                AbstractLineProcessor stdOutProcessor = new AbstractLineProcessor(){

                    public void processLine(String line, int lineNumber) {
                        logger.info(line);
                    }
                };
                AbstractLineProcessor stdErrProcessor = new AbstractLineProcessor(){

                    public void processLine(String line, int lineNumber) {
                        logger.warning(line);
                    }
                };
                ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(pb, (OutputProcessor)stdOutProcessor, (OutputProcessor)stdErrProcessor);
                int exitCode = 0;
                try {
                    exitCode = ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
                }
                catch (Exception e) {
                    succeeded = false;
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
                if (exitCode != 0) {
                    succeeded = false;
                }
            }
            if (!remoteNodes.isEmpty()) {
                String[] nodes = remoteNodes.toArray(new String[0]);
                ClusterCmd clusterCmd = new ClusterCmd();
                try {
                    succeeded = clusterCmd.runCmd(cmd, argsArr, null, nodes);
                }
                catch (ClusterException e) {
                    succeeded = false;
                    logger.log(Level.INFO, "VC Redistributable tool failed in some or all remote nodes.", e);
                    logger.log(Level.INFO, e.getMessage(), e);
                }
            }
            if (!succeeded) {
                logger.log(Level.INFO, "VC Redistributable tool failed.");
            }
        }
        this.setStatus(Status.SUCCEEDED);
    }

    public Callable<?> getWork() {
        return this;
    }

    @Override
    public Void call() throws Exception {
        this.call(false);
        return null;
    }

    public void retry() throws Exception {
        this.call(true);
    }

    public List<Job> getRetriableJobs() {
        ArrayList<Job> retriableJobs = new ArrayList<Job>();
        List jobList = this.getJobs();
        if (jobList.size() > 0) {
            for (Job job : jobList) {
                Status status = job.getStatus();
                if (!job.isRetryEnabled() || status != Status.PENDING && status != Status.FAILED) continue;
                logger.log(Level.INFO, "Selecting job named ''{0}'' for retry", job.getDescription());
                retriableJobs.add(job);
            }
        } else {
            Status status = this.getStatus();
            if (this.isRetryEnabled() && (status == Status.PENDING || status == Status.FAILED)) {
                retriableJobs.add((Job)this);
            }
        }
        return retriableJobs;
    }

    public List<String> getClusterNodes() {
        return this.clusterNodes;
    }
}

