/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.driver;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.driver.oui.OUICloneDriver;
import oracle.install.driver.oui.RootScriptJob;
import oracle.install.driver.oui.SetupJob;
import oracle.install.ivw.common.driver.DiagsetupToolJob;
import oracle.install.library.util.WinHelper;

public class OracleCloneDriver
extends OUICloneDriver {
    private static Logger logger = Logger.getLogger(OracleCloneDriver.class.getName());

    protected HashMap constructAdditionalProperties(HashMap hashMap) throws SetupDriverException {
        super.constructAdditionalProperties(hashMap);
        List args = Application.getInstance().getArguments();
        Iterator virtualIter = args.iterator();
        CommandLineArgumentHandler cliArgumentHandler = CommandLineArgumentHandler.getInstance();
        boolean isVirtualAccount = false;
        String oracleHome = hashMap.get("ORACLE_HOME").toString();
        String oracleHomeName = hashMap.get("ORACLE_HOME_NAME").toString();
        if (PlatformInfo.getInstance().isWindows()) {
            if (cliArgumentHandler.isArgumentPassed("virtualAccount")) {
                isVirtualAccount = true;
            }
            if (isVirtualAccount && oracleHomeName != null) {
                String oracle_home_userName = WinHelper.getVirtualHomeUserName(oracleHome, oracleHomeName);
                hashMap.put("oracle_install_OracleHomeUserName", oracle_home_userName);
                hashMap.put("oracle_install_IsOracleServiceUserExists", true);
                hashMap.put("oracle_install_IsBuiltInAccount", false);
                hashMap.put("oracle_install_OracleSVCUserPWDReq", false);
            }
        }
        return hashMap;
    }

    public void showUsage() {
        super.showUsage();
        if (Application.isCommandLineSwitchEnabled((String)"-help") || Application.isCommandLineSwitchEnabled((String)"-h")) {
            Resource resource = Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");
            String cloneHelp = "";
            cloneHelp = PlatformInfo.getInstance().isWindows() ? resource.getString("CLONE.windows.helpText", "Following are the possible options:\n\tORACLE_HOME=<OH>\n\t\tThe complete path to the Oracle home location. This is a mandatory parameter for clone.\n\tORACLE_BASE=<OB>\n\t\tThe complete path to the Oracle base location. This is a mandatory parameter for clone.\n\tORACLE_HOME_NAME=<OH name>\n\t\tThe Oracle home name for the home. This is an optional parameter as the -defaultHomeName flag can be passed instead of ORACLE_HOME_NAME to assign the default Oracle home name for the home.\n\tORACLE_HOME_USER=<OH user>\n\t\tThe Oracle home user for the home being cloned. Windows Built-in Account is used as the Oracle home user if the parameter for ORACLE_HOME_USER is not specified.\n", new Object[0]) : resource.getString("CLONE.unix.helpText", "Following are the possible options:\n\tORACLE_HOME=<OH>\n\t\tThe complete path to the Oracle home location. This is a mandatory parameter for clone.\n\tORACLE_BASE=<OB>\n\t\tThe complete path to the Oracle base location. This is a mandatory parameter for clone.\n\tORACLE_HOME_NAME=<OH name>\n\t\tThe Oracle home name for the home. This is an optional parameter as the -defaultHomeName flag can be passed instead of ORACLE_HOME_NAME to assign the default Oracle home name for the home.\n\tOSDBA_GROUP=<group name>\n\t\tThe operating system group to be used as OSDBA privileged group. It is recommended to pass this parameter for Oracle Database and Oracle Grid Infrastructure software cloning.\n\tOSOPER_GROUP=<group name>\n\t\tThe operating system group to be used as OSOPER privileged group. It is recommended to pass this parameter for Oracle Database and Oracle Grid Infrastructure software cloning.\n\tOSASM_GROUP=<group name>\n\t\tThe operating system group to be used as OSASM privileged group. It is recommended to pass this parameter for Oracle Grid Infrastructure software cloning.\n\tOSBACKUPDBA_GROUP=<group name>\n\t\tThe operating system group to be used as OSBACKUPDBA privileged database backup and recovery related administrative group. It is recommended to pass this parameter for Oracle Database software cloning.\n\tOSDGDBA_GROUP=<group name>\n\t\tThe operating system group to be used as OSDGDBA privileged administer and monitor Oracle Data Guard group. It is recommended to pass this parameter for Oracle Database software cloning.\n\tOSKMDBA_GROUP=<group name>\n\t\tThe operating system group to be used as OSKMDBA privileged Oracle Wallet Manager management group. It is recommended to pass this parameter for Oracle Database software cloning.\n\tOSRACDBA_GROUP=<group name>\n\t\tThe operating system group to be used as OSRACDBA privileged group. It is recommended to pass this parameter for Oracle Database software cloning.\n", new Object[0]);
            System.out.println(cloneHelp);
        }
    }

    public CompositeJob prepareJob() throws SetupDriverException {
        CompositeJob compositeJob = new CompositeJob();
        SetupJob cloneJob = new SetupJob((Object)"Clone", "Oracle Cloning", 0.95f, this.getCloneDetails(), SetupJob.OUISetupMode.CLONE);
        compositeJob.add((Job)cloneJob);
        DiagsetupToolJob diagSetupToolJob = new DiagsetupToolJob(this.getOracleHome(), this.getOracleBase(), null, null);
        compositeJob.add((Job)diagSetupToolJob);
        if (!PlatformInfo.getInstance().isWindows() && !Application.isCommandLineSwitchEnabled((String)"-suppressRootMessage")) {
            logger.log(Level.INFO, "Adding root script.");
            compositeJob.add((Job)new RootScriptJob(cloneJob));
        }
        return compositeJob;
    }
}

