/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.driver;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.install.commons.system.filemgmt.FileSystem;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.LogManager;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.Version;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.ContentType;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressUI;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;
import oracle.install.ivw.common.resource.CommonDialogLabelResID;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.resource.StringResourceBundle;
import oracle.install.library.util.PlatformInfo;

public class ApplyPatchJob
extends Job
implements Callable<Void>,
Retriable<ApplyPatchJob> {
    private static final int OPATCH_ERR_CODE_73 = 73;
    private ProgressUI<?> progressUI;
    private String oracleHome;
    private String patchDownLoadLocation;
    private String opatchPath;
    private String targeType;
    private OutputProcessor stdOutProcessor;
    private OutputProcessor stdErrProcessor;
    private ErrorMessage errMsg;
    private PatchType patchType;
    private boolean useCustomOPatch;
    private String customOpatchPath;
    public static final Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
    private static final String OPATCH_AUTO_COMMAND = "opatchauto";
    private static final String OPATCH_ARG_APPLY = "apply";
    private static final String OPATCH_ARG_OH = "-oh";
    private static final String OPATCH_ARG_BINARY = "-binary";
    private static final String OPATCH_ARG_TARGET_TYPE = "-target_type";
    private static final String OPATCH_ARG_BASE_PATCH_DIR = "-phBaseDir";
    private static final String OPATCH_ARG_SILENT = "-silent";
    private static final String OPATCH_ARG_VERBOSE = "-verbose";
    private static final String OPATCH_TOOL_NAME = "OPatch";
    private static final String OPATCH_AUTO_TOOL_NAME = "OPatchauto";
    private static Logger logger = Logger.getLogger(ApplyPatchJob.class.getName());

    public ApplyPatchJob(String oracleHome, String patchDownloadLocation, String targetType) {
        this.init(oracleHome, patchDownloadLocation, targetType, null);
    }

    public ApplyPatchJob(Object id, float weightage, String oracleHome, String patchDownloadLocation, String targetType) {
        super(id, weightage);
        this.init(oracleHome, patchDownloadLocation, targetType, null);
    }

    public ApplyPatchJob(Object id, String description, float weightage, String oracleHome, String patchDownloadLocation, String targetType, String opatchPath, PatchType patchType) {
        super(id, description, weightage);
        this.init(oracleHome, patchDownloadLocation, targetType, opatchPath);
        this.patchType = patchType;
    }

    public ApplyPatchJob(Object id, String description, String oracleHome, String patchDownloadLocation, String targetType) {
        super(id, description);
        this.init(oracleHome, patchDownloadLocation, targetType, null);
    }

    private void init(String oracleHome, String patchDownloadLocation, String targetType, String opatchPath) {
        this.oracleHome = oracleHome;
        this.patchDownLoadLocation = patchDownloadLocation;
        this.opatchPath = new File(oracleHome, OPATCH_TOOL_NAME).getAbsolutePath();
        if (opatchPath != null && opatchPath.length() > 0) {
            this.customOpatchPath = new File(opatchPath).getAbsolutePath();
            this.useCustomOPatch = true;
        }
        this.targeType = targetType;
        this.setRequired(true);
        this.setRetryEnabled(true);
        this.setRetriable(this);
        this.stdOutProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                this.getLines().add(line);
                logger.info(line);
            }
        };
        this.stdErrProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                this.getLines().add(line);
                logger.warning(line);
            }
        };
    }

    public List<ApplyPatchJob> getRetriableJobs() {
        ArrayList<ApplyPatchJob> retriableJobList = new ArrayList<ApplyPatchJob>();
        Status status = this.getStatus();
        if (this.isRetryEnabled() && (status == Status.PENDING || status == Status.FAILED)) {
            retriableJobList.add(this);
        }
        return retriableJobList;
    }

    public void retry() throws Exception {
        this.call(true);
    }

    public Callable<?> getWork() {
        return this;
    }

    @Override
    public Void call() throws Exception {
        this.call(false);
        return null;
    }

    private void call(boolean retry) throws Exception {
        this.setStatus(Status.INPROGRESS);
        if (this.progressUI != null) {
            String description = Application.getInstance().getString(ResourceURL.resURL((String)CommonDialogLabelResID.class.getName(), (String)"patchApplyJob.description"), "Apply Patch", new Object[0]);
            this.progressUI.log(Level.INFO, description, new Object[0]);
        }
        if (this.useCustomOPatch && !Boolean.getBoolean("CUSTOM_OPATCH_COPIED")) {
            if (!Application.isCommandLineSwitchEnabled((String)"-skipOpatchVersionCheck")) {
                Advice advise;
                String opatchCmd = PlatformInfo.getInstance().isWindows() ? "opatch.bat" : "opatch";
                String OHOPatchLoc = this.opatchPath + File.separator + opatchCmd;
                String customOPatchLoc = this.customOpatchPath + File.separator + opatchCmd;
                Version OHOPatchVersion = this.getOPatchVersion(OHOPatchLoc);
                Version customOPatchVersion = this.getOPatchVersion(customOPatchLoc);
                DefaultErrorMessage errMsg = null;
                if (OHOPatchVersion == null) {
                    errMsg = new DefaultErrorMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_OPATCH_VERSION_CHECK_FAILED, new Object[]{this.oracleHome + File.separator + OPATCH_TOOL_NAME, LogManager.getInstance().getDefaultLogFile().getAbsolutePath()});
                }
                if (customOPatchVersion == null) {
                    errMsg = new DefaultErrorMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_OPATCH_VERSION_CHECK_FAILED, new Object[]{this.customOpatchPath, LogManager.getInstance().getDefaultLogFile().getAbsolutePath()});
                }
                if (OHOPatchVersion.compareTo(customOPatchVersion) > 0) {
                    logger.info("OHOPatchVersion = " + OHOPatchVersion.toString() + ", customOPatchVersion = " + customOPatchVersion.toString());
                    Object[] args = new Object[]{this.customOpatchPath, customOPatchVersion.toString(), this.oracleHome + File.separator + OPATCH_TOOL_NAME, OHOPatchVersion.toString()};
                    errMsg = new DefaultErrorMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_OPATCH_VERSION_MISMATCH, args);
                }
                if (errMsg != null && (advise = ExceptionManager.advise(errMsg)) != Advice.CONTINUE) {
                    this.setStatus(Status.FAILED);
                    return;
                }
            }
            Date date = Calendar.getInstance().getTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ssaaa");
            String timestamp = dateFormat.format(date);
            String backupOPatchDirName = OPATCH_TOOL_NAME + "_" + timestamp + ".bkp";
            FileSystem.move((File)new File(this.oracleHome, OPATCH_TOOL_NAME), (File)new File(this.oracleHome, backupOPatchDirName), null);
            logger.info("Moved existent OPatch software to " + backupOPatchDirName);
            FileSystem.copy((File)new File(this.customOpatchPath), (File)new File(this.opatchPath), null, (boolean)true, (boolean)true);
            logger.info("Successfully copied the provided OPatch software from " + this.customOpatchPath + "into the oracle home " + this.oracleHome);
            System.setProperty("CUSTOM_OPATCH_COPIED", Boolean.TRUE.toString());
        }
        if (!PlatformInfo.getInstance().isWindows()) {
            if (this.patchType == PatchType.PSU) {
                this.patchUsingOpatchauto();
            } else {
                this.patchUsingOPatch();
            }
        } else {
            this.patchUsingOPatch();
        }
    }

    protected void patchUsingOPatch() {
        String cmd = this.opatchPath + File.separator;
        cmd = PlatformInfo.getInstance().isWindows() ? cmd + "opatch.bat" : cmd + "opatch";
        String[] patches = this.patchDownLoadLocation.split(",");
        ArrayList<String> args = new ArrayList<String>();
        for (String patch : patches) {
            if (patch == null) continue;
            args.clear();
            args.add(cmd);
            args.add(OPATCH_ARG_APPLY);
            args.add(OPATCH_ARG_OH);
            args.add(this.oracleHome);
            args.add(OPATCH_ARG_SILENT);
            args.add(OPATCH_ARG_VERBOSE);
            args.add(patch);
            logger.log(Level.INFO, "Execute command : " + this.formatCommand(args));
            boolean succeeded = true;
            ProcessBuilder pb = new ProcessBuilder(args);
            pb.environment().put("ORACLE_HOME", this.oracleHome);
            ((AbstractLineProcessor)this.stdOutProcessor).getLines().clear();
            ((AbstractLineProcessor)this.stdErrProcessor).getLines().clear();
            ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(pb, this.stdOutProcessor, this.stdErrProcessor);
            int exitCode = 0;
            try {
                exitCode = ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
            }
            catch (Exception e) {
                succeeded = false;
                logger.log(Level.WARNING, "OPatchauto command (" + this.formatCommand(args) + ") failed.", e);
                logger.log(Level.WARNING, e.getMessage());
            }
            logger.log(Level.INFO, "OPatch exit code : " + exitCode);
            if (PlatformInfo.getInstance().isWindows()) {
                if (exitCode != 0 && exitCode != 73) {
                    succeeded = false;
                }
            } else if (exitCode != 0) {
                succeeded = false;
            }
            if (succeeded) continue;
            String logFile = LogManager.getInstance().getDefaultLogFile().getAbsolutePath();
            DefaultErrorMessage errMsg = new DefaultErrorMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_PATCH_TOOL_FAILED, new Object[]{OPATCH_TOOL_NAME, logFile});
            errMsg.getErrorInfo().setExtraDetails((Content)this.getExtraDetails(succeeded));
            this.addStatusMessage((StatusMessage)errMsg);
            if (args == null) continue;
            PlainContent extraDetails = new PlainContent();
            String formattedCommand = this.formatCommand(args);
            extraDetails.setContent(formattedCommand);
            logger.log(Level.WARNING, formattedCommand);
        }
        if (this.getErrorMessages() != null && this.getErrorMessages().size() > 0) {
            Advice advise = ExceptionManager.advise((StatusMessages)this.getErrorMessages());
            if (advise != Advice.CONTINUE) {
                this.setStatus(Status.FAILED);
            } else {
                this.setStatus(Status.SUCCEEDED);
            }
        } else {
            this.setStatus(Status.SUCCEEDED);
        }
    }

    protected void patchUsingOpatchauto() {
        String[] patches;
        String cmd = this.opatchPath + File.separator + OPATCH_AUTO_COMMAND;
        ArrayList<String> args = new ArrayList<String>();
        for (String patch : patches = this.patchDownLoadLocation.split(",")) {
            args.clear();
            args.add(cmd);
            args.add(OPATCH_ARG_APPLY);
            args.add(OPATCH_ARG_BINARY);
            args.add(OPATCH_ARG_TARGET_TYPE);
            args.add(this.targeType);
            args.add(OPATCH_ARG_OH);
            args.add(this.oracleHome);
            args.add(OPATCH_ARG_BASE_PATCH_DIR);
            args.add(patch);
            logger.log(Level.INFO, "Execute command: " + this.formatCommand(args));
            boolean succeeded = true;
            ProcessBuilder pb = new ProcessBuilder(args);
            pb.environment().put("ORACLE_HOME", this.oracleHome);
            ((AbstractLineProcessor)this.stdOutProcessor).getLines().clear();
            ((AbstractLineProcessor)this.stdErrProcessor).getLines().clear();
            ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(pb, this.stdOutProcessor, this.stdErrProcessor);
            int exitCode = 0;
            try {
                exitCode = ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
            }
            catch (Exception e) {
                succeeded = false;
                logger.log(Level.WARNING, "OPatchauto command (" + this.formatCommand(args) + ") failed.", e);
                logger.log(Level.WARNING, e.getMessage());
            }
            logger.log(Level.INFO, "OPatchauto exit code : " + exitCode);
            if (exitCode != 0) {
                succeeded = false;
            }
            if (succeeded) continue;
            String logFile = LogManager.getInstance().getDefaultLogFile().getAbsolutePath();
            DefaultErrorMessage errMsg = new DefaultErrorMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_PATCH_TOOL_FAILED, new Object[]{OPATCH_AUTO_TOOL_NAME, logFile});
            errMsg.getErrorInfo().setExtraDetails((Content)this.getExtraDetails(succeeded));
            this.addStatusMessage((StatusMessage)errMsg);
            if (args == null) continue;
            PlainContent extraDetails = new PlainContent();
            String formattedCommand = this.formatCommand(args);
            extraDetails.setContent(formattedCommand);
            logger.log(Level.WARNING, formattedCommand);
        }
        if (this.getErrorMessages() != null && this.getErrorMessages().size() > 0) {
            Advice advice = ExceptionManager.advise((ErrorMessage)this.errMsg);
            if (advice == Advice.CONTINUE) {
                this.setStatus(Status.SUCCEEDED);
            } else {
                this.setStatus(Status.FAILED);
            }
        } else {
            this.setStatus(Status.SUCCEEDED);
        }
    }

    public void setProgressUI(ProgressUI<?> progressUI) {
        this.progressUI = progressUI;
    }

    public void handleException(Throwable jobException) {
        super.handleException(jobException);
    }

    public PlainContent getExtraDetails(boolean succeeded) {
        PlainContent content = null;
        if (!succeeded) {
            content = new PlainContent("");
            content.setContentType(ContentType.HTML);
            content.setTitle(resource.getString("ErrorMessage.extraDetails.message", "Additional Information:", new Object[0]));
            StringBuffer extraDetails = new StringBuffer();
            ArrayList totalLines = new ArrayList();
            logger.info("stdout : " + ((AbstractLineProcessor)this.stdOutProcessor).getLines().toString());
            totalLines.addAll(((AbstractLineProcessor)this.stdOutProcessor).getLines());
            logger.info("stderr : " + ((AbstractLineProcessor)this.stdErrProcessor).getLines().toString());
            totalLines.addAll(((AbstractLineProcessor)this.stdErrProcessor).getLines());
            for (String line : totalLines) {
                if (line == null) continue;
                extraDetails.append("&nbsp;-&nbsp;");
                extraDetails.append(StringUtils.textToHtml((String)line) + "<br>");
            }
            StringBuffer details = new StringBuffer(content.getContent());
            details.append(extraDetails.toString());
            content.setContent(details.toString());
        }
        return content;
    }

    public String[] getBugDirs(String location) {
        String[] locations;
        ArrayList<String> paths = new ArrayList<String>();
        Pattern regex = Pattern.compile("^[0-9]+$");
        for (String loc : locations = location.split(",")) {
            File parentDir = new File(loc);
            File[] subDirs = parentDir.listFiles();
            if (subDirs == null) continue;
            for (File subDir : subDirs) {
                if (subDir == null) continue;
                String patchDir = subDir.getName();
                if (!subDir.isDirectory() || !regex.matcher(patchDir).matches()) continue;
                paths.add(subDir.getAbsolutePath());
            }
        }
        return paths.toArray(new String[0]);
    }

    private String formatCommand(List<String> args) {
        StringBuilder s = new StringBuilder("Command:\n");
        for (String arg : args) {
            s.append(arg);
            s.append(" ");
        }
        return s.toString();
    }

    private Version getOPatchVersion(String cmd) {
        List output;
        ArrayList<String> args = new ArrayList<String>();
        args.add(cmd);
        args.add("version");
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.environment().put("ORACLE_HOME", this.oracleHome);
        ((AbstractLineProcessor)this.stdOutProcessor).getLines().clear();
        ((AbstractLineProcessor)this.stdErrProcessor).getLines().clear();
        ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(pb, this.stdOutProcessor, this.stdErrProcessor);
        int exitCode = 0;
        try {
            exitCode = ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, cmd + " command (" + this.formatCommand(args) + ") failed.", e);
            logger.log(Level.WARNING, e.getMessage());
        }
        logger.info(cmd + " command (" + this.formatCommand(args) + ") completed with exitCode = " + exitCode);
        if (exitCode == 0 && (output = ((AbstractLineProcessor)this.stdOutProcessor).getLines()) != null && !output.isEmpty()) {
            for (String line : output) {
                if (line == null || !line.startsWith("OPatch Version:")) continue;
                String ver = line.substring("OPatch Version:".length() + 1);
                try {
                    Version opatchVersion = Version.parseVersion((String)ver);
                    return opatchVersion;
                }
                catch (IllegalArgumentException iargEx) {
                    logger.log(Level.WARNING, "IllegalArgumentException occurred during parsing string - " + ver);
                }
            }
        }
        return null;
    }

    public static enum PatchType {
        PSU(0),
        ONEOFF(1);

        int patchType;

        private PatchType(int patchType) {
            this.patchType = patchType;
        }
    }
}

