/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.bean;

import java.util.Arrays;
import java.util.Locale;
import oracle.install.commons.bean.annotation.PropertyDef;
import oracle.install.commons.util.Bean;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.common.bean.OCMSettings;
import oracle.install.ivw.common.bean.PatchInstallSettings;
import oracle.install.ivw.common.bean.RootConfigurationSettings;
import oracle.install.ivw.common.bean.WindowsSecureOptionSettings;
import oracle.sysman.oii.oiix.OiixLanguage;

public abstract class OracleSetupBean
extends Bean {
    private String oracleHostName;
    private CentralInventorySettings centralInventory;
    private String[] languages;
    private OCMSettings ocmSettings = null;
    private AutoUpdatesInstallSettings autoUpdatesInstallSettings;
    private WindowsSecureOptionSettings windowsSecureOptionSettings;
    private RootConfigurationSettings rootConfigurationSettings;
    private PatchInstallSettings patchInstallSettings;
    public static final String[] DEFAULT_LANGUAGE_SET = new String[]{"en"};
    public static final String PROPERTY_LANGUAGES = "OracleSetupBean.PROPERTY_LANGUAGES";

    public OracleSetupBean() {
        this("", null, null, null);
    }

    public OracleSetupBean(String oracleHostName, CentralInventorySettings centralInventory, String[] languages) {
        this.OracleSetupBeanConstruct(oracleHostName, centralInventory, null, null, languages, true);
    }

    public OracleSetupBean(String oracleHostName, CentralInventorySettings centralInventory, boolean setLocale) {
        this.OracleSetupBeanConstruct(oracleHostName, centralInventory, null, null, null, setLocale);
    }

    public OracleSetupBean(String oracleHostName, CentralInventorySettings centralInventory, AutoUpdatesInstallSettings autoBean, String[] languages) {
        this.OracleSetupBeanConstruct(oracleHostName, centralInventory, autoBean, null, languages, true);
    }

    public OracleSetupBean(String oracleHostName, CentralInventorySettings centralInventory, AutoUpdatesInstallSettings autoBean, PatchInstallSettings patchSettings, String[] languages) {
        this.OracleSetupBeanConstruct(oracleHostName, centralInventory, autoBean, patchSettings, null, languages, true);
    }

    public OracleSetupBean(String oracleHostName, CentralInventorySettings centralInventory, AutoUpdatesInstallSettings autoBean, boolean setLocale) {
        this.OracleSetupBeanConstruct(oracleHostName, centralInventory, autoBean, null, null, setLocale);
    }

    public OracleSetupBean(String oracleHostName, CentralInventorySettings centralInventory, AutoUpdatesInstallSettings autoBean, WindowsSecureOptionSettings secureBean, String[] languages) {
        this.OracleSetupBeanConstruct(oracleHostName, centralInventory, autoBean, secureBean, languages, true);
    }

    public OracleSetupBean(String oracleHostName, CentralInventorySettings centralInventory, AutoUpdatesInstallSettings autoBean, WindowsSecureOptionSettings secureBean, boolean setLocale) {
        this.OracleSetupBeanConstruct(oracleHostName, centralInventory, autoBean, secureBean, null, setLocale);
    }

    public OracleSetupBean(boolean setLocale) {
        this("", null, null, setLocale);
    }

    public void OracleSetupBeanConstruct(String oracleHostName, CentralInventorySettings centralInventory, AutoUpdatesInstallSettings autoBean, WindowsSecureOptionSettings secureBean, String[] languages, boolean setLocale) {
        this.oracleHostName = oracleHostName;
        this.centralInventory = centralInventory;
        this.autoUpdatesInstallSettings = autoBean;
        this.windowsSecureOptionSettings = secureBean;
        Locale defLocale = OiixLanguage.getDefaultLocale();
        String defLang = defLocale.toString();
        String[] defaultLangs = setLocale ? (!defLang.equals("en") ? new String[]{"en", defLang} : new String[]{"en"}) : new String[]{"en"};
        this.languages = languages == null ? defaultLangs : languages;
        this.ocmSettings = new OCMSettings();
        this.rootConfigurationSettings = new RootConfigurationSettings();
    }

    public void OracleSetupBeanConstruct(String oracleHostName, CentralInventorySettings centralInventory, AutoUpdatesInstallSettings autoBean, PatchInstallSettings patchSettings, WindowsSecureOptionSettings secureBean, String[] languages, boolean setLocale) {
        this.patchInstallSettings = patchSettings;
        this.OracleSetupBeanConstruct(oracleHostName, centralInventory, autoBean, secureBean, languages, setLocale);
    }

    @PropertyDef(value="OCMSettings")
    public OCMSettings getOcmSettings() {
        return this.ocmSettings;
    }

    public void setOcmSettings(OCMSettings ocmSettings) {
        this.ocmSettings = ocmSettings;
    }

    @PropertyDef(value="AutoUpdatesInstallSettings")
    public AutoUpdatesInstallSettings getAutoUpdatesInstallSettings() {
        return this.autoUpdatesInstallSettings;
    }

    public void setAutoUpdatesInstallSettings(AutoUpdatesInstallSettings autoUpdatesInstallSettings) {
        this.autoUpdatesInstallSettings = autoUpdatesInstallSettings;
    }

    @PropertyDef(value="CentralInventorySettings")
    public CentralInventorySettings getCentralInventory() {
        return this.centralInventory;
    }

    public void setCentralInventory(CentralInventorySettings centralInventory) {
        this.centralInventory = centralInventory;
    }

    @PropertyDef(value="WindowsSecureOptionSettings")
    public WindowsSecureOptionSettings getWindowsSecureOptionSettings() {
        return this.windowsSecureOptionSettings;
    }

    public void setWindowsSecureOptionSettings(WindowsSecureOptionSettings windowsSecureOptionSettings) {
        this.windowsSecureOptionSettings = windowsSecureOptionSettings;
    }

    @PropertyDef(value="SELECTED_LANGUAGES")
    public String[] getLanguages() {
        return this.languages;
    }

    public void setLanguages(String[] languages) {
        if (languages != null && !Arrays.equals(this.languages, languages)) {
            String[] oldvalue = this.languages;
            this.languages = languages;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_LANGUAGES, oldvalue, this.languages);
        }
    }

    @PropertyDef(value="ORACLE_HOSTNAME")
    public String getOracleHostName() {
        return this.oracleHostName;
    }

    public void setOracleHostName(String oracleHostName) {
        this.oracleHostName = oracleHostName;
    }

    @PropertyDef(value="RootConfigurationSettings")
    public RootConfigurationSettings getRootConfigurationSettings() {
        return this.rootConfigurationSettings;
    }

    public void setRootConfigurationSettings(RootConfigurationSettings rootConfigurationSettings) {
        this.rootConfigurationSettings = rootConfigurationSettings;
    }

    @PropertyDef(value="PatchInstallSettings")
    public PatchInstallSettings getPatchInstallSettings() {
        return this.patchInstallSettings;
    }

    public void setPatchInstallSettings(PatchInstallSettings patchInstallSettings) {
        this.patchInstallSettings = patchInstallSettings;
    }
}

