/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.config.common;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ExitStatus;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.driver.oui.OUILogHandler;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.util.InventoryInfo;
import oracle.sysman.oii.oiic.OiicGlobalVarsReader;
import oracle.sysman.oii.oiis.OiisVariable;

public class ConfigToolsHelper {
    private static Logger logger = Logger.getLogger(ConfigToolsHelper.class.getName());

    public static void checkHomeIsRegistered(String oracleHome) {
        logger.info("Oracle home for config tools: " + oracleHome);
        boolean isHomeRegistered = false;
        InventoryInfo invInfo = InventoryInfo.getInstance();
        if (invInfo.isInventoryExist() && invInfo.isHomeWithLocationExist(oracleHome)) {
            isHomeRegistered = true;
        }
        if (!isHomeRegistered) {
            ExceptionManager.advise((ErrorMessage)new DefaultErrorMessage((ErrorCode)CommonErrorCode.CONFIG_TOOLS_COMMON_HOME_NOT_REGISTERED, new Object[0]));
            Application application = Application.getInstance();
            application.shutdown((ExitStatus)Application.CommonExitStatus.FAILURE);
        }
    }

    public static String getGlobalVar(String globalVarXml, String installOptionVarName) {
        String installOption = null;
        File globalvarxml_file = new File(globalVarXml);
        if (globalvarxml_file.exists()) {
            Map globalvars = null;
            try {
                globalvars = OiicGlobalVarsReader.readGlobalVariables((String)globalVarXml);
            }
            catch (IOException ioex) {
                logger.warning(ioex.getMessage());
            }
            if (globalvars != null) {
                Object val = null;
                Object v = globalvars.get(installOptionVarName);
                val = v;
                if (v != null) {
                    installOption = ((OiisVariable)val).getValue().toString();
                }
            }
        }
        return installOption;
    }

    public static void addNonEmptyPasswords(Map<String, String> destinationMap, Map<String, String> originMap) {
        if (originMap != null && !originMap.isEmpty()) {
            for (String key : originMap.keySet()) {
                String password;
                if (key == null || key.isEmpty() || (password = originMap.get(key)) == null || password.isEmpty()) continue;
                destinationMap.put(key, password);
            }
        }
    }

    public static void showLogLocation() {
        String logLocation = OUILogHandler.getLogLocation();
        if (logLocation != null && !logLocation.isEmpty()) {
            Application application = Application.getInstance();
            Resource resource = application.getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");
            System.out.println(resource.getString("LogLocationsMessage.text", "You can find the logs of this session at:\n{0}\n", new Object[]{logLocation}));
        }
    }
}

