/*
 * Decompiled with CFR 0.152.
 */
import HTTPClient.ParseException;
import HTTPClient.URI;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLPeerUnverifiedException;
import oracle.sysman.ccr.collector.install.AnonymousMailRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.AnonymousRegistrationPrincipal;
import oracle.sysman.ccr.collector.install.ConfigResponse;
import oracle.sysman.ccr.collector.install.ConnectionException;
import oracle.sysman.ccr.collector.install.InvalidValueException;
import oracle.sysman.ccr.collector.install.LicenseAgreement;
import oracle.sysman.ccr.collector.install.MetaLinkEmailPrincipal;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.OCMRegistrationPrincipal;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.oii.oiix.OiixFunctionOps;

public class OcmDialogValidation {
    public static final int PROXY_SUCCESSFUL = 0;
    public static final int PROXY_UNSUCCESSFUL = 1;
    public static final String METALINKSUCCESSFUL = "0";
    public static final String METALINKUNSUCCESSFUL = "2";
    public static final String RESPONSEFILE_CREATION_SUCCESSFUL = "0";
    public static final String RESPONSEFILE_CREATION_UNSUCCESSFUL = "3";
    public static int ERROR_CODE = -1;
    public static final int UNKNOWN_HOST_ERROR = 1;
    public static final int INVALID_VALUE_ERROR = 2;
    public static final int CONNECTION_ERROR = 3;
    public static final int SSL_PEER_ERROR = 4;
    public static final int INVALID_PORT = -1;
    private LicenseAgreement oLicenceAgree = null;
    private static NetworkConfiguration oNetworkConfig = null;
    private EndPoint oEndPoint = null;
    private static OCMRegistrationPrincipal ocm_registration_principal;

    public OcmDialogValidation() {
        ocm_registration_principal = new AnonymousRegistrationPrincipal();
    }

    String TestInstallProxyConnection(String string, int n, String string2, String string3, String string4, boolean bl) {
        this.debug("Testing OCM Connection.");
        oNetworkConfig = new NetworkConfiguration();
        if (string4 != null && string4.trim().length() > 0) {
            this.debug("The value of repeaterURI is " + string4);
            try {
                oNetworkConfig.setRepeaterURI(new URI(string4));
            }
            catch (InvalidValueException invalidValueException) {
                invalidValueException.printStackTrace();
                this.debug(invalidValueException.getMessage());
                return invalidValueException.getMessage();
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                this.debug(parseException.getMessage());
                return parseException.getMessage();
            }
        }
        if (bl) {
            this.setNoProxy();
            return String.valueOf(0);
        }
        if (string != null && string.length() != 0) {
            try {
                this.debug("Proxy host is not null so setting proxy host.");
                oNetworkConfig.setProxyHost(string);
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
                this.debug(unknownHostException.getMessage());
                return "java.net.UnknownHostException:" + unknownHostException.getMessage();
            }
        }
        if (n != -1) {
            try {
                this.debug("Proxy port is not null so setting proxy port.");
                oNetworkConfig.setProxyPort(n);
            }
            catch (InvalidValueException invalidValueException) {
                invalidValueException.printStackTrace();
                this.debug(invalidValueException.getMessage());
                return invalidValueException.getMessage();
            }
        }
        if (string2 != null && string2.length() != 0 && string3 != null && string3.length() != 0) {
            this.debug("Setting the Proxy credentials");
            oNetworkConfig.setProxyCreds(string2, string3.getBytes());
        }
        if (string != null && n != -1 && string.trim().length() != 0) {
            try {
                this.debug("Testing the connection using proxy information");
                this.oEndPoint = oNetworkConfig.testProxyConnection();
                if (this.oEndPoint == null) {
                    this.debug("Testing the connection using proxy information Unsuccessful");
                    return "Test Connection using the proxy details is Unsuccessful";
                }
                this.debug("Testing the connection using proxy information successful");
                return String.valueOf(0);
            }
            catch (ConnectionException connectionException) {
                connectionException.printStackTrace();
                this.debug(connectionException.getMessage());
                ERROR_CODE = 3;
                return connectionException.getMessage();
            }
        }
        this.debug("Testing the connection without proxy information");
        try {
            if (string4 != null && string4.trim().length() > 0) {
                this.oEndPoint = oNetworkConfig.testConnection();
                if (this.oEndPoint == null) {
                    this.debug("Test connection is unsuccessful ..");
                    return "Test connection without using proxy details is Unsuccessful.";
                }
                this.debug("Test connection is successful ..");
                return String.valueOf(0);
            }
            this.oEndPoint = oNetworkConfig.testProxyConnection();
            if (this.oEndPoint == null) {
                this.debug("Test connection with repeater is unsuccessful ..");
                return "Test connection with repeater is unsuccessful ..";
            }
            this.debug("Test connection is successful ..");
            return String.valueOf(0);
        }
        catch (ConnectionException connectionException) {
            connectionException.printStackTrace();
            this.debug(connectionException.getMessage());
            ERROR_CODE = 3;
            return connectionException.getMessage();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            this.debug(sSLPeerUnverifiedException.getMessage());
            sSLPeerUnverifiedException.printStackTrace();
            return sSLPeerUnverifiedException.getMessage();
        }
        catch (UnknownHostException unknownHostException) {
            this.debug(unknownHostException.getMessage());
            unknownHostException.printStackTrace();
            ERROR_CODE = 1;
            return unknownHostException.getMessage();
        }
        catch (IOException iOException) {
            this.debug(iOException.getMessage());
            iOException.printStackTrace();
            return iOException.getMessage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.debug(exception.getMessage());
            return exception.getMessage();
        }
    }

    public void setNoProxy() {
        oNetworkConfig.setNoProxy();
        ocm_registration_principal = null;
    }

    public EndPoint getConnection() {
        return this.oEndPoint;
    }

    public NetworkConfiguration getNetWorkConfigObject() {
        return oNetworkConfig;
    }

    public void debug(String string) {
        if ("TRUE".equalsIgnoreCase(System.getProperty("oracle.installer.debug"))) {
            OiixFunctionOps.addToLog((String)string);
        }
    }

    public String testMetaLinkconnection(String string, String string2, boolean bl) {
        String string3 = null;
        String string4 = "";
        this.debug("The value of My Oracle SupportUser " + string + " My Oracle SupportPassword *******");
        if (!bl && string.trim().length() != 0 && string2.trim().length() != 0) {
            try {
                this.debug("Calling authenticateMetalinkUser to validate the My Oracle Support credentials");
                if (this.getConnection() != null) {
                    OCMEndPoint oCMEndPoint = new OCMEndPoint(this.getConnection());
                    string3 = oCMEndPoint.authenticateUser(string, string2.getBytes());
                }
            }
            catch (NetworkException networkException) {
                networkException.printStackTrace();
                this.debug(networkException.getMessage());
                string4 = networkException.getMessage();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string4 = exception.getMessage();
            }
            if (string3 != null) {
                ocm_registration_principal = new MetaLinkEmailPrincipal(string, string2.getBytes(), string3);
                this.debug("Test My Oracle Support successful");
                return "0";
            }
            ocm_registration_principal = new AnonymousRegistrationPrincipal();
            this.debug("Test My Oracle Support unsuccessful");
            return string4;
        }
        if (string.trim().length() != 0) {
            this.debug("The noProxyConnection is " + bl + " My Oracle SupportUser " + string + " My Oracle SupportPassword ");
            ocm_registration_principal = new AnonymousMailRegistrationPrincipal(string);
        }
        this.debug("The My Oracle Support validation was successfull");
        return "0";
    }

    public String createOCMResponseFile(String string, boolean bl) {
        if (bl) {
            try {
                this.debug("License Accepted creating the response file");
                if (new File(string).exists() && !new File(string).delete()) {
                    return string + " file already exists and not able to delete.";
                }
                this.debug(" responsefileName " + string + " licenseAccepted " + bl + " getNetWorkConfigObject() " + this.getNetWorkConfigObject() + " ocm_registration_principal " + ocm_registration_principal);
                ConfigResponse.createResponseFile((String)string, (LicenseAgreement)new LicenseAgreement(bl), (NetworkConfiguration)this.getNetWorkConfigObject(), (OCMRegistrationPrincipal)ocm_registration_principal);
                return "0";
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.debug(iOException.getMessage());
            }
        } else {
            try {
                this.debug("Creating the response file in disconnected mode");
                ConfigResponse.createResponseFile((String)string, (LicenseAgreement)new LicenseAgreement(bl), null, null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.debug(iOException.getMessage());
                return iOException.getMessage();
            }
        }
        return "0";
    }

    public static void main(String[] stringArray) {
        OcmDialogValidation ocmDialogValidation = new OcmDialogValidation();
        System.out.println(ocmDialogValidation.TestInstallProxyConnection(null, -1, null, null, "http://sta00680.us.oracle.com:7654", false));
        System.out.println(ocmDialogValidation.createOCMResponseFile("c:\\test\\ocm.rsp", true));
        if (stringArray[0] != null && stringArray[1] != null) {
            System.out.println(ocmDialogValidation.testMetaLinkconnection(stringArray[0], stringArray[1], false));
        }
        System.out.println(ocmDialogValidation.createOCMResponseFile("c:\\test\\ocm1.rsp", true));
        System.out.println(ocmDialogValidation.TestInstallProxyConnection(null, -1, null, null, null, false));
        System.out.println(ocmDialogValidation.createOCMResponseFile("c:\\test\\ocm2.rsp", true));
        System.out.println(ocmDialogValidation.TestInstallProxyConnection(null, -1, null, null, "", false));
        System.out.println(ocmDialogValidation.createOCMResponseFile("c:\\test\\ocm3.rsp", true));
    }

    static {
        ConfigResponse.init();
    }
}

