/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.view;

import java.awt.Component;
import java.io.File;
import java.util.logging.Logger;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.driver.oui.OUIMetadata;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.ivw.client.view.InstallTypesPane;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.library.util.PlatformInfo;

@ViewDef(id="InstallTypesUI")
public class InstallTypesGUI
implements View {
    private static final Logger logger = Logger.getLogger(InstallTypesGUI.class.getName());
    private InstallTypesPane view = new InstallTypesPane();

    public Component getView() {
        return this.view;
    }

    public void localize(FlowContext flowContext) {
        this.view.localize();
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        ClientInstallSettings installSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        if (eventType == EventType.INIT) {
            ClientInstallSettings.InstallType type = installSettings.getInstallType();
            this.view.setInstallType(type);
        }
    }

    public void processInput(FlowContext flowContext) {
        ClientInstallSettings installSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        ClientInstallSettings.InstallType installType = this.view.getInstallType();
        File shiphomePropFile = new File(OUIMetadata.METADATA_FILE_LOC);
        installSettings.setInstallType(installType);
        if (installType == ClientInstallSettings.InstallType.InstantClient) {
            installSettings.setLaunchNETCA(false);
        } else if ((PlatformInfo.getInstance().isSolaris() || PlatformInfo.getInstance().isIntelSolaris()) && shiphomePropFile.exists() && OUIMetadata.is32BitShiphome((String)shiphomePropFile.getAbsolutePath())) {
            installSettings.setLaunchNETCA(false);
        } else {
            installSettings.setLaunchNETCA(true);
        }
        String restartSession = System.getProperty("oracle.install.restartSession");
        if (restartSession != null && restartSession.equalsIgnoreCase("true")) {
            AutoUpdatesInstallSettings autoBean = (AutoUpdatesInstallSettings)flowContext.getBean(AutoUpdatesInstallSettings.class);
            if (installSettings.getInstallType() == ClientInstallSettings.InstallType.InstantClient) {
                autoBean.setApplyUpdates(false);
            } else {
                autoBean.setApplyUpdates(true);
            }
        }
        logger.info("Client Install Type set in InstallTypeUI is : " + (Object)((Object)installType));
    }
}

