/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.validator;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.Validator;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.ivw.client.resource.ClientErrorCode;
import oracle.install.library.processes.RunningProcessInfoUnix;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.NTServiceInfo;
import oracle.install.library.util.PlatformInfo;

public class CustomInstallValidator
implements Validator {
    public static final Resource resource = Application.getInstance().getResource("oracle.install.ivw.client.resource.ClientErrorResID");
    public static Logger logger = Logger.getLogger(CustomInstallValidator.class.getName());

    public void validate(FlowContext flowContext) throws ValidationException {
        ClientInstallSettings clientSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        String[] customComponents = clientSettings.getCustomComponents();
        String oracleHome = clientSettings.getOracleHome();
        if (customComponents.length < 1) {
            throw new ValidationException((ErrorCode)ClientErrorCode.EMPTY_COMPONENTS_LIST, new Object[0]);
        }
        HashMap<String, String> componentMap = new HashMap<String, String>();
        if (!PlatformInfo.getInstance().isWindows()) {
            componentMap.put("oracle.network.listener", oracleHome + "/bin/tnslsnr");
            componentMap.put("oracle.network.aso", oracleHome + "/bin/oracle");
        } else {
            componentMap.put("oracle.network.listener", oracleHome + "\\bin\\tnslsnr.exe");
            componentMap.put("oracle.network.aso", oracleHome + "\\bin\\oracle.exe");
            componentMap.put("oracle.rdbms.scheduler", oracleHome + "\\bin\\jssu.exe");
            componentMap.put("oracle.ntoramts", oracleHome + "\\bin\\omtsreco.exe");
            componentMap.put("oracle.network.client", oracleHome + "\\bin\\nmesrvc.exe");
        }
        if (clientSettings.getInstallType() == ClientInstallSettings.InstallType.Custom && InventoryInfo.getInstance().isHomeWithLocationExist(oracleHome)) {
            ArrayList<String> processList = new ArrayList<String>();
            for (String component : clientSettings.getCustomComponents()) {
                File file;
                String fileName = (String)componentMap.get(component.split(":")[0]);
                if (fileName == null || !(file = new File(fileName)).exists()) continue;
                logger.log(Level.FINE, "File Name::" + fileName);
                processList.add(fileName);
                if (!fileName.contains("tnslsnr") || !PlatformInfo.getInstance().isWindows() || fileName.indexOf(".exe") <= -1) continue;
                fileName = fileName.substring(0, fileName.indexOf(".exe"));
                processList.add(fileName);
            }
            try {
                if (!PlatformInfo.getInstance().isWindows()) {
                    RunningProcessInfoUnix.getInstance().getRunningProcesses(processList.toArray(new String[0]));
                } else {
                    String serviceList = new String();
                    serviceList = NTServiceInfo.getRunningServices((String[])processList.toArray(new String[0]));
                    if (serviceList.length() > 0) {
                        if (serviceList.contains(",")) {
                            serviceList = serviceList.substring(0, serviceList.lastIndexOf(","));
                        }
                        throw new ValidationException((ErrorCode)CommonErrorCode.RUNNING_PROCESSES_SERVICES_FOUND, new Object[]{serviceList});
                    }
                }
            }
            catch (InstallException e) {
                throw new ValidationException((Throwable)e, e.getErrorInfo());
            }
        }
    }
}

