/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.driver;

import java.net.URL;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.interview.common.action.AbstractPrereqAction;
import oracle.install.commons.base.interview.common.util.PrereqExecutor;
import oracle.install.commons.bean.xml.PropertyFileFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreFormatRegistry;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.ivw.client.action.PrereqAction;
import oracle.install.ivw.client.bean.ClientSetupBean;
import oracle.install.ivw.common.util.OracleInstaller;

public class ClientInstaller
extends OracleInstaller {
    public static final String FLOW_CONFIG = "/oracle/install/ivw/client/resource/clientinstall-flow-config.xml";
    public static final String APPLICATION_CONFIG = "/oracle/install/ivw/client/resource/application-config.xml";

    public ClientInstaller() {
        this.init();
    }

    protected void init() {
        super.init();
        SetupDriver.registerDriver((String)"oracle.install.ivw.client.driver.ClientSetupDriver");
        System.setProperty("oracle.sysman.ccr.supressregistration", "true");
        XmlBeanStoreFormatRegistry registry = XmlBeanStoreFormatRegistry.getInstance();
        URL xsd = ClientInstaller.class.getResource("/oracle/install/ivw/client/resource/responsefile/clientinstall_rspfmt_response_schema_v11_2_0.xsd");
        URL raw2extTransformer = ClientInstaller.class.getResource("/oracle/install/ivw/client/resource/responsefile/rspfmt_raw2ext_transformer_v11_2_0.xsl");
        URL ext2rawTransformer = ClientInstaller.class.getResource("/oracle/install/ivw/client/resource/responsefile/rspfmt_ext2raw_transformer_v11_2_0.xsl");
        String namespaceURI = "/oracle/install/rspfmt_clientinstall_response_schema_v12.2.0";
        PropertyFileFormat rspFormat = new PropertyFileFormat(namespaceURI, raw2extTransformer, ext2rawTransformer, xsd);
        registry.registerFileFormat("rsp", (XmlBeanStoreFormat)rspFormat, true);
        Application.setActiveHelpRegistryResourcePath((String)"oracle.install.ivw.client.resource.ContextualHelpResource");
        this.setPrereqExecutor(new PrereqExecutor((AbstractPrereqAction)new PrereqAction()));
    }

    public void startup(String ... args) {
        super.startup(APPLICATION_CONFIG, FLOW_CONFIG, args);
    }

    public void run() {
        super.run();
        SetupDriver setupDriver = SetupDriver.getInstance();
        Object setupBean = setupDriver.getSetupBean();
        if (setupBean instanceof ClientSetupBean) {
            this.loadCmdLineVarsToBean(((ClientSetupBean)((Object)setupBean)).getClientInstallSettings());
        }
    }

    public static void main(String[] args) {
        try {
            ClientInstaller installer = (ClientInstaller)Application.getInstance(ClientInstaller.class);
            installer.startup(args);
        }
        catch (Exception e) {
            ExceptionManager.handle((Throwable)e);
        }
    }
}

