/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.driver;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.config.client.CMANHelper;
import oracle.install.config.client.SchedulerAgentHelper;
import oracle.install.config.common.ConfigToolsHelper;
import oracle.install.config.common.MTSHelper;
import oracle.install.config.common.NETCAHelperV2;
import oracle.install.driver.oui.ConfigJob;
import oracle.install.ivw.client.bean.ClientSetupBean;
import oracle.install.ivw.common.bean.WindowsSecureOptionSettings;

public class ClientConfigToolsDriver {
    private static Logger logger = Logger.getLogger(ClientConfigToolsDriver.class.getName());
    private String topComponent = "oracle.client";
    private ClientSetupBean setupBean;

    public ClientConfigToolsDriver(ClientSetupBean setupBean) {
        this.setupBean = setupBean;
    }

    public CompositeJob prepareJob() throws SetupDriverException {
        ConfigToolsHelper.showLogLocation();
        CompositeJob job = new CompositeJob();
        ConfigJob configJob = this.getClientConfigJob();
        job.add((Job)configJob);
        return job;
    }

    private ConfigJob getClientConfigJob() {
        String oraHomePath = this.setupBean.getClientInstallSettings().getOracleHome();
        ConfigJob configJob = new ConfigJob((Object)"Config", 0.2f, oraHomePath, this.topComponent);
        this.setClientPasswordParams(configJob);
        return configJob;
    }

    private void setClientPasswordParams(ConfigJob configJob) {
        HashMap transParams = new HashMap();
        HashMap passwordParams = new HashMap();
        Map netcaPasswordParams = NETCAHelperV2.getPasswordParams((WindowsSecureOptionSettings)this.setupBean.getWindowsSecureOptionSettings(), (boolean)true);
        ConfigToolsHelper.addNonEmptyPasswords(passwordParams, (Map)netcaPasswordParams);
        transParams.put(this.topComponent, passwordParams);
        passwordParams = new HashMap();
        Map<String, String> cmanPasswordParams = CMANHelper.getPasswordParams(this.setupBean.getWindowsSecureOptionSettings(), true);
        ConfigToolsHelper.addNonEmptyPasswords(passwordParams, cmanPasswordParams);
        transParams.put("oracle.network.cman", passwordParams);
        passwordParams = new HashMap();
        Map mtsPasswordParams = MTSHelper.getPasswordParams((WindowsSecureOptionSettings)this.setupBean.getWindowsSecureOptionSettings(), (boolean)true);
        ConfigToolsHelper.addNonEmptyPasswords(passwordParams, (Map)mtsPasswordParams);
        transParams.put("oracle.ntoramts", passwordParams);
        passwordParams = new HashMap();
        Map<String, String> saPasswordParams = SchedulerAgentHelper.getPasswordParams(this.setupBean.getWindowsSecureOptionSettings(), true);
        ConfigToolsHelper.addNonEmptyPasswords(passwordParams, saPasswordParams);
        transParams.put("oracle.rdbms.scheduler", passwordParams);
        configJob.setTransientParametersMap(transParams);
    }
}

