/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.client.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.Action;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.flow.validation.annotation.ValidatorRef;
import oracle.install.commons.util.Version;
import oracle.install.ivw.client.bean.ClientInstallSettings;
import oracle.install.ivw.client.validator.InstallLocationValidator;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.PlatformInfo;

@UIRef(value="InstallLocationUI")
@ValidatorRef(value=InstallLocationValidator.class)
public class InstallLocationAction
implements Action {
    private Logger logger = Logger.getLogger(InstallLocationAction.class.getName());
    private static final Route ICHOME_SELECTED = new Route("ICHOME_SELECTED");

    public final void execute(FlowContext flowContext) {
    }

    public final Route transition(FlowContext flowContext) {
        ClientInstallSettings installSettings = (ClientInstallSettings)((Object)flowContext.getBean(ClientInstallSettings.class));
        ClientInstallSettings.InstallType installType = installSettings.getInstallType();
        installSettings.setInternalInstallType(installSettings.getInstallType().name());
        if (installSettings.isUpgrading()) {
            Version version;
            String oraHome = installSettings.getOracleHome();
            InventoryInfo invInfo = InventoryInfo.getInstance();
            String type = invInfo.getComponentInstallType(oraHome, "oracle.client");
            if (type != null && type.length() > 0) {
                if (type.equalsIgnoreCase(ClientInstallSettings.InstallType.InstantClient.name())) {
                    installSettings.setInternalInstallType(ClientInstallSettings.InstallType.InstantClient.name());
                    installSettings.setOracleBase("");
                    installSettings.setInstallType(ClientInstallSettings.InstallType.InstantClient);
                } else {
                    installSettings.setOracleBase(installSettings.getOracleBase());
                    if (type.equalsIgnoreCase(ClientInstallSettings.InstallType.Administrator.name())) {
                        installSettings.setInternalInstallType(ClientInstallSettings.InstallType.Administrator.name());
                        installSettings.setInstallType(ClientInstallSettings.InstallType.Administrator);
                    } else if (type.equalsIgnoreCase(ClientInstallSettings.InstallType.Runtime.name())) {
                        installSettings.setInternalInstallType(ClientInstallSettings.InstallType.Runtime.name());
                        installSettings.setInstallType(ClientInstallSettings.InstallType.Runtime);
                    } else if (type.equalsIgnoreCase(ClientInstallSettings.InstallType.Custom.name())) {
                        installSettings.setInternalInstallType(ClientInstallSettings.InstallType.Custom.name());
                        installSettings.setInstallType(ClientInstallSettings.InstallType.Custom);
                    }
                }
            }
            if ((version = InventoryInfo.getInstance().getCompVersion("oracle.rdbms.scheduler", oraHome)) != null && version.compareTo(InstallConstants.VERSION) <= 0) {
                Properties properties = new Properties();
                File schagentConfigFile = new File(oraHome + File.separator + "schagent.conf");
                try {
                    if (schagentConfigFile.exists()) {
                        properties.load(new FileInputStream(schagentConfigFile));
                    }
                }
                catch (FileNotFoundException e) {
                    this.logger.log(Level.INFO, "File Not found while reading scheduler agent properties file", e);
                }
                catch (IOException e) {
                    this.logger.log(Level.INFO, "Exception while reading sceduler agent properties file", e);
                }
                String port = properties.getProperty("PORT");
                String hostname = properties.getProperty("HOST_NAME");
                if (port != null) {
                    installSettings.setSchAgtPort(Integer.parseInt(port));
                }
                if (hostname != null) {
                    installSettings.setSchAgtHost(hostname);
                }
            }
            String[] compsToUpgrade = invInfo.getAllCompsForHome(oraHome);
            installSettings.setCustomComponents(compsToUpgrade);
        }
        if (PlatformInfo.getInstance().isWindows() && installType == ClientInstallSettings.InstallType.InstantClient) {
            return new Route("ICHOME_SELECTED");
        }
        this.logger.log(Level.INFO, "Entering into Unix section.");
        if (InventoryInfo.getInstance().isInventoryExist()) {
            if (installSettings.isUpgrading()) {
                String home = installSettings.getOracleHome();
                String clientInstallType = InventoryInfo.getInstance().getComponentInstallType(home, "oracle.client");
                if (clientInstallType.equalsIgnoreCase(ClientInstallSettings.InstallType.InstantClient.toString())) {
                    return new Route("ICHOME_SELECTED");
                }
                return new Route("NON_ICHOME_SELECTED");
            }
            if (installType == ClientInstallSettings.InstallType.Custom) {
                this.logger.log(Level.INFO, "InstallLocationAction to INVENTORY_YES_CUSTOM_YES");
                return new Route("INVENTORY_YES_CUSTOM_YES");
            }
            this.logger.log(Level.INFO, "InstallLocationAction to INVENTORY_YES");
            return new Route("INVENTORY_YES");
        }
        if (installType == ClientInstallSettings.InstallType.Custom) {
            this.logger.log(Level.INFO, "InstallLocationAction to INVENTORY_NO_CUSTOM_YES");
            return new Route("INVENTORY_NO_CUSTOM_YES");
        }
        this.logger.log(Level.INFO, "InstallLocationAction to INVENTORY_NO");
        return new Route("INVENTORY_NO");
    }
}

