/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.SortableTwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.BooleanInputHandler;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridEditListener;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridRowSelectListener;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.GridToolTipClient;
import oracle.ewt.grid.RadioPainter;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.header.Header;
import oracle.ewt.header.HeaderItemInputHandler;
import oracle.ewt.header.HeaderKeyHandler;
import oracle.ewt.header.NullItemSelection;
import oracle.ewt.header.StandardHeaderKeyHandler;
import oracle.ewt.layout.GroupBoxContainer;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.popup.ToolTipClient;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;

public class SIDBUpgrade
extends OiifpWizPanel
implements ItemListener,
GridRowSelectListener,
GridEditListener {
    private static final String DEFAULT_TITLE = "Upgrade AN Existing Database";
    private static final String DEFAULT_PROMPT_0 = "You may upgrade one of the databases listed below to Oracle Database 10g Release 2 during this install session.  You may additionally upgrade Automatic Storage Management (ASM) to Release 2 as well.  If you select a database that uses ASM, both the database and ASM can be upgraded in the same session.  If you choose to perform an upgrade, the Oracle Database Upgrade Assistant (DBUA) will be launched at the end of the install to step you through the upgrade process. \n\nDo you want to perform an upgrade now?";
    private static final String DEFAULT_CHECK_BOX_0 = "No";
    private static final String DEFAULT_CHECK_BOX_1 = "Yes";
    private static final String DEFAULT_CHECK_BOX_2 = "Upgrade an existing database";
    private static final String DEFAULT_CHECK_BOX_3 = "Upgrade ASM instance currently running from ";
    private static String[] DEF_COL_HEADERS = new String[]{OiStdDialogRes.getString("SELECT"), OiStdDialogRes.getString("ORACLE_HOME"), OiStdDialogRes.getString("SID"), OiStdDialogRes.getString("USES_ASM")};
    private static int S_SELECT_COLWIDTH = 40;
    private static int S_ORAHOME_COLWIDTH = 350;
    private static int S_SID_COLWIDTH = 100;
    private static int S_USES_ASM_COLWIDTH = 80;
    private static int totRows = 0;
    private SpreadTable sTable;
    private SortableTwoDDataSource data;
    private ArrayOneDDataSource header;
    private ScrollBox tableScroll;
    private MultiLineLabel prompt0 = new MultiLineLabel(WordWrapper.getTextWrapper(), "You may upgrade one of the databases listed below to Oracle Database 10g Release 2 during this install session.  You may additionally upgrade Automatic Storage Management (ASM) to Release 2 as well.  If you select a database that uses ASM, both the database and ASM can be upgraded in the same session.  If you choose to perform an upgrade, the Oracle Database Upgrade Assistant (DBUA) will be launched at the end of the install to step you through the upgrade process. \n\nDo you want to perform an upgrade now?");
    private LWCheckboxGroup checkGroup0 = new LWCheckboxGroup();
    private LWCheckbox checkbox0 = new LWCheckbox("No", this.checkGroup0, true);
    private LWCheckbox checkbox1 = new LWCheckbox("Yes", this.checkGroup0, false);
    private LWCheckbox checkbox2 = new LWCheckbox("Upgrade an existing database");
    private LWCheckbox checkbox3 = new LWCheckbox("Upgrade ASM instance currently running from ");
    private LWContainer panel0 = null;
    private LWContainer panel1 = null;
    private LWContainer panel2 = null;
    private LWContainer containerForPanel2 = null;
    private LWContainer panel2_0 = null;
    private LWContainer panel2_1 = null;
    private LWContainer containerForPanel2_0 = null;
    private LWContainer panel2_0_0 = null;
    private Container frame;
    private GridBagLayout gridBag = new GridBagLayout();
    private GridBagConstraints c;
    private Color _defaultColor;
    private static final int CHECK_BOX_0 = 0;
    private static final int CHECK_BOX_1 = 1;
    private static final int CHECK_BOX_2 = 2;
    private static final int CHECK_BOX_3 = 3;
    private boolean inPlaceInstallAtASMHome = false;
    private boolean ASMInstancePresent = true;
    private boolean ASMAlreadyUpgraded = false;
    private boolean stateOfASMUpgradeCheckbox;

    public SIDBUpgrade() {
        super(DEFAULT_TITLE);
        this.mainPanel.setLayout((LayoutManager)this.gridBag);
        this.c = new GridBagConstraints();
        this.frame = this;
        this.createPanel0();
        this.createPanel2();
        this.addComponent((Component)this.panel0, (Container)this.mainPanel, this.gridBag, this.c, 1, 17, 0, 0, 4, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.panel2, (Container)this.mainPanel, this.gridBag, this.c, 1, 17, 0, 2, 4, 1, 1.0, 0.35, new Insets(0, 0, 0, 0));
        this.checkbox0.addItemListener((ItemListener)this);
        this.checkbox1.addItemListener((ItemListener)this);
        this.checkbox2.addItemListener((ItemListener)this);
        this.checkbox3.addItemListener((ItemListener)this);
        this._defaultColor = this.prompt0.getBackground();
    }

    public void createPanel0() {
        GridBagLayout gridBag1 = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        this.panel0 = new LWContainer();
        this.panel0.setLayout((LayoutManager)gridBag1);
        this.addComponent((Component)this.prompt0, (Container)this.panel0, gridBag1, c1, 1, 17, 0, 0, 1, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
    }

    public void createPanel1() {
        GridBagLayout gridbag0 = new GridBagLayout();
        GridBagConstraints c0 = new GridBagConstraints();
        this.panel1 = new LWContainer();
        this.panel1.setLayout((LayoutManager)gridbag0);
        this.addComponent((Component)this.checkbox0, (Container)this.panel1, gridbag0, c0, 2, 17, 0, 0, 1, 1, 1.0, 0.0, new Insets(0, 15, 0, 0));
    }

    public void createPanel2() {
        GridBagLayout gridbag0 = new GridBagLayout();
        GridBagConstraints c0 = new GridBagConstraints();
        this.panel2 = new LWContainer();
        this.panel2.setLayout((LayoutManager)gridbag0);
        GridBagLayout gridbag1 = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        LWComponent containerForPanel2 = new LWComponent();
        containerForPanel2.setLayout((LayoutManager)gridbag1);
        this.addComponent((Component)this.checkbox0, (Container)this.panel2, gridbag0, c0, 2, 17, 0, 0, 1, 1, 1.0, 0.0, new Insets(0, 15, 0, 0));
        GroupBoxContainer gbPanel = new GroupBoxContainer((Component)this.checkbox1, (Component)containerForPanel2);
        this.addComponent((Component)gbPanel, (Container)this.panel2, gridbag0, c0, 1, 17, 0, 1, 1, 1, 1.0, 1.0, new Insets(0, 0, 0, 0));
        this.createPanel2_0();
        this.addComponent((Component)this.panel2_0, (Container)containerForPanel2, gridbag1, c1, 1, 17, 0, 0, 1, 1, 1.0, 1.0, new Insets(0, 5, 0, 0));
        if (this.ASMInstancePresent) {
            this.createPanel2_1();
            this.addComponent((Component)this.panel2_1, (Container)containerForPanel2, gridbag1, c1, 1, 17, 0, 1, 1, 1, 1.0, 0.0, new Insets(0, 5, 0, 0));
        }
    }

    public void createPanel2_0() {
        GridBagLayout gridbag0 = new GridBagLayout();
        GridBagConstraints c0 = new GridBagConstraints();
        this.panel2_0 = new LWContainer();
        this.panel2_0.setLayout((LayoutManager)gridbag0);
        GridBagLayout gridbag1 = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        LWComponent containerForPanel2_0 = new LWComponent();
        containerForPanel2_0.setLayout((LayoutManager)gridbag1);
        GroupBoxContainer gbPanel = new GroupBoxContainer((Component)this.checkbox2, (Component)containerForPanel2_0);
        this.addComponent((Component)gbPanel, (Container)this.panel2_0, gridbag0, c0, 1, 17, 0, 0, 1, 1, 1.0, 1.0, new Insets(3, 0, 0, 0));
        this.createPanel2_0_0();
        this.addComponent((Component)this.panel2_0_0, (Container)containerForPanel2_0, gridbag1, c1, 1, 17, 0, 0, 1, 1, 1.0, 1.0, new Insets(0, 5, 0, 0));
    }

    public void createPanel2_0_0() {
        GridBagLayout gridBag1 = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        this.panel2_0_0 = new LWContainer();
        this.panel2_0_0.setLayout((LayoutManager)gridBag1);
        this.header = new ArrayOneDDataSource((Object[])DEF_COL_HEADERS);
        this.data = new SortableTwoDDataSource(4, 0);
        this.sTable = new SpreadTable((TwoDDataSource)this.data, (OneDDataSource)this.header, null);
        this.sTable.setColumnWidth(0, S_SELECT_COLWIDTH);
        this.sTable.setColumnWidth(1, S_ORAHOME_COLWIDTH);
        this.sTable.setColumnWidth(2, S_SID_COLWIDTH);
        this.sTable.setColumnWidth(3, S_USES_ASM_COLWIDTH);
        this.sTable.setHorizontalSeparatorsVisible(true);
        this.sTable.setVerticalSeparatorsVisible(true);
        Grid grid = this.sTable.getGrid();
        grid.setGridSelection((GridSelection)new SingleRowSelection());
        grid.setColumnPainter(0, RadioPainter.getPainter());
        grid.setColumnCellInputHandler(0, BooleanInputHandler.getCellInputHandler());
        grid.setToolTipValue((ToolTipClient)new CustomToolTipClient());
        grid.addRowSelectListener((GridRowSelectListener)this);
        grid.addEditListener((GridEditListener)this);
        Header h = this.sTable.getColumnHeader();
        h.setCanMoveItems(false);
        h.setHeaderSelection(NullItemSelection.getHeaderSelection());
        h.setHeaderKeyHandler((HeaderKeyHandler)new KeyHandler());
        h.setItemInputHandler((HeaderItemInputHandler)new SortInputHandler(this.data));
        this.tableScroll = new ScrollBox((Component)this.sTable, 0, 0);
        this.addComponent((Component)this.tableScroll, (Container)this.panel2_0_0, gridBag1, c1, 1, 17, 0, 0, 0, 1, 1.0, 0.05, new Insets(0, 0, 0, 0));
    }

    public void createPanel2_1() {
        GridBagLayout gridbag0 = new GridBagLayout();
        GridBagConstraints c0 = new GridBagConstraints();
        this.panel2_1 = new LWContainer();
        this.panel2_1.setLayout((LayoutManager)gridbag0);
        this.addComponent((Component)this.checkbox3, (Container)this.panel2_1, gridbag0, c0, 2, 17, 0, 0, 1, 1, 1.0, 0.0, new Insets(5, 15, 0, 0));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.checkbox0) {
                this.makeSelection(0);
            } else if (e.getSource() == this.checkbox1) {
                this.makeSelection(1);
            } else if (e.getSource() == this.checkbox2) {
                this.makeSelection(2);
            } else if (e.getSource() == this.checkbox3) {
                this.makeSelection(3);
            }
        } else if (e.getStateChange() == 2) {
            if (e.getSource() == this.checkbox2) {
                this.sTable.setEnabled(false);
                if (this.ASMInstancePresent && !this.inPlaceInstallAtASMHome && !this.ASMAlreadyUpgraded) {
                    this.checkbox3.setEnabled(true);
                }
            } else if (e.getSource() == this.checkbox3 && this.ASMInstancePresent && !this.inPlaceInstallAtASMHome) {
                int[] selRows = this.sTable.getGrid().getGridSelection().getSelectedRows();
                int rowIdx = selRows[0];
                this.stateOfASMUpgradeCheckbox = false;
            }
        }
    }

    private void makeSelection(int number) {
        if (number == 0) {
            this.checkbox0.setState(true);
            this.checkbox2.setEnabled(false);
            this.checkbox3.setEnabled(false);
            this.sTable.setEnabled(false);
        } else if (number == 1) {
            this.checkbox1.setState(true);
            this.checkbox2.setEnabled(this.data.getRowCount() > 0);
            if (this.checkbox2.getState()) {
                this.makeSelection(2);
            }
            if (this.ASMInstancePresent) {
                if (this.inPlaceInstallAtASMHome) {
                    this.checkbox3.setState(!this.ASMAlreadyUpgraded);
                    this.checkbox3.setEnabled(false);
                } else if (this.ASMAlreadyUpgraded) {
                    this.checkbox3.setEnabled(false);
                } else if (!this.checkbox2.getState()) {
                    this.checkbox3.setEnabled(true);
                }
            }
        } else if (number == 2) {
            int[] selRows;
            this.checkbox2.setState(true);
            this.sTable.setEnabled(true);
            if (this.ASMInstancePresent && !this.inPlaceInstallAtASMHome && !this.ASMAlreadyUpgraded && (selRows = this.sTable.getGrid().getGridSelection().getSelectedRows()) != null) {
                int rowIdx = selRows[0];
                String strUsesASM = (String)this.data.getData(3, rowIdx);
                boolean usesASM = strUsesASM.equalsIgnoreCase(DEFAULT_CHECK_BOX_1) || strUsesASM.equalsIgnoreCase("Unknown");
                this.checkbox3.setState(usesASM && this.stateOfASMUpgradeCheckbox);
                this.checkbox3.setEnabled(usesASM);
            }
        } else if (number == 3 && this.ASMInstancePresent && !this.inPlaceInstallAtASMHome) {
            int[] selRows = this.sTable.getGrid().getGridSelection().getSelectedRows();
            int rowIdx = selRows[0];
            this.stateOfASMUpgradeCheckbox = true;
        }
    }

    public void cellEditing(GridEvent e) {
    }

    public void cellEdited(GridEvent e) {
        if (this.data.getRowCount() > 0 && e.getColumn() == 0) {
            int selectedRow = e.getRow();
            this.data.setData(0, selectedRow, (Object)new Boolean(true));
            for (int i = 0; i < this.data.getRowCount(); ++i) {
                if (i == selectedRow) continue;
                this.data.setData(0, i, (Object)new Boolean(false));
            }
        }
    }

    public void rowSelecting(GridEvent e) {
    }

    public void rowDeselecting(GridEvent e) {
    }

    public void rowDeselected(GridEvent e) {
    }

    public void rowSelected(GridEvent e) {
        if (this.data.getRowCount() > 0) {
            int selectedRow = e.getRow();
            this.data.setData(0, selectedRow, (Object)new Boolean(true));
            for (int i = 0; i < this.data.getRowCount(); ++i) {
                if (i == selectedRow) continue;
                this.data.setData(0, i, (Object)new Boolean(false));
            }
            if (this.checkbox2.getState() && this.ASMInstancePresent && !this.inPlaceInstallAtASMHome && !this.ASMAlreadyUpgraded) {
                String strUsesASM = (String)this.data.getData(3, selectedRow);
                boolean usesASM = strUsesASM.equalsIgnoreCase(DEFAULT_CHECK_BOX_1) || strUsesASM.equalsIgnoreCase("Unknown");
                this.checkbox3.setState(this.stateOfASMUpgradeCheckbox && usesASM);
                this.checkbox3.setEnabled(usesASM);
            }
        }
    }

    public void setInPlaceInstallAtASMHome(Boolean bool) {
        this.inPlaceInstallAtASMHome = bool;
    }

    public Boolean getInPlaceInstallAtASMHome() {
        return new Boolean(this.inPlaceInstallAtASMHome);
    }

    public void setASMInstancePresent(Boolean bool) {
        this.ASMInstancePresent = bool;
        if (!this.ASMInstancePresent) {
            this.checkbox3.setVisible(false);
        }
    }

    public Boolean getASMInstancePresent() {
        return new Boolean(this.ASMInstancePresent);
    }

    public void setASMAlreadyUpgraded(Boolean bool) {
        this.ASMAlreadyUpgraded = bool;
    }

    public Boolean getASMAlreadyUpgraded() {
        return new Boolean(this.ASMAlreadyUpgraded);
    }

    public void setPrompt0(String text) {
        if (text != null) {
            this.prompt0.setText(text);
        }
    }

    public void setCheckBoxLabel0(String text) {
        if (text != null) {
            this.checkbox0.setLabel(text);
        }
    }

    public void setCheckBoxLabel1(String text) {
        if (text != null) {
            this.checkbox1.setLabel(text);
        }
    }

    public void setCheckBoxLabel2(String text) {
        if (text != null) {
            this.checkbox2.setLabel(text);
        }
    }

    public void setCheckBoxLabel3(String text) {
        if (text != null) {
            this.checkbox3.setLabel(text);
        }
    }

    public void setSelectable(String[] list) {
        if (list.length == 0) {
            this.checkbox2.setEnabled(false);
            return;
        }
        this.invalidate();
        this.data.removeRows(0, this.data.getRowCount());
        int rows = list.length / 3;
        int listIdx = 0;
        this.data.addRows(0, rows);
        for (int rowIdx = 0; rowIdx < rows; ++rowIdx) {
            for (int colIdx = 1; colIdx < this.data.getColumnCount(); ++colIdx) {
                this.data.setData(colIdx, rowIdx, (Object)list[listIdx++]);
            }
            this.data.setData(0, rowIdx, (Object)new Boolean(false));
        }
        this.sTable.setDataSources((TwoDDataSource)this.data, (OneDDataSource)this.header, null);
        this.sTable.getGrid().getGridSelection().setRowSelected(0, true);
        this.validate();
    }

    public String[] getSelectable() {
        String[] selectables = new String[this.data.getRowCount() * (this.data.getColumnCount() - 1)];
        int k = 0;
        for (int i = 0; i < this.data.getRowCount(); ++i) {
            for (int j = 1; j < this.data.getColumnCount(); ++j) {
                selectables[k++] = (String)this.data.getData(j, i);
            }
        }
        return selectables;
    }

    public void setPerformUpgrade(Integer idx) {
        if (idx == 0) {
            this.checkbox0.setState(true);
        } else {
            this.checkbox1.setState(true);
        }
    }

    public Integer getPerformUpgrade() {
        if (this.checkbox0.getState()) {
            return new Integer(0);
        }
        return new Integer(1);
    }

    public void setUpgradeDB(Integer idx) {
        if (idx == 0) {
            this.checkbox2.setState(false);
        } else {
            this.checkbox2.setState(true);
        }
        this.checkbox2.setEnabled(this.checkbox1.getState());
        this.sTable.setEnabled(this.checkbox1.getState() && this.checkbox2.getState());
    }

    public Integer getUpgradeDB() {
        if (this.checkbox2.getState()) {
            return new Integer(1);
        }
        return new Integer(0);
    }

    public void setSelection(Integer idx) {
        this.sTable.getGrid().getGridSelection().setRowSelected(idx.intValue(), true);
    }

    public Integer getSelection() {
        int[] selRows = this.sTable.getGrid().getGridSelection().getSelectedRows();
        if (selRows != null) {
            return new Integer(selRows[0]);
        }
        return new Integer(-1);
    }

    public void setSelectedOracleHome(String str) {
    }

    public String getSelectedOracleHome() {
        if (this.data.getRowCount() > 0) {
            int[] selRows = this.sTable.getGrid().getGridSelection().getSelectedRows();
            if (selRows != null) {
                int rowIdx = selRows[0];
                return (String)this.data.getData(1, rowIdx);
            }
            return new String("-");
        }
        return "";
    }

    public void setSelectedSID(String str) {
    }

    public String getSelectedSID() {
        if (this.data.getRowCount() > 0) {
            int[] selRows = this.sTable.getGrid().getGridSelection().getSelectedRows();
            if (selRows != null) {
                int rowIdx = selRows[0];
                return (String)this.data.getData(2, rowIdx);
            }
            return new String("-");
        }
        return "";
    }

    public void setSelectedDBUsesASM(String str) {
    }

    public String getSelectedDBUsesASM() {
        if (this.data.getRowCount() > 0) {
            int[] selRows = this.sTable.getGrid().getGridSelection().getSelectedRows();
            if (selRows != null) {
                int rowIdx = selRows[0];
                return (String)this.data.getData(3, rowIdx);
            }
            return "";
        }
        return "";
    }

    public void setUpgradeASM(Integer idx) {
        if (idx == 0) {
            this.checkbox3.setState(false);
            this.stateOfASMUpgradeCheckbox = false;
        } else {
            this.checkbox3.setState(true);
            this.stateOfASMUpgradeCheckbox = true;
        }
    }

    public Integer getUpgradeASM() {
        if (this.checkbox3.getState()) {
            return new Integer(1);
        }
        return new Integer(0);
    }

    public void setEnableUpgradeASMCheckbox(Boolean bool) {
        this.checkbox3.setEnabled(bool.booleanValue());
    }

    public Boolean getEnableUpgradeASMCheckbox() {
        return new Boolean(this.checkbox3.isEnabled());
    }

    private void addComponent(Component src, Container dest, GridBagLayout gbl, GridBagConstraints gbc, int fill, int anchor, int x, int y, int w, int h, double weightx, double weighty, Insets insets) {
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        gbl.setConstraints(src, gbc);
        dest.add(src);
    }

    public void markPrompt0() {
        this.prompt0.setBackground(this._markColor);
    }

    public void markCheckBoxLabel0() {
        this.checkbox0.setBackground(this._markColor);
    }

    public void markCheckBoxLabel1() {
        this.checkbox1.setBackground(this._markColor);
    }

    public void markCheckBoxLabel2() {
        this.checkbox2.setBackground(this._markColor);
    }

    public void markCheckBoxLabel3() {
        this.checkbox3.setBackground(this._markColor);
    }

    public void markPerformUpgrade() {
        this.checkbox0.setBackground(this._markColor);
        this.checkbox1.setBackground(this._markColor);
    }

    public void markSelection() {
        this.checkbox2.setBackground(this._markColor);
        this.checkbox3.setBackground(this._markColor);
    }

    public void unmarkPrompt0() {
        this.prompt0.setBackground(this._defaultColor);
    }

    public void unmarkCheckBoxLabel0() {
        this.checkbox0.setBackground(this._defaultColor);
    }

    public void unmarkCheckBoxLabel1() {
        this.checkbox1.setBackground(this._defaultColor);
    }

    public void unmarkCheckBoxLabel2() {
        this.checkbox2.setBackground(this._defaultColor);
    }

    public void unmarkCheckBoxLabel3() {
        this.checkbox3.setBackground(this._defaultColor);
    }

    public void unmarkSelection() {
        this.checkbox0.setBackground(this._defaultColor);
        this.checkbox1.setBackground(this._defaultColor);
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        SIDBUpgrade obj = new SIDBUpgrade();
        String[] str = new String[]{"123", "234", "Unknown", "34q543", "45324", DEFAULT_CHECK_BOX_1, "fghgfh", "rtyutu", "765"};
        String[] str1 = new String[]{};
        obj.setSelectable(str);
        f.add((Component)((Object)obj));
        f.setSize(630, 400);
        f.show();
    }

    private class CustomToolTipClient
    extends GridToolTipClient {
        private CustomToolTipClient() {
        }

        protected Object getCellToolTipValue(Grid grid, int column, int row) {
            return grid.getDataSource().getData(column, row);
        }

        protected boolean shouldDisplay(Grid grid, int column, int row) {
            return column != 0;
        }
    }

    public class SortInputHandler
    implements HeaderItemInputHandler {
        private SortableTwoDDataSource _ds;
        private int _item = -1;
        private boolean _inside;
        private boolean[] _order;

        public SortInputHandler(SortableTwoDDataSource ds) {
            this._ds = ds;
            this._order = new boolean[ds.getColumnCount()];
        }

        public void sort(int index) {
            boolean order = this._order[index];
            this._ds.sort(index, order);
            this._order[index] = !order;
            for (int i = 0; i < this._ds.getRowCount(); ++i) {
                Boolean bool = (Boolean)this._ds.getData(0, i);
                if (!bool.booleanValue()) continue;
                SIDBUpgrade.this.sTable.getGrid().getGridSelection().setRowSelected(i, true);
                break;
            }
        }

        public void mousePressed(MouseEvent e, Header header, int itemIndex) {
            this._inside = true;
            this._item = itemIndex;
        }

        public void mouseClicked(MouseEvent e, Header header, int itemIndex) {
        }

        public void mouseDragged(MouseEvent e, Header header, int itemIndex) {
        }

        public void mouseReleased(MouseEvent e, Header header, int itemIndex) {
            if (this._item == -1) {
                return;
            }
            if (this._inside && this._item == itemIndex) {
                this.sort(itemIndex);
            }
            this._item = -1;
        }

        public void mouseEntered(MouseEvent e, Header header, int itemIndex) {
            if (itemIndex == this._item) {
                this._inside = true;
            }
        }

        public void mouseExited(MouseEvent e, Header header, int itemIndex) {
            if (itemIndex == this._item) {
                this._inside = false;
            }
        }

        public void mouseMoved(MouseEvent e, Header header, int itemIndex) {
        }
    }

    private class KeyHandler
    extends StandardHeaderKeyHandler {
        private KeyHandler() {
        }

        public void handleKeyEvent(Header header, KeyEvent e) {
            if (e.getID() == 402 && e.getKeyCode() == 32) {
                SortInputHandler h = (SortInputHandler)header.getItemInputHandler();
                h.sort(header.getFocusItem());
            }
            super.handleKeyEvent(header, e);
            int selectedRow = 0;
            for (int i = 0; i < SIDBUpgrade.this.data.getRowCount(); ++i) {
                Boolean bool = (Boolean)SIDBUpgrade.this.data.getData(0, i);
                if (!bool.booleanValue()) continue;
                selectedRow = i;
                break;
            }
            SIDBUpgrade.this.sTable.getGrid().getGridSelection().setRowSelected(selectedRow, true);
        }
    }
}

