/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.factory.data.TaskFactoryConstants;
import oracle.ops.verification.framework.engine.factory.parser.TaskFactoryXmlParser;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.RangeType;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConditionsUtil
implements VerificationAPIConstants {
    private static MessageBundle s_eMsgBundle = VerificationUtil.getMessageBundle("Prve");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean evaluateCondition(Element conditionElem, String[] nodeList) throws XmlParserException {
        Element elem;
        boolean conditionEvaluationResult = false;
        RangeOfValue rangeValue = null;
        Task varTask = null;
        String mConditionVar = ConditionsUtil.getOptionalAttributeValue(conditionElem, TaskFactoryConstants.XMLAttributes.VAR);
        if (mConditionVar == null) {
            NodeList varTaskNL = ConditionsUtil.getChildrenByTagName(conditionElem, TaskFactoryConstants.XMLTags.VAR_TASK);
            if (varTaskNL.getLength() <= 0) {
                Trace.out((String)"VAR or VAR_TASK not specified");
                return false;
            }
            try {
                elem = (Element)varTaskNL.item(0);
                Element rootElementTaskDef = ConditionsUtil.getRootElementTaskDefinition();
                if (rootElementTaskDef == null) {
                    VerificationUtil.getTaskDefinitionXmlURI();
                    String errMsg = s_gMsgBundle.getMessage("13001", true, (Object[])new String[]{VerificationUtil.getTaskDefinitionXmlURI()});
                    throw new XmlParserException(errMsg);
                }
                varTask = new TaskFactoryXmlParser().parsePlacementTask(elem, VerificationUtil.getUniqueDistributionID(), nodeList, rootElementTaskDef);
            }
            catch (XmlFilePathException e) {
                throw new XmlParserException(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                throw new XmlParserException(e.getMessage());
            }
            catch (SAXException e) {
                throw new XmlParserException(e.getMessage());
            }
            catch (IOException e) {
                throw new XmlParserException(e.getMessage());
            }
        } else {
            elem = conditionElem;
        }
        String eq = ConditionsUtil.getOptionalAttributeValue(elem, TaskFactoryConstants.XMLAttributes.EQ);
        String eqNoCase = ConditionsUtil.getOptionalAttributeValue(elem, TaskFactoryConstants.XMLAttributes.EQ_NO_CASE);
        String ge = ConditionsUtil.getOptionalAttributeValue(elem, TaskFactoryConstants.XMLAttributes.ATLEAST);
        String le = ConditionsUtil.getOptionalAttributeValue(elem, TaskFactoryConstants.XMLAttributes.ATMOST);
        String gt = ConditionsUtil.getOptionalAttributeValue(elem, TaskFactoryConstants.XMLAttributes.GREATER_THAN);
        String lt = ConditionsUtil.getOptionalAttributeValue(elem, TaskFactoryConstants.XMLAttributes.LESS_THAN);
        String ne = ConditionsUtil.getOptionalAttributeValue(elem, TaskFactoryConstants.XMLAttributes.NE);
        String re = ConditionsUtil.getOptionalAttributeValue(elem, TaskFactoryConstants.XMLAttributes.RE);
        String type = ConditionsUtil.getOptionalAttributeValue(elem, TaskFactoryConstants.XMLAttributes.TYPE);
        if (eq != null || ge != null || le != null || gt != null || lt != null || eqNoCase != null || ne != null || re != null) {
            rangeValue = new RangeOfValue(ConditionsUtil.getRangeType(type));
            ConditionsUtil.manipulateRange(rangeValue, eq, eqNoCase, ge, le, gt, lt, ne, re, false);
        }
        if (VerificationUtil.isStringGood(mConditionVar)) {
            String value = CVUVariables.getValue(mConditionVar);
            if (rangeValue != null) {
                try {
                    conditionEvaluationResult = rangeValue.contains(value);
                }
                catch (InvalidRangeManipulationException e) {
                    Trace.out((String)("InvalidRangeManipulationException : " + e.getMessage()));
                    throw new XmlParserException(e.getMessage());
                }
            } else {
                conditionEvaluationResult = Boolean.valueOf(value);
            }
            Trace.out((String)("Condition variable " + mConditionVar + " evaluated to :" + conditionEvaluationResult));
            return conditionEvaluationResult;
        }
        Trace.out((String)"Performing var task!!");
        if (varTask == null) return conditionEvaluationResult;
        varTask.setSilent(true);
        boolean isTaskApplicable = false;
        try {
            isTaskApplicable = varTask.isApplicable();
        }
        catch (VerificationException ve) {
            Trace.out((String)("Encountered exception while checking if the task is applicable. " + ve.getMessage()));
            throw new XmlParserException(ve.getMessage(), ve);
        }
        varTask.setBestPractice(false);
        if (!isTaskApplicable) return conditionEvaluationResult;
        if (!varTask.perform()) return conditionEvaluationResult;
        Trace.out((String)"Var task returns true");
        if (rangeValue != null) {
            Hashtable ht = varTask.getResultSet().getResultTable();
            Enumeration e = ht.keys();
            boolean condRes = true;
            try {
                while (e.hasMoreElements()) {
                    String node = (String)e.nextElement();
                    Result result = (Result)ht.get(node);
                    String actualVal = result.getActualValue();
                    Trace.out((String)("Actual value from the system is : " + actualVal));
                    condRes &= rangeValue.contains(actualVal);
                }
            }
            catch (InvalidRangeManipulationException ex) {
                Trace.out((String)("InvalidRangeManipulationException : " + ex.getMessage()));
                throw new XmlParserException(ex.getMessage(), ex);
            }
            catch (ResultValuesUnavailableException rue) {
                Trace.out((String)("ResultValuesUnavailableException : " + rue.getMessage()));
                throw new XmlParserException(rue.getMessage(), rue);
            }
            conditionEvaluationResult = condRes;
        } else {
            conditionEvaluationResult = varTask.getResultSet().allSuccess();
        }
        Trace.out((String)("VAR_TASK condition evaluated to " + conditionEvaluationResult));
        return conditionEvaluationResult;
    }

    private static String getOptionalAttributeValue(Element elem, String key) {
        String attributeValue = null;
        if (elem.hasAttribute(key)) {
            attributeValue = elem.getAttribute(key);
        }
        return attributeValue;
    }

    private static NodeList getChildrenByTagName(Element elem, String tagName) {
        Trace.out((String)"Method Entry. elem=%s, tagName=%s", (Object[])new Object[]{elem.getTagName(), tagName});
        NodeList allChildren = elem.getChildNodes();
        final ArrayList<Node> _items = new ArrayList<Node>();
        NodeList immediateChildren = new NodeList(){

            @Override
            public int getLength() {
                return _items.size();
            }

            @Override
            public Node item(int paramInt) {
                return (Node)_items.get(paramInt);
            }
        };
        for (int i = 0; i < allChildren.getLength(); ++i) {
            Node toddler = allChildren.item(i);
            if (toddler == null || !toddler.getNodeName().equals(tagName)) continue;
            _items.add(toddler);
            Trace.out((String)("Adding the node " + toddler.getNodeName()));
        }
        return immediateChildren;
    }

    private static Element getRootElementTaskDefinition() throws XmlFilePathException, XmlParserException, ParserConfigurationException, SAXException, IOException {
        Element rootElementTaskDef = null;
        String xmlTaskDefFile = null;
        xmlTaskDefFile = VerificationUtil.getTaskDefinitionXmlURI();
        Trace.out((String)("Task definiton XML file is " + xmlTaskDefFile));
        rootElementTaskDef = new TaskFactoryXmlParser().getRootElement(xmlTaskDefFile);
        if (rootElementTaskDef == null) {
            Trace.out((String)"Either the definition xml or target xml not found or could not be parsed");
            return null;
        }
        return rootElementTaskDef;
    }

    private static RangeType getRangeType(String type) {
        if ("VERSION".equalsIgnoreCase(type)) {
            return RangeType.VERSION;
        }
        if ("NUMBER".equalsIgnoreCase(type)) {
            return RangeType.FLOAT;
        }
        return RangeType.STRING;
    }

    private static void manipulateRange(RangeOfValue r, String eq, String eqNoCase, String ge, String le, String gt, String lt, String ne, String re, boolean exclude) throws XmlParserException {
        RangeOperator firstRangeOp = null;
        RangeOperator secondRangeOp = null;
        String firstRangeValue = null;
        String secondRangeValue = null;
        if (!(eq == null && eqNoCase == null && ne == null && re == null || ge == null && le == null && gt == null && lt == null)) {
            String msg = s_msgBundle.getMessage("1113", false);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        firstRangeValue = eq;
        if (firstRangeValue != null) {
            firstRangeOp = RangeOperator.EQ;
        } else {
            firstRangeValue = eqNoCase;
            if (firstRangeValue != null) {
                firstRangeOp = RangeOperator.EQ_NO_CASE;
            } else {
                firstRangeValue = ne;
                if (firstRangeValue != null) {
                    firstRangeOp = RangeOperator.NE;
                } else {
                    firstRangeValue = re;
                    if (firstRangeValue != null) {
                        firstRangeOp = RangeOperator.RE;
                    }
                }
            }
        }
        if (firstRangeValue != null) {
            try {
                if (!exclude) {
                    r.include(firstRangeOp, firstRangeValue);
                } else {
                    r.exclude(firstRangeOp, firstRangeValue);
                }
                return;
            }
            catch (InvalidRangeManipulationException e) {
                throw new XmlParserException(e.getMessage());
            }
        }
        if (ge != null && gt != null) {
            Object[] msgParams = new String[]{RangeOperator.GE.toString(), RangeOperator.GT.toString()};
            String msg = s_msgBundle.getMessage("1114", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (le != null && lt != null) {
            Object[] msgParams = new String[]{RangeOperator.LE.toString(), RangeOperator.LT.toString()};
            String msg = s_msgBundle.getMessage("1114", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (ge != null) {
            firstRangeOp = RangeOperator.GE;
            firstRangeValue = ge;
        } else if (gt != null) {
            firstRangeOp = RangeOperator.GT;
            firstRangeValue = gt;
        }
        if (le != null) {
            if (firstRangeOp != null) {
                secondRangeOp = RangeOperator.LE;
                secondRangeValue = le;
            } else {
                firstRangeOp = RangeOperator.LE;
                firstRangeValue = le;
            }
        } else if (lt != null) {
            if (firstRangeOp != null) {
                secondRangeOp = RangeOperator.LT;
                secondRangeValue = lt;
            } else {
                firstRangeOp = RangeOperator.LT;
                firstRangeValue = lt;
            }
        }
        try {
            if (!exclude) {
                if (secondRangeOp != null) {
                    r.include(firstRangeOp, firstRangeValue, secondRangeOp, secondRangeValue);
                } else {
                    r.include(firstRangeOp, firstRangeValue);
                }
            } else if (secondRangeOp != null) {
                r.exclude(firstRangeOp, firstRangeValue, secondRangeOp, secondRangeValue);
            } else {
                r.exclude(firstRangeOp, firstRangeValue);
            }
        }
        catch (InvalidRangeManipulationException e) {
            throw new XmlParserException(e.getMessage());
        }
    }
}

