/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.File;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CommandsUtil {
    protected String m_awk = "/bin/awk";
    protected String m_grep = "/bin/grep";
    protected String m_nslookup = "/usr/bin/nslookup";
    protected String m_cat = "/bin/cat";
    protected String m_df = "/bin/df";
    protected String m_ping = "/bin/ping";
    protected String m_cp = "/bin/cp";
    protected String m_ls = "/bin/ls";
    protected String m_nsswitch = "/etc/nsswitch.conf";
    protected String m_groups = "/bin/groups";
    protected String m_sudo = "/usr/bin/sudo";
    protected String m_sudoLocal = "/usr/local/bin/sudo";
    protected String m_chkconfig = null;
    protected String m_ip = null;
    protected String m_lsof = null;

    public CommandsUtil() {
        Trace.out((String)"Commands defined");
        if (VerificationUtil.isPlatformLinux()) {
            this.m_chkconfig = "/sbin/chkconfig";
            this.m_ip = "/sbin/ip";
            this.m_lsof = "SUSE12".equals(VerificationUtil.getUniqueDistributionID()) ? "/usr/bin/lsof" : "/usr/sbin/lsof";
        } else if (VerificationUtil.isPlatformSolaris()) {
            this.m_nslookup = "/usr/sbin/nslookup";
            this.m_lsof = "/usr/local/bin/lsof";
        } else if (VerificationUtil.isPlatformAix()) {
            this.m_nsswitch = "/etc/netsvc.conf";
            this.m_lsof = "/usr/bin/lsof";
        } else if (VerificationUtil.isPlatformHp()) {
            this.m_lsof = "/usr/local/bin/lsof";
        } else if (VerificationUtil.isPlatformWindows()) {
            // empty if block
        }
    }

    public String getAwk() {
        Trace.out((String)("Returning '" + this.m_grep + "'"));
        return this.m_awk;
    }

    public String getGrep() {
        Trace.out((String)("Returning '" + this.m_grep + "'"));
        return this.m_grep;
    }

    public String getNslookup() {
        return this.m_nslookup;
    }

    public String getNsswitch() {
        return this.m_nsswitch;
    }

    public String getCat() {
        return this.m_cat;
    }

    public String getDf() {
        return this.m_df;
    }

    public String getPing() {
        return this.m_ping;
    }

    public String getCp() {
        return this.m_cp;
    }

    public String getLs() {
        return this.m_ls;
    }

    public String getGroups() {
        return this.m_groups;
    }

    public String getSudo() {
        File sudoLocation = new File(this.m_sudo);
        if (sudoLocation.exists()) {
            return this.m_sudo;
        }
        return this.m_sudoLocal;
    }

    public String getChkConfig() {
        return this.m_chkconfig;
    }

    public String getIp() {
        return this.m_ip;
    }

    public String getLsof() {
        return this.m_lsof;
    }
}

