/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.CollectionResult;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.CollectionValueUnavailableException;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.OCRInfo;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.gpnp.GPnPProfile;
import oracle.cluster.verification.gpnp.GPnPXmlParser;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.cluster.VoteDiskInfo;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.CopyFileFromNodeCommand;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.CollectionResultImpl;
import oracle.ops.verification.framework.engine.CollectionResultSetImpl;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.GetCRSHomeThread;
import oracle.ops.verification.framework.util.OCRDumpParser;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.xml.sax.InputSource;

public class ClusterwareUtil
implements VerificationConstants {
    private static final String OCRDUMP_PREFIX = "OCRDUMP";
    private static final String CRSCTL_CHECK_CLUSTER_ALL = "crsctl check cluster -all";
    private static final String CLU_RDY_SRVCS_ONLINE = "CRS-4537";
    private static final String CSS_ONLINE = "CRS-4529";
    private static final String EM_ONLINE = "CRS-4533";
    private static final String CRS_STR = "CRS-";
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static String[] m_ocrLoc = null;
    private static String[] m_votingLoc = null;
    private static List<GetCRSHomeThread> m_getCRSHomeThreadList = new ArrayList<GetCRSHomeThread>();
    private static HashMap<String, String> m_crsHomeCache = new HashMap();

    public static CollectionResultSet<String> getCRSHome(String[] nodeList) {
        CollectionResultSetImpl<String> crset = new CollectionResultSetImpl<String>();
        if (!ClusterwareUtil.isValidNodeList(nodeList, crset)) {
            return crset;
        }
        for (String node : nodeList) {
            String cacheCRSHome = m_crsHomeCache.get(node);
            if (VerificationUtil.isStringGood(cacheCRSHome)) {
                crset.addCollectedData(node, cacheCRSHome);
                continue;
            }
            GetCRSHomeThread crsHomeNodeThread = new GetCRSHomeThread();
            crsHomeNodeThread.setNodeName(node);
            crsHomeNodeThread.start();
            m_getCRSHomeThreadList.add(crsHomeNodeThread);
        }
        for (GetCRSHomeThread crsThread : m_getCRSHomeThreadList) {
            String node;
            String errMsg = null;
            try {
                crsThread.join();
            }
            catch (InterruptedException e) {
                Trace.out((String)"Interrupt while getting crshome");
                errMsg = e.getMessage();
            }
            node = crsThread.getNodeName();
            if (errMsg != null) {
                crset.addResult(node, 2);
                ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("5301", true) + LSEP + errMsg);
                crset.addErrorDescription(node, errDesc);
                continue;
            }
            String crsHome = crsThread.getCRSHome();
            CollectionResultImpl colRes = crsThread.getCollectionResult();
            if (VerificationUtil.isStringGood(crsHome)) {
                crset.addCollectedData(node, crsHome);
                continue;
            }
            crset.addResult(node, colRes);
        }
        return crset;
    }

    public static CollectionResult<String> getOracleBase(String node, String home) {
        Result result;
        String ORABASE = "orabase";
        CollectionResultImpl<String> colRes = new CollectionResultImpl<String>(node);
        String cmd = home + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + new SystemFactory().CreateSystem().getExeName(ORABASE);
        Trace.out((String)"Executing getOracleBase(node=%s,home=%s", (Object[])new Object[]{node, home});
        ErrorDescription errDesc = null;
        String oracleBase = null;
        ResultSet homeInfoRsltSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        boolean rslt = false;
        String[] args = new String[]{"-cv_oh", home};
        homeInfoRsltSet.clear();
        rslt = globalExec.runGenericCmd(new String[]{node}, cmd, args, null, homeInfoRsltSet);
        if (rslt && (result = (Result)homeInfoRsltSet.getResultTable().get(node)) != null && result.getStatus() == 1) {
            String outStr = (String)result.getResultInfoSet().firstElement();
            String exitStat = VerificationUtil.fetchVerificationResult(outStr);
            if (exitStat != null && exitStat.contentEquals("0")) {
                String[] cmdOut = (String[])result.getResultInfoSet().get(1);
                oracleBase = VerificationUtil.strArr2List(cmdOut).trim();
                colRes.setStatus(1);
            } else if (VerificationUtil.isStringGood(outStr)) {
                result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{cmd, node, exitStat}) + LSEP + outStr));
            } else {
                result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{cmd, node, exitStat})));
            }
        }
        if (!VerificationUtil.isStringGood(oracleBase)) {
            errDesc = new ErrorDescription(s_gMsgBundle.getMessage("11910", true, (Object[])new String[]{home, node}));
            colRes.addErrorDescription(errDesc);
            colRes.setStatus(2);
        } else {
            colRes.setCollectedData(oracleBase);
        }
        return colRes;
    }

    private static boolean isValidNodeList(String[] nodeList, CollectionResultSetImpl crset) {
        if (nodeList == null || nodeList.length == 0) {
            crset.setStatus(2);
            crset.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"node list"})));
            return false;
        }
        return true;
    }

    public static CollectionResultSet<GPnPProfile> getGPnPProfile(String[] nodeList) {
        Trace.out((String)"GPnP Profile");
        String FILE_SEPARATOR = VerificationConstants.FSEP;
        String GPNPTOOL_GET = "gpnptool get";
        String gpnptoolCommand = null;
        String crsHomeNode = null;
        String node = null;
        String profileXmlDoc = null;
        Result resultGPnP = null;
        VerificationCommand gpnpCmd = null;
        VerificationCommand[] tmpCmdArray = null;
        VerificationCommand[] gpnpCmdArray = null;
        CollectionResult<String> result = null;
        CollectionResultSet<String> crset = null;
        GPnPProfile gpnpProfile = null;
        CollectionResultImpl colResGPnP = null;
        CollectionResultSetImpl gpnpset = new CollectionResultSetImpl();
        ResultSet resultSetGPnP = new ResultSet();
        GPnPXmlParser xmlParse = new GPnPXmlParser();
        if (!ClusterwareUtil.isValidNodeList(nodeList, gpnpset)) {
            return gpnpset;
        }
        tmpCmdArray = new VerificationCommand[nodeList.length];
        crset = ClusterwareUtil.getCRSHome(nodeList);
        int indexNode = -1;
        for (int nodeIndex = 0; nodeIndex < nodeList.length; ++nodeIndex) {
            node = nodeList[nodeIndex];
            result = crset.getNodeCollectionResults().get(node);
            if (result.getNodeResultStatus() == NodeResultStatus.SUCCESSFUL) {
                try {
                    crsHomeNode = result.getCollectedValue();
                    gpnptoolCommand = crsHomeNode + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + GPNPTOOL_GET + " " + "-o-";
                    String[] arg = new String[]{"-rungencmd", gpnptoolCommand};
                    String[] env = null;
                    tmpCmdArray[++indexNode] = new VerificationCommand(node, arg, env);
                }
                catch (CollectionValueUnavailableException cvue) {
                    colResGPnP = new CollectionResultImpl(node);
                    VerificationUtil.traceAndLog("COLLECTIONVALUEUNAVAILEXCEPTION: GPnP Profile: " + cvue.getMessage());
                    colResGPnP.addErrorDescription(new ErrorDescription(cvue.getMessage()));
                    colResGPnP.setStatus(3);
                    gpnpset.addResult(node, colResGPnP);
                }
                continue;
            }
            colResGPnP = new CollectionResultImpl(node);
            for (VerificationError error : result.getErrors()) {
                colResGPnP.addErrorDescription((ErrorDescription)error);
            }
            if (result.getNodeResultStatus() == NodeResultStatus.OPERATION_FAILED) {
                colResGPnP.setStatus(2);
            }
            if (result.getNodeResultStatus() == NodeResultStatus.VERIFICATION_FAILED) {
                colResGPnP.setStatus(3);
            }
            if (result.getNodeResultStatus() == NodeResultStatus.UNDEFINED) {
                colResGPnP.setStatus(5);
            }
            if (result.getNodeResultStatus() == NodeResultStatus.VERIFICATION_WARNING) {
                colResGPnP.setStatus(4);
            }
            gpnpset.addResult(node, colResGPnP);
        }
        if (indexNode >= 0) {
            gpnpCmdArray = new VerificationCommand[indexNode + 1];
            for (int index = 0; index <= indexNode; ++index) {
                gpnpCmdArray[index] = tmpCmdArray[index];
            }
            new GlobalHandler().submit((Command[])gpnpCmdArray, 0, resultSetGPnP);
            String output = null;
            CollectionResultImpl<GPnPProfile> colRes = null;
            for (int nodeIndex = 0; nodeIndex < nodeList.length; ++nodeIndex) {
                gpnpCmd = gpnpCmdArray[nodeIndex];
                resultGPnP = gpnpCmd.getResult();
                node = gpnpCmd.getNode();
                Trace.out((String)("Node[" + node + "]"));
                colRes = new CollectionResultImpl<GPnPProfile>(node);
                if (resultGPnP.getStatus() == 1) {
                    output = gpnpCmd.getOutput();
                    try {
                        output = output.trim();
                        profileXmlDoc = output = output.replaceAll("Success.", "");
                        Trace.out((String)"success");
                        gpnpProfile = xmlParse.parse(profileXmlDoc);
                        colRes.setCollectedData(gpnpProfile);
                        colRes.setStatus(1);
                    }
                    catch (XmlParserException xpe) {
                        Trace.out((String)("GPnP Profile: " + xpe.getMessage()));
                        colRes.addErrorDescription(new ErrorDescription(xpe.getMessage()));
                        colRes.setStatus(3);
                    }
                } else {
                    for (VerificationError error : resultGPnP.getErrors()) {
                        colRes.addErrorDescription((ErrorDescription)error);
                    }
                    if (resultGPnP.getNodeResultStatus() == NodeResultStatus.OPERATION_FAILED) {
                        colRes.setStatus(2);
                    }
                    if (resultGPnP.getNodeResultStatus() == NodeResultStatus.VERIFICATION_FAILED) {
                        colRes.setStatus(3);
                    }
                    if (resultGPnP.getNodeResultStatus() == NodeResultStatus.UNDEFINED) {
                        colRes.setStatus(5);
                    }
                    if (resultGPnP.getNodeResultStatus() == NodeResultStatus.VERIFICATION_WARNING) {
                        colRes.setStatus(4);
                    }
                }
                gpnpset.addResult(node, colRes);
            }
        }
        return gpnpset;
    }

    public static CollectionResultSet<OCRInfo> getOCRDetails(String[] nodeList) {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        boolean isUnix = nativeSystem.isUnixSystem();
        String ocrLoc = nativeSystem.getConfigLocation(new Version());
        if (isUnix) {
            Trace.out((String)("ocr loc file " + ocrLoc));
            return ClusterwareUtil.getOCRDetailsUnix(nodeList, ocrLoc);
        }
        Trace.out((String)("ocr loc registry " + ocrLoc));
        return ClusterwareUtil.getOCRDetailsWindows(nodeList, ocrLoc);
    }

    private static CollectionResultSet<OCRInfo> getOCRDetailsUnix(String[] nodeList, String fileName) {
        CollectionResultImpl<OCRInfo> ocrResult = null;
        CollectionResultSetImpl ocrResultNodes = new CollectionResultSetImpl();
        OCRInfo ocrInfo = null;
        ClusterCmd clusterCmd = new ClusterCmd();
        ArrayList<String> ocrContent = null;
        ArrayList<CopyFileFromNodeCommand> cmdCpy = null;
        if (!ClusterwareUtil.isValidNodeList(nodeList, ocrResultNodes)) {
            return ocrResultNodes;
        }
        String scratchPath = VerificationUtil.getCVUSubDirPath() + "scratch";
        File tempArea = new File(scratchPath);
        if (!tempArea.exists()) {
            tempArea.mkdirs();
        }
        if (!tempArea.isDirectory()) {
            tempArea.delete();
            tempArea.mkdir();
        }
        if (!tempArea.exists() || !tempArea.isDirectory()) {
            Trace.out((String)("Couldn't create " + tempArea.getName()));
            String msg = s_gMsgBundle.getMessage("1104", true, (Object[])new String[]{scratchPath});
            ErrorDescription errDesc = new ErrorDescription(msg);
            ocrResultNodes.addErrorDescription(errDesc);
            ocrResultNodes.setStatus(2);
            return ocrResultNodes;
        }
        Trace.out((String)("Reading file permissions of " + fileName + " on nodes " + Arrays.toString(nodeList)));
        ResultSet resultAttr = new ResultSet();
        Hashtable<String, FileInfo> fileNodeTable = null;
        Hashtable<String, Hashtable<String, FileInfo>> ocrPermNodes = VerificationUtil.getFileAttributes(nodeList, fileName, resultAttr);
        Trace.out((String)("After getting file details in all the nodes" + ocrPermNodes));
        if (resultAttr.getStatus() == 2) {
            List<VerificationError> errList = resultAttr.getErrors();
            for (VerificationError err : errList) {
                ocrResultNodes.addErrorDescription(new ErrorDescription(err.getErrorMessage()));
            }
            ocrResultNodes.setStatus(2);
            return ocrResultNodes;
        }
        cmdCpy = new ArrayList<CopyFileFromNodeCommand>();
        for (String node : nodeList) {
            fileNodeTable = ocrPermNodes.get(node);
            FileInfo fileInfoNode = fileNodeTable.get(fileName);
            if (fileInfoNode.getErrorString() != null) {
                ErrorDescription errDesc = new ErrorDescription(fileInfoNode.getErrorString());
                ocrResult = new CollectionResultImpl<OCRInfo>(node);
                ocrResult.setStatus(2);
                ocrResult.addErrorDescription(errDesc);
                ocrResultNodes.addResult(node, ocrResult);
                Trace.out((String)("There is an error while reading ocr.loc in node " + node + " " + fileInfoNode.getErrorString()));
                continue;
            }
            cmdCpy.add(new CopyFileFromNodeCommand(node, fileName, scratchPath + "/ocr.loc_" + node));
        }
        if (cmdCpy.size() == 0) {
            return ocrResultNodes;
        }
        ResultSet resultCpy = new ResultSet();
        CopyFileFromNodeCommand[] cmdCpyArr = cmdCpy.toArray(new CopyFileFromNodeCommand[1]);
        new GlobalHandler().submit((Command[])cmdCpyArr, 0, resultCpy);
        Trace.out((String)"After copy files");
        if (resultCpy.getStatus() == 2) {
            List<VerificationError> errList = resultCpy.getErrors();
            for (VerificationError err : errList) {
                ocrResultNodes.addErrorDescription(new ErrorDescription(err.getErrorMessage()));
            }
            ocrResultNodes.setStatus(2);
            return ocrResultNodes;
        }
        for (CopyFileFromNodeCommand cmdNode : cmdCpyArr) {
            String node = (String)cmdNode.getKey();
            Trace.out((String)("Processing the node " + node));
            fileNodeTable = ocrPermNodes.get(node);
            FileInfo fileInfoNode = fileNodeTable.get(fileName);
            ocrContent = new ArrayList<String>();
            String ocrNode = scratchPath + "/ocr.loc_" + node;
            ocrResult = new CollectionResultImpl(node);
            ocrResult.setStatus(1);
            ocrResultNodes.addResult(node, ocrResult);
            String ocrConfigPropName = "ocrconfig_loc";
            String ocrMirrorPropName = "ocrmirrorconfig_loc";
            String ocrConfig3PropNameLocation = "ocrconfig_loc3";
            String ocrConfig4PropNameLocation = "ocrconfig_loc4";
            String ocrConfig5PropNameLocation = "ocrconfig_loc5";
            String tmpLoc = null;
            Result resCpyFile = resultCpy.getResult(node);
            if (resCpyFile.getStatus() == 2) {
                String msg = s_gMsgBundle.getMessage("1105", true, (Object[])new String[]{fileName, node});
                ErrorDescription errDesc = new ErrorDescription(msg);
                ocrResult.addErrorDescription(errDesc);
                ocrResult.addErrorDescription(resCpyFile.getErrors());
                ocrResult.setStatus(2);
            } else {
                try {
                    tmpLoc = Utils.getPropertyValue((String)ocrNode, (String)ocrConfigPropName, (boolean)true);
                    if (tmpLoc != null) {
                        ocrContent.add(tmpLoc);
                    }
                    if ((tmpLoc = Utils.getPropertyValue((String)ocrNode, (String)ocrMirrorPropName, (boolean)true)) != null) {
                        ocrContent.add(tmpLoc);
                    }
                    if ((tmpLoc = Utils.getPropertyValue((String)ocrNode, (String)ocrConfig3PropNameLocation, (boolean)true)) != null) {
                        ocrContent.add(tmpLoc);
                    }
                    if ((tmpLoc = Utils.getPropertyValue((String)ocrNode, (String)ocrConfig4PropNameLocation, (boolean)true)) != null) {
                        ocrContent.add(tmpLoc);
                    }
                    if ((tmpLoc = Utils.getPropertyValue((String)ocrNode, (String)ocrConfig5PropNameLocation, (boolean)true)) != null) {
                        ocrContent.add(tmpLoc);
                    }
                    Trace.out((String)("Content of the file " + ((Object)ocrContent).toString()));
                }
                catch (FileNotFoundException e) {
                    Trace.out((String)("This should not happen,file not found " + e.getMessage()));
                }
                catch (IOException e) {
                    Trace.out((String)("This should not happen, IO error " + e.getMessage()));
                }
                ocrInfo = new OCRInfo(ocrContent);
                ocrInfo.setFileDetails(fileInfoNode);
                ocrResult.setCollectedData(ocrInfo);
            }
            File tmpOcrFile = new File(ocrNode);
            tmpOcrFile.delete();
        }
        return ocrResultNodes;
    }

    private static CollectionResultSet<OCRInfo> getOCRDetailsWindows(String[] nodeList, String registryName) {
        CollectionResultImpl<OCRInfo> ocrResult = null;
        CollectionResultSetImpl ocrResultNodes = new CollectionResultSetImpl();
        OCRInfo ocrInfo = null;
        ArrayList<String> ocrContent = null;
        ClusterWindows clusterWindows = null;
        if (!ClusterwareUtil.isValidNodeList(nodeList, ocrResultNodes)) {
            return ocrResultNodes;
        }
        try {
            clusterWindows = new ClusterWindows(4);
        }
        catch (ClusterException ex) {
            Trace.out((String)("Couldn't create cluster windows system" + ex.getMessage()));
            ErrorDescription errDesc = new ErrorDescription(ex.getMessage());
            ocrResultNodes.addErrorDescription(errDesc);
            ocrResultNodes.setStatus(2);
            return ocrResultNodes;
        }
        for (String node : nodeList) {
            block6: {
                Trace.out((String)("Processing the node " + node));
                ocrContent = new ArrayList<String>();
                String ocrConfigPropName = "ocrconfig_loc";
                String ocrMirrorPropName = "ocrmirrorconfig_loc";
                String ocrConfig3PropNameLocation = "ocrconfig_loc3";
                String ocrConfig4PropNameLocation = "ocrconfig_loc4";
                String ocrConfig5PropNameLocation = "ocrconfig_loc5";
                String tmpLoc = null;
                String firstOcrLoc = null;
                try {
                    firstOcrLoc = clusterWindows.getRegStringDataOnNode(registryName, ocrConfigPropName, node);
                    ocrContent.add(firstOcrLoc);
                    tmpLoc = clusterWindows.getRegStringDataOnNode(registryName, ocrMirrorPropName, node);
                    ocrContent.add(tmpLoc);
                    tmpLoc = clusterWindows.getRegStringDataOnNode(registryName, ocrConfig3PropNameLocation, node);
                    ocrContent.add(tmpLoc);
                    tmpLoc = clusterWindows.getRegStringDataOnNode(registryName, ocrConfig4PropNameLocation, node);
                    ocrContent.add(tmpLoc);
                    tmpLoc = clusterWindows.getRegStringDataOnNode(registryName, ocrConfig5PropNameLocation, node);
                    ocrContent.add(tmpLoc);
                }
                catch (ClusterException ex) {
                    if (firstOcrLoc != null) break block6;
                    ErrorDescription errDesc = new ErrorDescription(ex.getMessage());
                    ocrResultNodes.addErrorDescription(errDesc);
                    ocrResultNodes.setStatus(2);
                    return ocrResultNodes;
                }
            }
            Trace.out((String)("Content of the file " + ((Object)ocrContent).toString()));
            ocrInfo = new OCRInfo(ocrContent);
            ocrResult = new CollectionResultImpl<OCRInfo>(node);
            ocrResult.setStatus(1);
            ocrResult.setCollectedData(ocrInfo);
            ocrResultNodes.addResult(node, ocrResult);
        }
        ocrResultNodes.setStatus(1);
        return ocrResultNodes;
    }

    public static CollectionResultSet<List<CollectionElement>> collectCRSResourceAttributes(String node, boolean collectOHASDResources) {
        Trace.out((String)"collectCRSResourceAttributes");
        String FILE_SEPARATOR = VerificationConstants.FSEP;
        String crsctlStatRes = "crsctl stat res";
        String crsHomeNode = null;
        Result crsctlCommandResult = null;
        VerificationCommand crsctlCmd = null;
        ArrayList<VerificationCommand> crsctlCmdArray = null;
        CollectionResultSet<String> crsHomeRS = null;
        CollectionResultImpl colResResourceAttributes = null;
        CollectionResultSetImpl crsResourceRS = new CollectionResultSetImpl();
        ResultSet resultSetResourceAttributes = new ResultSet();
        try {
            crsctlCmdArray = new ArrayList<VerificationCommand>();
            crsHomeRS = ClusterwareUtil.getCRSHome(new String[]{node});
            CollectionResult<String> crsHomeResult = crsHomeRS.getNodeCollectionResults().get(node);
            if (crsHomeResult.getNodeResultStatus() == NodeResultStatus.SUCCESSFUL) {
                crsHomeNode = crsHomeResult.getCollectedValue();
                String crsctlCommand = crsHomeNode + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + crsctlStatRes + (collectOHASDResources ? " -init " : "");
                String[] arg = new String[]{"-rungencmd", crsctlCommand};
                String[] env = null;
                crsctlCmdArray.add(new VerificationCommand(node, arg, env));
            } else {
                colResResourceAttributes = new CollectionResultImpl(node);
                for (VerificationError error : crsHomeResult.getErrors()) {
                    crsResourceRS.addErrorDescription((ErrorDescription)error);
                }
                colResResourceAttributes.setStatus(crsHomeResult.getNodeResultStatus().getResultStatus());
                crsResourceRS.addResult(node, colResResourceAttributes);
            }
            new GlobalHandler().submit((Command[])crsctlCmdArray.toArray(new VerificationCommand[0]), 0, resultSetResourceAttributes);
            String output = null;
            CollectionResultImpl<List<CollectionElement>> colRes = null;
            for (int nodeIndex = 0; nodeIndex < crsctlCmdArray.size(); ++nodeIndex) {
                crsctlCmd = (VerificationCommand)crsctlCmdArray.get(nodeIndex);
                crsctlCommandResult = crsctlCmd.getResult();
                node = crsctlCmd.getNode();
                Trace.out((String)("Node[" + node + "]"));
                colRes = new CollectionResultImpl<List<CollectionElement>>(node);
                if (crsctlCommandResult.getStatus() == 1) {
                    String[] outputLines;
                    output = crsctlCmd.getOutput();
                    ArrayList<String> resourceName = new ArrayList<String>();
                    colRes.setStatus(1);
                    output = output.trim();
                    for (String outputLine : outputLines = VerificationUtil.string2strArr(output, VerificationUtil.LSEP)) {
                        if (!outputLine.startsWith("NAME=")) continue;
                        resourceName.add(outputLine.substring("NAME=".length()));
                    }
                    colRes.setCollectedData(ClusterwareUtil.getResourceAttributes(node, crsHomeRS.getNodeCollectionResults().get(node).getCollectedValue(), resourceName, collectOHASDResources));
                } else {
                    for (VerificationError error : crsctlCommandResult.getErrors()) {
                        colRes.addErrorDescription((ErrorDescription)error);
                    }
                    colRes.setStatus(crsctlCommandResult.getNodeResultStatus().getResultStatus());
                }
                crsResourceRS.addResult(node, colRes);
            }
            return crsResourceRS;
        }
        catch (CollectionValueUnavailableException cvue) {
            Trace.out((String)("GPnP Profile: " + cvue.getMessage()));
            crsResourceRS.addErrorDescription(new ErrorDescription(cvue.getMessage()));
            crsResourceRS.setStatus(3);
            return crsResourceRS;
        }
    }

    private static List<CollectionElement> getResourceAttributes(String node, String crsHome, List<String> resourceNames, boolean collectOHASDResources) {
        Trace.out((String)"getResourceAttributes");
        String FILE_SEPARATOR = VerificationConstants.FSEP;
        String crsctlStatRes = "crsctl stat res";
        Result crsctlCommandResult = null;
        VerificationCommand crsctlCmd = null;
        ArrayList<VerificationCommand> crsctlCmdArray = null;
        CollectionResultSetImpl crsResourceRS = new CollectionResultSetImpl();
        ResultSet resultSetGPnP = new ResultSet();
        ArrayList<CollectionElement> resourceCollectionList = new ArrayList<CollectionElement>();
        crsctlCmdArray = new ArrayList<VerificationCommand>();
        for (int index = 0; index < resourceNames.size(); ++index) {
            String resourceName = resourceNames.get(index);
            String crsctlCommand = crsHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + crsctlStatRes + " " + resourceName + " -p" + (collectOHASDResources ? " -init " : "");
            String[] arg = new String[]{"-rungencmd", crsctlCommand};
            String[] env = null;
            crsctlCmdArray.add(new VerificationCommand(node, arg, env));
        }
        new GlobalHandler().submit((Command[])crsctlCmdArray.toArray(new VerificationCommand[0]), 0, resultSetGPnP);
        String output = null;
        CollectionResultImpl colRes = null;
        for (int nodeIndex = 0; nodeIndex < crsctlCmdArray.size(); ++nodeIndex) {
            crsctlCmd = (VerificationCommand)crsctlCmdArray.get(nodeIndex);
            crsctlCommandResult = crsctlCmd.getResult();
            node = crsctlCmd.getNode();
            Trace.out((String)("Node[" + node + "]"));
            colRes = new CollectionResultImpl(node);
            CollectionElement resourceCE = null;
            if (crsctlCommandResult.getStatus() == 1) {
                output = crsctlCmd.getOutput();
                if (output == null) {
                    String errMsg = s_gMsgBundle.getMessage("6015", true, (Object[])new String[]{node});
                    Trace.out((String)errMsg);
                    colRes.addErrorDescription(new ErrorDescription(errMsg));
                    colRes.setStatus(3);
                } else {
                    output = output.trim();
                    String[] outputLines = VerificationUtil.string2strArr(output, VerificationUtil.LSEP);
                    CollectionElement resourceAttributeCE = null;
                    for (String outputLine : outputLines) {
                        if (outputLine.trim().length() == 0) continue;
                        if (outputLine.startsWith("NAME=")) {
                            String name = outputLine.substring("NAME=".length());
                            resourceCE = new CollectionElement(name, null, null, null, name, 1);
                            resourceCollectionList.add(resourceCE);
                            resourceAttributeCE = null;
                            continue;
                        }
                        if (resourceCE == null) continue;
                        Pattern nameValue = Pattern.compile("([^=]*)=(.*)");
                        Matcher m = nameValue.matcher(outputLine);
                        if (m.matches()) {
                            resourceAttributeCE = new CollectionElement(m.group(1), m.group(2), null, null, m.group(1), 1);
                            resourceCE.addChild(resourceAttributeCE);
                            continue;
                        }
                        String resourceValue = "";
                        if (resourceCE.getValue() != null) {
                            resourceValue = resourceCE.getValue().toString();
                        }
                        resourceCE.setValue(resourceValue + VerificationUtil.LINE_SEPARATOR + outputLine);
                    }
                }
            } else {
                for (VerificationError error : crsctlCommandResult.getErrors()) {
                    colRes.addErrorDescription((ErrorDescription)error);
                }
                if (crsctlCommandResult.getNodeResultStatus() == NodeResultStatus.OPERATION_FAILED) {
                    colRes.setStatus(2);
                }
                if (crsctlCommandResult.getNodeResultStatus() == NodeResultStatus.VERIFICATION_FAILED) {
                    colRes.setStatus(3);
                }
                if (crsctlCommandResult.getNodeResultStatus() == NodeResultStatus.UNDEFINED) {
                    colRes.setStatus(5);
                }
                if (crsctlCommandResult.getNodeResultStatus() == NodeResultStatus.VERIFICATION_WARNING) {
                    colRes.setStatus(4);
                }
            }
            crsResourceRS.addResult(node, colRes);
        }
        return resourceCollectionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CollectionResultSet<List<CollectionElement>> collectOCRDump(String node) {
        File tmpFile;
        Trace.out((String)"collectOCRDump");
        String FILE_SEPARATOR = VerificationConstants.FSEP;
        String crsHome = null;
        CollectionResult<String> result = null;
        CollectionResultSetImpl<List<CollectionElement>> ocrDumpCollectionRS = new CollectionResultSetImpl<List<CollectionElement>>();
        CollectionResultSet<String> crsHomeRS = null;
        crsHomeRS = ClusterwareUtil.getCRSHome(new String[]{node});
        result = crsHomeRS.getNodeCollectionResults().get(node);
        if (result.getNodeResultStatus() == NodeResultStatus.SUCCESSFUL) {
            try {
                crsHome = result.getCollectedValue();
            }
            catch (CollectionValueUnavailableException cvue) {
                Trace.out((String)("GPnP Profile: " + cvue.getMessage()));
                ocrDumpCollectionRS.addErrorDescription(new ErrorDescription(cvue.getMessage()));
                ocrDumpCollectionRS.setStatus(3);
                return ocrDumpCollectionRS;
            }
        } else {
            for (VerificationError error : result.getErrors()) {
                ocrDumpCollectionRS.addErrorDescription((ErrorDescription)error);
            }
            if (result.getNodeResultStatus() == NodeResultStatus.OPERATION_FAILED) {
                ocrDumpCollectionRS.setStatus(2);
            }
            if (result.getNodeResultStatus() == NodeResultStatus.VERIFICATION_FAILED) {
                ocrDumpCollectionRS.setStatus(3);
            }
            if (result.getNodeResultStatus() == NodeResultStatus.UNDEFINED) {
                ocrDumpCollectionRS.setStatus(5);
            }
            if (result.getNodeResultStatus() == NodeResultStatus.VERIFICATION_WARNING) {
                ocrDumpCollectionRS.setStatus(4);
            }
            return ocrDumpCollectionRS;
        }
        String command = null;
        String errorMsg = null;
        ResultSet homeInfoRsltSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        String tempDir = VerificationUtil.getCVUSubDirPath();
        if (!new File(tempDir).exists()) {
            tempDir = VerificationUtil.getDestLoc();
        }
        try {
            tmpFile = File.createTempFile(OCRDUMP_PREFIX, ".xml", new File(tempDir));
            tmpFile.delete();
        }
        catch (IOException e1) {
            ocrDumpCollectionRS.setStatus(3);
            ocrDumpCollectionRS.addErrorDescription(new ErrorDescription(e1.getMessage()));
            return ocrDumpCollectionRS;
        }
        command = crsHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "ocrdump -xml " + tmpFile.getAbsolutePath();
        Trace.out((int)5, (String)("Executing command=>" + command));
        globalExec.runExe(new String[]{VerificationUtil.getLocalNode()}, command, homeInfoRsltSet, false);
        Result ocrDumpResult = (Result)homeInfoRsltSet.getResultTable().get(VerificationUtil.getLocalNode());
        if (ocrDumpResult.getStatus() == 1) {
            Trace.out((int)5, (String)("Successfully Retrieved XML :" + tmpFile.getAbsolutePath()));
            ocrDumpCollectionRS.setStatus(1);
            try {
                ocrDumpCollectionRS.setCollectedClusterwideData(OCRDumpParser.parse(new InputSource(new BufferedReader(new FileReader(tmpFile)))));
            }
            catch (XmlParserException e) {
                ocrDumpCollectionRS.setStatus(3);
                errorMsg = s_gMsgBundle.getMessage("6014", true, (Object[])new String[]{e.getMessage()});
                ocrDumpCollectionRS.addErrorDescription(new ErrorDescription(errorMsg));
            }
            catch (FileNotFoundException e) {
                ocrDumpCollectionRS.setStatus(3);
                errorMsg = s_gMsgBundle.getMessage("6014", true, (Object[])new String[]{e.getMessage()});
                ocrDumpCollectionRS.addErrorDescription(new ErrorDescription(errorMsg));
            }
            finally {
                tmpFile.delete();
                Trace.out((int)5, (String)("Successfully Deleted XML :" + tmpFile.getAbsolutePath()));
            }
        } else {
            ocrDumpCollectionRS.setStatus(2);
            errorMsg = s_gMsgBundle.getMessage("6015", true, (Object[])new String[]{node});
            errorMsg = VerificationUtil.getMsgWithExecutionDetails(errorMsg, ocrDumpResult);
            ocrDumpCollectionRS.addErrorDescription(new ErrorDescription(errorMsg));
        }
        return ocrDumpCollectionRS;
    }

    public static List<String> getOCRLocations() throws VerificationException {
        List<Object> ocrLocs = new ArrayList();
        if (m_ocrLoc != null) {
            VerificationUtil.traceAndLog("Returning OCR Locations based on earlier retrieval.");
            ocrLocs = Arrays.asList(m_ocrLoc);
            return ocrLocs;
        }
        String ocrLocStr = CVUVariables.getValue(CVUVariableConstants.OCR_LOCATIONS);
        GlobalVerificationContext globalCtx = GlobalVerificationContext.getInstance();
        if (VerificationUtil.isStringGood(ocrLocStr)) {
            m_ocrLoc = VerificationUtil.string2strArr(ocrLocStr);
            ocrLocs = Arrays.asList(m_ocrLoc);
        } else if (globalCtx.isCRSConfigured() && (globalCtx.isRollingUpgrade() || globalCtx.isNodeAdd() || !globalCtx.isPreCRS())) {
            VerificationUtil.traceAndLog("Obtaining OCR locations from the configured CRS home");
            ResultSet resultSet = new ResultSet();
            m_ocrLoc = VerificationUtil.getOCRLocations(VerificationUtil.getCRSActiveVersionObj(), resultSet);
            if (resultSet.allSuccess()) {
                ocrLocs = Arrays.asList(m_ocrLoc);
            } else {
                VerificationUtil.traceAndLog("VERIFICATIONEXCEPTION: " + VerificationUtil.errorCollection2String(resultSet.getErrors()));
                throw new VerificationException(VerificationUtil.errorCollection2String(resultSet.getErrors()));
            }
        }
        VerificationUtil.traceAndLog("Returning OCR Locations: '" + VerificationUtil.strArr2List(m_ocrLoc) + "'");
        return ocrLocs;
    }

    public static List<String> getVoteDiskLocations() throws ClusterInfoException {
        ArrayList<String> vDiskLocs = new ArrayList();
        if (m_votingLoc != null) {
            VerificationUtil.traceAndLog("Returning Voting Disk locations based on earlier retrieval");
            vDiskLocs = Arrays.asList(m_votingLoc);
            return vDiskLocs;
        }
        String votLocStr = CVUVariables.getValue(CVUVariableConstants.VOTING_LOCATIONS);
        GlobalVerificationContext globalCtx = GlobalVerificationContext.getInstance();
        if (VerificationUtil.isStringGood(votLocStr)) {
            m_votingLoc = VerificationUtil.string2strArr(votLocStr);
            vDiskLocs = Arrays.asList(m_votingLoc);
        } else if (globalCtx.isCRSConfigured() && (globalCtx.isRollingUpgrade() || globalCtx.isNodeAdd() || !globalCtx.isPreCRS())) {
            VoteDiskInfo[] voteDiskLocations2;
            VerificationUtil.traceAndLog("Obtaining Voting Disk info from the configured CRS home");
            ClusterInfo ci = new ClusterInfo(VerificationUtil.getCRSHome(), VerificationUtil.getCRSActiveVersionObj());
            for (VoteDiskInfo vdiskInfo : voteDiskLocations2 = ci.getVoteDiskLocations()) {
                vDiskLocs.add(vdiskInfo.getPath());
                Trace.out((String)("Added VoteDisk location: '" + vdiskInfo.getPath() + "'"));
            }
            m_votingLoc = vDiskLocs.toArray(new String[0]);
        } else {
            VerificationUtil.traceAndLog(LSEP + "No Voting Disk locations " + "specified.");
        }
        VerificationUtil.traceAndLog("Returning Voting Disk locations: " + VerificationUtil.strList2List(vDiskLocs));
        return vDiskLocs;
    }

    public static CollectionResultSet<String> getCRSDProcessID(String[] nodeList) {
        CollectionResultSetImpl<String> colRS = new CollectionResultSetImpl<String>();
        if (!ClusterwareUtil.isValidNodeList(nodeList, colRS)) {
            return colRS;
        }
        String localNode = VerificationUtil.getLocalNode();
        if (!VerificationUtil.isCRSConfigured()) {
            Trace.out((String)"getCRSHome() : Returning NULL as CRS is not found configured");
            colRS.addResult(nodeList, 2);
            colRS.addErrorDescription(new ErrorDescription("7593", new String[]{localNode}, s_msgBundle));
            return colRS;
        }
        Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
        if (VerificationUtil.isVersionPre(crsActiveVersion.toString4(), "11.2.0.3")) {
            colRS.addResult(nodeList, 2);
            colRS.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("13301", true, (Object[])new String[]{crsActiveVersion.toString4()})));
            return colRS;
        }
        CollectionResultSet<String> crsHomeRS = ClusterwareUtil.getCRSHome(new String[]{localNode});
        CollectionResult<String> crsHomeResult = crsHomeRS.getNodeCollectionResults().get(localNode);
        String crsHome = null;
        String oracleBase = null;
        if (crsHomeResult.getNodeResultStatus() == NodeResultStatus.SUCCESSFUL) {
            try {
                crsHome = crsHomeRS.getNodeCollectionResults().get(localNode).getCollectedValue();
            }
            catch (CollectionValueUnavailableException cvue) {
                VerificationUtil.traceAndLog("COLLECTIONVALUEUNAVAILEXCEPTION: " + cvue.getMessage());
                colRS.addResult(nodeList, 2);
                colRS.addErrorDescription(new ErrorDescription(cvue.getMessage()));
                return colRS;
            }
        } else {
            colRS.addResult(nodeList, 2);
            colRS.addErrorDescription(new ErrorDescription("5301", new String[]{localNode}, s_msgBundle));
            return colRS;
        }
        CollectionResult<String> oracleBaseCR = ClusterwareUtil.getOracleBase(localNode, crsHome);
        if (oracleBaseCR.getNodeResultStatus().equals((Object)NodeResultStatus.SUCCESSFUL)) {
            try {
                oracleBase = oracleBaseCR.getCollectedValue();
            }
            catch (CollectionValueUnavailableException e) {
                Trace.out((String)("CollectionValueUnavailableException: " + e.getMessage()));
                colRS.addResult(nodeList, 2);
                colRS.addErrorDescription(new ErrorDescription(e.getMessage()));
                return colRS;
            }
        } else {
            colRS.addResult(nodeList, 2);
            colRS.addErrorDescription(new ErrorDescription("11910", new String[]{crsHome, localNode}, s_gMsgBundle));
            return colRS;
        }
        String scratchPath = VerificationUtil.getCVUSubDirPath() + "scratch";
        File tempArea = new File(scratchPath);
        if (!tempArea.exists()) {
            tempArea.mkdirs();
        }
        if (!tempArea.isDirectory()) {
            tempArea.delete();
            tempArea.mkdir();
        }
        if (!tempArea.exists() || !tempArea.isDirectory()) {
            Trace.out((String)("Couldn't create " + tempArea.getName()));
            colRS.addResult(nodeList, 2);
            String msg = s_msgBundle.getMessage("5642", true, (Object[])new String[]{scratchPath});
            ErrorDescription errDesc = new ErrorDescription(msg);
            colRS.addErrorDescription(errDesc);
            return colRS;
        }
        ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
        ClusterCmd clusterCmd = new ClusterCmd();
        for (String node : nodeList) {
            try {
                if (!clusterwareInfo.isCRSRunning(crsHome, node, crsActiveVersion)) {
                    colRS.addResult(node, 3);
                    colRS.addErrorDescription(node, new ErrorDescription(s_msgBundle.getMessage("7590", true, (Object[])new String[]{"crsd", node})));
                    continue;
                }
                String pidFileLoc = ClusterwareUtil.getPidFileLocation(node, crsActiveVersion, crsHome, oracleBase);
                String nodeFilePath = scratchPath + "crsd.pid_" + node;
                File prvCopy = new File(nodeFilePath);
                if (prvCopy.exists()) {
                    prvCopy.delete();
                }
                try {
                    boolean copyStatus = clusterCmd.copyFileFromNode(node, pidFileLoc, nodeFilePath);
                    Trace.out((String)("copy status = " + copyStatus));
                    if (!copyStatus) {
                        colRS.addResult(node, 3);
                        colRS.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("2002", true, (Object[])new String[]{pidFileLoc, node, localNode})));
                        continue;
                    }
                    BufferedReader in = new BufferedReader(new FileReader(nodeFilePath));
                    String line = null;
                    String crsdPid = null;
                    while ((line = in.readLine()) != null) {
                        if (!VerificationUtil.isStringGood(line = line.trim())) continue;
                        crsdPid = line;
                    }
                    colRS.addCollectedData(node, crsdPid);
                }
                catch (ClusterException e) {
                    colRS.addResult(node, 3);
                    colRS.addErrorDescription(node, new ErrorDescription(e.getMessage()));
                }
                catch (FileNotFoundException e) {
                    colRS.addResult(node, 3);
                    colRS.addErrorDescription(node, new ErrorDescription(e.getMessage()));
                }
                catch (IOException e) {
                    colRS.addResult(node, 3);
                    colRS.addErrorDescription(node, new ErrorDescription(e.getMessage()));
                }
            }
            catch (InstallException e) {
                colRS.addResult(node, 3);
                colRS.addErrorDescription(node, new ErrorDescription(e.getMessage()));
            }
        }
        return colRS;
    }

    private static String getPidFileLocation(String node, Version crsActiveVersion, String crsHome, String oracleBase) {
        if (VerificationUtil.isVersionPost(crsActiveVersion.toString4(), "12.1.0.2")) {
            return oracleBase + VerificationUtil.FSEP + "crsdata" + VerificationUtil.FSEP + node + VerificationUtil.FSEP + "output" + VerificationUtil.FSEP + "crsd.pid";
        }
        return crsHome + VerificationUtil.FSEP + "crs" + VerificationUtil.FSEP + "init" + VerificationUtil.FSEP + node + ".pid";
    }

    public static List<String> getCRSRunningNodes(String[] nodeArr, ResultSet resultSet) {
        String crsHome = null;
        ArrayList<String> crsRunningNodes = new ArrayList<String>();
        GlobalExecution globalExec = new GlobalExecution();
        List<String> nodeList = Arrays.asList(nodeArr);
        String localNode = VerificationUtil.getLocalNode();
        if (VerificationUtil.isCRSConfigured()) {
            crsHome = VerificationUtil.getCRSHome();
            String crsctlCmd = crsHome + VerificationConstants.FSEP + "bin" + VerificationConstants.FSEP + CRSCTL_CHECK_CLUSTER_ALL;
            Trace.out((String)("Running command " + crsctlCmd + " on node " + localNode));
            globalExec.runGenericCmd(new String[]{localNode}, crsctlCmd, resultSet);
            Result result = (Result)resultSet.getResultTable().get(localNode);
            if (result != null && result.getStatus() == 1) {
                String cmdOutput = (String)result.getResultInfoSet().firstElement();
                if (VerificationUtil.fetchVerificationResult(cmdOutput).equals("0")) {
                    String[] crsctlOutput = (String[])result.getResultInfoSet().get(1);
                    String output = VerificationUtil.strArr2List(crsctlOutput, VerificationUtil.LSEP);
                    Trace.out((String)("crsctl check cluster -all  output : " + output));
                    for (int i = 0; i < crsctlOutput.length; ++i) {
                        int index;
                        String node;
                        if (crsctlOutput[i].indexOf(":") < 1 || !VerificationUtil.isStringGood(node = crsctlOutput[i].substring(0, index = crsctlOutput[i].indexOf(":")).trim()) || !nodeList.contains(node)) continue;
                        StringBuffer nodeCRSStatus = new StringBuffer("");
                        if (i + 3 >= crsctlOutput.length || !crsctlOutput[i + 1].trim().startsWith(CRS_STR) || !crsctlOutput[i + 2].trim().startsWith(CRS_STR) || !crsctlOutput[i + 3].trim().startsWith(CRS_STR)) continue;
                        nodeCRSStatus.append(crsctlOutput[i + 1].trim() + VerificationConstants.LSEP + crsctlOutput[i + 2].trim() + VerificationConstants.LSEP + crsctlOutput[i + 3].trim());
                        Trace.out((int)1, (String)("CRS status on node " + node + " is : " + nodeCRSStatus.toString()));
                        if (nodeCRSStatus.indexOf(CLU_RDY_SRVCS_ONLINE) >= 0 && nodeCRSStatus.indexOf(CSS_ONLINE) >= 0 && nodeCRSStatus.indexOf(EM_ONLINE) >= 0) {
                            Trace.out((String)("CRS is running on node " + node));
                            crsRunningNodes.add(node);
                            i += 3;
                            continue;
                        }
                        Trace.out((String)("CRS is not running on node " + node));
                    }
                } else {
                    String cmdOutValue = VerificationUtil.fetchVerificationValue(cmdOutput);
                    String errMsg = s_msgBundle.getMessage("5718", true, (Object[])new String[]{crsctlCmd, localNode, cmdOutValue});
                    VerificationUtil.traceAndLog(errMsg);
                    ErrorDescription errorDesc = new ErrorDescription(errMsg);
                    result.addErrorDescription(errorDesc);
                    result.setStatus(3);
                }
            } else {
                VerificationUtil.traceAndLog("Failed to get the crs running status of the cluster nodes.");
                for (VerificationError verror : result.getErrors()) {
                    VerificationUtil.traceAndLog(verror.getErrorMessage());
                }
                String errMsg = s_msgBundle.getMessage("7595", true, (Object[])new String[]{localNode});
                VerificationUtil.traceAndLog(errMsg);
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                result.addErrorDescription(errorDesc);
                result.setStatus(2);
            }
            return crsRunningNodes;
        }
        VerificationUtil.traceAndLog("CRS is not found to be configured");
        resultSet.addResult(nodeList, 2);
        resultSet.addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("7593", true, (Object[])new String[]{localNode})));
        return crsRunningNodes;
    }
}

