/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.cmdtools.CRSCTLUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.ClusterwideCollectionUnavailableException;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMUtils;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariableData;
import oracle.ops.verification.framework.util.CVUVariablesException;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.framework.util.sVerificationUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CVUVariables {
    protected static Map<String, String> s_variableValueRepos = Collections.synchronizedMap(new HashMap());
    private static Element m_rootElementTaskDef = null;
    private static Element m_currentReleaseVarDef = null;
    private static Hashtable<String, CVUVariableData> m_InstallUIVariables = new Hashtable();
    private static Hashtable<String, CVUVariableData> m_InstallResponseVariables = new Hashtable();
    private static Hashtable<String, CVUVariableData> m_CvuCmdVariables = new Hashtable();
    private static Hashtable<String, CVUVariableData> m_RootScriptVariables = new Hashtable();
    private static String m_releaseForVariablesXml = null;
    private static boolean m_isVariablesXmlParsed = false;
    private static String m_commonVariablesReleaseVal = "ALL";
    public static final String VARIABLES_ROOT_ELEMENT_TAG = "ROOT";
    public static final String VARIABLES_SOFTWARE_ELEMENT_TAG = "SOFTWARE";
    public static final String VARIABLES_VARIABLE_LIST_ELEMENT_TAG = "VARIABLE_LIST";
    public static final String VARIABLES_VARIABLE_ELEMENT_TAG = "VARIABLE";
    public static final String VARIABLES_VERSION_ELEMENT_TAG = "VERSION";
    public static final String VARIABLES_NAME_ATTRIBUTE_TAG = "NAME";
    public static final String VARIABLES_INSTALL_UI_ELEMENT_TAG = "INSTALL_UI";
    public static final String VARIABLES_INSTALL_RESP_ELEMENT_TAG = "INSTALL_RESP";
    public static final String VARIABLES_CVU_CMD_VAR_ELEMENT_TAG = "CVU_CMD_VAR";
    public static final String VARIABLES_ROOT_SCRIPT_ELEMENT_TAG = "ROOT_SCRIPT";
    private static final String DAX_DEVICE = "/dev/dax";
    private static boolean m_isUnix = new SystemFactory().CreateSystem().isUnixSystem();

    public static void setReleaseForVariablesXml(String release) {
        if (VerificationUtil.isStringGood(release)) {
            if (m_isVariablesXmlParsed) {
                Trace.out((String)("The CVUVariables facility has been already initialized for release: " + m_releaseForVariablesXml));
            } else {
                m_releaseForVariablesXml = release;
                CVUVariables.initialize();
                Trace.out((String)("Initialize CVUVariables for release : " + release));
            }
        } else {
            Trace.out((String)("The given release string is invalid : " + release));
        }
    }

    public static void setValue(String name, String value) {
        CVUVariableData cvuVar;
        Trace.out((Object)"variable name %s", (String)name);
        if (!VerificationUtil.isStringGood(name)) {
            Trace.out((String)"Variable name is not a valid String.");
            return;
        }
        if (value == null) {
            Trace.out((String)"The parameter <value> is null");
        }
        if ((cvuVar = CVUVariables.getCVUVariable(name)) != null) {
            cvuVar.setValue(value);
            CVUVariables.secureVariableValueTrace("setting CVUVariable", name, value);
        } else {
            try {
                CVUVariableConstants resolvableVar = CVUVariableConstants.valueOf(name);
                CVUVariables.setValue(resolvableVar, value);
            }
            catch (IllegalArgumentException e) {
                if (s_variableValueRepos.containsKey(name)) {
                    Trace.out((String)("The given variable < " + name + " > has previously " + "been set in the variable repository"));
                } else {
                    Trace.out((String)("Unknown Variable Name : " + name + " does not have " + "associated CVU var, adding to variable repository "));
                }
                s_variableValueRepos.put(name, value);
                CVUVariables.secureVariableValueTrace("setting repos variable", name, value);
            }
        }
    }

    public static void setValue(CVUVariableConstants variable, String value) {
        if (variable != null) {
            String name = variable.toString();
            Trace.out((Object)"CVUVarConstant : %s", (String)name);
            CVUVariableData cvuVar = CVUVariables.getCVUVariable(name);
            if (cvuVar == null && value != null) {
                try {
                    cvuVar = new CVUVariableData(null, null, name, null);
                    CVUVariables.addVariableToContextForNames(cvuVar, m_CvuCmdVariables, cvuVar.getCVUVariableNames());
                }
                catch (CVUVariablesException e) {
                    Trace.out((Exception)e);
                }
            }
            if (cvuVar != null) {
                cvuVar.setValue(value);
                CVUVariables.secureVariableValueTrace("setting CVUVariableConstant", name, value);
            } else {
                Trace.out((String)("Unable to set value for variable : " + name));
            }
        } else {
            Trace.out((String)"CVUVariableConstants parameter <variable> is null");
        }
    }

    public static String getValue(String variable) {
        String returnValue = null;
        if (!VerificationUtil.isStringGood(variable)) {
            Trace.out((String)"The given parameter < variable > is not valid");
            return null;
        }
        Pattern p = Pattern.compile("([^%]*)%([^%]+)%(.*)");
        Matcher m = p.matcher(variable);
        if (m.matches()) {
            while (m.matches()) {
                returnValue = m.group(1);
                String resolvableVarName = m.group(2);
                if (!VerificationUtil.isStringGood(resolvableVarName)) continue;
                String resolvedValue = CVUVariables.internalGetValue(resolvableVarName);
                if (resolvedValue == null) {
                    returnValue = null;
                    break;
                }
                returnValue = returnValue + resolvedValue;
                returnValue = returnValue + m.group(3);
                m = p.matcher(returnValue);
            }
        } else {
            returnValue = CVUVariables.internalGetValue(variable);
        }
        CVUVariables.secureVariableValueTrace("getting variable", variable, returnValue);
        return returnValue;
    }

    private static String internalGetValue(String variable) {
        Trace.out((String)("variable name = " + variable));
        CVUVariableData cvuVar = CVUVariables.getCVUVariable(variable);
        String returnValue = null;
        try {
            List<String> cvuVariableNames;
            if (cvuVar != null && (cvuVariableNames = cvuVar.getCVUVariableNames()) != null) {
                for (String cvuVarName : cvuVariableNames) {
                    try {
                        returnValue = CVUVariables.resolveAsCVUVariableConstant(cvuVarName);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        Trace.out((Object)"The given cvuVarName < %s > is not a CVUVariableConstant", (String)cvuVarName);
                    }
                }
            }
            if (returnValue == null) {
                returnValue = CVUVariables.resolveAsCVUVariableConstant(variable);
            }
        }
        catch (IllegalArgumentException e) {
            Trace.out((Object)"The given variable < %s > is not a CVUVariableConstant", (String)variable);
            if (cvuVar != null) {
                returnValue = cvuVar.getValue();
            }
            if (s_variableValueRepos.containsKey(variable)) {
                returnValue = s_variableValueRepos.get(variable);
            }
            Trace.out((String)("The given variable can not be resolved : " + variable));
        }
        return returnValue;
    }

    private static String resolveAsCVUVariableConstant(String variable) throws IllegalArgumentException {
        CVUVariableConstants variableEnum = CVUVariableConstants.valueOf(variable);
        return CVUVariables.resolve(variableEnum);
    }

    public static CVUVariableData getCVUVariable(String name) {
        Trace.out((int)1, (String)("variable name : " + name));
        String context = null;
        CVUVariableData retVar = null;
        if (name != null) {
            if (m_InstallUIVariables.containsKey(name)) {
                retVar = m_InstallUIVariables.get(name);
                context = "Install UI";
            } else if (m_InstallResponseVariables.containsKey(name)) {
                retVar = m_InstallResponseVariables.get(name);
                context = "Response file";
            } else if (m_CvuCmdVariables.containsKey(name)) {
                retVar = m_CvuCmdVariables.get(name);
                context = "CVU and Command Line";
            } else if (m_RootScriptVariables.containsKey(name)) {
                retVar = m_RootScriptVariables.get(name);
                context = "Root Scripts";
            } else {
                Trace.out((String)("The variable name : <" + name + "> is not listed"));
            }
        } else {
            Trace.out((String)"The parameter <name> is null");
        }
        if (context != null) {
            Trace.out((int)1, (String)"Variable found in the %s context", (Object[])new Object[]{context});
        }
        return retVar;
    }

    public static String getValue(CVUVariableConstants variable) {
        String retVal = null;
        if (variable != null) {
            retVal = CVUVariables.resolve(variable);
            CVUVariables.secureVariableValueTrace("getting CVUVariableConstant", variable.toString(), retVal);
        } else {
            Trace.out((String)"The CVUVariableConstant <variable> is null");
        }
        return retVal;
    }

    public static void setForceLookUpForVariable(String name, boolean force) {
        if (VerificationUtil.isStringGood(name)) {
            CVUVariableData modifyCVUVar = CVUVariables.getCVUVariable(name);
            if (modifyCVUVar != null) {
                modifyCVUVar.setForceLookUp(force);
                Trace.out((String)("The CVU variable associated with the name : " + name + ", has been updated with the forceLookUp value : " + force));
            } else {
                Trace.out((String)("There is NO CVU variable associated with the given name : " + name));
            }
        } else {
            Trace.out((String)"The given name is not a valid String");
        }
    }

    public static void clear(CVUVariableConstants varName) {
        if (varName != null) {
            CVUVariables.clear(varName.toString());
        } else {
            Trace.out((String)"The given variable name is null ");
        }
    }

    public static void clear(String name) {
        if (VerificationUtil.isStringGood(name)) {
            Trace.out((Object)"variable = %s", (String)name);
            CVUVariableData clsVar = CVUVariables.getCVUVariable(name);
            if (clsVar != null) {
                CVUVariables.secureVariableValueTrace("Clearing value for variable", name, clsVar.getValue());
                clsVar.setValue(null);
            } else if (s_variableValueRepos.containsKey(name)) {
                CVUVariables.secureVariableValueTrace("Clearing value for variable", name, s_variableValueRepos.get(name));
                s_variableValueRepos.remove(name);
            } else {
                Trace.out((String)"The given variable name was not found");
            }
        } else {
            Trace.out((String)"The given variable <name> is not a valid string ");
        }
    }

    public static void secureVariableValueTrace(String comment, String var, String val) {
        CVUVariables.secureVariableValueTrace(5, comment, var, val);
    }

    public static void secureVariableValueTrace(int traceLevel, String comment, String var, String val) {
        String secureVal = val;
        if (VerificationUtil.PASSWORD_VAR_NAME_PATTERN.matcher(var).matches()) {
            Trace.out((String)("Secured value for variable : " + var));
            secureVal = "*****";
        }
        Trace.out((int)traceLevel, (String)(comment + " : VAR = " + var + " VAL = " + secureVal));
    }

    private static String resolve(CVUVariableConstants variable) {
        String name = variable.toString();
        String value = null;
        CVUVariableData resolvedCVUVar = CVUVariables.getCVUVariable(name);
        if (resolvedCVUVar != null) {
            value = resolvedCVUVar.getValue();
            if (value == null || resolvedCVUVar.isLookUpForced()) {
                Trace.out((int)1, (String)("Current value null : " + (value == null) + " LookUp is " + "Forced: " + resolvedCVUVar.isLookUpForced() + ", try to resolve variable: " + name));
                value = CVUVariables.resolveValueForVariable(variable);
                if (VerificationUtil.isStringGood(value)) {
                    resolvedCVUVar.setValue(value);
                } else {
                    Trace.out((String)("Resolution failed, cached value is left untouched for variable : " + (Object)((Object)variable)));
                }
            } else {
                Trace.out((int)1, (String)("ForcedLookUp not enabled for variable:" + (Object)((Object)variable)));
            }
        } else {
            value = CVUVariables.resolveValueForVariable(variable);
            CVUVariables.setValue(variable, value);
        }
        return value;
    }

    private static String resolveValueForVariable(CVUVariableConstants variable) {
        String name = variable.toString();
        Trace.out((int)1, (String)("variable = " + name));
        boolean conditionResult = false;
        String value = null;
        Result result = null;
        String localNode = VerificationUtil.getLocalNode();
        switch (variable) {
            case PVT_NETWORKS_LIST: {
                value = NetworkUtility.getPrivateNetworkListVarString(true);
                break;
            }
            case PVT_NETWORK_COUNT: {
                String privateNetworkCommandSeparatedList = CVUVariables.getValue(CVUVariableConstants.PVT_NETWORKS_LIST);
                if (!VerificationUtil.isStringGood(privateNetworkCommandSeparatedList)) break;
                int count = VerificationUtil.string2strArr(privateNetworkCommandSeparatedList).length;
                value = Integer.toString(count);
                break;
            }
            case OS_DIST_NAME: {
                value = VerificationUtil.getCurrentOS();
            }
            case OS_DIST_VERSION: {
                value = VerificationUtil.getUniqueDistributionID();
                break;
            }
            case CONFIGURED_CRS_HOME: {
                value = VerificationUtil.getCRSHome();
                break;
            }
            case SIHA_HOME: {
                value = VerificationUtil.getHAHome();
                break;
            }
            case ASM_HOME: {
                Version curVer = null;
                if (VerificationUtil.isHAConfigured()) {
                    value = CVUVariables.getValue(CVUVariableConstants.SIHA_HOME);
                    curVer = VerificationUtil.getSIHAReleaseVersionObj();
                } else if (VerificationUtil.isCRSConfigured()) {
                    value = CVUVariables.getValue(CVUVariableConstants.CONFIGURED_CRS_HOME);
                    curVer = VerificationUtil.getCRSActiveVersionObj();
                }
                if (curVer != null && Version.isPre112((Version)curVer)) {
                    Trace.out((String)"Source home CRS version is pre 11.2, retrieving the ASM home using CVU helper");
                    result = new Result(localNode);
                    value = CVUHelperUtil.getASMhome(result);
                    break;
                }
                Trace.out((String)"Returning CRS/HA home as ASM home");
                break;
            }
            case GRID_SOFTWARE_VERSION: {
                if (VerificationUtil.isCRSConfigured()) {
                    value = String.valueOf(VerificationUtil.getCRSSoftwareVersionObj());
                    break;
                }
                value = String.valueOf(VerificationUtil.getSIHAReleaseVersion(true));
                break;
            }
            case GRID_RELEASE_VERSION: {
                if (VerificationUtil.isCRSConfigured()) {
                    value = VerificationUtil.getCRSReleaseVersion(localNode);
                    break;
                }
                value = String.valueOf(VerificationUtil.getSIHAReleaseVersion(true));
                break;
            }
            case GRID_ACTIVE_VERSION: {
                value = VerificationUtil.getCRSActiveVersion(true);
                break;
            }
            case SRC_HOME_RELEASE_VERSION: {
                String crsHome = CVUVariables.getValue(CVUVariableConstants.oracle_install_crs_configuredCRSHome);
                if (VerificationUtil.isCRSConfigured()) {
                    value = VerificationUtil.getCRSReleaseVersion(crsHome, localNode);
                    break;
                }
                value = String.valueOf(VerificationUtil.getSIHAReleaseVersion(true));
                break;
            }
            case DEST_HOME_RELEASE_VERSION: {
                String crsHome = CVUVariables.getValue(CVUVariableConstants.CRS_HOME);
                if (VerificationUtil.isCRSConfigured()) {
                    value = VerificationUtil.getCRSReleaseVersion(crsHome, localNode);
                    break;
                }
                value = String.valueOf(VerificationUtil.getSIHAReleaseVersion(true));
                break;
            }
            case SRC_RAC_HOME_VERSION: {
                String oracleHome = CVUVariables.getValue(CVUVariableConstants.SRC_RAC_HOME);
                try {
                    Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
                    if (crsActiveVersion == null) break;
                    value = new DBUtils(crsActiveVersion).getDBVersionString(oracleHome);
                }
                catch (DBUtilsException e) {
                    Trace.out((String)"Following exception ignored while determinig the version of oracle home %s as part of evaluating variable %s", (Object[])new Object[]{oracleHome, VerificationAPIConstants.VAR_SRC_RAC_HOME_VERSION});
                    Trace.out((String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
                }
                break;
            }
            case DEST_RAC_HOME_VERSION: {
                String oracleHome = CVUVariables.getValue(CVUVariableConstants.RAC_HOME);
                try {
                    Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
                    if (crsActiveVersion == null) break;
                    value = new DBUtils(crsActiveVersion).getDBVersionString(oracleHome);
                }
                catch (DBUtilsException e) {
                    Trace.out((String)"Following exception ignored while determing the version of oracle home %s as part of evaluating variable %s", (Object[])new Object[]{oracleHome, VerificationAPIConstants.VAR_DEST_RAC_HOME_VERSION});
                    Trace.out((String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
                }
                break;
            }
            case RAC_VERSION: {
                String racHome = CVUVariables.getValue(CVUVariableConstants.CV_RAC_HOME);
                try {
                    Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
                    if (crsActiveVersion == null) break;
                    value = String.valueOf(new DBUtils(crsActiveVersion).getDBVersion(racHome));
                }
                catch (DBUtilsException e) {
                    Trace.out((String)"Following exception ignored while determing the version of RAC home %s as part of evaluating variable %s", (Object[])new Object[]{racHome, VerificationAPIConstants.VAR_RAC_VERSION});
                    Trace.out((String)(e.getClass() + ": " + e.getMessage()));
                }
                break;
            }
            case TEMP_AREA: {
                value = VerificationUtil.getEnv("TMP");
                if (VerificationUtil.isStringGood(value)) break;
                if (m_isUnix) {
                    value = "/tmp";
                    break;
                }
                String systemRoot = VerificationUtil.getEnv("SystemRoot");
                if (!VerificationUtil.isStringGood(systemRoot)) break;
                value = systemRoot + File.separator + "Temp";
                break;
            }
            case VIRTUAL_ENVIRONMENT: {
                conditionResult = VerificationUtil.isVirtualEnvironment();
                value = Boolean.toString(conditionResult);
                break;
            }
            case CVUQDISK_VERSION: {
                value = "1.0.10-1";
                break;
            }
            case QUORUM_DISKS: {
                if (!VerificationUtil.isCRSConfigured()) break;
                try {
                    List<String> quorumDiskList = new ASMDiskGroupsUtil().getASMQuorumGroupDisks();
                    if (quorumDiskList.isEmpty()) break;
                    value = VerificationUtil.strList2List(quorumDiskList);
                }
                catch (CmdToolUtilException e) {
                    Trace.out((String)("CmdToolUtilException while an attempt to get quorum disks list. Error is:" + e.getMessage()));
                }
                break;
            }
            case INSTALL_USER: {
                value = System.getProperty("user.name");
                break;
            }
            case KERNEL_VER: {
                GlobalExecution globalExec = new GlobalExecution();
                ResultSet resultSet = new ResultSet();
                globalExec.checkKernelVersion(new String[]{localNode}, "", resultSet);
                result = resultSet.getResult(localNode);
                if (result.getStatus() != 1) break;
                value = result.getResultInfoSet().elementAt(0).toString();
                break;
            }
            case DB_SERVICE_COUNT: {
                value = "-1";
                CollectionResultSet<Integer> rs = CVUHelperUtil.getDBServiceCount();
                if (!rs.getOverallStatus().equals((Object)OverallStatus.SUCCESSFUL)) break;
                try {
                    value = String.valueOf(rs.getCollectedClusterwideValue());
                }
                catch (ClusterwideCollectionUnavailableException e) {
                    Trace.out((String)"Encountered exception %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
                }
                break;
            }
            case ASM_ADMIN_GROUP: 
            case ASM_DBA_GROUP: 
            case OSDBA_ASM_GROUP: 
            case ASM_OPER_GROUP: {
                try {
                    String asmHome = CVUVariables.getValue(CVUVariableConstants.ASM_HOME);
                    if (VerificationUtil.isStringGood(asmHome)) {
                        switch (variable) {
                            case ASM_ADMIN_GROUP: {
                                value = VerificationUtil.getASMAdminGroup(asmHome);
                                break;
                            }
                            case ASM_DBA_GROUP: 
                            case OSDBA_ASM_GROUP: {
                                value = VerificationUtil.getASMDBAGroup(asmHome);
                                break;
                            }
                            case ASM_OPER_GROUP: {
                                value = VerificationUtil.getASMOPERGroup(asmHome);
                            }
                        }
                        break;
                    }
                    Trace.out((String)"ASM home could not be retrieved.");
                }
                catch (CVUException ce) {
                    Trace.out((String)ce.getMessage());
                }
                break;
            }
            case OSASM_GROUP: 
            case OSOPER_GROUP: 
            case OSDBA_GROUP: 
            case OSBACKUPDBA_GROUP: 
            case OSDGDBA_GROUP: 
            case OSKMDBA_GROUP: 
            case OSRACDBA_GROUP: {
                try {
                    result = new Result(localNode);
                    String osdbaToolHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
                    if (VerificationUtil.isStringGood(osdbaToolHome)) {
                        switch (variable) {
                            case OSASM_GROUP: {
                                value = VerificationUtil.getOSAsmGroup(osdbaToolHome);
                                break;
                            }
                            case OSOPER_GROUP: {
                                value = VerificationUtil.getOSOPERGroup(osdbaToolHome);
                                break;
                            }
                            case OSDBA_GROUP: {
                                value = VerificationUtil.getOSDBAGroup(osdbaToolHome);
                                break;
                            }
                            case OSBACKUPDBA_GROUP: {
                                value = VerificationUtil.getOSBACKUPDBAGroup(osdbaToolHome);
                                break;
                            }
                            case OSDGDBA_GROUP: {
                                value = VerificationUtil.getOSDGDBAGroup(osdbaToolHome);
                                break;
                            }
                            case OSKMDBA_GROUP: {
                                value = VerificationUtil.getOSKMDBAGroup(osdbaToolHome);
                            }
                            case OSRACDBA_GROUP: {
                                value = VerificationUtil.getOSRACDBAGroup(osdbaToolHome);
                            }
                        }
                        break;
                    }
                    Trace.out((String)"OSDBA home could not be retrieved.");
                }
                catch (CVUException ce) {
                    Trace.out((String)ce.getMessage());
                }
                break;
            }
            case INVENTORY_GROUP: {
                value = VerificationUtil.getOraInventoryGroup();
                Trace.out((String)("OraInventory group retrieved is = >" + value + "<"));
                break;
            }
            case CRS_RESOURCE_OWNERS: {
                ResultSet resultSet = new ResultSet();
                List<String> crsResOwnersList = VerificationUtil.getCRSResourceOwners(resultSet);
                HashSet<String> crsResOwners = new HashSet<String>();
                if (crsResOwnersList != null && !crsResOwnersList.isEmpty()) {
                    crsResOwners.addAll(crsResOwnersList);
                }
                if (!crsResOwners.isEmpty()) {
                    value = VerificationUtil.strCollection2String(crsResOwners);
                    Trace.out((String)("CRS Resource owners retrieved are = >" + value + "<"));
                    break;
                }
                if (resultSet.anyFailure()) {
                    VerificationUtil.traceAndLogError("CRS Resource owners could not be retrieved. Error is :" + VerificationUtil.errorCollection2String(resultSet.getErrors()));
                    break;
                }
                Trace.out((String)"No CRS Resource owners found.");
                break;
            }
            case CRS_USER: {
                result = new Result(localNode);
                value = VerificationUtil.getCRSUser(localNode, result, false);
                Trace.out((String)("CRS User retrieved = >" + value + "<"));
                break;
            }
            case CRS_USER_GROUP: {
                result = new Result(localNode);
                value = VerificationUtil.getCRSUserGroup(localNode, result);
                Trace.out((String)("CRS User's Group retrieved = >" + value + "<"));
                break;
            }
            case CRS_CONFIG: 
            case CRS: {
                conditionResult = VerificationUtil.isCRSConfigured();
                value = Boolean.toString(conditionResult);
                break;
            }
            case HA_CONFIG: 
            case HA: {
                conditionResult = VerificationUtil.isHAConfigured();
                value = Boolean.toString(conditionResult);
                break;
            }
            case ASM_RUNNING: {
                String[] nodes;
                try {
                    nodes = VerificationUtil.getStaticNodelist();
                }
                catch (NodelistNotFoundException e) {
                    Trace.out((Exception)e);
                    nodes = new String[]{localNode};
                }
                conditionResult = VerificationUtil.isASMRunningOnAnyNode(nodes);
                value = Boolean.toString(conditionResult);
                break;
            }
            case AFD_LIB_FILE_NAME: {
                value = ASMUtils.getAFDLibFileName();
                break;
            }
            case AFD_DRV_NAME: {
                value = ASMUtils.getAFDDriverName();
                break;
            }
            case AFD_CONF_FILE_PATH: {
                value = ASMUtils.getAFDConfFilePath();
                break;
            }
            case ENABLE_AFD_CHECKS: {
                String confAFD = CVUVariables.getValue(CVUVariableConstants.CONFIGURE_AFD);
                if (!VerificationUtil.isStringGood(confAFD)) break;
                value = confAFD;
                if (!confAFD.equalsIgnoreCase("default") || !StorageUtil.isAFDSupported()) break;
                value = "TRUE";
                break;
            }
            case USE_DNFS: {
                result = VerificationUtil.isDNFSPathInUse();
                conditionResult = result.getStatus() == 1;
                value = Boolean.toString(conditionResult);
                break;
            }
            case USE_IPMI: {
                try {
                    CRSCTLUtil crsctlUtil = new CRSCTLUtil(VerificationUtil.getCRSHome());
                    value = crsctlUtil.isIPMIConfigured() ? "TRUE" : "FALSE";
                }
                catch (CmdToolUtilException cte) {
                    VerificationUtil.traceAndLogError("Exception while attempting to determine IPMI configuration, CmdToolUtilException :" + cte.getMessage());
                }
                break;
            }
            case RELEASE: {
                value = VerificationUtil.getConfiguredValue("CV_ORACLE_RELEASE", false);
                if (VerificationUtil.isStringGood(value)) break;
                value = "12.2";
                break;
            }
            case IS_DAX_DEVICE_EXISTS: {
                File daxDev = new File(DAX_DEVICE);
                value = Boolean.toString(daxDev.exists()).toUpperCase();
                break;
            }
            case RAC_USER: {
                File dbHome;
                String dbHomePath = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
                if (VerificationUtil.isStringGood(dbHomePath) && (dbHome = new File(dbHomePath)).exists()) {
                    Result nodeRslt = new Result(localNode);
                    String dbUser = VerificationUtil.getOracleUser(dbHomePath, localNode, nodeRslt);
                    if (nodeRslt.getStatus() == 1 && dbUser != null && dbUser.trim().length() > 0) {
                        value = dbUser.trim();
                        Trace.out((String)("db user obtained is " + value));
                        break;
                    }
                }
                value = CVUVariables.getValue(CVUVariableConstants.INSTALL_USER);
                Trace.out((String)("db user obtained is " + value));
                break;
            }
            case ORACLE_HOME_EXIST_OR_CREATABLE: {
                String[] nodeList = null;
                String nodeStr = CVUVariables.getValue(CVUVariableConstants.NODE_LIST);
                nodeList = VerificationUtil.isStringGood(nodeStr) ? VerificationUtil.string2strArr(nodeStr) : new String[]{localNode};
                String oracleHomePath = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
                ResultSet rsltSet = new ResultSet();
                if (VerificationUtil.isStringGood(oracleHomePath)) {
                    VerificationUtil.checkPathWriteableCreateable(nodeList, oracleHomePath, rsltSet, true);
                    conditionResult = rsltSet.allSuccess();
                    value = Boolean.toString(conditionResult);
                    if (!conditionResult) break;
                    String oracleHomeExistingPath = VerificationUtil.getLongestExistingParentPath(nodeList, oracleHomePath, false);
                    if (VerificationUtil.isStringGood(oracleHomeExistingPath)) {
                        CVUVariables.setValue(CVUVariableConstants.ORACLE_HOME_EXISTING_PATH, oracleHomeExistingPath);
                        break;
                    }
                    value = Boolean.toString(false);
                    break;
                }
                value = Boolean.toString(false);
                break;
            }
            case CRS_HOME_EXIST_OR_CREATABLE: {
                String[] nodeArr = null;
                String nodeListStr = CVUVariables.getValue(CVUVariableConstants.NODE_LIST);
                nodeArr = VerificationUtil.isStringGood(nodeListStr) ? VerificationUtil.string2strArr(nodeListStr) : new String[]{localNode};
                String crsHomePath = CVUVariables.getValue(CVUVariableConstants.CRS_HOME);
                ResultSet crsResultSet = new ResultSet();
                if (VerificationUtil.isStringGood(crsHomePath)) {
                    VerificationUtil.checkPathWriteableCreateable(nodeArr, crsHomePath, crsResultSet, true);
                    conditionResult = crsResultSet.allSuccess();
                    value = Boolean.toString(conditionResult);
                    if (!conditionResult) break;
                    String crsHomeExistingPath = VerificationUtil.getLongestExistingParentPath(nodeArr, crsHomePath, false);
                    if (VerificationUtil.isStringGood(crsHomeExistingPath)) {
                        CVUVariables.setValue(CVUVariableConstants.CRS_HOME_EXISTING_PATH, crsHomeExistingPath);
                        break;
                    }
                    value = Boolean.toString(false);
                    break;
                }
                value = Boolean.toString(false);
                break;
            }
            case EXADATA_SYS: {
                conditionResult = VerificationUtil.isExadataSystem();
                value = Boolean.toString(conditionResult);
                break;
            }
            case OPC_SYS: {
                conditionResult = VerificationUtil.isOPC();
                value = Boolean.toString(conditionResult);
                break;
            }
            case ENGINEERED_SYS: {
                conditionResult = VerificationUtil.isEngineeredSystem();
                value = Boolean.toString(conditionResult);
                break;
            }
            case ODA_LITE_SYS: {
                conditionResult = VerificationUtil.isODALiteEnv();
                value = Boolean.toString(conditionResult);
                break;
            }
            case ODA_SINGLEIP_SYS: {
                conditionResult = VerificationUtil.isODASingleIPEnv();
                value = Boolean.toString(conditionResult);
                break;
            }
            case NAMESERVER_CONFIG: {
                conditionResult = VerificationUtil.isNameServerConfigured();
                value = Boolean.toString(conditionResult);
                break;
            }
            case APPLICATION_CLUSTER: {
                try {
                    conditionResult = new ClusterwareInfo().isApplicationCluster();
                    value = Boolean.toString(conditionResult);
                }
                catch (InstallException e) {
                    value = Boolean.toString(false);
                    Trace.out((String)"Following exception ignored while determing application cluster variable %s", (Object[])new Object[]{CVUVariableConstants.APPLICATION_CLUSTER});
                    Trace.out((String)"IGNORED: %s : %s", (Object[])new Object[]{((Object)((Object)e)).getClass(), e.getMessage()});
                }
                break;
            }
            default: {
                value = sVerificationUtil.resolve(variable);
            }
        }
        CVUVariables.secureVariableValueTrace(1, "Resolved CVUVariableConstant...", variable.toString(), value);
        return value;
    }

    public static void initialize() {
        if (!m_isVariablesXmlParsed && !VerificationUtil.isStringGood(m_releaseForVariablesXml)) {
            String reqRelease = VerificationUtil.getRequestedRelease();
            if (reqRelease != null) {
                m_releaseForVariablesXml = reqRelease;
                Trace.out((String)("RequestedRelease is: " + reqRelease));
            } else {
                m_releaseForVariablesXml = "12.2";
                Trace.out((String)("using CUR_RELEASE : " + m_releaseForVariablesXml + ", to parse variables.xml"));
            }
        }
        if (!m_isVariablesXmlParsed) {
            try {
                Trace.out((String)"Start parse all variables from variables.xml...");
                CVUVariables.parse(m_releaseForVariablesXml);
                m_isVariablesXmlParsed = true;
            }
            catch (SAXException e) {
                Trace.out((Exception)e);
            }
            catch (URISyntaxException e) {
                Trace.out((Exception)e);
            }
            catch (ParserConfigurationException e) {
                Trace.out((Exception)e);
            }
            catch (IOException e) {
                Trace.out((Exception)e);
            }
            catch (XmlFilePathException e) {
                Trace.out((Exception)e);
            }
            catch (CVUVariablesException e) {
                Trace.out((Exception)e);
            }
        }
    }

    private static void parse(String release) throws SAXException, URISyntaxException, ParserConfigurationException, IOException, XmlFilePathException, CVUVariablesException {
        m_rootElementTaskDef = CVUVariables.getRootElement();
        if (m_rootElementTaskDef == null) {
            Trace.out((String)"CVUVariables xml file not found or could not be parsed");
            return;
        }
        NodeList softwareReleaseList = m_rootElementTaskDef.getElementsByTagName(VARIABLES_SOFTWARE_ELEMENT_TAG);
        String version = null;
        boolean foundRelease = false;
        for (int i = 0; i < softwareReleaseList.getLength(); ++i) {
            Element elem = (Element)softwareReleaseList.item(i);
            version = elem.getAttribute(VARIABLES_VERSION_ELEMENT_TAG);
            Trace.out((String)("Version found " + version));
            if (version.equalsIgnoreCase(m_commonVariablesReleaseVal)) {
                Trace.out((String)"Process common variables ");
                CVUVariables.processVariableListForRelease(elem);
                continue;
            }
            if (version.equalsIgnoreCase(release)) {
                Trace.out((String)("Process variables for the release: " + version));
                foundRelease = true;
                CVUVariables.processVariableListForRelease(elem);
                continue;
            }
            if (version.equalsIgnoreCase("12.2")) {
                m_currentReleaseVarDef = elem;
                Trace.out((String)("Found variable definition for the current release : " + version));
                continue;
            }
            Trace.out((String)("Not parsing variables for the release : " + version));
        }
        if (!foundRelease) {
            if (m_currentReleaseVarDef == null) {
                Trace.out((String)"Variable definitions for the current release not found");
            } else {
                Trace.out((String)("The requested release " + release + " was not found"));
                m_releaseForVariablesXml = "12.2";
                Trace.out((String)"Default to variable definitions of the current release");
                CVUVariables.processVariableListForRelease(m_currentReleaseVarDef);
            }
        }
    }

    private static void processVariableListForRelease(Element releaseElem) throws CVUVariablesException {
        CVUVariableData nextVariable = null;
        NodeList variableList = releaseElem.getElementsByTagName(VARIABLES_VARIABLE_LIST_ELEMENT_TAG);
        Element variableListElem = (Element)variableList.item(0);
        NodeList xmlVariableList = variableListElem.getElementsByTagName(VARIABLES_VARIABLE_ELEMENT_TAG);
        for (int i = 0; i < xmlVariableList.getLength(); ++i) {
            Element variableElem = (Element)xmlVariableList.item(i);
            nextVariable = new CVUVariableData(CVUVariables.getVariableNamesForContext(variableElem, VARIABLES_INSTALL_UI_ELEMENT_TAG), CVUVariables.getVariableNamesForContext(variableElem, VARIABLES_INSTALL_RESP_ELEMENT_TAG), CVUVariables.getVariableNamesForContext(variableElem, VARIABLES_CVU_CMD_VAR_ELEMENT_TAG), CVUVariables.getVariableNamesForContext(variableElem, VARIABLES_ROOT_SCRIPT_ELEMENT_TAG));
            CVUVariables.addVariableToContextForNames(nextVariable, m_InstallUIVariables, nextVariable.getInstallUINames());
            CVUVariables.addVariableToContextForNames(nextVariable, m_InstallResponseVariables, nextVariable.getInstallResponseNames());
            CVUVariables.addVariableToContextForNames(nextVariable, m_CvuCmdVariables, nextVariable.getCVUVariableNames());
            CVUVariables.addVariableToContextForNames(nextVariable, m_RootScriptVariables, nextVariable.getRootScriptNames());
        }
    }

    private static void addVariableToContextForNames(CVUVariableData nextVariable, Hashtable<String, CVUVariableData> context, List<String> allVarNamesList) throws CVUVariablesException {
        if (allVarNamesList == null) {
            Trace.out((int)1, (String)"The given list of variable names is null");
            return;
        }
        for (int namesIndex = 0; namesIndex < allVarNamesList.size(); ++namesIndex) {
            String name = allVarNamesList.get(namesIndex);
            if (context.containsKey(name)) {
                CVUVariableData tmp = context.get(name);
                if (tmp != nextVariable) {
                    throw new CVUVariablesException("Duplicated entry in file variables.xml.  Variable name : " + name + ". " + "CVUVariable string representation : " + nextVariable.toString());
                }
                VerificationUtil.traceAndLog("Variable name used in multiple context for the same CVU Variable");
                continue;
            }
            context.put(name, nextVariable);
        }
    }

    private static String getVariableNamesForContext(Element variableElem, String context) {
        String result = null;
        Element rootScriptElem = CVUVariables.getFirstChildByTagName(variableElem, context);
        if (rootScriptElem != null) {
            String name = rootScriptElem.getAttribute(VARIABLES_NAME_ATTRIBUTE_TAG);
            if (VerificationUtil.isStringGood(name)) {
                result = name;
            } else {
                Trace.out((int)1, (String)("The variable Name attribute was not found for context: " + context));
            }
        }
        return result;
    }

    private static Element getRootElement() throws SAXException, URISyntaxException, ParserConfigurationException, IOException, XmlFilePathException {
        DocumentBuilderFactory m_xmlFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder m_xmlParser = null;
        Document m_xmlDocument = null;
        File file_xsdURI = null;
        File file_xmlFile = null;
        String m_xmlVarFile = VerificationUtil.getVariablesXmlURI();
        String m_xsdVarFile = VerificationUtil.getVariablesXmlSchemaURI();
        Trace.out((String)("==== URIs obtained :xsd URI = " + m_xsdVarFile));
        Trace.out((String)("==== URIs obtained :xml URI = " + m_xmlVarFile));
        if (m_xsdVarFile != null) {
            file_xsdURI = new File(new URI(m_xsdVarFile));
        }
        if (file_xsdURI == null || !file_xsdURI.exists()) {
            Trace.out((String)("xmlFile: " + m_xsdVarFile + " does not exists. returning " + "null"));
            return null;
        }
        Trace.out((String)("xsdFile exists : " + m_xsdVarFile));
        if (m_xmlVarFile != null) {
            file_xmlFile = new File(new URI(m_xmlVarFile));
        }
        if (file_xmlFile == null || !file_xmlFile.exists()) {
            Trace.out((String)("xmlFile: " + m_xmlVarFile + " does not exists. returning " + "null"));
            return null;
        }
        Trace.out((String)("xmlFile exists : " + m_xmlVarFile));
        if (m_xsdVarFile != null) {
            m_xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            m_xmlFactory.setNamespaceAware(true);
            m_xmlFactory.setValidating(true);
            m_xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", m_xsdVarFile);
            Trace.out((String)("setting xmlFactory to use xsdFile : " + m_xsdVarFile));
        } else {
            Trace.out((String)"xsdFileVarFile is null");
        }
        m_xmlParser = m_xmlFactory.newDocumentBuilder();
        ErrorHandler handler = new ErrorHandler(){

            @Override
            public void error(SAXParseException arg0) throws SAXException {
                throw arg0;
            }

            @Override
            public void fatalError(SAXParseException arg0) throws SAXException {
                throw arg0;
            }

            @Override
            public void warning(SAXParseException arg0) throws SAXException {
                Trace.out((String)("Igonred warning while parsing: " + arg0));
            }
        };
        m_xmlParser.setErrorHandler(handler);
        m_xmlDocument = m_xmlParser.parse(file_xmlFile);
        if (m_xmlDocument != null) {
            Trace.out((String)("The xml variables file: " + m_xmlVarFile + ", was parsed" + " correctly"));
        } else {
            Trace.out((String)("The xml variables file: " + m_xmlVarFile + ", was NOT" + " parsed"));
        }
        return m_xmlDocument.getDocumentElement();
    }

    private static NodeList getChildrenByTagName(Element elem, String tagName) {
        NodeList allChildren = elem.getChildNodes();
        final ArrayList<Node> _items = new ArrayList<Node>();
        NodeList immediateChildren = new NodeList(){

            @Override
            public int getLength() {
                return _items.size();
            }

            @Override
            public Node item(int paramInt) {
                return (Node)_items.get(paramInt);
            }
        };
        for (int i = 0; i < allChildren.getLength(); ++i) {
            Node toddler = allChildren.item(i);
            if (toddler == null || !toddler.getNodeName().equals(tagName)) continue;
            _items.add(toddler);
        }
        return immediateChildren;
    }

    private static Element getFirstChildByTagName(Element elem, String tagName) {
        NodeList allChildren = CVUVariables.getChildrenByTagName(elem, tagName);
        for (int i = 0; i < allChildren.getLength(); ++i) {
            Node toddler = allChildren.item(i);
            if (toddler == null || !toddler.getNodeName().equals(tagName)) continue;
            return (Element)toddler;
        }
        return null;
    }
}

