/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.File;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.verification.VerificationError;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.util.ASMUtilsException;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class ASMUtils
implements CVUHelperConstants {
    private static GlobalVerificationContext m_gCtx = GlobalVerificationContext.getInstance();
    private static final String ASM_DISK_STRING = "asm_diskstring";
    private static final String NULL_DISK_STRING = "null";
    private static HashMap<String, Boolean> asmDiscoveryStringHM = null;
    private static String asmDiscoveryString = null;
    private static final String ASM_DISK_STRING_QUERY = "select value, isdefault from v$parameter where name='asm_diskstring'";
    private static final String ASM_DISK_GROUP_DETAILS_QUERY = "select dg.inst_id as inst_id, a.name as name, a.value as value, read_only from gv$asm_diskgroup dg, v$asm_attribute a where dg.name = '%s' and dg.group_number = a.group_number and a.name not like '%%template%%'";
    private static final String ASM_DISK_DETAILS_QUERY = "select * from gv$asm_disk_stat";
    private static final String ASM_INSTANCE_QUERY = "select inst_id, instance_name from gv$instance order by inst_id";
    private static final String ASM_DISK_GROUP_NAME_AND_ID_QUERY = "select inst_id, group_number, name from gv$asm_diskgroup order by group_number";
    private static final String ASM_ACL_ENABLED_DG = "select distinct d.name from gv$asm_attribute a, gv$asm_diskgroup d where a.GROUP_NUMBER = d.GROUP_NUMBER and a.NAME like 'access_control.enabled' and  a.VALUE like 'TRUE'";
    private static final String ASM_DG_LIST = "select distinct d.name from gv$asm_diskgroup d";
    public static final String CONFIG_AFD_DEF_VAL = "default";
    private static final String AFD_DRV_NAME = "oracleafd";
    private static final String AFD_LIB_FILE_NAME_UNIX = "libafd12.so ";
    private static final String AFD_LIB_FILE_NAME_WINDOWS = "libafd12.dll";
    private static final String AFD_CONF_FILE_PATH_12102 = "/etc/afd.conf";
    private static final String AFD_CONF_FILE_NAME = "oracleafd.conf";
    private static final String AFD_CONF_FILE_DIR_UNIX = "/etc";
    private static final String AFD_CONF_FILE_DIR_WINDOWS = VerificationUtil.getEnv("SystemRoot") != null ? VerificationUtil.getEnv("SystemRoot") + File.separator + "system32" + File.separator + "drivers" : "";
    private static final String AFD_CONF_FILE_PATH_122 = "/etc" + File.separator + "oracleafd.conf";
    private static final String AFD_CONF_FILE_PATH_WINDOWS = AFD_CONF_FILE_DIR_WINDOWS + File.separator + "oracleafd.conf";
    private static HashMap<String, HashMap<String, String>> s_asmDGIDMap = null;
    private static HashMap<String, String> s_asmInstanceIDHM = null;

    public static HashMap<String, Boolean> getASMDiscoveryStringInfo() throws ASMUtilsException {
        if (asmDiscoveryStringHM != null) {
            Trace.out((String)"returning cached information for discovery string");
            return asmDiscoveryStringHM;
        }
        Result result = new Result(VerificationUtil.getLocalNode());
        OracleCachedRowSet rowSet = CVUHelperUtil.runASMQuery(ASM_DISK_STRING_QUERY, "sysdba", result);
        if (rowSet == null) {
            Trace.out((String)"cvuhelper failed to run the SQL query on ASM");
            List<VerificationError> errDescList = result.getErrors();
            String errMesg = "";
            for (VerificationError errDesc : errDescList) {
                errMesg = errMesg + errDesc.getErrorMessage() + LSEP;
            }
            throw new ASMUtilsException(errMesg);
        }
        asmDiscoveryStringHM = new HashMap();
        try {
            rowSet.first();
            asmDiscoveryStringHM.put(rowSet.getString(1), new Boolean("TRUE".equalsIgnoreCase(rowSet.getString(2))));
            return asmDiscoveryStringHM;
        }
        catch (SQLException sqlex) {
            Trace.out((String)("failed to retreive results " + sqlex.getMessage()));
            throw new ASMUtilsException(sqlex.getMessage());
        }
    }

    public static String getASMDiscoveryString(String version) throws ASMUtilsException {
        String[] discoveryStringArray;
        Result result = new Result(VerificationUtil.getLocalNode());
        if (asmDiscoveryString != null) {
            Trace.out((String)"returning cached information for discovery string");
            return asmDiscoveryString;
        }
        asmDiscoveryString = CVUHelperUtil.getASMParameter(ASM_DISK_STRING, result);
        if (asmDiscoveryString == null) {
            Trace.out((String)"cvuhelper failed to run the SQL query on ASM");
            List<VerificationError> errDescList = result.getErrors();
            String errMesg = "";
            for (VerificationError errDesc : errDescList) {
                errMesg = errMesg + errDesc.getErrorMessage() + LSEP;
            }
            throw new ASMUtilsException(errMesg);
        }
        if ((asmDiscoveryString.equalsIgnoreCase(NULL_DISK_STRING) || asmDiscoveryString.length() < 1) && (discoveryStringArray = VerificationUtil.getDefaultDiscoveryDevice(version)).length > 0) {
            asmDiscoveryString = Arrays.asList(discoveryStringArray).toString();
        }
        return asmDiscoveryString;
    }

    public static HashMap<String, HashMap<String, String>> getASMDiskGroupDetails(String diskGroupName, Result result) throws ASMUtilsException {
        String diskGroupDetailsQuery = String.format(ASM_DISK_GROUP_DETAILS_QUERY, diskGroupName);
        OracleCachedRowSet rowSet = CVUHelperUtil.runASMQuery(diskGroupDetailsQuery, "sysdba", result);
        HashMap<String, HashMap<String, String>> dgDetailsHM = new HashMap<String, HashMap<String, String>>();
        if (rowSet != null) {
            result.setStatus(1);
            try {
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    HashMap<String, String> dgMap;
                    String instanceId = rowSet.getString(1);
                    String instanceName = ASMUtils.getASMInstanceName(instanceId, result);
                    if (!VerificationUtil.isStringGood(instanceName)) {
                        instanceName = instanceId;
                    }
                    if ((dgMap = dgDetailsHM.get(instanceName)) == null) {
                        dgMap = new HashMap();
                        dgDetailsHM.put(instanceName, dgMap);
                    }
                    dgMap.put(rowSet.getString(2), rowSet.getString(3));
                }
            }
            catch (SQLException sqlex) {
                Trace.out((String)("failed to retreive results " + sqlex.getMessage()));
                result.setStatus(2);
                result.addErrorDescription(new ErrorDescription(sqlex.getMessage()));
            }
        }
        return dgDetailsHM;
    }

    private static String getASMDiskGroupName(String instanceName, String dgNumber, Result result) throws ASMUtilsException {
        HashMap<String, String> dgMap;
        String dgName = null;
        if (s_asmDGIDMap == null) {
            s_asmDGIDMap = ASMUtils.getASMDiskGroups(result);
        }
        if ((dgMap = s_asmDGIDMap.get(instanceName)) != null) {
            dgName = dgMap.get(dgNumber);
        }
        return dgName;
    }

    public static HashMap<String, HashMap<String, String>> getASMDiskGroups(Result result) throws ASMUtilsException {
        OracleCachedRowSet rowSet = CVUHelperUtil.runASMQuery(ASM_DISK_GROUP_NAME_AND_ID_QUERY, "sysdba", result);
        HashMap<String, HashMap<String, String>> dgDetailsHM = new HashMap<String, HashMap<String, String>>();
        if (rowSet != null) {
            result.setStatus(1);
            try {
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    String instanceId = rowSet.getString(1);
                    String instanceName = ASMUtils.getASMInstanceName(instanceId, result);
                    if (!VerificationUtil.isStringGood(instanceName)) {
                        instanceName = instanceId;
                    }
                    String diskGroupNumber = rowSet.getString(2);
                    String diskGroupName = rowSet.getString(3);
                    HashMap<String, String> dgMap = dgDetailsHM.get(instanceName);
                    if (dgMap == null) {
                        dgMap = new HashMap();
                        dgDetailsHM.put(instanceName, dgMap);
                    }
                    dgMap.put(diskGroupNumber, diskGroupName);
                }
            }
            catch (SQLException sqlex) {
                Trace.out((String)("failed to retreive results " + sqlex.getMessage()));
                result.setStatus(2);
                result.addErrorDescription(new ErrorDescription(sqlex.getMessage()));
            }
        }
        return dgDetailsHM;
    }

    private static String getASMInstanceName(String instanceId, Result result) throws ASMUtilsException {
        if (s_asmInstanceIDHM == null) {
            s_asmInstanceIDHM = ASMUtils.getASMInstanceIDs(result);
        }
        return s_asmInstanceIDHM.get(instanceId);
    }

    private static HashMap<String, String> getASMInstanceIDs(Result result) throws ASMUtilsException {
        OracleCachedRowSet rowSet = CVUHelperUtil.runASMQuery(ASM_INSTANCE_QUERY, "sysdba", result);
        HashMap<String, String> asmInstanceIDHM = new HashMap<String, String>();
        if (rowSet != null) {
            result.setStatus(1);
            try {
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    asmInstanceIDHM.put(rowSet.getString(1), rowSet.getString(2));
                }
            }
            catch (SQLException sqlex) {
                Trace.out((String)("failed to retreive results " + sqlex.getMessage()));
                result.setStatus(2);
                result.addErrorDescription(new ErrorDescription(sqlex.getMessage()));
            }
        }
        return asmInstanceIDHM;
    }

    public static HashMap<String, HashMap<String, HashMap<String, String>>> getASMDiskDetails(Result result) throws ASMUtilsException {
        OracleCachedRowSet rowSet = CVUHelperUtil.runASMQuery(ASM_DISK_DETAILS_QUERY, "sysdba", result);
        ResultSetMetaData rsmd = null;
        HashMap<String, HashMap<String, HashMap<String, String>>> asmInstanceDiskDetailsHM = new HashMap<String, HashMap<String, HashMap<String, String>>>();
        if (rowSet != null) {
            result.setStatus(1);
            try {
                rsmd = rowSet.getMetaData();
                int columnCount = rsmd.getColumnCount();
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    String instanceId = null;
                    String instanceName = null;
                    String diskGroupNumber = null;
                    String diskGroupName = null;
                    String diskPath = null;
                    HashMap<String, String> diskDetailsHM = new HashMap<String, String>();
                    for (int i = 1; i <= columnCount; ++i) {
                        String columnName = rsmd.getColumnLabel(i);
                        if ("inst_id".equalsIgnoreCase(columnName)) {
                            instanceId = rowSet.getString(i);
                            instanceName = ASMUtils.getASMInstanceName(instanceId, result);
                            if (VerificationUtil.isStringGood(instanceName)) continue;
                            instanceName = instanceId;
                            continue;
                        }
                        if ("group_number".equalsIgnoreCase(columnName)) {
                            diskGroupNumber = rowSet.getString(i);
                            diskGroupName = ASMUtils.getASMDiskGroupName(instanceName, diskGroupNumber, result);
                            if (!VerificationUtil.isStringGood(diskGroupName)) {
                                diskGroupName = diskGroupNumber;
                            }
                            diskDetailsHM.put("DISK_GROUP_NAME", diskGroupName);
                            continue;
                        }
                        if ("path".equalsIgnoreCase(columnName)) {
                            diskPath = rowSet.getString(i);
                            continue;
                        }
                        String value = rowSet.getString(i);
                        diskDetailsHM.put(columnName, value);
                    }
                    HashMap<String, HashMap<String, String>> asmInstDiskHM = asmInstanceDiskDetailsHM.get(instanceName);
                    if (asmInstDiskHM == null) {
                        asmInstDiskHM = new HashMap();
                        asmInstanceDiskDetailsHM.put(instanceName, asmInstDiskHM);
                    }
                    asmInstDiskHM.put(diskPath, diskDetailsHM);
                }
            }
            catch (SQLException sqlex) {
                Trace.out((String)("failed to retreive results " + sqlex.getMessage()));
                result.setStatus(2);
                result.addErrorDescription(new ErrorDescription(sqlex.getMessage()));
            }
        }
        return asmInstanceDiskDetailsHM;
    }

    public static List<String> getACLEnabledDGList(List<String> dgList) throws ASMUtilsException {
        Result result = new Result(VerificationUtil.getLocalNode());
        OracleCachedRowSet rowSet = CVUHelperUtil.runASMQuery(ASM_ACL_ENABLED_DG, "sysdba", result);
        if (rowSet == null) {
            Trace.out((String)"cvuhelper failed to run the SQL query on ASM");
            List<VerificationError> errDescList = result.getErrors();
            String errMesg = "";
            for (VerificationError errDesc : errDescList) {
                errMesg = errMesg + errDesc.getErrorMessage() + LSEP;
            }
            throw new ASMUtilsException(errMesg);
        }
        ArrayList<String> diskGroupList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                diskGroupList.add(rowSet.getString(1));
            }
        }
        catch (SQLException sqlex) {
            Trace.out((String)("failed to retreive results " + sqlex.getMessage()));
            throw new ASMUtilsException(sqlex.getMessage());
        }
        if (!diskGroupList.isEmpty() && dgList != null && !dgList.isEmpty()) {
            diskGroupList.retainAll(dgList);
        }
        return diskGroupList;
    }

    public static List<String> getASMDgList() throws ASMUtilsException {
        Result result = new Result(VerificationUtil.getLocalNode());
        OracleCachedRowSet rowSet = CVUHelperUtil.runASMQuery(ASM_DG_LIST, "sysdba", result);
        if (rowSet == null) {
            Trace.out((String)"cvuhelper failed to run the SQL query on ASM");
            List<VerificationError> errDescList = result.getErrors();
            String errMesg = "";
            for (VerificationError errDesc : errDescList) {
                errMesg = errMesg + errDesc.getErrorMessage() + LSEP;
            }
            throw new ASMUtilsException(errMesg);
        }
        ArrayList<String> diskGroupList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                diskGroupList.add(rowSet.getString(1));
            }
        }
        catch (SQLException sqlex) {
            Trace.out((String)("failed to retreive results " + sqlex.getMessage()));
            throw new ASMUtilsException(sqlex.getMessage());
        }
        return diskGroupList;
    }

    public static String getAFDDriverName() {
        return AFD_DRV_NAME;
    }

    public static String getAFDLibFileName() {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (nativeSys.isUnixSystem()) {
            return AFD_LIB_FILE_NAME_UNIX;
        }
        return AFD_LIB_FILE_NAME_WINDOWS;
    }

    public static String getAFDConfFilePath() {
        String confFilePath = "";
        if (m_gCtx.isUpgrade()) {
            Version gridActiveVer = VerificationUtil.getCRSActiveVersionObj(true);
            if (gridActiveVer == null) {
                return confFilePath;
            }
            NativeSystem nativeSys = new SystemFactory().CreateSystem();
            if (nativeSys.isUnixSystem()) {
                if (Version.isPre122((Version)gridActiveVer)) {
                    if (!Version.isPre12102((Version)gridActiveVer) && VerificationUtil.isPlatformLinux()) {
                        confFilePath = AFD_CONF_FILE_PATH_12102;
                    }
                } else {
                    confFilePath = AFD_CONF_FILE_PATH_122;
                }
            } else {
                confFilePath = AFD_CONF_FILE_PATH_WINDOWS;
            }
        }
        return confFilePath;
    }
}

