/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.HashMap;
import oracle.cluster.verification.StorageType;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.storage.StorageCheckContext;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataHandler;
import oracle.ops.verification.framework.storage.StorageSignature;
import oracle.ops.verification.framework.storage.StorageWithSignature;
import oracle.ops.verification.framework.util.VerificationUtil;

class VxDGData
extends StorageData
implements StorageConstants,
StorageWithSignature {
    private String m_dgid = null;

    public VxDGData(String id) {
        super(id, StorageType.VXDG);
    }

    public VxDGData(String dgname, String dgid) {
        super(dgname, StorageType.VXDG);
        this.m_dgid = dgid;
        if (VerificationUtil.isStringGood(this.m_dgid)) {
            this.setStorageSignature(new StorageSignature(this.m_dgid));
        }
    }

    @Override
    public void checkSharedness(HashMap<String, StorageData> nodeSDmap, ResultSet rSet) {
        StorageDataHandler.checkSignatures(nodeSDmap, rSet);
    }

    @Override
    public void checkStorageAttributes(HashMap<String, StorageData> nodeSDmap, StorageCheckContext stChkContext, ResultSet rSet) {
        new StorageDataHandler(stChkContext).checkVGAttributes(nodeSDmap, rSet);
    }

    public String getDGID() {
        return this.m_dgid;
    }

    @Override
    public String toString() {
        return super.toString() + LSEP + "dgid=" + this.m_dgid;
    }
}

