/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.cmdtools.ASMCMDUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.KFODUtil;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.impl.verification.StoragePathInfoImpl;
import oracle.cluster.impl.verification.StoragePathResultSetImpl;
import oracle.cluster.install.InstallException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.StoragePathResultSet;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Entity;
import oracle.ops.verification.framework.engine.EntityStatus;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageCheckContext;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataHandler;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class StorageUtil
implements StorageConstants {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static boolean s_isOCFSsupported;
    private static int OCFS_TYPE;
    private static Hashtable<String, Hashtable<String, String>> m_nodeWiseAFDDiskListTable;
    private static String m_isAFDSupportedOpStr;
    private static final String ORCL_STAMP_TOKEN = "ORCL";
    private static final String ORCL_TOKEN = "ORCL:";
    private static final String AFD_STAMP_TOKEN = "AFD";
    private static final String AFD_TOKEN = "AFD:";
    private static final String ASM_DISK_NOT_LABELED_TOKEN = "#";
    private static ResultSet m_afdInstallRstSet;
    private static ResultSet m_afdLoadRstSet;

    public static boolean isAnyRaw(String[] locations) throws StorageException {
        for (String location : locations) {
            StorageInfo sInfo;
            if (VerificationUtil.isASMPath(location) || (sInfo = new TypeFinder().getStorageInstance(location)).getType() != 1) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidStorageType(String[] nodeList, StorageInfo stInfo, OracleFileType usageType, String release, boolean considerASMStorage) throws StorageException {
        String nodeListStr = VerificationUtil.strArr2List(nodeList);
        Trace.out((String)("nodeList=" + nodeListStr + "; path=" + stInfo.getPath() + "; type=" + stInfo.getTypeStr()));
        int[] supportedStorageTypes = sStorageUtil.getSupportedFileTypes(usageType, release, considerASMStorage);
        ArrayList<String> supportStorageTypesStr = new ArrayList<String>();
        for (int supportStorageType : supportedStorageTypes) {
            supportStorageTypesStr.add(sStorageUtil.getTypeStr(supportStorageType));
        }
        boolean supported = false;
        for (int supportedType : supportedStorageTypes) {
            if (stInfo.getType() != supportedType) continue;
            Trace.out((String)("The file type '" + stInfo.getTypeStr() + "' is found suitable for: " + usageType.name()));
            supported = true;
            break;
        }
        if (!supported) {
            Trace.out((String)("The file type for '" + stInfo.getPath() + "' is not found suitable for:" + usageType.name()));
            HashMap<String, String> h = StorageDataHandler.getSuitabilityMsg(usageType);
            throw new StorageException(h.values().iterator().next(), true, (Object[])new String[]{stInfo.getPath(), stInfo.getTypeStr(), release, VerificationUtil.strCollection2String(supportStorageTypesStr, ", ")}, h.keySet().iterator().next());
        }
        if (stInfo.getType() == 14) {
            try {
                String[] rimNodes;
                NodeManager nm = NodeManagerFactory.getInstance().getNodeManager();
                if (nm.isBigCluster() && (rimNodes = nm.getNodes(nodeList, NodeRoleCapability.RIM)) != null) {
                    Trace.out((String)"ACFS path %s is not suitable for rim nodes %s", (Object[])new Object[]{stInfo.getPath(), VerificationUtil.strArr2List(rimNodes)});
                    throw new StorageException("11500", true, (Object[])new String[]{stInfo.getPath(), VerificationUtil.strArr2List(rimNodes)}, "Prvg");
                }
            }
            catch (NodeManagerFactoryException e) {
                Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
            }
            catch (NoSuchNodesException e) {
                Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
            }
            catch (NodeManagerException e) {
                Trace.out((int)5, (String)"IGNORED: %s : %s", (Object[])new Object[]{e.getClass(), e.getMessage()});
            }
        }
        return true;
    }

    public static List<String> expandDevicePaths(String node, String[] deviceString) {
        ResultSet resultSet = new ResultSet();
        return StorageUtil.expandDevicePaths(node, deviceString, resultSet);
    }

    public static List<String> expandDevicePaths(String node, String[] deviceString, ResultSet resultSet) {
        ArrayList<String> deviceListAll = new ArrayList<String>();
        List<Object> discoveredDeviceList = new ArrayList();
        for (String device : deviceString) {
            List m_deviceList = new ArrayList();
            if (VerificationUtil.containsWildCard(device)) {
                String localNode = VerificationUtil.getLocalNode();
                device = device.trim();
                Trace.out((String)("Disovery string is : " + device));
                if (device.startsWith(ORCL_TOKEN) || device.startsWith(AFD_TOKEN)) {
                    ErrorDescription errDesc;
                    String errMsg;
                    Hashtable asmDiskLabels = new Hashtable();
                    KFODUtil kUtil = null;
                    String kfodLoc = null;
                    try {
                        if (VerificationUtil.isCRSConfigured()) {
                            kfodLoc = VerificationUtil.getKFODLocation(localNode, false);
                            Trace.out((String)("Kfod location obtained " + kfodLoc));
                            if (VerificationUtil.isStringGood(kfodLoc)) {
                                kUtil = new KFODUtil(kfodLoc, false);
                            }
                        } else {
                            kfodLoc = VerificationUtil.getKFODLocation(localNode, true);
                            Trace.out((String)("Kfod location obtained " + kfodLoc));
                            if (VerificationUtil.isStringGood(kfodLoc)) {
                                kUtil = new KFODUtil(kfodLoc, true);
                            }
                        }
                        asmDiskLabels = kUtil.getASMDiskLabelTable(localNode, device);
                        Trace.out((String)("Disocvery string : " + device + " discovered devices: " + asmDiskLabels.keySet()));
                        deviceListAll.addAll(new ArrayList(asmDiskLabels.keySet()));
                    }
                    catch (VerificationException ve) {
                        VerificationUtil.traceAndLog("failed to get kfod location. " + ve.getMessage());
                        errMsg = ve.getMessage();
                        resultSet.addResult(localNode, 2);
                        errDesc = new ErrorDescription(errMsg);
                        resultSet.addErrorDescription(errDesc);
                    }
                    catch (CmdToolUtilException ce) {
                        VerificationUtil.traceAndLog("failed to run kfod command. " + ce.getMessage());
                        errMsg = ce.getMessage();
                        resultSet.addResult(localNode, 2);
                        errDesc = new ErrorDescription(errMsg);
                        resultSet.addErrorDescription(errDesc);
                    }
                    continue;
                }
                GlobalExecution globalExec = new GlobalExecution();
                ResultSet rsltSet = new ResultSet();
                if (node == null) {
                    node = localNode;
                }
                String cmd = null;
                NativeSystem nativeSystem = new SystemFactory().CreateSystem();
                if (nativeSystem.isUnixSystem()) {
                    cmd = "'" + VerificationUtil.getFileListCommand() + " " + device + "'";
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("expandDevicePaths: Command is : " + cmd));
                    }
                    globalExec.runGenericCmd(new String[]{node}, cmd, rsltSet);
                    Result result = rsltSet.getResult(node);
                    if (result.getStatus() == 1 || result.getStatus() == 4) {
                        String outStr = (String)result.getResultInfoSet().firstElement();
                        Trace.out((String)("outStr=" + outStr));
                        String exitStat = VerificationUtil.fetchVerificationResult(outStr);
                        Trace.out((String)("exitStat=" + exitStat));
                        if (exitStat != null && exitStat.contentEquals("0")) {
                            String[] cmdOut = (String[])result.getResultInfoSet().get(1);
                            m_deviceList = VerificationUtil.parseFileListOutput(cmdOut);
                            if (Trace.isLevelEnabled((int)5)) {
                                for (int i = 0; i < cmdOut.length; ++i) {
                                    Trace.out((String)("expandDevicePaths: Command output is : " + cmdOut[i]));
                                }
                            }
                            deviceListAll.addAll(m_deviceList);
                            continue;
                        }
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("Failed to expand wildcarded device string " + device));
                        }
                        resultSet.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("12810", true, (Object[])new String[]{device})));
                        resultSet.addResult(node, 2);
                        continue;
                    }
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Wildcard expansion operation failed for device string " + device));
                    }
                    resultSet.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("12810", true, (Object[])new String[]{device})));
                    resultSet.addResult(node, 2);
                    continue;
                }
                String windeviceRootToken = "\\\\.\\";
                if (device.startsWith(windeviceRootToken)) {
                    Trace.out((String)("The discovery string name " + device + " contains windows device root token prefix "));
                    device = device.substring(windeviceRootToken.length());
                }
                Trace.out((String)("Discovery string is : " + device));
                globalExec.checkAsmStamp(new String[]{node}, device, true, rsltSet);
                Result result = (Result)rsltSet.getResultTable().get(node);
                String discoveredDevices = null;
                if (result.getStatus() == 1) {
                    discoveredDevices = (String)result.getResultInfoSet().elementAt(0);
                    Trace.out((String)("Discovered devices : " + discoveredDevices));
                    if (VerificationUtil.isStringGood(discoveredDevices)) {
                        discoveredDeviceList = Arrays.asList(VerificationUtil.string2strArr(discoveredDevices));
                    }
                    if (discoveredDeviceList.isEmpty()) continue;
                    deviceListAll.addAll(discoveredDeviceList);
                    continue;
                }
                Trace.out((String)("Wildcard expansion operation failed for device string " + device));
                resultSet.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("12810", true, (Object[])new String[]{device})));
                resultSet.addResult(node, 2);
                continue;
            }
            deviceListAll.add(device);
        }
        return deviceListAll;
    }

    public static Set<String> expandDevicePaths(String[] nodeList, String[] deviceString, ResultSet resultSet) {
        HashSet<String> expandedDevicePathSet = new HashSet<String>();
        for (String node : nodeList) {
            List<String> expandedDevicePathNode = StorageUtil.expandDevicePaths(node, deviceString, resultSet);
            if (expandedDevicePathNode == null) continue;
            expandedDevicePathSet.addAll(expandedDevicePathNode);
        }
        return expandedDevicePathSet;
    }

    public static Set<String> expandDevicePaths(String[] nodeList, String[] deviceString) {
        ResultSet resultSet = new ResultSet();
        return StorageUtil.expandDevicePaths(nodeList, deviceString, resultSet);
    }

    public static boolean isRawDiscoveryEnabled() {
        boolean enabled = true;
        String configVal = VerificationUtil.getConfiguredValue("CV_RAW_CHECK_ENABLED", false);
        if (null != configVal && configVal.equalsIgnoreCase("FALSE")) {
            enabled = false;
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("RawDiscovery enabled? " + enabled));
        }
        return enabled;
    }

    public static String getTypeStr(int type) {
        switch (type) {
            case 1: {
                return "Disk";
            }
            case 2: {
                return "NFS";
            }
            case 5: {
                return "File System";
            }
            case 3: {
                return "Vx Disk Group";
            }
            case 4: {
                return "Vx Volume";
            }
            case 11: {
                return "Native DG";
            }
            case 12: {
                return "Native LV";
            }
            case 10: {
                return "GPFS(mmfs)";
            }
            case 15: {
                return "SAM File System";
            }
            case 16: {
                return "Quick File System";
            }
            case 6: {
                return "Disk Partition";
            }
            case 7: {
                return "OCFS";
            }
            case 8: {
                return "OCFS2";
            }
            case 14: {
                return "ACFS";
            }
            case 17: {
                return "VXFS";
            }
            case 13: {
                return "ASM Disk Group";
            }
            case 19: {
                return "Temporary File System";
            }
            case 21: {
                return "NTFS";
            }
        }
        return "Unknown";
    }

    public static String getTypesListByStr(int[] typesIntArr) {
        ArrayList<String> typesStrList = new ArrayList<String>();
        for (int typeInt : typesIntArr) {
            typesStrList.add(StorageUtil.getTypeStr(typeInt));
        }
        return VerificationUtil.strCollection2String(typesStrList, ", ");
    }

    public static StorageType getTypeEnum(int type) {
        switch (type) {
            case 1: {
                return StorageType.DISK;
            }
            case 6: {
                return StorageType.DISK_PARTITION;
            }
            case 2: {
                return StorageType.NFS;
            }
            case 5: {
                return StorageType.FILESYSTEM;
            }
            case 3: {
                return StorageType.VXDG;
            }
            case 4: {
                return StorageType.VXVOLUME;
            }
            case 11: {
                return StorageType.LVMDG;
            }
            case 12: {
                return StorageType.LVMLV;
            }
            case 10: {
                return StorageType.GPFS;
            }
            case 7: {
                return StorageType.OCFS;
            }
            case 8: {
                return StorageType.OCFS2;
            }
            case 15: {
                return StorageType.SAMFS;
            }
            case 16: {
                return StorageType.QFS;
            }
            case 14: {
                return StorageType.ACFS;
            }
            case 13: {
                return StorageType.ASMDG;
            }
            case 17: {
                return StorageType.VXFS;
            }
            case 19: {
                return StorageType.TMPFS;
            }
            case 21: {
                return StorageType.NTFS;
            }
        }
        return StorageType.UNKNOWN;
    }

    public static int getTypeByStr(String str) throws StorageException {
        int type = -1;
        if (str.equals("FS")) {
            type = 5;
        } else if (str.equals("DISK")) {
            type = 1;
        } else if (str.equals("SCSI")) {
            type = 1;
        } else if (str.equals("VXVOLUME")) {
            type = 4;
        } else if (str.equals("NFS")) {
            type = 2;
        } else if (str.equals("NFS3")) {
            type = 2;
        } else if (str.equals("SAMFS")) {
            type = 15;
        } else if (str.equals("QFS")) {
            type = 16;
        } else if (str.equals("GPFS")) {
            type = 10;
        } else if (str.equals("IBMDG") || str.equals("HPXDG")) {
            type = 11;
        } else if (str.equals("IBMLV") || str.equals("HPXLV")) {
            type = 12;
        } else if (str.equals("OCFS")) {
            type = s_isOCFSsupported ? 7 : 8;
        } else if (str.equals("OCFS2")) {
            type = 8;
        } else if (str.equals("ACFS")) {
            type = 14;
        } else if (str.equals("ASM")) {
            type = 13;
        } else if (str.equals("VXFS")) {
            type = 17;
        } else if (str.equals("TMPFS")) {
            type = 19;
        } else if (str.equals("NTFS")) {
            type = 21;
        } else {
            Trace.out((String)("_st_:String " + str + " is not a recognized type."));
            throw new StorageException();
        }
        return type;
    }

    public static HashMap<String, String> filterASMDiskStamps(List<String> deviceList) {
        String orclStampToken = ORCL_STAMP_TOKEN;
        String afdStampToken = AFD_STAMP_TOKEN;
        String windeviceRootToken = "\\\\.\\";
        HashMap<String, String> stampMap = new HashMap<String, String>();
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            orclStampToken = orclStampToken + ":";
            afdStampToken = afdStampToken + ":";
        }
        if (deviceList != null && deviceList.size() > 0) {
            Iterator<String> iterator = deviceList.iterator();
            while (iterator.hasNext()) {
                String disk;
                String origDisk = disk = iterator.next();
                if (!VerificationUtil.isStringGood(disk)) {
                    Trace.out((String)"Disk name was found to be null or empty");
                    continue;
                }
                Trace.out((String)("Processing Disk " + disk));
                if (disk.startsWith(windeviceRootToken)) {
                    Trace.out((String)("The disk name " + disk + " contains device token prefix"));
                    disk = disk.substring(windeviceRootToken.length());
                }
                if (VerificationUtil.isASMPath(disk)) {
                    Trace.out((String)("The disk name " + disk + " is an ASM path and not an ASM stamp hence skipped"));
                    continue;
                }
                if (disk.startsWith(orclStampToken)) {
                    Trace.out((String)("Disk is ORCL type of disk, Adding " + disk + " to ASM stamp list"));
                    stampMap.put(origDisk, ORCL_STAMP_TOKEN);
                    continue;
                }
                if (disk.startsWith(afdStampToken)) {
                    Trace.out((String)("Disk is AFD type of disk, Adding " + disk + " to ASM stamp list"));
                    stampMap.put(origDisk, AFD_STAMP_TOKEN);
                    continue;
                }
                if (disk.length() <= 0 || disk.contains(VerificationConstants.FILE_SEPARATOR)) continue;
                Trace.out((String)("Disk is label name, Assuming ASM Label and Adding " + disk + " to ASM stamp list"));
                stampMap.put(origDisk, "");
            }
        }
        return stampMap;
    }

    public static ResultSet processASMDiskStamps(String[] nodeList, List<String> deviceList, List<String> devicesManagedByASM, List<String> resolvedDevicePathList) {
        String localNode = VerificationUtil.getLocalNode();
        ResultSet resultSet = new ResultSet();
        if (deviceList == null || deviceList.isEmpty()) {
            resultSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"deviceList"})));
            resultSet.setStatus(2);
            return resultSet;
        }
        if (nodeList == null || nodeList.length == 0) {
            nodeList = new String[]{localNode};
        }
        HashMap<String, String> asmStampsMap = StorageUtil.filterASMDiskStamps(deviceList);
        Hashtable<String, String> afdManagedDiskLabels = new Hashtable<String, String>();
        ArrayList<Object> afdManagedDevices = new ArrayList<Object>();
        boolean isUnix = new SystemFactory().CreateSystem().isUnixSystem();
        boolean isAFDAvailable = false;
        boolean isAFDSupported = StorageUtil.isAFDSupported();
        Version crsActiveVersion = null;
        ResultSet afdResultSet = new ResultSet();
        if (VerificationUtil.isUpgrade() || VerificationUtil.isCRSConfigured()) {
            Trace.out((String)"Post CRS or Upgrade scenario, Checking if AFD tool is installed and loaded");
            VerificationLogData.log("Post CRS or Upgrade scenario, Checking if AFD tool is installed and loaded");
            Result crsHomeRes = new Result(localNode);
            String crsHome = VerificationUtil.getCRSHome(localNode, crsHomeRes);
            if (VerificationUtil.isStringGood(crsHome)) {
                crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
                List<Object> nodesForAFDCheck = new ArrayList();
                try {
                    NodeManager nm = null;
                    String[] newNodesForNodeAdd = null;
                    GlobalVerificationContext gCtx = GlobalVerificationContext.getInstance();
                    if (gCtx.isNodeAdd()) {
                        NodeManagerFactory nmFactory = NodeManagerFactory.getInstance();
                        nm = nmFactory.getNodeManager();
                        newNodesForNodeAdd = nm.getNewNodes(nodeList, NodeRoleCapability.ALL);
                    }
                    if (newNodesForNodeAdd != null && newNodesForNodeAdd.length > 0) {
                        Trace.out((String)("Found nodes " + VerificationUtil.strArr2List(newNodesForNodeAdd) + " being newly added" + "Skipping these nodes from afd check nodelist as these nodes won't have crshome yet"));
                        VerificationLogData.log("Found nodes " + VerificationUtil.strArr2List(newNodesForNodeAdd) + " being newly added" + "Skipping these nodes from afd check nodelist as these nodes won't have crshome yet");
                        for (String node : nodeList) {
                            if (Arrays.asList(newNodesForNodeAdd).contains(node)) continue;
                            nodesForAFDCheck.add(node);
                        }
                    } else {
                        nodesForAFDCheck = Arrays.asList(nodeList);
                        Trace.out((String)"All nodes are expected to have CRS home and hence considering all nodes for AFD check.");
                        VerificationLogData.log("All nodes are expected to have CRS home and hence considering all nodes for AFD check.");
                    }
                }
                catch (NodeManagerException nmEx) {
                    Trace.out((String)("NodeManagerException occured. message: " + nmEx.getMessage()));
                    Trace.out((Exception)nmEx);
                    Trace.out((String)"Ignoring as this should not occur if upper layers have created the NodeManager");
                    nodesForAFDCheck = Arrays.asList(nodeList);
                }
                Trace.out((String)("The final nodelist to proceed with AFD check is " + nodesForAFDCheck));
                VerificationLogData.log("The final nodelist to proceed with AFD check is " + nodesForAFDCheck);
                if (crsActiveVersion != null && !Version.isPre12102((Version)crsActiveVersion) && isAFDSupported) {
                    isAFDAvailable = StorageUtil.isASMFilterDriverConfigured(nodesForAFDCheck.toArray(new String[0]), crsHome, crsActiveVersion, afdResultSet);
                    if (afdResultSet.getStatus() == 2) {
                        resultSet.uploadResultSet(afdResultSet);
                    }
                } else if (crsActiveVersion == null) {
                    Trace.out((String)"Failed to retrieve active CRS version, Assuming AFD tool not available.");
                    resultSet.addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("5300", true)));
                    resultSet.setStatus(2);
                } else {
                    Trace.out((String)"Source CRS home active version is pre 12.1.0.2. The AFDtoold is available starting 12.1.0.2 release.");
                }
                if (isAFDAvailable) {
                    Hashtable<String, Hashtable<String, String>> afdLabelList = StorageUtil.getAFDDiskList(new String[]{localNode}, crsHome, crsActiveVersion, resultSet);
                    if (null != afdLabelList && afdLabelList.containsKey(localNode)) {
                        afdManagedDiskLabels = afdLabelList.get(localNode);
                    }
                    if (!afdManagedDiskLabels.isEmpty()) {
                        afdManagedDevices.addAll(afdManagedDiskLabels.values());
                    }
                }
            } else {
                Trace.out((String)"Failed to get CRS home");
                VerificationLogData.log("Failed to get CRS home");
                resultSet.addResult(localNode, crsHomeRes);
            }
        } else if (isAFDSupported) {
            try {
                String kfodLoc = VerificationUtil.getKFODLocation(localNode, true);
                Trace.out((String)("Kfod location obtained " + kfodLoc));
                if (VerificationUtil.isStringGood(kfodLoc)) {
                    KFODUtil kUtil;
                    String discString = CVUVariables.getValue(CVUVariableConstants.ASM_DISK_DISCOVERY_STRING);
                    if (!VerificationUtil.isStringGood(discString)) {
                        discString = VerificationUtil.strList2List(deviceList);
                    }
                    if (!(afdManagedDiskLabels = (kUtil = new KFODUtil(kfodLoc, true)).getASMDiskLabelTable(localNode, discString)).isEmpty()) {
                        afdManagedDevices.addAll(afdManagedDiskLabels.keySet());
                    }
                }
            }
            catch (VerificationException ve) {
                VerificationUtil.traceAndLog("failed to get kfod location. " + ve.getMessage());
            }
            catch (CmdToolUtilException ctex) {
                VerificationUtil.traceAndLog("failed to run kfod command. " + ctex.getMessage());
            }
        }
        if (resultSet.anyFailure()) {
            Trace.out((String)"Failed to determine the availability of Asm Filter Driver");
            VerificationLogData.log("Failed to determine the availability of Asm Filter Driver");
            return resultSet;
        }
        resultSet.clear();
        resultSet.setStatus(1);
        Trace.out((String)("Processing devices : " + VerificationUtil.strList2List(deviceList)));
        for (String device : deviceList) {
            if (VerificationUtil.isASMPath(device)) {
                Trace.out((String)("The device (" + device + ") is managed by ASM"));
                devicesManagedByASM.add(device);
                continue;
            }
            if (asmStampsMap.containsKey(device)) {
                Result result = new Result(localNode, 1);
                if (AFD_STAMP_TOKEN.equals(asmStampsMap.get(device))) {
                    String errMsg;
                    if (!afdManagedDiskLabels.isEmpty()) {
                        String devPathTocheck;
                        String string = devPathTocheck = device.contains(":") ? device.substring(device.indexOf(":") + 1) : device;
                        if (afdManagedDiskLabels.containsKey(devPathTocheck)) {
                            Trace.out((String)("The asm stamp (" + device + ") is managed by AFD"));
                            devicesManagedByASM.add(device);
                            result.setStatusConditionally(1);
                        } else {
                            result.setStatus(2);
                            errMsg = s_gMsgBundle.getMessage("10491", true, (Object[])new String[]{device});
                            result.addErrorDescription(new ErrorDescription(errMsg));
                        }
                    } else {
                        String errMsg2;
                        result.setStatus(2);
                        if (!isAFDSupported) {
                            Version versionObj = crsActiveVersion != null ? crsActiveVersion : new Version();
                            Trace.out((String)"AFD is not supported on the platform");
                            errMsg = s_gMsgBundle.getMessage("6078", true, (Object[])new String[]{versionObj.toString4()});
                            result.addErrorDescription(new ErrorDescription(errMsg));
                        } else if (isAFDAvailable) {
                            Trace.out((String)"AFD was found to be configured but the label was not listed by afdtool command");
                            errMsg2 = s_gMsgBundle.getMessage("10491", true, (Object[])new String[]{device});
                            result.addErrorDescription(new ErrorDescription(errMsg2));
                        } else {
                            Trace.out((String)"AFD type label is passed but AFD is not configured.Add afddriverstate supported|loaded|installed error messages");
                            errMsg2 = s_gMsgBundle.getMessage("10490", true, (Object[])new String[]{device});
                            errMsg2 = errMsg2 + VerificationConstants.LSEP + afdResultSet.getAllErrorsStr();
                            result.addErrorDescription(new ErrorDescription(errMsg2));
                        }
                    }
                } else if (!isUnix) {
                    Result resolveStampResult = sStorageUtil.processASMStamp(device);
                    if (resolveStampResult.getStatus() == 1) {
                        try {
                            String resolvedDevicePath = resolveStampResult.getActualValue();
                            if (VerificationUtil.isStringGood(resolvedDevicePath)) {
                                Trace.out((String)("The ASM stamp (" + device + ") is resolved to device path (" + resolvedDevicePath + ") hence adding the actual device path to the list"));
                                resolvedDevicePathList.add(resolvedDevicePath);
                                result.setStatusConditionally(resolveStampResult.getStatus());
                            }
                        }
                        catch (ResultValuesUnavailableException e) {
                            Trace.out((String)"Caught ResultValuesUnavailableException : Ignoring");
                        }
                    } else {
                        result.addErrorDescription(resolveStampResult.getErrors());
                        result.setStatusConditionally(resolveStampResult.getStatus());
                        Trace.out((String)("Failed to resolve ASM stamp (" + device + ") to the real device path"));
                    }
                } else if (VerificationUtil.isPlatformLinux()) {
                    Result checkStampResult = sStorageUtil.processASMStamp(device);
                    if (checkStampResult.getStatus() == 1) {
                        Trace.out((String)("The asm stamp (" + device + ") is managed by ASM"));
                        devicesManagedByASM.add(device);
                        result.setStatusConditionally(checkStampResult.getStatus());
                    } else {
                        result.addErrorDescription(checkStampResult.getErrors());
                        result.setStatusConditionally(checkStampResult.getStatus());
                        if (checkStampResult.getStatus() == 2) {
                            Trace.out((String)("Failed to validate if ASM stamped disk (" + device + ") is managed by ASM"));
                        } else {
                            Trace.out((String)("ASM stamped disk (" + device + ") is NOT managed by ASM"));
                        }
                    }
                } else {
                    result.setStatusConditionally(1);
                    resolvedDevicePathList.add(device);
                }
                if (resultSet.getResult(localNode) != null) {
                    resultSet.getResult(localNode).addErrorDescription(result.getErrors());
                    resultSet.getResult(localNode).setStatusConditionally(result.getStatus());
                    continue;
                }
                resultSet.addResult(localNode, result);
                continue;
            }
            if (!afdManagedDevices.isEmpty() && afdManagedDevices.contains(device)) {
                Trace.out((String)("The device (" + device + ") is managed by AFD"));
                resultSet.addResult(localNode, 1);
                devicesManagedByASM.add(device);
                continue;
            }
            resolvedDevicePathList.add(device);
        }
        return resultSet;
    }

    public static boolean isAFDSupported() {
        if (VerificationUtil.isStringGood(m_isAFDSupportedOpStr)) {
            return Boolean.valueOf(m_isAFDSupportedOpStr);
        }
        String[] nodes = new String[]{VerificationUtil.getLocalNode()};
        String homeLoc = VerificationUtil.getCVHome();
        String commandLoc = VerificationUtil.getAFDDriverCommandPath(homeLoc);
        String[] cmdArgs = new String[]{"-orahome", homeLoc, "supported"};
        ResultSet afdResultSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.checkFileExistence(nodes, commandLoc, afdResultSet);
        if (!afdResultSet.anyFailure()) {
            String[] envs = null;
            GlobalVerificationContext gCtx = GlobalVerificationContext.getInstance();
            if (gCtx.isPreCRS()) {
                String tempObase = VerificationUtil.getCVUSubDirPath() + "scratch" + File.separator + "tempob";
                File tempArea = new File(tempObase);
                if (!tempArea.exists()) {
                    if (!tempArea.mkdirs()) {
                        VerificationUtil.traceAndLog("Failed to create temporary oracle base :" + tempObase + " for afddriverstate execution in a pre-CRS scenario");
                        return false;
                    }
                } else if (!tempArea.isDirectory()) {
                    tempArea.delete();
                    if (!tempArea.mkdir()) {
                        VerificationUtil.traceAndLog("Failed to create temporary oracle base :" + tempObase + " for afddriverstate execution in a pre-CRS scenario");
                        return false;
                    }
                }
                envs = new String[]{"ORACLE_BASE=" + tempObase};
            }
            VerificationUtil.traceAndLog(commandLoc + " present. Running " + commandLoc + VerificationUtil.strArr2List(cmdArgs, " ") + " to check whether AFD is supported or not. ");
            ResultSet afdSupportCmdResSet = new ResultSet();
            globalExec.runGenericCmd(nodes, commandLoc, cmdArgs, envs, afdSupportCmdResSet);
            afdSupportCmdResSet = StorageUtil.analyzeAFDCommandOutput(afdSupportCmdResSet, commandLoc, new String[]{"AFD-9200", "Supported"}, new String[]{"AFD-9201", "Not Supported"});
            if (!afdSupportCmdResSet.anyFailure()) {
                VerificationUtil.traceAndLog("AFD is supported.");
                m_isAFDSupportedOpStr = "true";
                return true;
            }
        }
        m_isAFDSupportedOpStr = "false";
        return false;
    }

    public static boolean isASMFilterDriverInstalled(String[] nodeList, String homeLoc, Version crsActiveVersion, boolean checkConsistency, ResultSet afdInstallRsltSet, Vector<String> afdNotInstallNodes, Vector<String> operationFailedNode) {
        if (null == afdInstallRsltSet) {
            afdInstallRsltSet = new ResultSet();
        }
        if (null == nodeList || nodeList.length == 0 || crsActiveVersion == null || !VerificationUtil.isStringGood(homeLoc)) {
            return false;
        }
        if (!StorageUtil.isAFDSupported() || Version.isPre12102((Version)crsActiveVersion)) {
            afdInstallRsltSet.setStatus(2);
            String errMsg = s_gMsgBundle.getMessage("6078", true, (Object[])new String[]{crsActiveVersion.toString4()});
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            afdInstallRsltSet.addErrorDescription(errorDesc);
            return false;
        }
        ArrayList<String> nodesToCheck = new ArrayList<String>();
        for (String node : nodeList) {
            try {
                afdInstallRsltSet.addResult(node, (Result)m_afdInstallRstSet.getNodeResult(node));
            }
            catch (NodeResultsUnavailableException ex) {
                Trace.out((String)("Node results for node " + node + " is not cached yet"));
                nodesToCheck.add(node);
            }
        }
        String commandLoc = VerificationUtil.getAFDDriverCommandPath(homeLoc);
        String command = commandLoc + " -orahome " + homeLoc + " installed";
        if (!nodesToCheck.isEmpty()) {
            String[] afdInstalledNodes;
            String[] nodeArr = nodesToCheck.toArray(new String[0]);
            ResultSet afdResultSet = new ResultSet();
            GlobalExecution globalExec = new GlobalExecution();
            globalExec.checkFileExistence(nodeArr, commandLoc, afdResultSet);
            if (afdResultSet.anySuccess() && (afdInstalledNodes = afdResultSet.getSuccNodes()) != null && afdInstalledNodes.length > 0) {
                ResultSet afdInstallCmdResSet = new ResultSet();
                globalExec.runGenericCmd(afdInstalledNodes, command, afdInstallCmdResSet);
                afdInstallCmdResSet = StorageUtil.analyzeAFDCommandOutput(afdInstallCmdResSet, command, new String[]{"AFD-9203", "true"}, new String[]{"AFD-9204", "false"});
                afdResultSet.uploadResultSet(afdInstallCmdResSet);
            }
            afdInstallRsltSet.uploadResultSet(afdResultSet);
            m_afdInstallRstSet.uploadResultSet(afdResultSet);
        }
        Hashtable htInst = afdInstallRsltSet.getResultTable();
        Enumeration e = htInst.keys();
        while (e.hasMoreElements()) {
            String errMsg;
            String[] node = (String[])e.nextElement();
            Result result = (Result)htInst.get(node);
            if (result.getStatus() == 1 || result.getStatus() == 4) {
                Trace.out((String)("AFD found installed on node (" + (String)node + ")"));
                VerificationLogData.logFine("AFD found installed on node (" + (String)node + ")");
                continue;
            }
            if (result.getStatus() == 3) {
                Trace.out((String)("AFD not found installed on node (" + (String)node + ")"));
                VerificationLogData.logFine("AFD not found installed on node (" + (String)node + ")");
                afdNotInstallNodes.add((String)node);
                errMsg = s_gMsgBundle.getMessage("6074", true, (Object[])new String[]{node});
                afdInstallRsltSet.addErrorDescription((String)node, new ErrorDescription(errMsg));
                continue;
            }
            operationFailedNode.add((String)node);
            Trace.out((String)("Failed to determine the status of AFD installation on node (" + (String)node + ")"));
            VerificationLogData.logFine("Failed to determine the status of AFD installation on node (" + (String)node + ")");
            errMsg = result.getErrMessage();
            errMsg = VerificationUtil.isStringGood(errMsg) ? s_gMsgBundle.getMessage("6070", true, (Object[])new String[]{command, node}) + VerificationConstants.LSEP + errMsg : s_gMsgBundle.getMessage("6070", true, (Object[])new String[]{command, node});
            afdInstallRsltSet.addResult((String)node, 2);
            afdInstallRsltSet.addErrorDescription((String)node, new ErrorDescription(errMsg));
            afdInstallRsltSet.addErrorDescription((String)node, new ErrorDescription(s_gMsgBundle.getMessage("6063", true, (Object[])new String[]{node})));
        }
        if (afdNotInstallNodes.size() == nodeList.length) {
            if (checkConsistency) {
                Trace.out((String)("AFD is not installed on any of the nodes : " + VerificationUtil.strArr2List(nodeList)));
                VerificationLogData.logFine("AFD is not installed on any of the nodes :" + VerificationUtil.strArr2List(nodeList));
                afdInstallRsltSet.clear();
                for (String node : nodeList) {
                    Result nodeResult = new Result(node);
                    nodeResult.setStatus(1);
                    afdInstallRsltSet.addResult(node, nodeResult);
                }
            }
        } else {
            String msg = "AFD installation status on nodes (" + VerificationUtil.strArr2List(nodeList) + ")" + "\n not Installed on nodes (" + VerificationUtil.strCollection2String(afdNotInstallNodes) + ")" + "\n operation failed nodes i.e. could not determine (" + VerificationUtil.strCollection2String(operationFailedNode) + ")";
            Trace.out((String)msg);
            VerificationLogData.logInfo(msg);
            if (afdNotInstallNodes.size() > 0) {
                afdInstallRsltSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("6074", true, (Object[])new String[]{VerificationUtil.strCollection2String(afdNotInstallNodes)})));
            }
            if (operationFailedNode.size() > 0) {
                afdInstallRsltSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("6063", true, (Object[])new String[]{VerificationUtil.strCollection2String(operationFailedNode)})));
            }
        }
        afdInstallRsltSet.setStatus();
        return afdInstallRsltSet.allSuccess();
    }

    public static boolean isASMFilterDriverInstallConsistent(String[] nodeList, String homeLoc, Version crsActiveVersion, ResultSet afdInstallRsltSet, Vector<String> afdNotInstallNodes, Vector<String> operationFailedNode) {
        return StorageUtil.isASMFilterDriverInstalled(nodeList, homeLoc, crsActiveVersion, true, afdInstallRsltSet, afdNotInstallNodes, operationFailedNode);
    }

    public static boolean isASMFilterDriverLoaded(String[] nodeList, String homeLoc, Version crsActiveVersion, boolean checkConsistency, ResultSet afdLoadedRsltSet, Vector<String> afdLibNotLoadedNodes, Vector<String> operationFailedNode) {
        if (null == afdLoadedRsltSet) {
            afdLoadedRsltSet = new ResultSet();
        }
        if (null == nodeList || nodeList.length == 0 || crsActiveVersion == null || !VerificationUtil.isStringGood(homeLoc)) {
            return false;
        }
        if (!StorageUtil.isAFDSupported() || Version.isPre12102((Version)crsActiveVersion)) {
            afdLoadedRsltSet.setStatus(2);
            String errMsg = s_gMsgBundle.getMessage("6078", true, (Object[])new String[]{crsActiveVersion.toString4()});
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            afdLoadedRsltSet.addErrorDescription(errorDesc);
            return false;
        }
        ArrayList<String> nodesToCheck = new ArrayList<String>();
        for (String node : nodeList) {
            try {
                afdLoadedRsltSet.addResult(node, (Result)m_afdLoadRstSet.getNodeResult(node));
            }
            catch (NodeResultsUnavailableException ex) {
                Trace.out((String)("Node results for node " + node + " is not cached yet"));
                nodesToCheck.add(node);
            }
        }
        String commandLoc = VerificationUtil.getAFDDriverCommandPath(homeLoc);
        String command = commandLoc + " -orahome " + homeLoc + " loaded";
        if (!nodesToCheck.isEmpty()) {
            String[] afdInstalledNodes;
            ResultSet afdResultSet = new ResultSet();
            GlobalExecution globalExec = new GlobalExecution();
            globalExec.checkFileExistence(nodeList, commandLoc, afdResultSet);
            if (afdResultSet.anySuccess() && (afdInstalledNodes = afdResultSet.getSuccNodes()) != null && afdInstalledNodes.length > 0) {
                ResultSet afdLoadedCmdResSet = new ResultSet();
                globalExec.runGenericCmd(afdInstalledNodes, command, afdLoadedCmdResSet);
                afdLoadedCmdResSet = Version.isPre122((Version)crsActiveVersion) ? StorageUtil.analyzeAFDCommandOutput(afdLoadedCmdResSet, command, new String[]{"AFD-9203", "true"}, new String[]{"AFD-9204", "false"}) : StorageUtil.analyzeAFDCommandOutput(afdLoadedCmdResSet, command, new String[]{"AFD-9205", "true"}, new String[]{"AFD-9206", "false"});
                afdResultSet.uploadResultSet(afdLoadedCmdResSet);
            }
            afdLoadedRsltSet.uploadResultSet(afdResultSet);
            m_afdLoadRstSet.uploadResultSet(afdResultSet);
        }
        Hashtable htInst = afdLoadedRsltSet.getResultTable();
        Enumeration e = htInst.keys();
        while (e.hasMoreElements()) {
            String errMsg;
            String[] node = (String[])e.nextElement();
            Result result = (Result)htInst.get(node);
            if (result.getStatus() == 1 || result.getStatus() == 4) {
                Trace.out((String)("AFD found loaded on node (" + (String)node + ")"));
                VerificationLogData.logFine("AFD found loaded on node (" + (String)node + ")");
                continue;
            }
            if (result.getStatus() == 3) {
                Trace.out((String)("AFD not found loaded on node (" + (String)node + ")"));
                VerificationLogData.logFine("AFD not found loaded on node (" + (String)node + ")");
                afdLibNotLoadedNodes.add((String)node);
                errMsg = s_gMsgBundle.getMessage("6062", true, (Object[])new String[]{node});
                afdLoadedRsltSet.addErrorDescription((String)node, new ErrorDescription(errMsg));
                continue;
            }
            operationFailedNode.add((String)node);
            Trace.out((String)("Failed to determine the status of AFD configuration on node (" + (String)node + ")"));
            VerificationLogData.logFine("Failed to determine the status of AFD configuration on node (" + (String)node + ")");
            errMsg = result.getErrMessage();
            errMsg = VerificationUtil.isStringGood(errMsg) ? s_gMsgBundle.getMessage("6070", true, (Object[])new String[]{command, node}) + VerificationConstants.LSEP + errMsg : s_gMsgBundle.getMessage("6070", true, (Object[])new String[]{command, node});
            afdLoadedRsltSet.addResult((String)node, 2);
            afdLoadedRsltSet.addErrorDescription((String)node, new ErrorDescription(errMsg));
            afdLoadedRsltSet.addErrorDescription((String)node, new ErrorDescription(s_gMsgBundle.getMessage("6075", true, (Object[])new String[]{node})));
        }
        if (afdLibNotLoadedNodes.size() == nodeList.length) {
            if (checkConsistency) {
                Trace.out((String)("AFD is not loaded on any of the nodes : " + VerificationUtil.strArr2List(nodeList)));
                VerificationLogData.logFine("AFD is not loaded on any of the nodes : " + VerificationUtil.strArr2List(nodeList));
                afdLoadedRsltSet.clear();
                for (String node : nodeList) {
                    Result nodeResult = new Result(node);
                    nodeResult.setStatus(1);
                    afdLoadedRsltSet.addResult(node, nodeResult);
                }
            }
        } else {
            String msg = "AFD loaded status on nodes (" + VerificationUtil.strArr2List(nodeList) + ")" + "\n not loaded on nodes (" + VerificationUtil.strCollection2String(afdLibNotLoadedNodes) + ")" + "\n operation failed nodes i.e. could not determine (" + VerificationUtil.strCollection2String(operationFailedNode) + ")";
            Trace.out((String)msg);
            VerificationLogData.logInfo(msg);
            if (afdLibNotLoadedNodes.size() > 0) {
                afdLoadedRsltSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("6062", true, (Object[])new String[]{VerificationUtil.strCollection2String(afdLibNotLoadedNodes)})));
            }
            if (operationFailedNode.size() > 0) {
                afdLoadedRsltSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("6075", true, (Object[])new String[]{VerificationUtil.strCollection2String(afdLibNotLoadedNodes)})));
            }
        }
        afdLoadedRsltSet.setStatus();
        return afdLoadedRsltSet.allSuccess();
    }

    public static boolean isASMFilterDriverLoadedConsistently(String[] nodeList, String homeLoc, Version crsActiveVersion, ResultSet afdLoadedRsltSet, Vector<String> afdLibNotLoadedNodes, Vector<String> operationFailedNode) {
        return StorageUtil.isASMFilterDriverLoaded(nodeList, homeLoc, crsActiveVersion, true, afdLoadedRsltSet, afdLibNotLoadedNodes, operationFailedNode);
    }

    public static boolean isASMFilterDriverConfigured(String[] nodeList, String homeLoc, Version crsActiveVersion, ResultSet afdChkRsltSet) {
        if (null == nodeList || nodeList.length == 0 || crsActiveVersion == null || !VerificationUtil.isStringGood(homeLoc)) {
            return false;
        }
        if (!StorageUtil.isAFDSupported() || Version.isPre12102((Version)crsActiveVersion)) {
            afdChkRsltSet.setStatus(2);
            String errMsg = s_gMsgBundle.getMessage("6078", true, (Object[])new String[]{crsActiveVersion.toString4()});
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            afdChkRsltSet.addErrorDescription(errorDesc);
            return false;
        }
        Vector<String> afdNotAvailableNodes = new Vector<String>();
        Vector<String> operationFailedNodes = new Vector<String>();
        Trace.out((String)"checking if AFD installation is consistent");
        boolean isInstallConsistent = StorageUtil.isASMFilterDriverInstalled(nodeList, homeLoc, crsActiveVersion, false, afdChkRsltSet, afdNotAvailableNodes, operationFailedNodes);
        if (!isInstallConsistent) {
            Trace.out((String)"AFD install not consistent");
            return isInstallConsistent;
        }
        if (afdNotAvailableNodes.size() == nodeList.length) {
            Trace.out((String)"AFD not installed on any of the nodes");
            return false;
        }
        Trace.out((String)"checking if configuration is consistent");
        afdChkRsltSet.clear();
        afdNotAvailableNodes.clear();
        boolean isConfigConsistent = StorageUtil.isASMFilterDriverLoaded(nodeList, homeLoc, crsActiveVersion, false, afdChkRsltSet, afdNotAvailableNodes, operationFailedNodes);
        if (isConfigConsistent && afdNotAvailableNodes.size() > 0) {
            Trace.out((String)("AFD is not configured on nodes " + afdNotAvailableNodes));
            VerificationLogData.log("AFD is not configured on nodes " + afdNotAvailableNodes);
            return false;
        }
        return isConfigConsistent;
    }

    private static ResultSet analyzeAFDCommandOutput(ResultSet inResultSet, String command, String[] expectedSuccessOutputTokens, String[] expectedFailureOutputTokens) {
        ResultSet outResultSet = new ResultSet();
        Hashtable htInst = inResultSet.getResultTable();
        Enumeration e = htInst.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)htInst.get(node);
            if (result.getStatus() == 1 || result.getStatus() == 4) {
                String outStr = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("outStr=" + outStr));
                String exitStat = VerificationUtil.fetchVerificationResult(outStr);
                Trace.out((String)("exitStat=" + exitStat));
                if (exitStat != null) {
                    String[] cmdOut = (String[])result.getResultInfoSet().get(1);
                    String output = VerificationUtil.strArr2List(cmdOut, " ");
                    if (VerificationUtil.isStringGood(output)) {
                        output = output.trim();
                        Trace.out((String)("Command (" + command + ") output on node " + node + " is as following:"));
                        for (int i = 0; i < cmdOut.length; ++i) {
                            Trace.out((String)cmdOut[i]);
                        }
                        if (exitStat.contentEquals("0")) {
                            Trace.out((String)"Command executed successfully and returned zero");
                            for (String token : expectedSuccessOutputTokens) {
                                if (!output.contains(token)) {
                                    Trace.out((String)("The output (" + output + ") does not contain expected token (" + token + ")"));
                                    result.setStatus(3);
                                    break;
                                }
                                result.setStatus(1);
                            }
                        } else {
                            Trace.out((String)"Command executed successfully but returned non-zero");
                            boolean isFailureNotError = true;
                            for (String token : expectedFailureOutputTokens) {
                                if (output.contains(token)) continue;
                                Trace.out((String)("The failure output (" + output + ") does not contain expected token (" + token + ") to declare a verification failure"));
                                result.addErrorDescription(new ErrorDescription(output));
                                isFailureNotError = false;
                                break;
                            }
                            if (isFailureNotError) {
                                result.setStatus(3);
                            } else {
                                result.setStatus(2);
                            }
                        }
                    } else {
                        Trace.out((String)("Command (" + command + ") did not produce output on node " + node));
                        result.setStatus(3);
                    }
                } else {
                    Trace.out((String)("Command (" + command + ") failed on node " + node + " with exitstatus " + exitStat));
                    result.setStatus(2);
                }
            }
            outResultSet.addResult(node, result);
        }
        return outResultSet;
    }

    public static Hashtable<String, Hashtable<String, String>> getAFDDiskList(String[] nodeList, String homeLoc, Version activeCRSVer, ResultSet listDiskResultSet) {
        if (activeCRSVer == null || !VerificationUtil.isStringGood(homeLoc)) {
            if (null == activeCRSVer) {
                listDiskResultSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"actvieCRSVer"})));
            }
            if (!VerificationUtil.isStringGood(homeLoc)) {
                listDiskResultSet.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"grid-location-01"})));
            }
            listDiskResultSet.setStatus(2);
            return new Hashtable<String, Hashtable<String, String>>();
        }
        if (!StorageUtil.isAFDSupported() || Version.isPre12102((Version)activeCRSVer)) {
            listDiskResultSet.setStatus(2);
            String errMsg = s_gMsgBundle.getMessage("6078", true, (Object[])new String[]{activeCRSVer.toString4()});
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            listDiskResultSet.addErrorDescription(errorDesc);
            return m_nodeWiseAFDDiskListTable;
        }
        List<Object> nodesTogetFDLabelListFrom = new ArrayList();
        if (m_nodeWiseAFDDiskListTable != null && !m_nodeWiseAFDDiskListTable.isEmpty()) {
            for (String node : nodeList) {
                if (!m_nodeWiseAFDDiskListTable.containsKey(node)) {
                    nodesTogetFDLabelListFrom.add(node);
                    continue;
                }
                listDiskResultSet.addResult(node, 1);
            }
        } else {
            m_nodeWiseAFDDiskListTable = new Hashtable();
            nodesTogetFDLabelListFrom = Arrays.asList(nodeList);
        }
        if (!nodesTogetFDLabelListFrom.isEmpty()) {
            String[] afdToolAvlblNodes;
            String commandLoc = VerificationUtil.getAFDToolCommandPath(homeLoc);
            String afdListCmd = commandLoc + " -getdevlist \\\"*\\\" -nohdr";
            String afdListCmdRemoteNode = commandLoc + " -getdevlist \\\\\\\"\\\\*\\\\\\\" -nohdr";
            ResultSet afdToolResultSet = new ResultSet();
            GlobalExecution globalExec = new GlobalExecution();
            globalExec.checkFileExistence(nodesTogetFDLabelListFrom.toArray(new String[0]), commandLoc, afdToolResultSet);
            listDiskResultSet.uploadResultSet(afdToolResultSet);
            if (afdToolResultSet.anySuccess() && (afdToolAvlblNodes = afdToolResultSet.getSuccNodes()) != null && afdToolAvlblNodes.length > 0) {
                afdToolResultSet.clear();
                VerificationCommand[] afdtoolCmdArr = new VerificationCommand[nodesTogetFDLabelListFrom.size()];
                int cmdCount = 0;
                String[] env = null;
                for (String node : afdToolAvlblNodes) {
                    String[] args = new String[]{"-rungencmd", VerificationUtil.isLocalNode(node) ? afdListCmd : afdListCmdRemoteNode, "-cv_oh", homeLoc};
                    afdtoolCmdArr[cmdCount] = new VerificationCommand(node, args, env);
                    ++cmdCount;
                }
                Trace.out((String)"executing afdtool to list disks on all the applicable nodes");
                new GlobalHandler().submit((Command[])afdtoolCmdArr, 0, afdToolResultSet);
                if (!afdToolResultSet.anySuccess()) {
                    Trace.out((String)("Global failure executing afdtool command " + afdListCmd));
                    VerificationLogData.logError("Global failure executing afdtool command " + afdListCmd);
                    String errMsg = s_gMsgBundle.getMessage("6067", false, (Object[])new String[]{afdListCmd});
                    ErrorDescription errorDesc = new ErrorDescription(errMsg);
                    listDiskResultSet.addErrorDescription(afdToolAvlblNodes, errorDesc);
                    ReportUtil.sureprintln(errMsg);
                } else {
                    for (VerificationCommand cmd : afdtoolCmdArr) {
                        String node = cmd.getNode();
                        String exectaskOutput = cmd.getExectaskOutput();
                        boolean executionSucc = VerificationUtil.fetchExecResult(exectaskOutput);
                        boolean commandSucc = VerificationUtil.fetchVerificationStatus(exectaskOutput);
                        Trace.out((String)("The exectask output on node (" + node + ") is:\n" + exectaskOutput));
                        if (executionSucc && commandSucc) {
                            String[] afdDiskListEntryArr;
                            String output = cmd.getOutput();
                            if (!VerificationUtil.isStringGood(output)) {
                                Trace.out((String)("There were no labels listed by afdtool on node " + node));
                                continue;
                            }
                            Trace.out((String)("The command (" + afdListCmd + ") output on node (" + node + ") is \n" + output));
                            VerificationLogData.log("The command (" + afdListCmd + ") output on node (" + node + ") is \n" + output);
                            for (String line : afdDiskListEntryArr = VerificationUtil.string2strArr(output, VerificationConstants.LINE_SEPARATOR)) {
                                Trace.out((String)("Processing Output Line : " + line));
                                String[] labelPathArray = line.split("\\s+");
                                if (labelPathArray != null && labelPathArray.length == 2) {
                                    String label = labelPathArray[0];
                                    Trace.out((String)("The extracted label is (" + label + ")"));
                                    String path = "";
                                    if (labelPathArray.length > 1) {
                                        path = labelPathArray[1];
                                    }
                                    Trace.out((String)("The extracted path is (" + path + ")"));
                                    if (m_nodeWiseAFDDiskListTable.containsKey(node)) {
                                        if (m_nodeWiseAFDDiskListTable.get(node).containsKey(label)) continue;
                                        m_nodeWiseAFDDiskListTable.get(node).put(label, path);
                                        continue;
                                    }
                                    Hashtable<String, String> labelPathPair = new Hashtable<String, String>();
                                    labelPathPair.put(label, path);
                                    m_nodeWiseAFDDiskListTable.put(node, labelPathPair);
                                    continue;
                                }
                                Trace.out((String)("Skipping the output line (" + line + ") as it contains invalid format. i.e. more than 2 columns"));
                            }
                            listDiskResultSet.addResult(node, 1);
                            continue;
                        }
                        Trace.out((String)("afdtool command failed to execute on node " + node));
                        String errMsg = s_gMsgBundle.getMessage("6070", true, (Object[])new String[]{afdListCmd, node}) + VerificationConstants.LINE_SEPARATOR + cmd.getOutput();
                        ReportUtil.sureprintln(errMsg);
                        ErrorDescription errDesc = new ErrorDescription(errMsg);
                        listDiskResultSet.addResult(node, executionSucc ? 3 : 2);
                        listDiskResultSet.addErrorDescription(node, errDesc);
                    }
                }
            }
        }
        return m_nodeWiseAFDDiskListTable;
    }

    public static StoragePathResultSet checkStorageADVMCompatibility(List<String> acfsPathList) throws StorageException {
        Trace.out((String)"ENTRY");
        StoragePathResultSetImpl storagePathResultSetImpl = new StoragePathResultSetImpl();
        ClusterwareInfo cwinfo = new ClusterwareInfo();
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        HashMap<String, Version> diskGrpVerMap = new HashMap<String, Version>();
        ASMCMDUtil asmcmd = null;
        String crshome = VerificationUtil.getCRSHome();
        if (!VerificationUtil.isStringGood(crshome)) {
            String msg = s_gMsgBundle.getMessage("5301", true);
            throw new StorageException(msg);
        }
        try {
            asmcmd = new ASMCMDUtil(crshome);
        }
        catch (CmdToolUtilException e) {
            Trace.out((String)("CmdToolUtilException - " + e.getMessage()));
            String msg = s_gMsgBundle.getMessage("1302", true) + VerificationConstants.LSEP + e.getMessage();
            throw new StorageException(msg);
        }
        for (String acfsPath : acfsPathList) {
            String msg;
            Result res = new Result(VerificationUtil.getLocalNode());
            try {
                if (cwinfo.isPathOnACFS(crshome, acfsPath, VerificationUtil.getLocalNode())) {
                    Trace.out((String)("The Path : " + acfsPath + " is on acfs "));
                    String volumeDevice = cwinfo.getVolumeDevice(acfsPath);
                    String dgGroupName = asmcmd.getDiskGroupName(volumeDevice);
                    Version ver = null;
                    ver = (Version)diskGrpVerMap.get(dgGroupName);
                    if (null == ver) {
                        ver = asmcmd.getADVMCompatibility(dgGroupName);
                        diskGrpVerMap.put(dgGroupName, ver);
                    }
                    String verToCheck = null;
                    verToCheck = !nativeSys.isUnixSystem() ? Version.get12102Version().toString() : Version.get12100Version().toString();
                    Trace.out((String)("volumeDevice : " + volumeDevice + " dgGroupName : " + dgGroupName + " Version  : " + ver + " Version to check   : " + verToCheck));
                    if (VerificationUtil.isVersionPost(ver.toString(), verToCheck)) {
                        res.setStatus(1);
                    } else {
                        String msg2 = s_gMsgBundle.getMessage("1301", true, (Object[])new String[]{ver.toString(), Version.get12102Version().toString(), dgGroupName, acfsPath});
                        res.addErrorDescription(new ErrorDescription(msg2));
                        res.setStatus(3);
                    }
                } else {
                    Trace.out((String)("The path is not on ACFS : " + acfsPath));
                    String msg3 = s_gMsgBundle.getMessage("1299", true, (Object[])new String[]{acfsPath});
                    res.addErrorDescription(new ErrorDescription(msg3));
                    res.setStatus(3);
                }
            }
            catch (InstallException e) {
                Trace.out((String)("InstallException - " + e.getMessage()));
                msg = s_gMsgBundle.getMessage("1302", true, (Object[])new String[]{acfsPath}) + VerificationConstants.LSEP + e.getMessage();
                res.addErrorDescription(new ErrorDescription(msg));
                res.setStatus(2);
            }
            catch (CmdToolUtilException e) {
                Trace.out((String)("CmdToolUtilException - " + e.getMessage()));
                msg = s_gMsgBundle.getMessage("1302", true, (Object[])new String[]{acfsPath}) + VerificationConstants.LSEP + e.getMessage();
                res.addErrorDescription(new ErrorDescription(msg));
                res.setStatus(2);
            }
            catch (NotExistsException e) {
                Trace.out((String)("NotExistsException - " + e.getMessage()));
                msg = s_gMsgBundle.getMessage("1302", true, (Object[])new String[]{acfsPath}) + VerificationConstants.LSEP + e.getMessage();
                res.addErrorDescription(new ErrorDescription(msg));
                res.setStatus(2);
            }
            storagePathResultSetImpl.addStoragePathInfo(new StoragePathInfoImpl(acfsPath, res));
            storagePathResultSetImpl.addResult(acfsPath, res);
        }
        return storagePathResultSetImpl;
    }

    public static ResultSet checkDiskListAFDCapable(String[] nodeList, Hashtable<String, Hashtable<String, List<String>>> htdg) {
        Hashtable<String, List<String>> nodeDeviceListTable = new Hashtable<String, List<String>>();
        if (htdg != null && !htdg.isEmpty()) {
            Trace.out((String)"Using device list retrieved using kfod for each node to validate if devices are AFD capable");
            for (String node : htdg.keySet()) {
                for (String diskGrp : htdg.get(node).keySet()) {
                    if (nodeDeviceListTable.containsKey(node)) {
                        nodeDeviceListTable.get(node).addAll((Collection<String>)htdg.get(node).get(diskGrp));
                        continue;
                    }
                    ArrayList diskList = new ArrayList();
                    diskList.addAll(htdg.get(node).get(diskGrp));
                    nodeDeviceListTable.put(node, diskList);
                }
            }
        }
        if (!nodeDeviceListTable.isEmpty()) {
            return StorageUtil.checkDiskListAFDCapable(nodeDeviceListTable);
        }
        return null;
    }

    public static ResultSet checkDiskListAFDCapable(String[] nodeList, List<String> deviceList) {
        Hashtable<String, List<String>> nodeDeviceListTable = new Hashtable<String, List<String>>();
        if (nodeList == null || nodeList.length < 1 || deviceList == null || deviceList.isEmpty()) {
            return null;
        }
        Trace.out((String)"Using device list to validate if devices are AFD capable");
        for (String node : nodeList) {
            if (nodeDeviceListTable.containsKey(node)) {
                nodeDeviceListTable.get(node).addAll(deviceList);
                continue;
            }
            nodeDeviceListTable.put(node, deviceList);
        }
        if (!nodeDeviceListTable.isEmpty()) {
            return StorageUtil.checkDiskListAFDCapable(nodeDeviceListTable);
        }
        return null;
    }

    public static ResultSet checkDiskListAFDCapable(Hashtable<String, List<String>> nodeDeviceListTable) {
        if (nodeDeviceListTable != null && !nodeDeviceListTable.isEmpty()) {
            GlobalExecution globalExec = new GlobalExecution();
            return globalExec.checkDiskAFDCapable(nodeDeviceListTable);
        }
        return null;
    }

    public static StorageType getStorageType(String id, String node, Result rslt) {
        String errMsg = s_gMsgBundle.getMessage("0819", true, (Object[])new String[]{id, node});
        StorageCheckContext scCtx = new StorageCheckContext();
        StorageDataHandler sdHndlr = new StorageDataHandler(scCtx);
        StorageData stData = sdHndlr.getStorageData(id, node);
        Entity<StorageType> stTypeEntity = stData.getStorageType();
        Trace.out((String)("stTypeEntity=" + stTypeEntity));
        if (stTypeEntity == null || stTypeEntity.getStatus() != EntityStatus.VALID) {
            Trace.out((String)("Storage type for id '" + id + "' could not be retrieved from node '" + node + "'"));
            rslt.setStatus(2);
            rslt.addErrorDescription(new ErrorDescription(errMsg));
            if (stTypeEntity != null) {
                for (ErrorDescription errDesc : stTypeEntity.getErrors()) {
                    rslt.addErrorDescription(errDesc);
                }
            }
            return StorageType.UNKNOWN;
        }
        rslt.setStatus(1);
        return stTypeEntity.getValue();
    }

    public static void clearAFDResultCache() {
        m_afdInstallRstSet.clear();
        m_afdLoadRstSet.clear();
    }

    public static void filterStoragesIfVirtualEnvironment(Collection<String> storageList, HashSet<String> storageToCheck, HashSet<String> storagesToSkip) {
        if (VerificationUtil.isVirtualEnvironment()) {
            HashMap<StorageType, Collection<String>> stTypeStorageIDListTable = StorageUtil.filterByStorageType(storageList);
            if (stTypeStorageIDListTable.containsKey((Object)StorageType.DISK)) {
                storagesToSkip.addAll(stTypeStorageIDListTable.get((Object)StorageType.DISK));
            }
            if (stTypeStorageIDListTable.containsKey((Object)StorageType.DISK_PARTITION)) {
                storagesToSkip.addAll(stTypeStorageIDListTable.get((Object)StorageType.DISK_PARTITION));
            }
            if (storagesToSkip.isEmpty()) {
                VerificationUtil.traceAndLog("All the storages are valid to be checked for sharedness in this virtual environment. Returning the storages list as is.");
                storageToCheck.addAll(storageList);
            } else {
                for (String storage : storageList) {
                    if (storagesToSkip.contains(storage)) continue;
                    storageToCheck.add(storage);
                }
                VerificationUtil.traceAndLog("Filtering out storages " + VerificationUtil.strCollection2String(storagesToSkip) + " \nReturning storages " + VerificationUtil.strCollection2String(storageToCheck) + " for this virtual environment.");
            }
        } else {
            Trace.out((String)"Not a virtual environment. Returning storages list as is.");
            storageToCheck.addAll(storageList);
        }
    }

    private static HashMap<StorageType, Collection<String>> filterByStorageType(Collection<String> storageIDList) {
        Trace.out((String)"Start Storage type retrieval");
        HashMap<StorageType, Collection<String>> storageTypeStorageListTable = new HashMap<StorageType, Collection<String>>();
        String localNode = VerificationUtil.getLocalNode();
        for (String storageID : storageIDList) {
            Result nodeResult;
            StorageType stType = StorageUtil.getStorageType(storageID, localNode, nodeResult = new Result(localNode));
            if (!storageTypeStorageListTable.containsKey((Object)stType)) {
                HashSet idList = new HashSet();
                storageTypeStorageListTable.put(stType, idList);
            }
            storageTypeStorageListTable.get((Object)stType).add(storageID);
        }
        Trace.out((String)"End Storage type retrieval");
        return storageTypeStorageListTable;
    }

    static {
        OCFS_TYPE = 8;
        m_nodeWiseAFDDiskListTable = null;
        m_isAFDSupportedOpStr = null;
        m_afdInstallRstSet = new ResultSet();
        m_afdLoadRstSet = new ResultSet();
        String distID = VerificationUtil.getUniqueDistributionID();
        boolean bl = s_isOCFSsupported = distID.equalsIgnoreCase("RHEL3") || distID.equalsIgnoreCase("OEL3") || distID.equalsIgnoreCase("RHEL2");
        if (s_isOCFSsupported) {
            OCFS_TYPE = 7;
        }
    }
}

