/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.xmlreport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultKeyType;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.xmlreport.CVXMLZipReportReader;
import oracle.ops.verification.framework.report.xmlreport.XmlReportToolException;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CVXMLReportReader {
    protected String m_xmlXsdURI = null;
    protected BufferedInputStream m_is = null;
    protected HashMap<String, HashMap<String, String>> m_targetList = null;
    protected ReportUtilConstants.BasicClusterWareDetails m_header = null;
    protected static MessageBundle s_prvgMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    protected String m_xmlFileName = null;
    SAXParser saxParser = null;

    CVXMLReportReader(String xmlFile) throws FileNotFoundException, XmlReportToolException {
        try {
            this.m_xmlFileName = xmlFile;
            this.m_xmlXsdURI = ReportUtilConstants.getCVUXmlReportSchemaURI();
            Trace.out((String)("m_xmlXsdURI: '" + this.m_xmlXsdURI + "'"));
        }
        catch (XmlFilePathException e) {
            throw new XmlReportToolException(e);
        }
    }

    public String getXmlFileName() {
        return this.m_xmlFileName;
    }

    public HashMap<String, HashMap<String, String>> getTargetList() throws XmlReportToolException {
        if (this.m_targetList != null) {
            return this.m_targetList;
        }
        HeaderAndTargetListHandler handler = new HeaderAndTargetListHandler();
        try {
            this.parse(new BufferedInputStream(new FileInputStream(this.m_xmlFileName)), handler);
            this.m_header = handler.m_header;
            this.m_targetList = handler.m_targetList;
        }
        catch (FileNotFoundException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
        return this.m_targetList;
    }

    public HashMap<String, String> getAttributes(Attributes attributes) {
        HashMap<String, String> attributesHM = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Trace.out((int)1, (String)("attr:Qname: '" + attributes.getQName(i) + "' attr:Value: '" + attributes.getValue(i) + "'"));
            attributesHM.put(attributes.getQName(i), attributes.getValue(i));
        }
        return attributesHM;
    }

    public String getTargetKey(String targetName, Attributes attributes) {
        String targetKey = "";
        for (int i = 0; i < attributes.getLength(); ++i) {
            targetKey = targetKey + attributes.getValue(i);
        }
        return targetKey;
    }

    protected void parse(InputStream is, DefaultHandler handler) throws XmlReportToolException {
        try {
            if (this.saxParser == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(true);
                this.saxParser = factory.newSAXParser();
                if (new File(this.m_xmlXsdURI).exists()) {
                    this.saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.m_xmlXsdURI);
                    Trace.out((String)("Using '" + this.m_xmlXsdURI + "' for parsing"));
                } else {
                    Trace.out((String)"Using DEFAULT parser.");
                }
            }
            this.saxParser.parse(is, handler);
        }
        catch (SAXException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
    }

    public ReportUtilConstants.BasicClusterWareDetails getHeader() throws XmlReportToolException {
        if (this.m_header != null) {
            return this.m_header;
        }
        HeaderAndTargetListHandler handler = new HeaderAndTargetListHandler();
        try {
            this.parse(new BufferedInputStream(new FileInputStream(this.m_xmlFileName)), handler);
            this.m_header = handler.m_header;
            this.m_targetList = handler.m_targetList;
        }
        catch (FileNotFoundException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
        return this.m_header;
    }

    public List<Task> getTaskList(String targetKey) throws XmlReportToolException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        TaskListHandler handler = new TaskListHandler(taskList, targetKey);
        try {
            this.parse(new BufferedInputStream(new FileInputStream(this.m_xmlFileName)), handler);
        }
        catch (FileNotFoundException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
        return taskList;
    }

    private SeverityType getSeverityAttributeValue(String severityStr) {
        SeverityType severity = SeverityType.CRITICAL;
        if (SeverityType.FATAL.name().equalsIgnoreCase(severityStr)) {
            severity = SeverityType.FATAL;
        } else if (SeverityType.IGNORABLE.name().equalsIgnoreCase(severityStr)) {
            severity = SeverityType.IGNORABLE;
        }
        return severity;
    }

    private int getOverallStatus(String status) {
        if (status.equals("SUCCESSFUL")) {
            return 1;
        }
        if (status.equals("OPERATION_FAILED")) {
            return 2;
        }
        if (status.equals("VERIFICATION_FAILED")) {
            return 3;
        }
        if (status.equals("WARNING")) {
            return 4;
        }
        return 5;
    }

    private int getStatus(String status) {
        if (status.contains("SUCCESSFUL")) {
            return 1;
        }
        if (status.contains("OPERATION_FAILED")) {
            return 2;
        }
        if (status.contains("VERIFICATION_FAILED")) {
            return 3;
        }
        if (status.contains("VERIFICATION_WARNING")) {
            return 4;
        }
        if (status.contains("NOT_APPLICABLE")) {
            return 6;
        }
        return 5;
    }

    public static CVXMLReportReader getCVXMLReportReader(String xmlFilePath) throws XmlReportToolException {
        try {
            if (xmlFilePath.endsWith(".zip")) {
                return new CVXMLZipReportReader(xmlFilePath);
            }
            return new CVXMLReportReader(xmlFilePath);
        }
        catch (FileNotFoundException e) {
            throw new XmlReportToolException(e.getMessage(), e);
        }
    }

    protected class HeaderAndTargetListHandler
    extends DefaultHandler {
        boolean headerStart = false;
        protected HashMap<String, HashMap<String, String>> m_targetList = new LinkedHashMap<String, HashMap<String, String>>();
        protected ReportUtilConstants.BasicClusterWareDetails m_header = new ReportUtilConstants.BasicClusterWareDetails();

        HeaderAndTargetListHandler() {
            Trace.out((int)1, (String)"Setup init'd m_targetList, m_header");
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Trace.out((int)1, (String)("qName: '" + qName + "'"));
            if (qName.equalsIgnoreCase("HEADER")) {
                this.headerStart = true;
                return;
            }
            if (qName.equalsIgnoreCase("TARGET_DATA")) {
                String targetName = attributes.getValue("ID");
                Trace.out((int)1, (String)("targetName: '" + targetName + "'"));
                this.m_targetList.put(CVXMLReportReader.this.getTargetKey(targetName, attributes), CVXMLReportReader.this.getAttributes(attributes));
                Trace.out((int)1, (String)("attributes: '" + CVXMLReportReader.this.getAttributes(attributes) + "'"));
            }
            if (this.headerStart && qName.equalsIgnoreCase("TIME_STAMP")) {
                String year = attributes.getValue("YEAR");
                String month = attributes.getValue("MONTH");
                String day = attributes.getValue("DAY");
                String hours = attributes.getValue("HOURS");
                String minutes = attributes.getValue("MINUTES");
                String seconds = attributes.getValue("SECONDS");
                this.m_header.getTimeStamp().set(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day), Integer.parseInt(hours), Integer.parseInt(minutes), Integer.parseInt(seconds));
            }
            if (this.headerStart && qName.equalsIgnoreCase("CLUSTER_DETAILS")) {
                this.m_header.setClusterName(attributes.getValue("CLUSTER_NAME"));
                this.m_header.setClusterwareVersion(attributes.getValue("CLUSTERWARE_VERSION"));
                this.m_header.setCrsHome(attributes.getValue("CRS_HOME"));
                this.m_header.setCrsUserName(attributes.getValue("CRS_USER"));
                this.m_header.setOsPlatform(attributes.getValue("OS_PLATFORM"));
                this.m_header.setnodeListStr(attributes.getValue("NODE_LIST"));
                this.m_header.setOracleBase(attributes.getValue("ORACLE_BASE"));
            }
            if (this.headerStart && qName.equalsIgnoreCase("DATABASE")) {
                this.m_header.addDatabaseDetails(attributes.getValue("NAME"), attributes.getValue("DATABASE_HOME"), attributes.getValue("DATABASE_VERSION"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("HEADER")) {
                this.headerStart = false;
            }
        }
    }

    protected class TaskListHandler
    extends DefaultHandler {
        private final List<Task> taskList;
        private final String targetKey;
        boolean targetMatch = false;
        boolean elementName = false;
        boolean elementDesc = false;
        boolean moreDetails = false;
        boolean moreDetailsText = false;
        boolean reference = false;
        boolean nodeResult = false;
        boolean expectedValue = false;
        boolean availableValue = false;
        boolean nodeCollectionSet = false;
        boolean globalErrorDescList = false;
        boolean nodeResultSet = false;
        private boolean msgTxt;
        private boolean cause;
        private boolean action;
        Stack<CollectionElement> collectionElementStack = new Stack();
        Stack<Task> taskStack = new Stack();
        ErrorDescription errDesc = null;
        Result result = null;
        private boolean summary;
        private boolean globalCollectionSet;
        private List<String> referenceList = null;
        int taskLevel = 0;

        protected TaskListHandler(List<Task> taskList, String targetKey) {
            this.taskList = taskList;
            this.targetKey = targetKey;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("TARGET_DATA")) {
                String targetName = attributes.getValue("ID");
                if (this.targetKey.equals(CVXMLReportReader.this.getTargetKey(targetName, attributes))) {
                    this.targetMatch = true;
                }
                Trace.out((int)1, (String)("targetMatch: '" + this.targetMatch + "'"));
                return;
            }
            if (!this.targetMatch) {
                return;
            }
            if (qName.equalsIgnoreCase("TASK")) {
                String type = attributes.getValue("TYPE");
                boolean m_bestPractice = ReportUtilConstants.TaskType.RECCOMENDED_TASK.name().equals(type);
                String severity = attributes.getValue("SEVERITY");
                String overallStatus = attributes.getValue("OVER_ALL_STATUS");
                Task task = new Task(){

                    @Override
                    public String getDefaultElementName() {
                        return null;
                    }

                    @Override
                    public String getDefaultDescription() {
                        return null;
                    }
                };
                task.setBestPractice(m_bestPractice);
                task.setSeverity(CVXMLReportReader.this.getSeverityAttributeValue(severity));
                task.getResultSet().setStatus(CVXMLReportReader.this.getOverallStatus(overallStatus));
                this.taskStack.push(task);
                if (this.taskLevel == 0) {
                    this.taskList.add(task);
                }
            }
            if (qName.equalsIgnoreCase("ELEMENT")) {
                this.elementName = true;
            }
            if (qName.equalsIgnoreCase("DESC")) {
                this.elementDesc = true;
            }
            if (qName.equalsIgnoreCase("MORE_DETAILS")) {
                this.moreDetails = true;
            }
            if (qName.equalsIgnoreCase("TEXT") && this.moreDetails) {
                this.moreDetailsText = true;
            }
            if (qName.equalsIgnoreCase("REFERENCE") && this.moreDetails) {
                this.reference = true;
                if (this.referenceList == null) {
                    this.referenceList = new ArrayList<String>();
                    this.taskStack.peek().setReferences(this.referenceList);
                }
            }
            if (qName.equalsIgnoreCase("GLOBAL_ERROR_DESC_LIST")) {
                this.globalErrorDescList = true;
            }
            if (qName.equalsIgnoreCase("NODE_RESULT_SET")) {
                this.nodeResultSet = true;
            }
            if (qName.equalsIgnoreCase("NODE_RESULT") && this.nodeResultSet) {
                String nodeName = attributes.getValue("NAME");
                String status = attributes.getValue("STATUS");
                String fixupAvailable = attributes.getValue("FIXUP_AVAILABLE");
                String type = attributes.getValue("RESULTKEYTYPE");
                this.result = new Result(nodeName, CVXMLReportReader.this.getStatus(status), ResultKeyType.getResultKeyType(type));
                Trace.out((String)("NEW Result with node: '" + nodeName + "' of type: '" + type + "'"));
                this.result.setFixupAvailable(Boolean.parseBoolean(fixupAvailable));
                this.taskStack.peek().getResultSet().addResult(nodeName, this.result);
            }
            if (qName.equalsIgnoreCase("EXPECTED_VALUE")) {
                this.expectedValue = true;
            }
            if (qName.equalsIgnoreCase("ACTUAL_VALUE")) {
                this.availableValue = true;
            }
            if (qName.equalsIgnoreCase("ERROR_DESC")) {
                this.errDesc = new ErrorDescription();
                CollectionElement collectionElement = null;
                if (this.collectionElementStack.size() > 0) {
                    collectionElement = this.collectionElementStack.peek();
                }
                if (collectionElement != null) {
                    collectionElement.addErrorDescription(this.errDesc);
                }
                if (this.collectionElementStack.size() <= 1) {
                    if (this.globalErrorDescList) {
                        this.taskStack.peek().getResultSet().addErrorDescription(this.errDesc);
                    }
                    if (this.nodeResult) {
                        this.result.addErrorDescription(this.errDesc);
                    }
                }
            }
            if (qName.equalsIgnoreCase("MSG_TXT")) {
                this.msgTxt = true;
            }
            if (qName.equalsIgnoreCase("CAUSE")) {
                this.cause = true;
            }
            if (qName.equalsIgnoreCase("ACTION")) {
                this.action = true;
            }
            if (qName.equalsIgnoreCase("TASK_SUMMARY")) {
                this.summary = true;
            }
            if (qName.equalsIgnoreCase("GLOBAL_COLLECTION_SET")) {
                this.globalCollectionSet = true;
            }
            if (qName.equalsIgnoreCase("NODE_COLLECTION_SET")) {
                this.nodeCollectionSet = true;
            }
            if (qName.equalsIgnoreCase("COLLECTION_ELEMENT")) {
                String name = attributes.getValue("NAME");
                String node = attributes.getValue("NODE");
                String desc = attributes.getValue("DESCRIPTION");
                String status = attributes.getValue("STATUS");
                CollectionElement collectionElement = new CollectionElement(name, node, null, null, null, desc, status);
                if (this.collectionElementStack.size() > 0) {
                    CollectionElement parentElement = this.collectionElementStack.peek();
                    parentElement.addChild(collectionElement);
                }
                this.collectionElementStack.push(collectionElement);
                if (this.collectionElementStack.size() == 1) {
                    if (this.nodeCollectionSet) {
                        this.taskStack.peek().getResultSet().addCollectionElement(node, collectionElement);
                    }
                    if (this.globalCollectionSet) {
                        this.taskStack.peek().getResultSet().addCollectionElement(collectionElement);
                    }
                }
            }
            if (qName.equalsIgnoreCase("SUBTASK_LIST")) {
                ++this.taskLevel;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("TARGET_DATA")) {
                this.targetMatch = false;
            }
            if (!this.targetMatch) {
                return;
            }
            if (qName.equalsIgnoreCase("TASK")) {
                Task task = this.taskStack.pop();
                if (this.taskStack.size() > 0) {
                    this.taskStack.peek().addChildTask(task);
                }
            }
            if (qName.equalsIgnoreCase("ELEMENT")) {
                this.elementName = false;
            }
            if (qName.equalsIgnoreCase("DESC")) {
                this.elementDesc = false;
            }
            if (qName.equalsIgnoreCase("MORE_DETAILS")) {
                this.moreDetails = false;
                this.referenceList = null;
            }
            if (qName.equalsIgnoreCase("TEXT") && this.moreDetails) {
                this.moreDetailsText = false;
            }
            if (qName.equalsIgnoreCase("REFERENCE") && this.moreDetails) {
                this.reference = false;
            }
            if (qName.equalsIgnoreCase("GLOBAL_ERROR_DESC_LIST")) {
                this.globalErrorDescList = false;
            }
            if (qName.equalsIgnoreCase("NODE_RESULT_SET")) {
                this.nodeResultSet = false;
            }
            if (qName.equalsIgnoreCase("NODE_RESULT") && this.nodeResultSet) {
                this.result = null;
            }
            if (qName.equalsIgnoreCase("EXPECTED_VALUE")) {
                this.expectedValue = false;
            }
            if (qName.equalsIgnoreCase("ACTUAL_VALUE")) {
                this.availableValue = false;
            }
            if (qName.equalsIgnoreCase("ERROR_DESC")) {
                this.errDesc = new ErrorDescription();
            }
            if (qName.equalsIgnoreCase("MSG_TXT")) {
                this.msgTxt = false;
            }
            if (qName.equalsIgnoreCase("CAUSE")) {
                this.cause = false;
            }
            if (qName.equalsIgnoreCase("ACTION")) {
                this.action = false;
            }
            if (qName.equalsIgnoreCase("TASK_SUMMARY")) {
                this.summary = false;
            }
            if (qName.equalsIgnoreCase("GLOBAL_COLLECTION_SET")) {
                this.globalCollectionSet = false;
            }
            if (qName.equalsIgnoreCase("NODE_COLLECTION_SET")) {
                this.nodeCollectionSet = false;
            }
            if (qName.equalsIgnoreCase("COLLECTION_ELEMENT") && this.collectionElementStack.size() > 0) {
                this.collectionElementStack.pop();
            }
            if (qName.equalsIgnoreCase("SUBTASK_LIST")) {
                --this.taskLevel;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            CollectionElement collectionElement;
            if (this.elementName) {
                this.taskStack.peek().setElementName(new String(ch, start, length));
                Trace.out((int)1, (String)("taskStack.peek().ElementName: '" + this.taskStack.peek().getElementName() + "'"));
            }
            if (this.elementDesc) {
                this.taskStack.peek().setDescription(new String(ch, start, length));
                Trace.out((int)1, (String)("taskStack.peek().Description: '" + this.taskStack.peek().getDescription() + "'"));
            }
            if (this.moreDetailsText && this.moreDetails) {
                this.taskStack.peek().setMoreDetails(new String(ch, start, length));
            }
            if (this.reference && this.moreDetails) {
                this.referenceList.add(new String(ch, start, length));
            }
            if (this.expectedValue) {
                collectionElement = null;
                if (this.collectionElementStack.size() > 0) {
                    collectionElement = this.collectionElementStack.peek();
                }
                if (collectionElement != null) {
                    collectionElement.setExpectedValue(new String(ch, start, length));
                }
                if (this.collectionElementStack.size() <= 1 && this.result != null) {
                    this.result.setHasResultValues(true);
                    this.result.setExpectedValue(new String(ch, start, length));
                }
            }
            if (this.availableValue) {
                collectionElement = null;
                if (this.collectionElementStack.size() > 0) {
                    collectionElement = this.collectionElementStack.peek();
                }
                if (collectionElement != null) {
                    collectionElement.setValue(new String(ch, start, length));
                }
                if (this.collectionElementStack.size() <= 1 && this.result != null) {
                    this.result.setHasResultValues(true);
                    this.result.setActualValue(new String(ch, start, length));
                }
            }
            if (this.msgTxt) {
                this.errDesc.setErrorMessage(new String(ch, start, length));
            }
            if (this.cause) {
                this.errDesc.setCause(new String(ch, start, length));
            }
            if (this.action) {
                this.errDesc.setAction(new String(ch, start, length));
            }
            if (this.summary) {
                this.taskStack.peek().getResultSet().setResultSummary(new String(ch, start, length));
            }
        }
    }
}

