/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.util.ConsoleUtil;
import oracle.cluster.util.ConsoleUtilException;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationTask;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.xmlreport.XmlReportTool;
import oracle.ops.verification.framework.util.HeavyWeightVerificationUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ReportUtil {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_prvgMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle s_prveMsgBundle = VerificationUtil.getMessageBundle("Prve");
    public static String ERROR = s_msgBundle.getMessage("8504", false);
    public static String ERRORS = s_prveMsgBundle.getMessage("9906", false);
    public static String STR_WARNING = s_prveMsgBundle.getMessage("10032", false);
    public static String WARNING = s_msgBundle.getMessage("8503", false);
    public static String NOTE = s_msgBundle.getMessage("8511", false);
    public static String UNKNOWN = s_msgBundle.getMessage("8200", false);
    public static String PASSED = s_msgBundle.getMessage("8201", false);
    public static String PINNED = s_msgBundle.getMessage("8509", false);
    public static String NOT_PINNED = s_msgBundle.getMessage("8510", false);
    public static String FAILED = s_msgBundle.getMessage("8202", false);
    public static String FAILED_IGNORABLE = s_msgBundle.getMessage("8222", false);
    public static String IGNORED = s_msgBundle.getMessage("8216", false);
    public static String SUCCESSFUL = s_msgBundle.getMessage("8203", false);
    public static String PARTIALLY_SUCCESSFUL = s_msgBundle.getMessage("8204", false);
    public static String MATCHED = s_msgBundle.getMessage("8217", false);
    public static String MISMATCHED = s_msgBundle.getMessage("8218", false);
    public static String INSTALLED = s_msgBundle.getMessage("8205", false);
    public static String MISSING = s_msgBundle.getMessage("8206", false);
    public static String ALIVE = s_msgBundle.getMessage("8207", false);
    public static String NOTALIVE = s_msgBundle.getMessage("8208", false);
    public static String ONLINE = s_msgBundle.getMessage("8221", false);
    public static String EXIST = s_msgBundle.getMessage("8209", false);
    public static String NOTEXIST = s_msgBundle.getMessage("8210", false);
    public static String YES = s_msgBundle.getMessage("8212", false);
    public static String NO = s_msgBundle.getMessage("8213", false);
    public static String ON = s_msgBundle.getMessage("8214", false);
    public static String OFF = s_msgBundle.getMessage("8215", false);
    public static String NOT_APPLICABLE = s_msgBundle.getMessage("8211", false);
    public static String UNDEFINED = s_prvgMsgBundle.getMessage("0500", false);
    public static String PORT_NUMBER = s_prvgMsgBundle.getMessage("0327", false);
    public static String PROTOCOL = s_prvgMsgBundle.getMessage("0328", false);
    public static String USED = s_prvgMsgBundle.getMessage("0331", false);
    public static String STATUS = s_msgBundle.getMessage("8018", false);
    public static String REF_STATUS = s_msgBundle.getMessage("8021", false);
    public static String COMMENT = s_msgBundle.getMessage("8001", false);
    public static String AVAILABLE = s_msgBundle.getMessage("8012", false);
    public static String APPLIED = s_msgBundle.getMessage("8028", false);
    public static String CONFIGURED = s_msgBundle.getMessage("8023", false);
    public static String REQUIRED = s_msgBundle.getMessage("8019", false);
    public static String NODENAME = s_msgBundle.getMessage("8000", false);
    public static String CRS_OK = s_msgBundle.getMessage("8002", false);
    public static String RUNNING = s_msgBundle.getMessage("8003", false);
    public static String PROCESS = s_msgBundle.getMessage("8033", false);
    public static String DESTINATION_NODE = s_msgBundle.getMessage("8004", false);
    public static String REACHABLE = s_msgBundle.getMessage("8005", false);
    public static String SOURCE = s_msgBundle.getMessage("8006", false);
    public static String DESTINATION = s_msgBundle.getMessage("8007", false);
    public static String CONNECTED = s_msgBundle.getMessage("8008", false);
    public static String INTERFACE_NAME = s_msgBundle.getMessage("8009", false);
    public static String IPADDR = s_msgBundle.getMessage("8010", false);
    public static String SUBNET = s_msgBundle.getMessage("8011", false);
    public static String USER_EXISTS = s_msgBundle.getMessage("8013", false);
    public static String GROUP_ID = s_msgBundle.getMessage("8017", false);
    public static String GROUP_AND_GID = s_msgBundle.getMessage("8022", false);
    public static String GROUP_EXISTS = s_msgBundle.getMessage("8014", false);
    public static String USER_IN_GROUP = s_msgBundle.getMessage("8015", false);
    public static String PRIMARY = s_msgBundle.getMessage("8016", false);
    public static String DAEMON = s_msgBundle.getMessage("8020", false);
    public static String OS_PATCH = s_msgBundle.getMessage("8024", false);
    public static String PACKAGE = s_msgBundle.getMessage("8025", false);
    public static String OSVER = s_msgBundle.getMessage("8027", false);
    public static String KRNVER = s_msgBundle.getMessage("8032", false);
    public static String VERSION = s_msgBundle.getMessage("8029", false);
    public static String FILESIZE = s_msgBundle.getMessage("8030", false);
    public static String RUNLEVEL = s_msgBundle.getMessage("8031", false);
    public static String SHELL_LIMIT_TYPE = s_msgBundle.getMessage("8048", false);
    public static String PATH = s_msgBundle.getMessage("8040", false);
    public static String MNTPNT = s_msgBundle.getMessage("8034", false);
    public static String COMPONENT = s_msgBundle.getMessage("8053", false);
    public static String FILE = s_msgBundle.getMessage("8041", false);
    public static String SCANNAME = s_msgBundle.getMessage("4658", false);
    public static String CURRENT = s_prvgMsgBundle.getMessage("0400", false);
    public static String FAILED_ON_NODES = s_prvgMsgBundle.getMessage("0501", false);
    public static String REBOOT_REQUIRED = s_prvgMsgBundle.getMessage("0502", false);
    public static String FAILED_GENERATE_FIXUP = s_prvgMsgBundle.getMessage("0530", false);
    public static String LOGIN_SHELL = s_prvgMsgBundle.getMessage("0332", false);
    public static String OWNER = s_msgBundle.getMessage("5181", false);
    public static String GROUP = s_msgBundle.getMessage("5182", false);
    public static String PERMISSION = s_msgBundle.getMessage("5183", false);
    public static final int FORMAT_NO_KB = 1;
    public static final int FORMAT_ADD_KB = 2;
    private static long KILO_BYTE = 1024L;
    private static long MEGA_BYTE = 0x100000L;
    private static long GIGA_BYTE = 0x40000000L;
    private static String SPACES = "                                                                           ";
    private static String SEPARATOR = "---------------------------------------------------------------------------";
    private static int SPACE_1 = 1;
    private static int SPACE_2 = 2;
    private static int SPACE_4 = 4;
    private static int SPACE_8 = 8;
    private static int WOFCOL1 = 12;
    private static int WOFCOL2 = 24;
    private static int WOFCOL3 = 24;
    private static int WOFCOL4 = 10;
    private static int COLW_6 = 6;
    private static int COLW_8 = 8;
    private static int COLW_12 = 12;
    private static int COLW_15 = 15;
    private static int COLW_16 = 16;
    private static int COLW_17 = 17;
    private static int COLW_20 = 20;
    private static int COLW_24 = 24;
    private static int COLW_30 = 30;
    private static int COLW_36 = 36;
    private static int COLW_40 = 40;
    private static int COLW_80 = 80;
    private static int COLW_1OF2_EQUAL = 32;
    private static int COLW_2OF2_EQUAL = 32;
    private static ParamManager pm = null;
    private static boolean isCLImode;
    private static boolean s_isQuietModeForSession;
    private static boolean s_isQuietMode;
    private static boolean s_usePre122Format;
    private static boolean s_reportVerifyingCalledLast;
    private static boolean s_endStatusCalledLast;
    private static boolean s_baselineHealthcheck;
    private static Task m_taskDetailsBufferReference;
    private static PrintWriter s_printWriter;
    private static final int CVU_GLOBAL_ALERTLOG_MESSAGE = 10051;
    private static XmlReportTool s_xmlReportTool;
    private static String xmlSaveDirectory;
    private static int m_numberOfOperations;
    private static int m_dataPointsVerified;
    private static boolean m_notifyMessage;

    public static boolean isVerbose() {
        return pm.checkArgVerbose();
    }

    public static boolean isFormat() {
        return pm.checkArgFormat();
    }

    public static boolean getMode() {
        return isCLImode;
    }

    public static void setMode(boolean newMode) {
        isCLImode = newMode;
    }

    public static XmlReportTool getXmlReportTool() {
        return s_xmlReportTool;
    }

    public static String getXmlDirLocation() {
        return xmlSaveDirectory;
    }

    public static void setOldFormat(boolean format) {
        s_usePre122Format = format;
    }

    public static boolean getOldFormat() {
        return s_usePre122Format;
    }

    public static void setBaselineHealthcheck(boolean baselineHealthcheck) {
        s_baselineHealthcheck = baselineHealthcheck;
    }

    public static Task setTaskReference(Task taskPointer) {
        Task oldTaskReference = m_taskDetailsBufferReference;
        if (oldTaskReference == null) {
            Trace.out((String)"Old task refrence is NULL");
        } else {
            Trace.out((String)("Replacing task reference to: " + oldTaskReference.getElementName()));
        }
        m_taskDetailsBufferReference = taskPointer;
        Trace.out((String)("Setting task reference to: " + (taskPointer == null ? "NULL" : taskPointer.getElementName())));
        return oldTaskReference;
    }

    public static void setQuietModeForSession(boolean quietModeForSession) {
        Trace.out((String)("Request for setting session quiet mode to '" + quietModeForSession + "'"));
        s_isQuietModeForSession = quietModeForSession;
        s_isQuietMode = quietModeForSession;
    }

    public static void setQuietModeLocal(boolean quietModeLocal) {
        Trace.out((String)("Request for setting local quiet mode to '" + quietModeLocal + "'"));
        Trace.out((String)("s_isQuietModeForSession=" + s_isQuietModeForSession + "; s_isQuietMode=" + s_isQuietMode));
        if (!s_isQuietModeForSession) {
            s_isQuietMode = quietModeLocal;
        }
        Trace.out((String)("s_isQuietMode=" + s_isQuietMode));
    }

    public static void processAlert(String strAlert) {
        if (isCLImode && !ReportUtil.isFormat()) {
            System.out.println(strAlert);
        }
    }

    public static void reportPrint(String str) {
        if (!s_usePre122Format && isCLImode && !s_isQuietMode) {
            System.out.print(str);
        }
    }

    public static void reportErrors(List<String> errorMessages) {
        if (errorMessages == null || errorMessages.size() == 0) {
            return;
        }
        boolean headerPrinted = false;
        Task taskPtr = m_taskDetailsBufferReference;
        for (String errorMessage : errorMessages) {
            if (!headerPrinted) {
                ReportUtil.sureprintln(VerificationConstants.LSEP + (errorMessages.size() == 1 ? ERROR : ERRORS) + VerificationConstants.LSEP);
                headerPrinted = true;
            }
            ReportUtil.sureprintln(errorMessage);
        }
    }

    public static void reportFormatPrintln(String str) {
        if (s_usePre122Format) {
            return;
        }
        int childTaskLevel = 0;
        if (m_taskDetailsBufferReference != null) {
            childTaskLevel = m_taskDetailsBufferReference.getChildTaskLevel();
        }
        ReportUtil.reportPrintln(ReportUtil.formatTextWithMargins(str, childTaskLevel * SPACE_2));
    }

    public static void verboseReportPrintln(String str) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.reportPrintln(str);
        }
    }

    public static void reportPrintln(String str) {
        if (!s_usePre122Format && isCLImode && !s_isQuietMode) {
            System.out.println(str);
        }
        if (!s_isQuietMode) {
            s_reportVerifyingCalledLast = false;
        }
    }

    public static void reportTaskVerifying(Task taskPtr) {
        if (s_usePre122Format) {
            return;
        }
        String taskName = "<task_name>:" + taskPtr.getClass().getName();
        if (taskName.contains(".")) {
            taskName = taskName.substring(taskName.lastIndexOf(".") + 1);
        }
        taskName = taskName + ": <elem_name>:" + taskPtr.getElementName();
        taskName = taskName + " <taskID>[" + taskPtr.getTaskID() + "]";
        taskName = taskName + " nodeList:" + VerificationUtil.strArr2List(taskPtr.getNodeList());
        Trace.out((String)("Verifying: '" + taskName + "'"));
        ++m_numberOfOperations;
        String verifyStr = null;
        verifyStr = taskPtr.getTaskInformationalDetailsContent();
        if (verifyStr != null && verifyStr.length() > 0) {
            ReportUtil.reportPrintln((s_endStatusCalledLast ? "" : VerificationConstants.LSEP) + verifyStr);
        }
        verifyStr = (s_endStatusCalledLast ? "" : VerificationConstants.LSEP) + ReportUtil.addSpaces(taskPtr.getChildTaskLevel(), SPACE_2) + s_prvgMsgBundle.getMessage("0207", false, (Object[])new String[]{taskPtr.getElementName()});
        ReportUtil.reportPrint(verifyStr);
        s_endStatusCalledLast = false;
        s_reportVerifyingCalledLast = true;
    }

    public static void reportTaskEndStatus(Task taskPtr) {
        if (s_usePre122Format) {
            return;
        }
        s_endStatusCalledLast = true;
        String verifyStr = null;
        Trace.out((String)("Error message ID's for task (if found): " + taskPtr.getElementName() + " [" + taskPtr.getErrorMessageIDs() + "]"));
        String failedStatus = FAILED.toUpperCase() + taskPtr.getErrorMessageIDs();
        String warnStatus = STR_WARNING + taskPtr.getErrorMessageIDs();
        m_dataPointsVerified += taskPtr.getDataPointsVerified();
        String verificationDetailsStr = taskPtr.getTaskVerificationDetailsContent();
        if (!taskPtr.hasCreatedTasks() && verificationDetailsStr.length() == 0 && s_reportVerifyingCalledLast) {
            verifyStr = taskPtr.getResultSet().getStatus() == 1 ? PASSED.toUpperCase() : (taskPtr.getResultSet().getStatus() == 4 ? warnStatus : failedStatus);
        } else {
            if (verificationDetailsStr.length() > 0) {
                ReportUtil.reportPrintln(VerificationUtil.LSEP + verificationDetailsStr);
            }
            verifyStr = ReportUtil.addSpaces(taskPtr.getChildTaskLevel(), SPACE_2) + s_prvgMsgBundle.getMessage("0207", false, (Object[])new String[]{taskPtr.getElementName()});
            verifyStr = taskPtr.getResultSet().getStatus() == 1 ? verifyStr + PASSED.toUpperCase() : (taskPtr.getResultSet().getStatus() == 4 ? verifyStr + warnStatus : verifyStr + failedStatus);
        }
        String taskName = "<task_name>:" + taskPtr.getClass().getName();
        if (taskName.contains(".")) {
            taskName = taskName.substring(taskName.lastIndexOf(".") + 1);
        }
        taskName = taskName + ": <elem_name>:" + taskPtr.getElementName();
        taskName = taskName + " <taskID>[" + taskPtr.getTaskID() + "]";
        Trace.out((String)("hasCreatedTasks:[" + taskPtr.hasCreatedTasks() + "]\n" + "Summary for: '" + taskName + "'\n" + verifyStr));
        ReportUtil.reportPrintln(verifyStr);
    }

    public static void reportOperationalSummary(ReportUtilConstants.BasicClusterWareDetails details, List<Task> taskList) {
        if (s_usePre122Format) {
            return;
        }
        Object reportStr = null;
        ReportUtil.reportTaskSummary(details, taskList);
        ReportUtil.reportOperationalSummary(details);
    }

    public static String formatTextWithMargins(String textLine, int leftMarginIndent) {
        return ReportUtil.formatTextWithMargins(textLine, leftMarginIndent, COLW_80, true);
    }

    public static String formatTextWithMargins(String textLine, int leftMarginIndent, boolean indentToError) {
        return ReportUtil.formatTextWithMargins(textLine, leftMarginIndent, COLW_80, indentToError);
    }

    public static String formatTextWithMargins(String textLine, int leftMarginIndent, int rightMargin, boolean indentToError) {
        StringBuffer newTextLine = new StringBuffer();
        String spacePadding = "";
        int errorIndent = textLine.indexOf("PR");
        int textLineSize = textLine.length();
        int indexStart = 0;
        int indexEnd = 0;
        boolean firstLine = true;
        if (textLineSize + leftMarginIndent < rightMargin) {
            newTextLine.append(ReportUtil.addSpaces(leftMarginIndent, SPACE_1));
            newTextLine.append(textLine);
            return newTextLine.toString();
        }
        if (errorIndent == -1) {
            errorIndent = 0;
        }
        String textToProcess = new String(textLine);
        String tempString = null;
        while (textToProcess.length() > 0) {
            if (!firstLine && indentToError) {
                if (leftMarginIndent + errorIndent < rightMargin) {
                    spacePadding = ReportUtil.addSpaces(leftMarginIndent + errorIndent, SPACE_1);
                    indexEnd = rightMargin - (leftMarginIndent + errorIndent);
                } else {
                    indexEnd = rightMargin;
                }
            } else {
                if (leftMarginIndent < rightMargin) {
                    spacePadding = ReportUtil.addSpaces(leftMarginIndent, SPACE_1);
                    indexEnd = rightMargin - leftMarginIndent;
                } else {
                    indexEnd = rightMargin;
                }
                firstLine = false;
            }
            Trace.out((int)1, (String)("Processing string: '" + textToProcess + "'" + "\ntextToProcess.length: " + textToProcess.length() + "\nleftMarginIndent: " + leftMarginIndent + "\nerrorIndent: " + errorIndent + "\nrightMargin: " + rightMargin + "\nspacePadding: '" + spacePadding + "'" + "\nindexStart: " + indexStart + "\nindexEnd: " + indexEnd));
            if (indexEnd > textToProcess.length()) {
                indexEnd = textToProcess.length();
            }
            tempString = textToProcess.substring(indexStart, indexEnd);
            Trace.out((int)1, (String)("tempString: '" + tempString + "'" + VerificationUtil.LSEP + "tempString.length: " + tempString.length()));
            if (tempString.contains(VerificationUtil.LSEP)) {
                indexEnd = tempString.indexOf(VerificationUtil.LSEP);
                if (indexEnd == 0) {
                    newTextLine.append(VerificationUtil.LSEP);
                    textToProcess = textToProcess.substring(VerificationUtil.LSEP.length());
                    continue;
                }
            } else if (tempString.length() != textToProcess.length() && tempString.lastIndexOf(32) != -1) {
                indexEnd = tempString.lastIndexOf(32);
            }
            Trace.out((int)1, (String)("\nspacePadding: '" + spacePadding + "'\nindexStart: " + indexStart + "\nindexEnd: " + indexEnd + "\ntextToProcess: '" + textToProcess + "'"));
            newTextLine.append(spacePadding + textToProcess.substring(indexStart, indexEnd) + (textToProcess.length() <= indexEnd ? "" : VerificationUtil.LSEP));
            if (indexEnd == textToProcess.length() || tempString.lastIndexOf(32) == -1) {
                textToProcess = textToProcess.substring(indexEnd);
                continue;
            }
            Trace.out((int)1, (String)("last index of ' ': " + tempString.lastIndexOf(32) + " text length: " + tempString.length() + "\ntail of tempString: '" + tempString.substring(indexEnd - 2) + "'"));
            if (tempString.lastIndexOf(32) == indexEnd) {
                textToProcess = textToProcess.substring(indexEnd + 1);
                continue;
            }
            textToProcess = textToProcess.substring(indexEnd + VerificationUtil.LSEP.length());
        }
        String formattedString = newTextLine.toString();
        Trace.out((int)1, (String)("Reformatted input string: \n" + textLine + "\nTo string:\n" + formattedString + "\n"));
        return formattedString;
    }

    private static void reportTaskSummary(ReportUtilConstants.BasicClusterWareDetails details, List<Task> taskList) {
        String verifyStr = null;
        if (s_baselineHealthcheck) {
            return;
        }
        Trace.out((String)("taskList size: " + taskList.size()));
        for (int i = 0; i < taskList.size(); ++i) {
            Task taskPtr = taskList.get(i);
            ResultSet taskRS = taskPtr.getResultSet();
            Trace.out((String)("Processing task: '" + taskPtr.getElementName() + "'"));
            if (taskRS.getStatus() == 1) continue;
            if (!m_notifyMessage) {
                verifyStr = VerificationConstants.LSEP + VerificationConstants.LSEP + s_prveMsgBundle.getMessage(taskRS.getStatus() == 4 ? "9907" : "9905", false, (Object[])new String[]{details.getCVUOperation()}) + VerificationConstants.LSEP;
                ReportUtil.reportPrintln(verifyStr);
                m_notifyMessage = true;
            }
            verifyStr = s_prvgMsgBundle.getMessage("0207", false, (Object[])new String[]{taskPtr.getElementName()});
            verifyStr = taskRS.getStatus() == 4 ? verifyStr + STR_WARNING : verifyStr + FAILED.toUpperCase();
            ReportUtil.reportPrintln(ReportUtil.formatTextWithMargins(verifyStr, taskPtr.getChildTaskLevel() * SPACE_2));
            List<VerificationError> operationalErrors = taskRS.getOperationalErrors();
            if (operationalErrors != null && operationalErrors.size() > 0) {
                for (VerificationError ve : operationalErrors) {
                    verifyStr = ve.getErrorMessage();
                    String[] errorMessageArr = verifyStr.split(VerificationConstants.LSEP);
                    Trace.out((int)1, (String)("\nerrorMessageArr: '" + VerificationUtil.strArr2List(errorMessageArr) + "'"));
                    if (errorMessageArr == null || errorMessageArr.length == 0) continue;
                    for (String errMessage : errorMessageArr) {
                        Trace.out((int)1, (String)("errMessage: '" + errMessage + "'"));
                        if (errMessage == null || errMessage.length() == 0) continue;
                        String trimmedErrorMessage = errMessage.trim();
                        ReportUtil.reportPrintln(ReportUtil.formatTextWithMargins(trimmedErrorMessage, taskPtr.getChildTaskLevel() * SPACE_2));
                    }
                }
                ReportUtil.reportPrint(VerificationConstants.LSEP);
            }
            if (taskRS.hasNodeResults()) {
                List<VerificationResult> nrList = null;
                try {
                    nrList = taskRS.getOperationalNodeResults();
                }
                catch (NodeResultsUnavailableException nre) {
                    Trace.out((String)"APPLICATION_ERROR: NodeResultsUnavailableException thrown when hasNodeResults() returns true");
                    nrList = null;
                }
                if (nrList != null) {
                    boolean nodeResultMessageHeader = false;
                    for (VerificationResult nres : nrList) {
                        List<VerificationError> errorList = nres.getErrors();
                        for (VerificationError err : errorList) {
                            verifyStr = nres.getNode() + ": " + err.getErrorMessage();
                            ReportUtil.reportPrintln(ReportUtil.formatTextWithMargins(verifyStr, taskPtr.getChildTaskLevel() * SPACE_2));
                        }
                        if (errorList.size() <= 0) continue;
                        ReportUtil.reportPrint(VerificationConstants.LSEP);
                    }
                }
            }
            if (!taskPtr.hasCreatedTasks()) continue;
            ArrayList<Task> childTasks = new ArrayList<Task>();
            for (VerificationTask vTask : taskPtr.getCreatedTasks()) {
                childTasks.add((Task)vTask);
            }
            ReportUtil.reportTaskSummary(details, childTasks);
        }
    }

    public static void reportOperationalSummary(ReportUtilConstants.BasicClusterWareDetails details) {
        String outputMessage = null;
        outputMessage = ReportUtil.getPaddedStr(s_prveMsgBundle.getMessage("9900", false), COLW_30) + details.getCVUOperation();
        ReportUtil.reportPrintln(VerificationUtil.LSEP + outputMessage);
        outputMessage = ReportUtil.getPaddedStr(s_prveMsgBundle.getMessage("9901", false), COLW_30) + DateFormat.getDateTimeInstance().format(details.getTimeStamp().getTime());
        ReportUtil.reportPrintln(outputMessage);
        if (VerificationUtil.isStringGood(details.getClusterName())) {
            outputMessage = ReportUtil.getPaddedStr(s_prveMsgBundle.getMessage("10005", false) + ": ", COLW_30) + details.getClusterName();
            ReportUtil.reportPrintln(outputMessage);
        }
        if (VerificationUtil.isStringGood(details.getClusterwareVersion())) {
            outputMessage = ReportUtil.getPaddedStr(s_prveMsgBundle.getMessage("10049", false) + ": ", COLW_30) + details.getClusterwareVersion();
            ReportUtil.reportPrintln(outputMessage);
        }
        if (VerificationUtil.isStringGood(details.getCrsHome())) {
            outputMessage = ReportUtil.getPaddedStr(s_prveMsgBundle.getMessage("10037", false) + ": ", COLW_30) + details.getCrsHome();
            ReportUtil.reportPrintln(outputMessage);
        } else if (VerificationUtil.isStringGood(details.getCVUHome())) {
            outputMessage = ReportUtil.getPaddedStr(s_prveMsgBundle.getMessage("9902", false), COLW_30) + details.getCVUHome();
            ReportUtil.reportPrintln(outputMessage);
        }
        if (VerificationUtil.isStringGood(details.getCrsUserName())) {
            outputMessage = ReportUtil.getPaddedStr(s_prveMsgBundle.getMessage("9999", false) + ": ", COLW_30) + details.getCrsUserName();
            ReportUtil.reportPrintln(outputMessage);
        }
        if (VerificationUtil.isStringGood(details.getOsPlatform())) {
            outputMessage = ReportUtil.getPaddedStr(s_prveMsgBundle.getMessage("10050", false) + ": ", COLW_30) + details.getOsPlatform();
            ReportUtil.reportPrintln(outputMessage);
        }
    }

    public static void writeColHeaders(String hdr1) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders(hdr1);
        }
    }

    public static void surewriteColHeaders(String hdr1) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        int col1 = COLW_36;
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr1, col1));
        ReportUtil.reportPrintln(VerificationConstants.LSEP + spacer + ReportUtil.getPaddedStr(hdr1, col1));
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(col1));
        ReportUtil.reportPrintln(spacer + ReportUtil.getHdrSep(col1));
    }

    public static void writeRecord(String col1) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord(col1);
        }
    }

    public static void surewriteRecord(String col1) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col1, COLW_36));
        ReportUtil.reportPrintln(spacer + ReportUtil.getPaddedStr(col1, COLW_36));
    }

    public static void writeColHeaders(String hdr1, String hdr2) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders(hdr1, hdr2);
        }
    }

    public static void surewriteColHeaders(String hdr1, String hdr2) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        int col1 = COLW_36;
        int col2 = COLW_24;
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, col1) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr2, col2));
        ReportUtil.reportPrintln(VerificationConstants.LSEP + spacer + ReportUtil.getPaddedStr(hdr1, col1) + spacer + ReportUtil.getPaddedStr(hdr2, col2));
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(col1) + spacer);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(col2));
        ReportUtil.reportPrintln(spacer + ReportUtil.getHdrSep(col1) + spacer + ReportUtil.getHdrSep(col2));
    }

    public static void reportwriteColHeaders(String hdr1, String hdr2) {
        Task taskPtr = m_taskDetailsBufferReference;
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        int col1 = COLW_36;
        int col2 = COLW_24;
        String outputStr = ReportUtil.getPaddedStr(hdr1, col1) + spacer + ReportUtil.getPaddedStr(hdr2, col2);
        taskPtr.addTaskVerificationDetails(ReportUtil.formatTextWithMargins(outputStr, taskPtr.getChildTaskLevel() * SPACE_2) + VerificationConstants.LSEP);
        outputStr = ReportUtil.getHdrSep(col1) + spacer + ReportUtil.getHdrSep(col2);
        taskPtr.addTaskVerificationDetails(ReportUtil.formatTextWithMargins(outputStr, taskPtr.getChildTaskLevel() * SPACE_2) + VerificationConstants.LSEP);
    }

    public static void writeRecord(String col1, String col2) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord(col1, col2);
        }
    }

    public static void surewriteRecord(String col1, String col2) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, COLW_36) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col2, COLW_24));
        ReportUtil.reportPrintln(spacer + ReportUtil.getPaddedStr(col1, COLW_36) + spacer + ReportUtil.getPaddedStr(col2, COLW_24));
    }

    public static void reportwriteRecord(String col1, String col2) {
        Task taskPtr = m_taskDetailsBufferReference;
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        String outputStr = ReportUtil.getPaddedStr(col1, COLW_36) + spacer + ReportUtil.getPaddedStr(col2, COLW_24);
        taskPtr.addTaskVerificationDetails(ReportUtil.formatTextWithMargins(outputStr, taskPtr.getChildTaskLevel() * SPACE_2) + VerificationConstants.LSEP);
    }

    public static void writeEqualColHeaders(String hdr1, String hdr2) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteEqualColHeaders(hdr1, hdr2);
        }
    }

    public static void surewriteEqualColHeaders(String hdr1, String hdr2) {
        String spacer_2 = ReportUtil.getPaddedStr("", SPACE_2);
        String spacer_8 = ReportUtil.getPaddedStr("", SPACE_8);
        int col1 = COLW_1OF2_EQUAL;
        int col2 = COLW_2OF2_EQUAL;
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, col1) + spacer_8);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr2, col2));
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getHdrSep(col1) + spacer_8);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(col2));
        ReportUtil.reportPrintln(VerificationConstants.LSEP + spacer_2 + ReportUtil.getPaddedStr(hdr1, col1) + spacer_8 + ReportUtil.getPaddedStr(hdr2, col2));
        ReportUtil.reportPrintln(spacer_2 + ReportUtil.getHdrSep(col1) + spacer_8 + ReportUtil.getHdrSep(col2));
    }

    public static void writeEqualRecord(String col1, String col2) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteEqualRecord(col1, col2);
        }
    }

    public static void surewriteEqualRecord(String col1, String col2) {
        String spacer_2 = ReportUtil.getPaddedStr("", SPACE_2);
        String spacer_8 = ReportUtil.getPaddedStr("", SPACE_8);
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, COLW_1OF2_EQUAL) + spacer_8);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col2, COLW_2OF2_EQUAL));
        ReportUtil.reportPrintln(spacer_2 + ReportUtil.getPaddedStr(col1, COLW_1OF2_EQUAL) + spacer_8 + ReportUtil.getPaddedStr(col2, COLW_2OF2_EQUAL));
    }

    public static void writeColHeaders(String hdr1, String hdr2, String hdr3, String hdr4) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders(hdr1, hdr2, hdr3, hdr4);
        }
    }

    public static void surewriteColHeaders(String hdr1, String hdr2, String hdr3, String hdr4) {
        String spacer_2 = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, WOFCOL1) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr2, WOFCOL2) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr3, WOFCOL3) + spacer_2);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr4, WOFCOL4));
        ReportUtil.reportPrintln(VerificationConstants.LSEP + spacer_2 + ReportUtil.getPaddedStr(hdr1, WOFCOL1) + spacer_2 + ReportUtil.getPaddedStr(hdr2, WOFCOL2) + spacer_2 + ReportUtil.getPaddedStr(hdr3, WOFCOL3) + spacer_2 + ReportUtil.getPaddedStr(hdr4, WOFCOL4));
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getHdrSep(WOFCOL1) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getHdrSep(WOFCOL2) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getHdrSep(WOFCOL3) + spacer_2);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(WOFCOL4));
        ReportUtil.reportPrintln(spacer_2 + ReportUtil.getHdrSep(WOFCOL1) + spacer_2 + ReportUtil.getHdrSep(WOFCOL2) + spacer_2 + ReportUtil.getHdrSep(WOFCOL3) + spacer_2 + ReportUtil.getHdrSep(WOFCOL4));
    }

    public static void writeRecord(String col1, String col2, String col3, String col4) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord(col1, col2, col3, col4);
        }
    }

    public static void surewriteRecord(String col1, String col2, String col3, String col4) {
        String spacer_2 = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, WOFCOL1) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col2, WOFCOL2) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col3, WOFCOL3) + spacer_2);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col4, WOFCOL4));
        ReportUtil.reportPrintln(spacer_2 + ReportUtil.getPaddedStr(col1, WOFCOL1) + spacer_2 + ReportUtil.getPaddedStr(col2, WOFCOL2) + spacer_2 + ReportUtil.getPaddedStr(col3, WOFCOL3) + spacer_2 + ReportUtil.getPaddedStr(col4, WOFCOL4));
    }

    public static void writeColHeaders(String hdr1, String hdr2, String hdr3) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders(hdr1, hdr2, hdr3);
        }
    }

    public static void reportwriteColHeaders(String hdr1, String hdr2, String hdr3) {
        Task taskPtr = m_taskDetailsBufferReference;
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        String outputStr = ReportUtil.getPaddedStr(hdr1, WOFCOL1) + spacer + ReportUtil.getPaddedStr(hdr2, WOFCOL2) + spacer + ReportUtil.getPaddedStr(hdr3, WOFCOL3);
        taskPtr.addTaskVerificationDetails(ReportUtil.formatTextWithMargins(outputStr, taskPtr.getChildTaskLevel() * SPACE_2) + VerificationConstants.LSEP);
        outputStr = ReportUtil.getHdrSep(WOFCOL1) + spacer + ReportUtil.getHdrSep(WOFCOL2) + spacer + ReportUtil.getHdrSep(WOFCOL3);
        taskPtr.addTaskVerificationDetails(ReportUtil.formatTextWithMargins(outputStr, taskPtr.getChildTaskLevel() * SPACE_2) + VerificationConstants.LSEP);
    }

    public static void reportaddTableCaption(String caption) {
        Task taskPtr = m_taskDetailsBufferReference;
        taskPtr.addTaskVerificationDetails(ReportUtil.formatTextWithMargins(caption, taskPtr.getChildTaskLevel() * SPACE_2) + VerificationConstants.LSEP);
    }

    public static void surewriteColHeaders(String hdr1, String hdr2, String hdr3) {
        String spacer_2 = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, WOFCOL1) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr2, WOFCOL2) + spacer_2);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr3, WOFCOL3));
        ReportUtil.reportPrintln(VerificationConstants.LSEP + spacer_2 + ReportUtil.getPaddedStr(hdr1, WOFCOL1) + spacer_2 + ReportUtil.getPaddedStr(hdr2, WOFCOL2) + spacer_2 + ReportUtil.getPaddedStr(hdr3, WOFCOL3));
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getHdrSep(WOFCOL1) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getHdrSep(WOFCOL2) + spacer_2);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(WOFCOL3));
        ReportUtil.reportPrintln(spacer_2 + ReportUtil.getHdrSep(WOFCOL1) + spacer_2 + ReportUtil.getHdrSep(WOFCOL2) + spacer_2 + ReportUtil.getHdrSep(WOFCOL3));
    }

    public static void writeRecord(String col1, String col2, String col3) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord(col1, col2, col3);
        }
    }

    public static void reportwriteRecord(String col1, String col2, String col3) {
        Task taskPtr = m_taskDetailsBufferReference;
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        String outputStr = ReportUtil.getPaddedStr(col1, WOFCOL1) + spacer + ReportUtil.getPaddedStr(col2, WOFCOL2) + spacer + ReportUtil.getPaddedStr(col3, WOFCOL3);
        taskPtr.addTaskVerificationDetails(ReportUtil.formatTextWithMargins(outputStr, taskPtr.getChildTaskLevel() * SPACE_2) + VerificationConstants.LSEP);
    }

    public static void surewriteRecord(String col1, String col2, String col3) {
        String spacer_2 = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, WOFCOL1) + spacer_2);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col2, WOFCOL2) + spacer_2);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col3, WOFCOL3));
        ReportUtil.reportPrintln(spacer_2 + ReportUtil.getPaddedStr(col1, WOFCOL1) + spacer_2 + ReportUtil.getPaddedStr(col2, WOFCOL2) + spacer_2 + ReportUtil.getPaddedStr(col3, WOFCOL3));
    }

    public static void writeColHeaders_2eq(String hdr1, String hdr2, String hdr3) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders_2eq(hdr1, hdr2, hdr3);
        }
    }

    public static void surewriteColHeaders_2eq(String hdr1, String hdr2, String hdr3) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, COLW_30) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr2, COLW_30) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr3, COLW_16));
        ReportUtil.reportPrintln(VerificationConstants.LSEP + spacer + ReportUtil.getPaddedStr(hdr1, COLW_30) + spacer + ReportUtil.getPaddedStr(hdr2, COLW_30) + spacer + ReportUtil.getPaddedStr(hdr3, COLW_16));
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_30) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_30) + spacer);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(COLW_16));
        ReportUtil.reportPrintln(spacer + ReportUtil.getHdrSep(COLW_30) + spacer + ReportUtil.getHdrSep(COLW_30) + spacer + ReportUtil.getHdrSep(COLW_16));
    }

    public static void writeRecord_2eq(String col1, String col2, String col3) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord_2eq(col1, col2, col3);
        }
    }

    public static void surewriteRecord_2eq(String col1, String col2, String col3) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, COLW_30) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col2, COLW_30) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col3, COLW_16));
        ReportUtil.reportPrintln(spacer + ReportUtil.getPaddedStr(col1, COLW_30) + spacer + ReportUtil.getPaddedStr(col2, COLW_30) + spacer + ReportUtil.getPaddedStr(col3, COLW_16));
    }

    public static void writeColHeaders(String hdr1, String hdr2, String hdr3, String hdr4, String hdr5) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders(hdr1, hdr2, hdr3, hdr4, hdr5);
        }
    }

    public static void surewriteColHeaders(String hdr1, String hdr2, String hdr3, String hdr4, String hdr5) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, COLW_16) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr2, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr3, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr4, COLW_12) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr5, COLW_16));
        ReportUtil.reportPrintln(VerificationConstants.LSEP + spacer + ReportUtil.getPaddedStr(hdr1, COLW_16) + spacer + ReportUtil.getPaddedStr(hdr2, COLW_12) + spacer + ReportUtil.getPaddedStr(hdr3, COLW_12) + spacer + ReportUtil.getPaddedStr(hdr4, COLW_12) + spacer + ReportUtil.getPaddedStr(hdr5, COLW_16));
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_16) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_12) + spacer);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(COLW_16));
        ReportUtil.reportPrintln(spacer + ReportUtil.getHdrSep(COLW_16) + spacer + ReportUtil.getHdrSep(COLW_12) + spacer + ReportUtil.getHdrSep(COLW_12) + spacer + ReportUtil.getHdrSep(COLW_12) + spacer + ReportUtil.getHdrSep(COLW_16));
    }

    public static void writeRecord(String col1, String col2, String col3, String col4, String col5) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord(col1, col2, col3, col4, col5);
        }
    }

    public static void surewriteRecord(String col1, String col2, String col3, String col4, String col5) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, COLW_16) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col2, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col3, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col4, COLW_12) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col5, COLW_16));
        ReportUtil.reportPrintln(spacer + ReportUtil.getPaddedStr(col1, COLW_16) + spacer + ReportUtil.getPaddedStr(col2, COLW_12) + spacer + ReportUtil.getPaddedStr(col3, COLW_12) + spacer + ReportUtil.getPaddedStr(col4, COLW_12) + spacer + ReportUtil.getPaddedStr(col5, COLW_16));
    }

    public static void writeColHeaders(String hdr1, String hdr2, String hdr3, String hdr4, String hdr5, String hdr6) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders(hdr1, hdr2, hdr3, hdr4, hdr5, hdr6);
        }
    }

    public static void surewriteColHeaders(String hdr1, String hdr2, String hdr3, String hdr4, String hdr5, String hdr6) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, COLW_16) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr2, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr3, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr4, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr5, COLW_12) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr6, COLW_12));
        ReportUtil.reportPrintln(VerificationConstants.LSEP + spacer + ReportUtil.getPaddedStr(hdr1, COLW_16) + spacer + ReportUtil.getPaddedStr(hdr2, COLW_12) + spacer + ReportUtil.getPaddedStr(hdr3, COLW_12) + spacer + ReportUtil.getPaddedStr(hdr4, COLW_12) + spacer + ReportUtil.getPaddedStr(hdr5, COLW_12) + spacer + ReportUtil.getPaddedStr(hdr6, COLW_12));
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_16) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_12) + spacer);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(COLW_12));
        ReportUtil.reportPrintln(spacer + ReportUtil.getHdrSep(COLW_16) + spacer + ReportUtil.getHdrSep(COLW_12) + spacer + ReportUtil.getHdrSep(COLW_12) + spacer + ReportUtil.getHdrSep(COLW_12) + spacer + ReportUtil.getHdrSep(COLW_12) + spacer + ReportUtil.getHdrSep(COLW_12));
    }

    public static void writeRecord(String col1, String col2, String col3, String col4, String col5, String col6) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord(col1, col2, col3, col4, col5, col6);
        }
    }

    public static void surewriteRecord(String col1, String col2, String col3, String col4, String col5, String col6) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_2);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, COLW_16) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col2, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col3, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col4, COLW_12) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col5, COLW_12) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col6, COLW_12));
        ReportUtil.reportPrintln(spacer + ReportUtil.getPaddedStr(col1, COLW_16) + spacer + ReportUtil.getPaddedStr(col2, COLW_12) + spacer + ReportUtil.getPaddedStr(col3, COLW_12) + spacer + ReportUtil.getPaddedStr(col4, COLW_12) + spacer + ReportUtil.getPaddedStr(col5, COLW_12) + spacer + ReportUtil.getPaddedStr(col6, COLW_12));
    }

    public static void writeColHeaders(String hdr1, String hdr2, String hdr3, String hdr4, String hdr5, String hdr6, String hdr7) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteColHeaders(hdr1, hdr2, hdr3, hdr4, hdr5, hdr6, hdr7);
        }
    }

    public static void surewriteColHeaders(String hdr1, String hdr2, String hdr3, String hdr4, String hdr5, String hdr6, String hdr7) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_1);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr1, COLW_6) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr2, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr3, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr4, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr5, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(hdr6, COLW_17) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(hdr7, COLW_6));
        ReportUtil.reportPrintln(VerificationConstants.LSEP + spacer + ReportUtil.getPaddedStr(hdr1, COLW_6) + spacer + ReportUtil.getPaddedStr(hdr2, COLW_15) + spacer + ReportUtil.getPaddedStr(hdr3, COLW_15) + spacer + ReportUtil.getPaddedStr(hdr4, COLW_15) + spacer + ReportUtil.getPaddedStr(hdr5, COLW_15) + spacer + ReportUtil.getPaddedStr(hdr6, COLW_17) + spacer + ReportUtil.getPaddedStr(hdr7, COLW_6));
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_6) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getHdrSep(COLW_17) + spacer);
        ReportUtil.sureprintln(ReportUtil.getHdrSep(COLW_6));
        ReportUtil.reportPrintln(spacer + ReportUtil.getHdrSep(COLW_6) + spacer + ReportUtil.getHdrSep(COLW_15) + spacer + ReportUtil.getHdrSep(COLW_15) + spacer + ReportUtil.getHdrSep(COLW_15) + spacer + ReportUtil.getHdrSep(COLW_15) + spacer + ReportUtil.getHdrSep(COLW_17) + spacer + ReportUtil.getHdrSep(COLW_6));
    }

    public static void writeRecord(String col1, String col2, String col3, String col4, String col5, String col6, String col7) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.surewriteRecord(col1, col2, col3, col4, col5, col6, col7);
        }
    }

    public static void surewriteRecord(String col1, String col2, String col3, String col4, String col5, String col6, String col7) {
        String spacer = ReportUtil.getPaddedStr("", SPACE_1);
        ReportUtil.sureprint(spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col1, COLW_6) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col2, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col3, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col4, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col5, COLW_15) + spacer);
        ReportUtil.sureprint(ReportUtil.getPaddedStr(col6, COLW_17) + spacer);
        ReportUtil.sureprintln(ReportUtil.getPaddedStr(col7, COLW_6));
        ReportUtil.reportPrintln(spacer + ReportUtil.getPaddedStr(col1, COLW_6) + spacer + ReportUtil.getPaddedStr(col2, COLW_15) + spacer + ReportUtil.getPaddedStr(col3, COLW_15) + spacer + ReportUtil.getPaddedStr(col4, COLW_15) + spacer + ReportUtil.getPaddedStr(col5, COLW_15) + spacer + ReportUtil.getPaddedStr(col6, COLW_17) + spacer + ReportUtil.getPaddedStr(col7, COLW_6));
    }

    private static String getPaddedStr(String str, int width) {
        if (str == null) {
            return ReportUtil.addSpaces(1, width);
        }
        if (str.length() >= width) {
            return str;
        }
        return new String(str + ReportUtil.addSpaces(1, width - str.length()));
    }

    private static String getHdrSep(int hwidth) {
        return SEPARATOR.substring(0, hwidth);
    }

    public static void print(String str) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.sureprint(str);
        }
    }

    public static void sureprint(String str) {
        if (isCLImode && !ReportUtil.isFormat() && !s_baselineHealthcheck) {
            ReportUtil.quietprint(str);
        }
    }

    public static void quietprint(String str) {
        if (!VerificationUtil.isCVUResource()) {
            if (!s_isQuietMode && (s_baselineHealthcheck || s_usePre122Format)) {
                System.out.print(str);
            }
            if (!s_usePre122Format && m_taskDetailsBufferReference != null) {
                Trace.out((String)("quietprint: adding details to buffer for task: " + m_taskDetailsBufferReference.getElementName()));
                Trace.out((String)("BEFORE: " + m_taskDetailsBufferReference.getTaskVerificationDetailsContent()));
                Trace.out((String)("AFTER: " + m_taskDetailsBufferReference.getTaskVerificationDetailsContent()));
            }
        } else {
            try {
                if (s_printWriter == null) {
                    s_printWriter = new PrintWriter((Writer)new FileWriter(VerificationUtil.getLogFileName()), true);
                }
                s_printWriter.print(str);
            }
            catch (IOException e) {
                System.out.print(str);
            }
        }
    }

    public static void println(String str) {
        if (ReportUtil.isVerbose()) {
            ReportUtil.sureprintln(str);
        }
    }

    public static void sureprintln(String str) {
        if (isCLImode && !ReportUtil.isFormat() && !s_baselineHealthcheck && s_usePre122Format) {
            ReportUtil.quietprintln(str);
        }
    }

    public static void quietprintln(String str) {
        if (!VerificationUtil.isCVUResource()) {
            if (!s_isQuietMode && (s_baselineHealthcheck || s_usePre122Format)) {
                System.out.println(str);
            }
            if (!s_usePre122Format && m_taskDetailsBufferReference != null) {
                Task taskPtr = m_taskDetailsBufferReference;
                Trace.out((String)("adding details to buffer for task: " + taskPtr.getElementName()));
            }
        } else {
            try {
                if (s_printWriter == null) {
                    s_printWriter = new PrintWriter((Writer)new FileWriter(VerificationUtil.getLogFileName()), true);
                }
                s_printWriter.println(str);
            }
            catch (IOException e) {
                System.out.println(str);
            }
        }
    }

    public static void blankln() {
        if (ReportUtil.isVerbose()) {
            ReportUtil.sureblankln();
        }
    }

    public static void sureblankln() {
        if (isCLImode && !ReportUtil.isFormat() && !s_baselineHealthcheck) {
            ReportUtil.quietblankln();
        }
    }

    public static void quietblankln() {
        if (!s_isQuietMode && (s_baselineHealthcheck || s_usePre122Format)) {
            System.out.println("");
        }
        if (!s_usePre122Format && m_taskDetailsBufferReference != null) {
            Trace.out((String)("adding details to buffer for task: " + m_taskDetailsBufferReference.getElementName()));
        }
    }

    public static void blankln(int count) {
        if (ReportUtil.isVerbose()) {
            for (int i = 0; i < count; ++i) {
                ReportUtil.blankln();
            }
        }
    }

    public static void sureblankln(int count) {
        if (isCLImode && !ReportUtil.isFormat()) {
            ReportUtil.quietblankln(count);
        }
    }

    public static void quietblankln(int count) {
        for (int i = 0; i < count; ++i) {
            ReportUtil.quietblankln();
        }
    }

    public static String unitize(String value, int format) {
        return ReportUtil.unitizeSize(value, StorageUnit.BYTE, format);
    }

    public static String unitizeByte(String value) {
        return ReportUtil.unitize(value, 2);
    }

    public static String unitizeSize(String value, StorageUnit sizeInUnits, int format) {
        StorageSize val;
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("====Attempting to unitize '" + value + (Object)((Object)sizeInUnits) + "'"));
        }
        try {
            val = new StorageSize(Double.parseDouble(value), sizeInUnits);
        }
        catch (NumberFormatException e) {
            Trace.out((String)("Invalid value '" + value + "'. Did not attempt to unitize"));
            return value;
        }
        return ReportUtil.unitizeSize(val, format);
    }

    public static String unitizeSize(StorageSize val, int format) {
        double d;
        if (val == null) {
            Trace.out((String)"Null memory size value ''. Did not attempt to unitize");
            return null;
        }
        String fmttxt = null;
        String kbText = "";
        DecimalFormat numFormat = new DecimalFormat("###.####");
        numFormat.setMaximumFractionDigits(4);
        numFormat.setDecimalSeparatorAlwaysShown(false);
        if (format == 2) {
            double kbVal = val.sizeIn(StorageUnit.KBYTE);
            kbText = "(" + kbVal + "KB)";
        } else if (format != 1) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"==== Invalid unitizing format. Proceeding with default");
            }
            format = 1;
        }
        double dFinalval = val.sizeIn(StorageUnit.TBYTE);
        if (d >= 1.0) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("==== " + val + " in TB: " + dFinalval));
            }
            fmttxt = numFormat.format(dFinalval) + "TB " + kbText;
        } else {
            double d2;
            dFinalval = val.sizeIn(StorageUnit.GBYTE);
            if (d2 >= 1.0) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("==== " + val + " in GB: " + dFinalval));
                }
                fmttxt = numFormat.format(dFinalval) + "GB " + kbText;
            } else {
                double d3;
                dFinalval = val.sizeIn(StorageUnit.MBYTE);
                if (d3 >= 1.0) {
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("==== " + val + " in MB: " + dFinalval));
                    }
                    fmttxt = numFormat.format(dFinalval) + "MB " + kbText;
                } else {
                    double d4;
                    dFinalval = val.sizeIn(StorageUnit.KBYTE);
                    if (d4 >= 1.0) {
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)("==== " + val + " in KB: " + dFinalval));
                        }
                        fmttxt = numFormat.format(dFinalval) + "KB ";
                    } else {
                        fmttxt = val.sizeIn(StorageUnit.BYTE) + " bytes";
                    }
                }
            }
        }
        return fmttxt;
    }

    public static String unitizeSize(String value, StorageUnit sizeInUnits) {
        return ReportUtil.unitizeSize(value, sizeInUnits, 2);
    }

    public static String unitizeSize(StorageSize size) {
        return ReportUtil.unitizeSize(size, 2);
    }

    public static String addSpaces(int multiplier) {
        return ReportUtil.addSpaces(multiplier, SPACE_2);
    }

    public static String addSpaces(int multiplier, int numberOfSpaces) {
        if (multiplier == 0 || numberOfSpaces == 0) {
            return new String("");
        }
        StringBuffer spaceBuffer = new StringBuffer();
        for (int i = 0; i < numberOfSpaces; ++i) {
            spaceBuffer.append(" ");
        }
        String spaceBufferString = spaceBuffer.toString();
        spaceBuffer = new StringBuffer();
        for (int i = 0; i < multiplier; ++i) {
            spaceBuffer.append(spaceBufferString);
        }
        return spaceBuffer.toString();
    }

    public static void printCopyright() {
        ReportUtil.sureprintln(s_msgBundle.getMessage("0004", false));
    }

    public static void printReportHeader() {
        if (pm.checkArgComp()) {
            String compName = pm.getCompID();
            Trace.out((String)("Component name in ReportUtil is:" + compName));
            String compMsg = ReportUtil.getCompMsg(compName);
            Trace.out((String)("Component ID in ReportUtil is:" + compMsg));
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage("8110", false, (Object[])new String[]{compMsg}));
        } else if (pm.checkArgStage()) {
            boolean isPre = pm.checkArgPre();
            String stageHdrID = isPre ? "8111" : "8112";
            String stageName = pm.getStageID();
            String stageMsg = ReportUtil.getStageMsg(stageName);
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage(stageHdrID, false, (Object[])new String[]{stageMsg}));
        } else {
            Trace.out((String)"ERROR: Stage or comp was not defined");
            ReportUtil.sureprintln("ERROR: Stage or comp can not be handled.");
        }
    }

    public static String getCompMsg(String compName) {
        String compMsg = null;
        if (compName.equals("nodecon")) {
            compMsg = s_msgBundle.getMessage("8311", false);
        } else if (compName.equals("nodereach")) {
            compMsg = s_msgBundle.getMessage("8309", false);
        } else if (compName.equals("space")) {
            compMsg = s_msgBundle.getMessage("8314", false);
        } else if (compName.equals("ssa")) {
            compMsg = s_msgBundle.getMessage("8313", false);
        } else if (compName.equals("sys")) {
            compMsg = s_msgBundle.getMessage("8315", false);
        } else if (compName.equals("admprv")) {
            compMsg = s_msgBundle.getMessage("8320", false);
        } else if (compName.equals("cfs")) {
            compMsg = s_msgBundle.getMessage("8312", false);
        } else if (compName.equals("clumgr")) {
            compMsg = s_msgBundle.getMessage("8317", false);
        } else if (compName.equals("clu")) {
            compMsg = s_msgBundle.getMessage("8316", false);
        } else if (compName.equals("ocr")) {
            compMsg = s_msgBundle.getMessage("8318", false);
        } else if (compName.equals("olr")) {
            compMsg = s_msgBundle.getMessage("8323", false);
        } else if (compName.equals("ha")) {
            compMsg = s_msgBundle.getMessage("8324", false);
        } else if (compName.equals("crs")) {
            compMsg = s_msgBundle.getMessage("8319", false);
        } else if (compName.equals("peer")) {
            compMsg = s_msgBundle.getMessage("8321", false);
        } else if (compName.equals("nodeapp")) {
            compMsg = s_msgBundle.getMessage("8322", false);
        } else if (compName.equals("scan")) {
            compMsg = s_msgBundle.getMessage("8335", false);
        } else if (compName.equals("software")) {
            compMsg = s_msgBundle.getMessage("8328", false);
        } else if (compName.equals("asm")) {
            compMsg = s_msgBundle.getMessage("8336", false);
        } else if (compName.equals("acfs")) {
            compMsg = s_msgBundle.getMessage("8330", false);
        } else if (compName.equals("gns")) {
            compMsg = s_msgBundle.getMessage("8333", false);
        } else if (compName.equals("gpnp")) {
            compMsg = s_msgBundle.getMessage("8334", false);
        } else if (compName.equals("ohasd")) {
            compMsg = s_msgBundle.getMessage("8337", false);
        } else if (compName.equals("clocksync")) {
            compMsg = s_msgBundle.getMessage("8338", false);
        } else if (compName.equals("vdisk")) {
            compMsg = s_msgBundle.getMessage("8339", false);
        } else if (compName.equals("health")) {
            compMsg = s_msgBundle.getMessage("8340", false);
        } else if (compName.equals("dns")) {
            compMsg = s_msgBundle.getMessage("8341", false);
        } else if (compName.equals("dhcp")) {
            compMsg = s_msgBundle.getMessage("8342", false);
        } else if (compName.equals("healthcheck")) {
            compMsg = s_prvgMsgBundle.getMessage("0205", false);
        } else if (compName.equals("freespace")) {
            compMsg = s_prvgMsgBundle.getMessage("0326", false);
        } else if (compName.equals("baseline")) {
            compMsg = s_prvgMsgBundle.getMessage("11624", false);
        } else if (compName.equals("farmcheck")) {
            compMsg = s_prvgMsgBundle.getMessage("0275", false);
        }
        return compMsg;
    }

    public static String getStageMsg(String stageName) {
        String stageMsg = null;
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("getStageMsg(): stageName = " + stageName));
        }
        if (stageName.equals("hwos")) {
            stageMsg = s_msgBundle.getMessage("8300", false);
        } else if (stageName.equals("cfs")) {
            stageMsg = s_msgBundle.getMessage("8301", false);
        } else if (stageName.equals("crsinst")) {
            stageMsg = s_msgBundle.getMessage("8302", false);
        } else if (stageName.equals("hacfg")) {
            stageMsg = s_msgBundle.getMessage("8325", false);
        } else if (stageName.equals("dbinst")) {
            stageMsg = s_msgBundle.getMessage("8303", false);
        } else if (stageName.equals("dbcfg")) {
            stageMsg = s_msgBundle.getMessage("8305", false);
        } else if (stageName.equals("nodeadd")) {
            stageMsg = s_msgBundle.getMessage("8306", false);
        } else if (stageName.equals("storadd")) {
            stageMsg = s_msgBundle.getMessage("8307", false);
        } else if (stageName.equals("netmod")) {
            stageMsg = s_msgBundle.getMessage("8308", false);
        } else if (stageName.equals("nodeadd")) {
            stageMsg = s_msgBundle.getMessage("8306", false);
        } else if (stageName.equals("nodedel")) {
            stageMsg = s_msgBundle.getMessage("8327", false);
        } else if (stageName.equals("acfscfg")) {
            stageMsg = s_msgBundle.getMessage("8329", false);
        } else if (stageName.equals("appcluster")) {
            stageMsg = s_prvgMsgBundle.getMessage("13200", false);
        }
        return stageMsg;
    }

    public static void printReportFooter(ResultSet resultSet) {
        String statusMsgID = null;
        String compMsg = null;
        String stageMsg = null;
        boolean partFailure = false;
        String footerMessage = null;
        resultSet.traceResultSet("Looking for FINAL status...");
        if (pm.checkArgComp()) {
            String compName = pm.getCompID();
            compMsg = ReportUtil.getCompMsg(compName);
            if (resultSet.anyFailure() && resultSet.anySuccess()) {
                statusMsgID = "8122";
                partFailure = true;
            } else if (resultSet.allSuccess()) {
                statusMsgID = "8121";
            } else {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("compName: " + compName));
                }
                statusMsgID = compName.equals("ha") ? "8130" : "8123";
            }
            footerMessage = s_msgBundle.getMessage(statusMsgID, false, (Object[])new String[]{compMsg});
            ReportUtil.reportPrintln("");
            ReportUtil.reportPrintln(footerMessage);
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(footerMessage);
            if (partFailure) {
                ReportUtil.printFailureSummary(resultSet);
            }
            if (pm.checkArgDisplayStatus()) {
                ReportUtil.printDetailedStatus(resultSet);
            }
        } else if (pm.checkArgStage()) {
            boolean isPre = pm.checkArgPre();
            String stageName = pm.getStageID();
            stageMsg = ReportUtil.getStageMsg(stageName);
            if (resultSet.anyFailure() && resultSet.anySuccess()) {
                statusMsgID = isPre ? "8125" : "8128";
                partFailure = true;
            } else if (resultSet.anySuccess()) {
                statusMsgID = isPre ? "8124" : "8127";
            } else if (isPre) {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("stageMsgID: " + stageMsg));
                }
                statusMsgID = stageName.equals("hacfg") ? "8132" : "8126";
            } else {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("stageMsgID: " + stageMsg));
                }
                statusMsgID = stageName.equals("hacfg") ? "8131" : "8129";
            }
            footerMessage = s_msgBundle.getMessage(statusMsgID, false, (Object[])new String[]{stageMsg});
            ReportUtil.reportPrintln("");
            ReportUtil.reportPrintln(footerMessage);
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(footerMessage);
            if (partFailure) {
                ReportUtil.printFailureSummary(resultSet);
            }
            if (pm.checkArgDisplayStatus()) {
                ReportUtil.printDetailedStatus(resultSet);
            }
        } else {
            Trace.out((String)"ERROR: Stage or comp was not defined");
            ReportUtil.sureprintln("ERROR: Stage or comp can not be handled.");
        }
    }

    private static void printFailureSummary(ResultSet resultSet) {
        String footerMessage = new String("");
        String[] failedNodes = resultSet.getFailureNodes();
        String[] failedASMParameters = resultSet.getFailureASMParameters();
        String[] failedASMInstances = resultSet.getFailureASMInstances();
        String[] failedASMDiskGroups = resultSet.getFailureASMDiskGroups();
        String[] failedASMDisks = resultSet.getFailureASMDisks();
        String[] failedDatabases = resultSet.getFailureDatabases();
        String[] failedDBInstances = resultSet.getFailureDatabaseInstances();
        Trace.out((String)("failedNodes: '" + VerificationUtil.strArr2List(failedNodes) + "'\nfailedASMParameters: '" + VerificationUtil.strArr2List(failedASMParameters) + "'\nfailedASMInstances: '" + VerificationUtil.strArr2List(failedASMInstances) + "'\nfailedASMDiskGroups: '" + VerificationUtil.strArr2List(failedASMDiskGroups) + "'\nfailedASMDisks: '" + VerificationUtil.strArr2List(failedASMDisks) + "'\nfailedDatabases: '" + VerificationUtil.strArr2List(failedDatabases) + "'\nfailedDBInstances: '" + VerificationUtil.strArr2List(failedDBInstances) + "'"));
        footerMessage = footerMessage + ReportUtil.buildFailureSummary(footerMessage, failedNodes, s_msgBundle.getMessage("8102", false));
        footerMessage = footerMessage + ReportUtil.buildFailureSummary(footerMessage, failedASMParameters, s_prvgMsgBundle.getMessage("0503", false));
        footerMessage = footerMessage + ReportUtil.buildFailureSummary(footerMessage, failedASMInstances, s_prvgMsgBundle.getMessage("0504", false));
        footerMessage = footerMessage + ReportUtil.buildFailureSummary(footerMessage, failedASMDiskGroups, s_prvgMsgBundle.getMessage("0505", false));
        footerMessage = footerMessage + ReportUtil.buildFailureSummary(footerMessage, failedASMDisks, s_prvgMsgBundle.getMessage("0506", false));
        footerMessage = footerMessage + ReportUtil.buildFailureSummary(footerMessage, failedDatabases, s_prvgMsgBundle.getMessage("0507", false));
        footerMessage = footerMessage + ReportUtil.buildFailureSummary(footerMessage, failedDBInstances, s_prvgMsgBundle.getMessage("0508", false));
        Trace.out((String)("Footer message: " + footerMessage));
        ReportUtil.reportPrintln(footerMessage);
        ReportUtil.sureprintln(footerMessage);
    }

    private static String buildFailureSummary(String footMsg, String[] failureElements, String errMsg) {
        String errorString = "";
        if (failureElements != null && failureElements.length > 0) {
            if (footMsg.length() > 1) {
                errorString = errorString + VerificationConstants.LSEP;
            }
            errorString = errorString + errMsg + VerificationConstants.LSEP + "\t" + VerificationUtil.strArr2List(failureElements);
        }
        return errorString;
    }

    public static void printErrorHeader(String subject) {
        ReportUtil.sureprintln(VerificationConstants.LSEP + ERROR + " " + subject);
    }

    public static void printError(String msg) {
        ReportUtil.sureprintln(VerificationConstants.LSEP + ERROR + VerificationConstants.LSEP + msg);
    }

    public static void printWarning(String msg) {
        ReportUtil.sureprintln(VerificationConstants.LSEP + WARNING + VerificationConstants.LSEP + msg);
    }

    public static void printWarning(String msg, Vector nodeVect) {
        ReportUtil.sureprintln(VerificationConstants.LSEP + WARNING + VerificationUtil.strVect2List(nodeVect) + VerificationConstants.LSEP + msg);
    }

    public static void printNote(String msg) {
        ReportUtil.sureprintln(VerificationConstants.LSEP + NOTE + VerificationConstants.LSEP + msg);
    }

    public static void printResult(String msg) {
        String prefix = "";
        if (ReportUtil.isVerbose()) {
            prefix = s_msgBundle.getMessage("8506", false);
        }
        ReportUtil.sureprintln(prefix + msg);
    }

    public static void printComment(String msg) {
        String prefix = "";
        if (ReportUtil.isVerbose()) {
            prefix = "Comment: ";
        }
        ReportUtil.sureprintln(prefix + msg);
    }

    public static void printNodelist(String[] nodelist) {
        String text = VerificationUtil.strArr2List(nodelist);
        ReportUtil.println("\t" + text);
    }

    public static void printNodelist(Vector nodelistVec) {
        ReportUtil.printNodelist(nodelistVec.toArray(new String[nodelistVec.size()]));
    }

    public static void printNodelist(Collection nodeCollection) {
        ReportUtil.printNodelist(nodeCollection.toArray(new String[nodeCollection.size()]));
    }

    public static void sureprintNodelist(String[] nodelist) {
        String text = VerificationUtil.strArr2List(nodelist);
        ReportUtil.sureprintln("\t" + text);
    }

    public static void sureprintNodelist(Vector nodelistVec) {
        ReportUtil.sureprintNodelist(nodelistVec.toArray(new String[nodelistVec.size()]));
    }

    public static void sureprintNodelist(Collection nodeCollection) {
        ReportUtil.sureprintNodelist(nodeCollection.toArray(new String[nodeCollection.size()]));
    }

    public static void printErrorNodes(String[] nodelist) {
        if (nodelist == null || nodelist.length <= 0) {
            Trace.out((String)"==== Nodelist is empty or null. Cannot print");
            return;
        }
        String text = VerificationUtil.strArr2List(nodelist);
        String msg = s_msgBundle.getMessage("8505", false);
        if (!ReportUtil.isVerbose()) {
            ReportUtil.sureprintln(msg);
            ReportUtil.sureprintln("\t" + text);
        }
    }

    public static void printErrorNodes(Vector nodelistVec) {
        ReportUtil.printErrorNodes(nodelistVec.toArray(new String[nodelistVec.size()]));
    }

    public static void printErrorNodes(ResultSet resultSet) {
        ReportUtil.printErrorNodes(resultSet.getFailureNodes());
    }

    public static void printErrorWithNodes(String msg, String[] nodelist) {
        if (!ReportUtil.isVerbose()) {
            ReportUtil.sureprintln(VerificationConstants.LSEP + ERROR + VerificationConstants.LSEP + msg);
        }
        ReportUtil.printErrorNodes(nodelist);
    }

    public static void printErrorWithNodes(String msg, Vector nodelistVec) {
        ReportUtil.printErrorWithNodes(msg, nodelistVec.toArray(new String[nodelistVec.size()]));
    }

    public static void printErrorWithNodes(String msg, Collection nodeCollection) {
        ReportUtil.printErrorWithNodes(msg, nodeCollection.toArray(new String[nodeCollection.size()]));
    }

    public static void reportNotRunList(String[] nodelist) {
        if (nodelist == null || nodelist.length <= 0) {
            Trace.out((String)"==== reportNotRunList: empty or null nodelist. Cannot print");
            return;
        }
        if (!ReportUtil.isVerbose()) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("8101", false));
            ReportUtil.sureprintNodelist(nodelist);
        }
    }

    public static void reportNotRunList(Vector vec) {
        ReportUtil.reportNotRunList(vec.toArray(new String[vec.size()]));
    }

    private static void printDetailedStatus(ResultSet rset) {
        Hashtable t = rset.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            ReportUtil.reportPrintln("NODE_STATUS::" + node + ":" + ReportUtil.statusOfResult(result));
            ReportUtil.sureprintln("NODE_STATUS::" + node + ":" + ReportUtil.statusOfResult(result));
        }
        ReportUtil.reportPrintln("OVERALL_STATUS::" + ReportUtil.statusOfResultSet(rset));
        ReportUtil.sureprintln("OVERALL_STATUS::" + ReportUtil.statusOfResultSet(rset));
    }

    public static String statusOfResultSet(ResultSet rset) {
        switch (rset.getStatus()) {
            case 1: {
                return "SUCC";
            }
            case 2: {
                return "EFAIL";
            }
            case 3: {
                return "VFAIL";
            }
            case 4: {
                return "WARNING";
            }
        }
        return "UNKNOWN";
    }

    public static String statusOfResult(Result result) {
        switch (result.getStatus()) {
            case 1: {
                return "SUCC";
            }
            case 2: {
                return "EFAIL";
            }
            case 3: {
                return "VFAIL";
            }
            case 4: {
                return "WARNING";
            }
        }
        return "UNKNOWN";
    }

    public static void reportAllerrors(ResultSet rset) {
        List<VerificationError> errorList = rset.getErrors();
        for (VerificationError err : errorList) {
            ReportUtil.sureprintln(VerificationConstants.LSEP + err.getErrorMessage());
        }
        if (rset.hasNodeResults()) {
            List<VerificationResult> nrList = null;
            try {
                nrList = rset.getNodeResults();
            }
            catch (NodeResultsUnavailableException nre) {
                Trace.out((String)(VerificationConstants.LSEP + "          APPLICATION_ERROR: NodeResultsUnavailableException thrown when hasNodeResults() returns true"));
            }
            if (nrList != null) {
                for (VerificationResult nres : nrList) {
                    errorList = nres.getErrors();
                    for (VerificationError err : errorList) {
                        ReportUtil.sureprintln(VerificationConstants.LSEP + err.getErrorMessage());
                    }
                }
            }
        }
    }

    public static String getUserInput(String msg) throws ConsoleUtilException {
        ConsoleUtil console = new ConsoleUtil();
        String input = console.read(msg);
        return input;
    }

    public static void printGlobalAlertLog(String[] args) {
        HeavyWeightVerificationUtil.printGlobalAlertLog(10051, args);
    }

    protected void finalize() {
        if (s_printWriter != null) {
            s_printWriter.close();
        }
    }

    static {
        s_isQuietModeForSession = false;
        s_isQuietMode = false;
        s_usePre122Format = false;
        s_reportVerifyingCalledLast = false;
        s_endStatusCalledLast = false;
        s_baselineHealthcheck = false;
        m_taskDetailsBufferReference = new TaskAnonymousProxy("ReportUtilDummy");
        s_printWriter = null;
        s_xmlReportTool = null;
        xmlSaveDirectory = null;
        m_numberOfOperations = 0;
        m_dataPointsVerified = 0;
        m_notifyMessage = false;
        try {
            pm = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        isCLImode = VerificationUtil.isCLIMode();
        s_usePre122Format = ParamManager.checkArgOldFormat();
        Trace.out((String)("s_usePre122Format set to: " + s_usePre122Format + " isFormat set to: " + ReportUtil.isFormat()));
    }
}

