/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report;

import java.io.Serializable;
import java.util.HashMap;

public class ReportSerializableObj
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long m_sizeInBytes = 0L;
    private HashMap<Integer, Object> m_objectTable = new HashMap();
    private int m_index = 0;

    protected ReportSerializableObj() {
    }

    public Object getObject(int index) {
        if (index <= this.m_index) {
            return this.m_objectTable.get(index);
        }
        return null;
    }

    public int addObject(Object o) {
        ++this.m_index;
        this.m_sizeInBytes += (long)o.toString().getBytes().length;
        this.m_objectTable.put(this.m_index, o);
        return this.m_index;
    }

    public void deleteObject(int index) {
        this.m_objectTable.put(index, null);
    }

    public void clear() {
        this.m_objectTable.clear();
        this.m_index = 0;
        this.m_sizeInBytes = 0L;
    }

    public int getObjectCount() {
        return this.m_index;
    }

    public long getSizeInBytes() {
        return this.m_sizeInBytes;
    }
}

