/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param.parser;

import java.util.List;
import oracle.ops.verification.framework.param.CLSyntax;
import oracle.ops.verification.framework.param.parser.CLCommand;
import oracle.ops.verification.framework.param.parser.CLSyntaxValidator;
import oracle.ops.verification.framework.param.parser.InvalidCLException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CollectDBNameDBHomeValidator
extends CLSyntaxValidator {
    @Override
    public void isValid(List<String> clTokens, CLCommand command) throws InvalidCLException {
        String collectionType = CVUVariables.getValue(CVUVariableConstants.BASELINE_COLLECT);
        if (VerificationUtil.isStringGood(collectionType)) {
            String dbName = CVUVariables.getValue(CVUVariableConstants.BASELINE_DB);
            if (VerificationUtil.isStringGood(dbName) && !CLSyntax.STR_DATABASE.equals(collectionType) && !CLSyntax.STR_ALL.equals(collectionType)) {
                throw new InvalidCLException(s_msgBundle.getMessage("1056", true));
            }
            String dbHome = CVUVariables.getValue(CVUVariableConstants.BASELINE_DBHOME);
            if (VerificationUtil.isStringGood(dbHome) && !CLSyntax.STR_DATABASE.equals(collectionType) && !CLSyntax.STR_ALL.equals(collectionType)) {
                throw new InvalidCLException(s_msgBundle.getMessage("1057", true));
            }
        } else {
            collectionType = CVUVariables.getValue(CVUVariableConstants.HEALTH_CHECK_COLLECT);
            String dbName = CVUVariables.getValue(CVUVariableConstants.HEALTH_CHECK_DB);
            if (VerificationUtil.isStringGood(collectionType) && VerificationUtil.isStringGood(dbName) && !CLSyntax.STR_DATABASE.equals(collectionType) && !CLSyntax.STR_ALL.equals(collectionType)) {
                throw new InvalidCLException(s_msgBundle.getMessage("1056", true));
            }
        }
    }
}

