/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.network.CommandHandler;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.util.GenericUtil;

class sCommandHandler
extends CommandHandler
implements NetworkConstants {
    private static final String KEY_CONNECTED = "CONNECTED";
    private static final String VAL_CONNECTED_YES = "YES";
    private static final String PING = "ping";
    private static final String PING_OPT_SRC = "-S";
    private static final String PING_COUNT = "-n 1";
    private static final String PING_OPT_TIMEOUT = "-w";
    private static final String PING_OPT_IPV6 = "-6";

    sCommandHandler() {
    }

    @Override
    protected VerificationCommand generateReachabilityCommand(String srcNode, String destNode) {
        String[] arg = new String[2];
        String[] env = null;
        arg[0] = "-checkNetReach";
        arg[1] = destNode;
        return new VerificationCommand(srcNode, arg, env);
    }

    protected VerificationCommand generateIPConnectivityCommand(String srcNode, String srcIP, String destIP) {
        String[] arg = new String[]{"-checkNetCon", srcIP, destIP};
        return new VerificationCommand(srcNode, arg, null);
    }

    protected VerificationCommand generateIPConnectivityCommand(String srcNode, String srcIP, String destIP, int family) {
        String[] arg = new String[]{"-checkNetCon", srcIP, destIP};
        if (family == 6) {
            arg[0] = "-runexe";
            arg[1] = " ping -n 1 -w " + String.valueOf(sCommandHandler.getTimeOut()) + " " + PING_OPT_SRC + " " + srcIP + " " + PING_OPT_IPV6 + " ";
            arg[2] = destIP;
        }
        return new VerificationCommand(srcNode, arg, null);
    }

    @Override
    protected VerificationCommand generateICMPCommandWithoutFragment(String srcNode, String srcIP, String destIP, int mtuSize) {
        String[] args = null;
        return new VerificationCommand(srcNode, args, null);
    }

    protected boolean parseConnectivityCmd(VerificationCommand vfyCmd) {
        String output = vfyCmd.getOutput();
        String val = null;
        boolean connectSucc = false;
        try {
            val = GenericUtil.getValueByKey(output, KEY_CONNECTED);
            if (val == null) {
                val = output.indexOf("Received = 0") == -1 ? VAL_CONNECTED_YES : "";
            }
            connectSucc = val.equalsIgnoreCase(VAL_CONNECTED_YES);
        }
        catch (Exception e) {
            Trace.out((String)("output :" + output));
            Trace.out((String)("Exception :" + e.getClass().getName()));
            Trace.out((String)("Exception mesg :" + e.getMessage()));
            Trace.out((Exception)e);
            connectSucc = false;
        }
        return connectSucc;
    }

    @Override
    protected NetworkInfo parseGetIfInfoCommandOutput(String fmtdStr, String node, ResultSet resultSet) {
        NetworkInfo network = super.parseGetIfInfoCommandOutput(fmtdStr, node, resultSet);
        network = sCommandHandler.updatePlatformSpecificNetworkDetails(network, fmtdStr, resultSet, node);
        return network;
    }

    public static NetworkInfo updatePlatformSpecificNetworkDetails(NetworkInfo network, String fmtdStr, ResultSet resultSet, String node) {
        return network;
    }

    private static int getTimeOut() {
        return 3;
    }
}

