/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.command.ICMPPingCommand;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.CommandHandler;
import oracle.ops.verification.framework.network.CommandHandlerFactory;
import oracle.ops.verification.framework.network.ConMatrix;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.network.Subnet;
import oracle.ops.verification.framework.network.TCPMatrix;
import oracle.ops.verification.framework.network.sCommandHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class VerifyNetwork
implements NetworkConstants {
    private static int DEFAULT_SSH_MAX_STARTUPS = 10;
    private static CommandHandler s_commandHandler = CommandHandlerFactory.createCommandHandler();
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    public boolean checkReachFromLocalNode(String[] nodeList, boolean[] nodeConArray, String[] nodeErrorArray) throws NetworkException {
        boolean ret = false;
        int successCount = 0;
        int failureCount = 0;
        ClusterCmd clusterCmd = new ClusterCmd();
        ArrayList<String> failedIPs = new ArrayList<String>();
        ArrayList<String> failedNodes = new ArrayList<String>();
        if (nodeConArray.length != nodeList.length) {
            Trace.out((String)"arrays' lengths don't match");
            throw new NetworkException(NetworkException.DEFAULT_MSG);
        }
        for (int i = 0; i < nodeList.length; ++i) {
            nodeConArray[i] = true;
        }
        try {
            int timeOut = 3;
            if (!new SystemFactory().CreateSystem().isUnixSystem()) {
                timeOut = 40;
            }
            Trace.out((String)("timeout = " + timeOut));
            ret = clusterCmd.areNodesAlive(nodeList, timeOut, null);
        }
        catch (ClusterException ce) {
            for (int i = 0; i < nodeList.length; ++i) {
                nodeConArray[i] = false;
                if (IPAddressUtil.isIPAddressString((String)nodeList[i])) {
                    failedIPs.add(nodeList[i]);
                    continue;
                }
                failedNodes.add(nodeList[i]);
            }
            VerificationUtil.traceAndLogError("CLUSTEREXCEPTION: " + ce.getMessage() + "\n" + Trace.getStackTrace((Throwable)ce));
            String errMsg = "";
            if (!failedNodes.isEmpty()) {
                errMsg = s_gMsgBundle.getMessage("11097", true, (Object[])new String[]{VerificationUtil.strArr2List(failedNodes.toArray(new String[0]))});
            }
            if (!failedIPs.isEmpty()) {
                if (VerificationUtil.isStringGood(errMsg)) {
                    errMsg = errMsg + VerificationUtil.LSEP;
                }
                errMsg = errMsg + s_msgBundle.getMessage("6006", true, (Object[])new String[]{VerificationUtil.strArr2List(failedIPs.toArray(new String[0]))});
            }
            throw new NetworkException(errMsg, ce);
        }
        catch (RemoteFileOperationException re) {
            for (int i = 0; i < nodeList.length; ++i) {
                try {
                    int status = re.getStatus(nodeList[i]);
                    if (0 == status) {
                        nodeConArray[i] = true;
                        nodeErrorArray[i] = null;
                        Trace.out((String)(nodeList[i] + "is reachable from local node"));
                        ++successCount;
                        continue;
                    }
                    nodeConArray[i] = false;
                    ++failureCount;
                    if (status == 1) {
                        nodeErrorArray[i] = re.getErrorMessage(nodeList[i]);
                    } else if (status == 2) {
                        nodeErrorArray[i] = re.getException(nodeList[i]).getMessage();
                    }
                    Trace.out((String)(nodeList[i] + " not reachable from local node"));
                    Trace.out((String)("Message: " + nodeErrorArray[i]));
                    VerificationLogData.logError("REMOTEFILEOPERATIONEXCEPTION: " + nodeErrorArray[i] + "\n" + Trace.getStackTrace((Throwable)re));
                    continue;
                }
                catch (NoSuchNodeException ne) {
                    VerificationLogData.logError("NOSUCHNODEEXCEPTION: " + ne.getMessage() + "\n" + nodeList[i] + " failed areNodesAlive check.\n" + Trace.getStackTrace((Throwable)ne));
                    nodeConArray[i] = false;
                    nodeErrorArray[i] = ne.getMessage();
                    ++failureCount;
                }
            }
        }
        Trace.out((String)("nodeList length: " + nodeList.length + "successCount: " + successCount + " failureCount: " + failureCount));
        if (failureCount == 0) {
            return true;
        }
        return ret;
    }

    public boolean checkReachFromSrcNode(String[] nodeList, boolean[] nodeConArray, String srcNode, String[] nodeConErrArray) {
        int nodeCount;
        int numCmds = nodeCount = nodeList.length;
        for (int i = 0; i < nodeCount; ++i) {
            nodeConArray[i] = false;
            nodeConErrArray[i] = null;
        }
        VerificationCommand[] cmdArray = new VerificationCommand[numCmds];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = s_commandHandler.generateReachabilityCommand(srcNode, nodeList[i]);
        }
        ResultSet resultSet = new ResultSet();
        boolean cmdSucc = new GlobalHandler().submit((Command[])cmdArray, 0, resultSet, DEFAULT_SSH_MAX_STARTUPS);
        Trace.out((String)("cmdSucc=" + cmdSucc));
        for (int i = 0; i < nodeCount; ++i) {
            VerificationCommand vfyCmd = cmdArray[i];
            Result result = vfyCmd.getResult();
            if (result.getStatus() == 1) {
                nodeConArray[i] = s_commandHandler.parseConnectivityCommandOutput(vfyCmd);
                if (!nodeConArray[i]) {
                    nodeConErrArray[i] = vfyCmd.fetchExecutionDetailsMessage(null);
                }
            } else {
                nodeConErrArray[i] = vfyCmd.getErrorString();
            }
            if (nodeConArray[i] || VerificationUtil.isStringGood(nodeConErrArray[i])) continue;
            nodeConErrArray[i] = s_gMsgBundle.getMessage("2044", true, (Object[])new String[]{vfyCmd.getCommandExecuted(), nodeList[i]});
        }
        if (!cmdSucc) {
            return false;
        }
        int numConnected = 0;
        for (int i = 0; i < nodeCount; ++i) {
            if (!nodeConArray[i]) continue;
            ++numConnected;
        }
        return numConnected == nodeCount;
    }

    public boolean checkSubnetConnectivity(List<Subnet> subnets, List<ConMatrix> matrixList, ResultSet resultSet) throws NetworkException {
        return this.checkSubnetConnectivity(subnets, matrixList, resultSet, false);
    }

    public boolean checkSubnetConnectivity(List<Subnet> subnets, List<ConMatrix> matrixList, ResultSet resultSet, boolean isRDSPingCheck) throws NetworkException {
        ConMatrix matrix;
        boolean retVal = true;
        Vector<SubnetConnectivityThread> threadList = new Vector<SubnetConnectivityThread>();
        for (Subnet subnet : subnets) {
            ArrayList<String> tempIps = new ArrayList<String>();
            ArrayList<String> tempNodes = new ArrayList<String>();
            ArrayList<String> tempInterfaces = new ArrayList<String>();
            for (NetworkInfo network : subnet.getNetworks()) {
                tempIps.add(network.getIPAsString());
                tempNodes.add(network.getNodeName());
                tempInterfaces.add(network.getInterfaceName());
            }
            this.makeLocalNodeAsFirstNode(tempNodes, tempIps);
            matrix = new ConMatrix(subnet.getSubnet(), tempNodes.toArray(new String[0]), tempIps.toArray(new String[0]), tempInterfaces.toArray(new String[0]));
            matrixList.add(matrixList.size(), matrix);
            threadList.add(new SubnetConnectivityThread(tempIps.toArray(new String[0]), tempNodes.toArray(new String[0]), subnet.getSubnet(), matrix, isRDSPingCheck));
        }
        Enumeration threadEnum = threadList.elements();
        while (threadEnum.hasMoreElements()) {
            Thread t = (Thread)threadEnum.nextElement();
            Trace.out((String)("==> Running " + t.getName()));
            t.start();
        }
        try {
            threadEnum = threadList.elements();
            while (threadEnum.hasMoreElements()) {
                ((Thread)threadEnum.nextElement()).join();
            }
        }
        catch (InterruptedException e) {
            VerificationLogData.logError("INTERRUPTEDEXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
            throw new NetworkException(e.getMessage(), e, true);
        }
        threadEnum = threadList.elements();
        while (threadEnum.hasMoreElements()) {
            SubnetConnectivityThread threadElement = (SubnetConnectivityThread)threadEnum.nextElement();
            matrix = threadElement.getMatrix();
            boolean subnetCon = 1 == matrix.getStatus();
            if (subnetCon) continue;
            resultSet.addResultSetData(threadElement.getResultSet());
            retVal = false;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("checkSubnetCon returns " + retVal));
        }
        return retVal;
    }

    public boolean checkRDSSubnetConnectivity(List<Subnet> subnets, List<ConMatrix> matrixList, ResultSet resultSet) throws NetworkException {
        return this.checkSubnetConnectivity(subnets, matrixList, resultSet, true);
    }

    public Collection<TCPMatrix> checkSubnetTCPConnectivity(List<Subnet> subnets) throws NetworkException {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        ArrayList<TCPMatrix> tcpMatrixList = new ArrayList<TCPMatrix>();
        for (Subnet subnet : subnets) {
            String subnetId = subnet.getSubnet();
            HashSet<NetworkInfo> networks = new HashSet<NetworkInfo>();
            Collection networksCollection = subnet.getNetworks();
            networks.addAll(networksCollection);
            TCPMatrix m = new TCPMatrix(networks);
            Trace.out((String)("Initial Status of TCPMatrix of subnet " + subnetId));
            Trace.out((String)m.toString());
            m.runTCPServers();
            Trace.out((String)("After running TCPServer, status of TCPMatrix of subnet " + subnetId));
            Trace.out((String)m.toString());
            m.runTCPClients();
            Trace.out((String)("After running TCPClient, status of TCPMatrix of subnet " + subnetId));
            Trace.out((String)m.toString());
            m.killTCPServers();
            tcpMatrixList.add(m);
        }
        return tcpMatrixList;
    }

    public boolean checkNodeConnectivityByIP(String[] IPList, String[] nodeList, ConMatrix matrix, ResultSet resultSet) {
        return this.checkNodeConnectivityByIP(IPList, nodeList, matrix, resultSet, false);
    }

    public boolean checkNodeConnectivityByIP(String[] IPList, String[] nodeList, ConMatrix matrix, ResultSet resultSet, boolean isRDSPingCheck) {
        boolean allConnected = false;
        boolean[][] nodeConMatrix = matrix.getMatrixForChange();
        for (int i = 0; i < IPList.length; ++i) {
            for (int j = 0; j < IPList.length; ++j) {
                nodeConMatrix[i][j] = false;
            }
        }
        if (IPList.length == 1) {
            boolean isValidIP = this.checkIPReachability(IPList[0], resultSet);
            if (isValidIP) {
                for (int i = 0; i < IPList.length; ++i) {
                    for (int j = 0; j < IPList.length; ++j) {
                        nodeConMatrix[i][j] = true;
                    }
                }
                matrix.setStatus(1, true);
                allConnected = true;
                Trace.out((String)("Node " + nodeList[0] + " connected to all."));
                resultSet.setStatus(1);
                return true;
            }
            matrix.setStatus(3, true);
            return false;
        }
        Trace.out((String)("First try to get the connectivity from local node: " + nodeList[0]));
        int numConnected = this.getRowConByRemotePingFile(true, IPList, nodeList, nodeConMatrix[0], matrix, resultSet, isRDSPingCheck);
        Trace.out((String)("Number of connected nodes to local node: " + numConnected));
        if (numConnected == nodeList.length) {
            matrix.setStatus(1, true);
            allConnected = true;
            Trace.out((String)("Node " + nodeList[0] + " connected to all."));
            resultSet.setStatus(1);
        } else {
            matrix.setStatus(3, true);
            resultSet.setStatus(4);
            int numDisconnected = nodeList.length - numConnected;
            Trace.out((String)("NumDisConnected: " + numDisconnected + " to Node " + nodeList[0] + " for subnet " + matrix.getKey()));
            if (!nodeConMatrix[0][0]) {
                --numDisconnected;
            }
            if (numDisconnected > 1) {
                ArrayList<Integer> disconToOriginalMap = new ArrayList<Integer>();
                ArrayList<String> disconNodeList = new ArrayList<String>();
                ArrayList<String> disconIPList = new ArrayList<String>();
                for (int i = 1; i < nodeList.length; ++i) {
                    if (nodeConMatrix[0][i]) continue;
                    disconToOriginalMap.add(i);
                    disconNodeList.add(nodeList[i]);
                    disconIPList.add(IPList[i]);
                }
                String[] disConNodeArray = disconNodeList.toArray(new String[0]);
                String[] disConIpArray = disconIPList.toArray(new String[0]);
                VerificationUtil.traceAndLog("Disconnected nodes: " + VerificationUtil.strArr2List(disConNodeArray));
                numConnected = this.getRowConByRemotePingFile(false, disConIpArray, disConNodeArray, nodeConMatrix[0], matrix, resultSet, isRDSPingCheck);
            }
        }
        VerificationUtil.traceAndLog("\nExiting... IPList: '" + VerificationUtil.strArr2List(IPList) + "'\nnodeList: '" + VerificationUtil.strArr2List(nodeList) + "'\nnodeConMatrix: " + matrix.toString());
        return allConnected;
    }

    public HashMap<String, List<NetworkInfo>> getIPMPConfigInfo(String[] nodeList, ResultSet ipmpRsltSet) {
        int nodeCount = nodeList.length;
        VerificationCommand[] cmdArray = new VerificationCommand[nodeCount];
        HashMap<String, List<NetworkInfo>> nodeWiseIPMPInfo = new HashMap<String, List<NetworkInfo>>();
        for (int j = 0; j < nodeCount; ++j) {
            cmdArray[j] = s_commandHandler.generateGetIPMPInfoCommand(nodeList[j]);
        }
        new GlobalHandler().submit((Command[])cmdArray, 0, ipmpRsltSet);
        if (!ipmpRsltSet.anySuccess()) {
            Trace.out((String)"GlobalHandler failed");
            ipmpRsltSet.addErrorDescription(nodeList, new ErrorDescription(s_gMsgBundle.getMessage("1510", false)));
            return nodeWiseIPMPInfo;
        }
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            VerificationCommand vfyCmd = cmdArray[nodeIndex];
            Result result = vfyCmd.getResult();
            String node = nodeList[nodeIndex];
            if (result.getStatus() == 1) {
                List<NetworkInfo> ipmpNetworks = s_commandHandler.parseIPMPInfoOutput(vfyCmd, node, ipmpRsltSet);
                if (ipmpNetworks != null && !ipmpNetworks.isEmpty()) {
                    nodeWiseIPMPInfo.put(vfyCmd.getNode(), ipmpNetworks);
                    continue;
                }
                result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("1511", true, (Object[])new String[]{node})));
                ipmpRsltSet.addResult(node, result);
                continue;
            }
            result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("1511", true, (Object[])new String[]{node})));
            ipmpRsltSet.addResult(node, result);
        }
        Trace.out((String)("Returning the IPMP Group as " + nodeWiseIPMPInfo));
        return nodeWiseIPMPInfo;
    }

    public HashMap<String, Vector> getNICBindOrder(String[] nodeList, ResultSet rsltSet) {
        int nodeCount = nodeList.length;
        VerificationCommand[] cmdArray = new VerificationCommand[nodeCount];
        HashMap<String, Vector> nodeWiseNICOrder = new HashMap<String, Vector>();
        for (int j = 0; j < nodeCount; ++j) {
            cmdArray[j] = s_commandHandler.generateGetNICBindOrderCommand(nodeList[j]);
        }
        new GlobalHandler().submit((Command[])cmdArray, 0, rsltSet);
        if (!rsltSet.anySuccess()) {
            Trace.out((String)"GlobalHandler failed");
            rsltSet.addErrorDescription(nodeList, new ErrorDescription(s_gMsgBundle.getMessage("11776", false)));
            return nodeWiseNICOrder;
        }
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            VerificationCommand vfyCmd = cmdArray[nodeIndex];
            String node = nodeList[nodeIndex];
            Result result = vfyCmd.getResult();
            if (result.getStatus() == 1) {
                try {
                    nodeWiseNICOrder.put(node, s_commandHandler.parseNICBindOrderInfoOutput(vfyCmd));
                }
                catch (NetworkException e) {
                    result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("11775", true, (Object[])new String[]{node}) + VerificationConstants.LINE_SEPARATOR + e.getMessage()));
                    result.setStatus(3);
                    rsltSet.addResult(node, result);
                }
                continue;
            }
            result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("11775", true, (Object[])new String[]{node})));
            rsltSet.addResult(node, result);
        }
        Trace.out((String)" Exiting the get NIC bind order ");
        return nodeWiseNICOrder;
    }

    public boolean checkMTUWithoutFragment(List<NetworkInfo> privateNetworksList, String subnet, ResultSet resultSet) {
        int i;
        boolean resultVal = true;
        List<NetworkInfo> privateNetworks = privateNetworksList;
        HashMap nodePvtNetworksMap = new HashMap();
        for (NetworkInfo network : privateNetworksList) {
            List<NetworkInfo> networkList;
            String node = network.getNodeName();
            if (nodePvtNetworksMap.containsKey(node)) {
                networkList = (List)nodePvtNetworksMap.get(node);
                networkList.add(network);
                continue;
            }
            networkList = new ArrayList();
            networkList.add(network);
            if (!VerificationUtil.isStringGood(node)) continue;
            nodePvtNetworksMap.put(node, networkList);
        }
        List localNetworkList = new ArrayList();
        String localNode = VerificationUtil.getLocalNode();
        if (nodePvtNetworksMap.containsKey(localNode)) {
            localNetworkList = (List)nodePvtNetworksMap.get(localNode);
        } else {
            String[] nodeList = nodePvtNetworksMap.keySet().toArray(new String[0]);
            if (nodeList.length > 0) {
                localNetworkList = (List)nodePvtNetworksMap.get(nodeList[0]);
            }
        }
        privateNetworks.removeAll(localNetworkList);
        NetworkInfo networkInfo = (NetworkInfo)localNetworkList.get(0);
        VerificationUtil.traceAndLog("Local network info: " + networkInfo.toString());
        String srcNode = networkInfo.getNodeName();
        String srcIP = networkInfo.getIPAsString();
        int networkMTU = networkInfo.getMTU();
        if (localNetworkList.size() > 1) {
            localNetworkList.remove(0);
            for (NetworkInfo nInfo : localNetworkList) {
                VerificationUtil.traceAndLog("Local network info:" + nInfo.toString());
                if (nInfo.getMTU() >= networkMTU) continue;
                networkMTU = nInfo.getMTU();
                srcNode = nInfo.getNodeName();
                srcIP = nInfo.getIPAsString();
            }
        }
        networkMTU -= 28;
        VerificationCommand[] cmdArray = new VerificationCommand[privateNetworks.size()];
        for (i = 0; i < privateNetworks.size(); ++i) {
            NetworkInfo privateNetwork = privateNetworks.get(i);
            String destIP = privateNetwork.getIPAsString();
            cmdArray[i] = s_commandHandler.generateICMPCommandWithoutFragment(srcNode, srcIP, destIP, networkMTU);
        }
        new GlobalHandler().submit((Command[])cmdArray, 0, resultSet, DEFAULT_SSH_MAX_STARTUPS);
        for (i = 0; i < privateNetworks.size(); ++i) {
            VerificationCommand vfyCmd = cmdArray[i];
            Result result = vfyCmd.getResult();
            String node = result.getNode();
            NetworkInfo privateNetwork = privateNetworks.get(i);
            if (result.getStatus() == 1 && vfyCmd.getVfyCode() == 0) {
                Trace.out((String)("MTU size packet goes through without fragmentation  for interface " + privateNetwork.getInterfaceName() + "( " + privateNetwork.getIPAsString() + " )"));
                continue;
            }
            Trace.out((String)("MTU size packet does not go through without fragmentation  for interface " + privateNetwork.getInterfaceName() + "( " + privateNetwork.getIPAsString() + " )"));
            String errMsg = s_gMsgBundle.getMessage("12885", true, (Object[])new String[]{Integer.toString(privateNetwork.getMTU()), subnet});
            String execTaskOutput = vfyCmd.getExectaskOutput();
            String cmdStr = VerificationUtil.fetchCommandValue(execTaskOutput);
            String cmdOutput = VerificationUtil.fetchVerificationValue(execTaskOutput);
            if (VerificationUtil.isStringGood(cmdStr) && VerificationUtil.isStringGood(cmdOutput)) {
                errMsg = errMsg + VerificationConstants.LSEP + s_msgBundle.getMessage("0050", false, (Object[])new String[]{cmdStr, cmdOutput});
            }
            resultSet.addErrorDescription(new ErrorDescription(errMsg));
            resultSet.addResult(node, result);
            ReportUtil.printError(errMsg);
            resultVal = false;
        }
        return resultVal;
    }

    private int getRowConByRemotePingFile(boolean fromFirstNode, String[] IPList, String[] nodeList, boolean[] nodeConArray, ConMatrix sourceMatrix, ResultSet resultSet, boolean isRDSPingCheck) {
        int nodeCount = IPList.length;
        int numConnected = 0;
        if (nodeCount == 0) {
            return 0;
        }
        HashSet<String> sourceNodes = new HashSet<String>();
        if (fromFirstNode) {
            sourceNodes.add(nodeList[0]);
        } else {
            Collections.addAll(sourceNodes, nodeList);
        }
        Trace.out((String)("checking connectivity for the following nodes: " + VerificationUtil.strCollection2String(sourceNodes) + " for the subnet " + sourceMatrix.getKey()));
        boolean retVal = NetworkUtility.createAndCopyPingCommandInputFile(sourceMatrix, resultSet, sourceNodes.toArray(new String[0]));
        if (!retVal && !resultSet.anySuccess()) {
            Trace.out((String)"Failed to create and copy ping command input file");
            return 0;
        }
        int sourceNodesSize = sourceNodes.size();
        VerificationCommand[] cmdArray = new VerificationCommand[sourceNodesSize];
        int cmdIndex = 0;
        for (String sourceNode : sourceNodes) {
            cmdArray[cmdIndex++] = sCommandHandler.getICMPPingCommand(sourceNode, sourceMatrix, isRDSPingCheck);
        }
        ResultSet pingCmdResultSet = new ResultSet();
        boolean cmdSucc = new GlobalHandler().submit((Command[])cmdArray, 0, pingCmdResultSet, DEFAULT_SSH_MAX_STARTUPS);
        if (!cmdSucc && !pingCmdResultSet.anySuccess()) {
            Trace.out((String)"ICMP Ping command failed");
            resultSet.addResultSetData(pingCmdResultSet);
            return 1;
        }
        for (int nodeIndex = 0; nodeIndex < sourceNodesSize; ++nodeIndex) {
            int i;
            ICMPPingCommand vfyCmd = (ICMPPingCommand)cmdArray[nodeIndex];
            Result result = vfyCmd.getResult();
            String resultNode = vfyCmd.getNode();
            ConMatrix matrixFromNode = vfyCmd.getConnectivityMatrix();
            VerificationUtil.traceAndLog("Connectivity matrix from the node " + resultNode + "\nIPList: '" + VerificationUtil.strArr2List(matrixFromNode.getIPList()) + "'\nnodeList: '" + VerificationUtil.strArr2List(matrixFromNode.getNodeList()) + "'\nnodeConMatrix: " + matrixFromNode.toString());
            if (result.getStatus() == 2) {
                for (i = 1; i < nodeList.length; ++i) {
                    nodeConArray[i] = false;
                }
                resultSet.addResult(resultNode, result);
                continue;
            }
            if (vfyCmd.getConnectivityMatrix().getStatus() == 1) {
                Trace.out((String)("Node " + resultNode + " connected to all the nodes "));
                if (fromFirstNode) {
                    for (i = 0; i < nodeList.length; ++i) {
                        nodeConArray[i] = true;
                    }
                    sourceMatrix.setStatus(1, true);
                    sourceMatrix.updateMatrix(matrixFromNode, null);
                    continue;
                }
                sourceMatrix.updateMatrix(matrixFromNode, null);
                continue;
            }
            Trace.out((String)("Node " + resultNode + " connected to some of the nodes "));
            if (fromFirstNode) {
                sourceMatrix.setStatus(3, true);
                resultSet.addResult(resultNode, result);
                sourceMatrix.updateMatrix(matrixFromNode, nodeConArray);
                continue;
            }
            sourceMatrix.updateMatrix(matrixFromNode, null);
        }
        sourceMatrix.getMatrixForOutput();
        VerificationUtil.traceAndLog("Combined matrix from all the nodes \nIPList: '" + VerificationUtil.strArr2List(IPList) + "'\nnodeList: '" + VerificationUtil.strArr2List(nodeList) + "'\nnodeConMatrix: " + sourceMatrix.toString());
        for (int i = 0; i < nodeList.length; ++i) {
            if (!nodeConArray[i]) continue;
            ++numConnected;
        }
        Trace.out((String)("Subnet check connectivity status = " + (numConnected == nodeList.length)));
        return numConnected;
    }

    protected void makeLocalNodeAsFirstNode(List<String> nodes, List<String> ips) {
        String[] nodeList = nodes.toArray(new String[0]);
        String[] ipList = ips.toArray(new String[0]);
        if (!VerificationUtil.isLocalNode(nodeList[0])) {
            Trace.out((String)"Subnet thread do not have local node as first node");
            for (int i = 0; i < nodeList.length; ++i) {
                if (!VerificationUtil.isLocalNode(nodeList[i])) continue;
                String tempNode = nodeList[0];
                String tempIp = ipList[0];
                nodeList[0] = nodeList[i];
                ipList[0] = ipList[i];
                nodeList[i] = tempNode;
                ipList[i] = tempIp;
                Trace.out((String)"Made local node as the first node in the matrix");
                break;
            }
        } else {
            Trace.out((String)"Matrix already has local node as first node");
        }
        nodes.clear();
        ips.clear();
        Collections.addAll(nodes, nodeList);
        Collections.addAll(ips, ipList);
    }

    public boolean checkIPReachability(String IP, ResultSet resultSet) {
        boolean[] nodeConArray = new boolean[1];
        String[] nodeErrorArray = new String[1];
        boolean reachable = false;
        try {
            reachable = this.checkReachFromLocalNode(new String[]{IP}, nodeConArray, nodeErrorArray);
        }
        catch (NetworkException e) {
            String msg = e.getMessage();
            VerificationUtil.traceAndLog(IP + " is either unreachable or invalid. " + "Error message: " + msg);
            ErrorDescription errDesc = new ErrorDescription(msg);
            resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(VerificationUtil.LSEP + msg);
            resultSet.setStatus(3);
            return false;
        }
        if (!reachable) {
            VerificationUtil.traceAndLog(IP + " is either unreachable or invalid");
            String msg = nodeErrorArray[0];
            ErrorDescription errDesc = new ErrorDescription(msg);
            resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(VerificationUtil.LSEP + msg);
            resultSet.setStatus(3);
        }
        return reachable;
    }

    class SubnetConnectivityThread
    extends Thread {
        String m_subnet;
        String[] m_IPList;
        String[] m_nodeList;
        ConMatrix m_matrix = null;
        ResultSet m_resultSet = new ResultSet();
        boolean m_isRDSPingCheck;

        SubnetConnectivityThread(String[] IPList, String[] nodeList, String subnet, ConMatrix matrix, boolean isRDSPingCheck) {
            this.m_IPList = IPList;
            this.m_nodeList = nodeList;
            this.m_subnet = subnet;
            this.m_matrix = matrix;
            this.m_matrix.setIPList(IPList);
            this.m_isRDSPingCheck = isRDSPingCheck;
        }

        @Override
        public void run() {
            Trace.out((String)("==> In run method of thread" + Thread.currentThread().getName()));
            VerifyNetwork.this.checkNodeConnectivityByIP(this.m_IPList, this.m_nodeList, this.m_matrix, this.m_resultSet, this.m_isRDSPingCheck);
        }

        protected ConMatrix getMatrix() {
            return this.m_matrix;
        }

        String getSubnet() {
            return this.m_subnet;
        }

        public ResultSet getResultSet() {
            return this.m_resultSet;
        }
    }
}

