/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.util.ClassifierTable;
import oracle.ops.verification.util.DeepSortedTable;

public class Subnet
implements NetworkConstants {
    private ClassifierTable m_networks;
    private HashMap<String, Integer> m_ifNameTable;
    private int m_numPrivate;
    private int m_numPublic;
    private int m_numAsm;
    private int m_numUnknown;
    private String m_subnetNumber;

    protected Subnet() {
        if (null == this.m_networks) {
            this.m_networks = new ClassifierTable();
            this.m_ifNameTable = new HashMap();
        }
    }

    protected Subnet(Collection networks) {
        this();
        for (NetworkInfo network : networks) {
            this.add(network);
        }
    }

    protected void add(NetworkInfo network) {
        int networkType;
        this.m_networks.put(network.getNodeName(), network);
        Integer numSameName = this.m_ifNameTable.get(network.getInterfaceName());
        numSameName = null == numSameName ? new Integer(0) : new Integer(numSameName + 1);
        this.m_ifNameTable.put(network.getInterfaceName(), numSameName);
        if (null == this.m_subnetNumber) {
            this.m_subnetNumber = network.getSubnetAsString();
        }
        if (((networkType = network.getNetworkType()) & 1) != 0) {
            ++this.m_numPrivate;
        }
        if ((networkType & 2) != 0) {
            ++this.m_numPublic;
        }
        if ((networkType & 0x80) != 0) {
            ++this.m_numAsm;
        }
        if ((networkType & 4) != 0) {
            ++this.m_numUnknown;
        }
    }

    private int getNumberOfPrivateNetworks() {
        return this.m_numPrivate;
    }

    private int getNumberOfPublicNetworks() {
        return this.m_numPublic;
    }

    private int getNumberOfAsmNetworks() {
        return this.m_numAsm;
    }

    private int getNumberOfUnknownTypeNetworks() {
        return this.m_numUnknown;
    }

    public String getSubnet() {
        return this.m_subnetNumber;
    }

    public int getNumberOfNodes() {
        return this.m_networks.keySet().size();
    }

    public Collection getNodes() {
        return this.m_networks.keySet();
    }

    public Collection getNetworkNames() {
        return this.m_ifNameTable.keySet();
    }

    public int getNumberOfNetworks() {
        return this.m_networks.size();
    }

    public Collection getNetworks() {
        return this.m_networks.values();
    }

    public Collection getNetworksByNode(String node) {
        return this.m_networks.getSubGroup(node);
    }

    public boolean isPrivate() {
        boolean isPrivate = 0 == this.m_numPublic && 0 == this.m_numUnknown && this.m_numPrivate > 0;
        return isPrivate;
    }

    private Collection getSpanningNetworks(int minNodes, boolean sameName, int typeFlags) {
        ClassifierTable ifTable = new ClassifierTable();
        DeepSortedTable nodeMap = new DeepSortedTable();
        Iterator networkIterator = this.m_networks.values().iterator();
        Vector<Subnet> okSubnets = new Vector<Subnet>();
        if (this.getNumberOfNodes() < minNodes) {
            return okSubnets;
        }
        while (networkIterator.hasNext()) {
            NetworkInfo network = (NetworkInfo)networkIterator.next();
            String key = network.getSubnetMaskAsString();
            if (sameName) {
                key = network.getInterfaceName() + "|" + key;
            }
            if (0 == (network.getNetworkType() & typeFlags) || network.getStatus() == 8) continue;
            nodeMap.put(key, network.getNodeName());
            ifTable.put(key, network);
        }
        for (String key : nodeMap.keySet()) {
            Collection nodeList = nodeMap.getSubGroup(key);
            if (nodeList.size() < minNodes) continue;
            Collection networkList = ifTable.getSubGroup(key);
            Subnet subnet = new Subnet(networkList);
            okSubnets.add(subnet);
        }
        return okSubnets;
    }

    public Collection<Subnet> getVIPOkSubnets(int minNodes) {
        Collection<Subnet> vipOkSubnets = this.getNumberOfUnknownTypeNetworks() + this.getNumberOfPublicNetworks() < minNodes ? new Vector<Subnet>() : this.getSpanningNetworks(minNodes, true, 6);
        return vipOkSubnets;
    }

    public Collection<Subnet> getPrivateOkSubnets(int minNodes, boolean isSameName) {
        Collection<Subnet> okSubnets = this.getNumberOfPrivateNetworks() < minNodes ? new Vector<Subnet>() : this.getSpanningNetworks(minNodes, isSameName, 1);
        return okSubnets;
    }

    public static Collection<Subnet> classifyToSubnets(HashMap<String, Set<NetworkInfo>> subnetNetworksMap) {
        HashSet<NetworkInfo> NetworkList = new HashSet<NetworkInfo>();
        for (String subnet : subnetNetworksMap.keySet()) {
            NetworkList.addAll((Collection<NetworkInfo>)subnetNetworksMap.get(subnet));
        }
        return Subnet.classifyToSubnets(NetworkList, false);
    }

    public static Collection<Subnet> classifyToSubnets(Set<NetworkInfo> NetworkList, boolean byName) {
        LinkedHashMap<String, Subnet> table = new LinkedHashMap<String, Subnet>();
        for (NetworkInfo network : NetworkList) {
            Subnet subnet;
            String subnetNumber;
            String key = subnetNumber = network.getSubnetAsString();
            if (byName) {
                String name = network.getInterfaceName();
                key = key + "|" + name;
            }
            if (table.containsKey(key)) {
                subnet = (Subnet)table.get(key);
            } else {
                subnet = new Subnet();
                table.put(key, subnet);
            }
            subnet.add(network);
        }
        return table.values();
    }

    public static List<Subnet> getIPv4Subnets(List<Subnet> subnets) {
        ArrayList<Subnet> ipv4OnlySubnets = new ArrayList<Subnet>();
        for (Subnet subnet : subnets) {
            if (IPAddressUtil.isIPv6AddressString((String)subnet.getSubnet())) continue;
            ipv4OnlySubnets.add(subnet);
        }
        return ipv4OnlySubnets;
    }

    public static List<Subnet> getIPv6Subnets(List<Subnet> subnets) {
        ArrayList<Subnet> ipv6OnlySubnets = new ArrayList<Subnet>();
        for (Subnet subnet : subnets) {
            if (!IPAddressUtil.isIPv6AddressString((String)subnet.getSubnet())) continue;
            ipv6OnlySubnets.add(subnet);
        }
        return ipv6OnlySubnets;
    }
}

