/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.SeverityType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskRootConsistency
extends Task {
    private boolean m_usegroupscmd = false;

    public sTaskRootConsistency(String[] nodelist) {
        super(nodelist);
        if (VerificationUtil.getCurrentOS().equals("HP-UX")) {
            this.setUseGroupsCmd(true);
        }
    }

    public void setUseGroupsCmd(boolean value) {
        this.m_usegroupscmd = value;
    }

    @Override
    public boolean performTask() {
        ErrorDescription errDesc;
        String errMsg;
        Result result;
        Trace.out((String)"performTask Entry");
        this.setSeverity(SeverityType.IGNORABLE);
        GlobalExecution globalExec = new GlobalExecution();
        boolean rootEquiv = true;
        ResultSet resultSet = new ResultSet();
        HashMap<String, UserInfo> nodeMap = new HashMap<String, UserInfo>();
        String[] nodeList = this.m_nodeList;
        ArrayList<String> verificationFailedNodeList = new ArrayList<String>();
        ArrayList<String> operationFailedNodeList = new ArrayList<String>();
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("10951", false));
        boolean cmdResult = globalExec.checkRootGidConsistency(this.m_nodeList, resultSet, this.m_usegroupscmd);
        if (cmdResult) {
            if (this.m_usegroupscmd) {
                return this.processGroupsResult(resultSet, nodeList);
            }
            for (String node : this.m_nodeList) {
                result = resultSet.getResult(node);
                if (result.getStatus() != 1) continue;
                String execTaskOutput = (String)result.getResultInfoSet().get(0);
                Trace.out((int)5, (String)("Result String from node " + node + " is " + (String)execTaskOutput));
                String resultStr = VerificationUtil.fetchVerificationValue(execTaskOutput);
                UserInfo nodeUserInfo = this.filterOutput(resultStr);
                nodeMap.put(node, nodeUserInfo);
            }
            for (String refNode : nodeMap.keySet()) {
                ArrayList<String> groupNotExistNodes = new ArrayList<String>();
                UserInfo refUserInfo = (UserInfo)nodeMap.get(refNode);
                String primaryGroup = refUserInfo.getPrimaryGroup();
                if (!VerificationUtil.isStringGood(primaryGroup)) {
                    Trace.out((String)("Could not get the primary group info on node: " + refNode));
                    resultSet.addResult(refNode, 3);
                    if (verificationFailedNodeList.contains(refNode)) continue;
                    verificationFailedNodeList.add(refNode);
                    continue;
                }
                for (String node : nodeMap.keySet()) {
                    if (((UserInfo)nodeMap.get(node)).getAllGroups().contains(primaryGroup)) continue;
                    groupNotExistNodes.add(node);
                    if (verificationFailedNodeList.contains(node)) continue;
                    verificationFailedNodeList.add(node);
                }
                if (groupNotExistNodes.size() > 0) {
                    if (!verificationFailedNodeList.contains(refNode)) {
                        verificationFailedNodeList.add(refNode);
                    }
                    resultSet.addResult(verificationFailedNodeList, 3);
                    Trace.out((String)"Check failed on one or more nodes ");
                    errMsg = s_gMsgBundle.getMessage("10958", true, (Object[])new String[]{primaryGroup, refNode, primaryGroup, VerificationUtil.strCollection2String(groupNotExistNodes)});
                    errDesc = new ErrorDescription(errMsg);
                    resultSet.addErrorDescription(errDesc);
                    continue;
                }
                if (verificationFailedNodeList.contains(refNode)) continue;
                resultSet.addResult(refNode, 1);
            }
        }
        this.m_resultSet.addResultSetData(resultSet);
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
        String status = "";
        Hashtable h = resultSet.getResultTable();
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String node;
            node = (String)e.nextElement();
            result = (Result)h.get(node);
            if (result.getStatus() == 1) {
                status = ReportUtil.PASSED;
                Trace.out((String)("Task PASSED on node " + node));
            } else if (result.getStatus() == 3) {
                status = ReportUtil.FAILED;
                rootEquiv = false;
            } else {
                status = ReportUtil.FAILED;
                operationFailedNodeList.add(node);
                errMsg = s_gMsgBundle.getMessage("10959", true, (Object[])new String[]{node});
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                rootEquiv = false;
                Trace.out((String)(" Check failed on node because of command failure" + errMsg));
            }
            ReportUtil.writeRecord(node, status);
        }
        if (rootEquiv) {
            ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("10954", false));
        } else {
            if (verificationFailedNodeList.size() > 0) {
                ReportUtil.printError(s_gMsgBundle.getMessage("10952", true, (Object[])new String[]{VerificationUtil.strList2List(verificationFailedNodeList)}));
            }
            if (operationFailedNodeList.size() > 0) {
                ReportUtil.printError(s_gMsgBundle.getMessage("10953", true, (Object[])new String[]{VerificationUtil.strList2List(operationFailedNodeList)}));
            }
        }
        Trace.out((String)"sTaskRootConsistency :: exiting ");
        return rootEquiv;
    }

    private boolean processGroupsResult(ResultSet rs, String[] nodeList) {
        StringBuilder verFailNodeList = new StringBuilder();
        StringBuilder opFailNodeList = new StringBuilder();
        boolean rootEquiv = true;
        String lrgrp = VerificationUtil.getLocalRootGroup(rs);
        if (lrgrp == null) {
            Trace.out((String)"Received local primary group as null, failing the check");
            rs.addResult(this.m_nodeList, 2);
            this.m_resultSet.addResultSetData(rs);
        }
        ArrayList<String> passList = new ArrayList<String>();
        ArrayList<String> verFailList = new ArrayList<String>();
        ArrayList<String> opFailList = new ArrayList<String>();
        for (String node : nodeList) {
            String allGroups = (String)rs.getResult(node).getResultInfoSet().get(0);
            if (allGroups != null && allGroups.contains(lrgrp)) {
                rs.getResult(node).setStatus(1);
                rs.setStatus();
                passList.add(node);
                continue;
            }
            if (rs.getResult(node).getStatus() != 2) {
                rs.getResult(node).setStatus(3);
                rs.setStatus();
                verFailList.add(node);
                continue;
            }
            opFailList.add(node);
        }
        if (passList.size() == nodeList.length) {
            rs.addResult(this.m_nodeList, 1);
            Trace.out((String)"Root group id consistency check with groups command passed on all nodes");
        } else {
            if (verFailList.size() > 0) {
                for (String node : verFailList) {
                    verFailNodeList.append(node);
                    if (verFailList.indexOf(node) >= verFailList.size()) continue;
                    verFailNodeList.append(",");
                }
                Trace.out((String)("Check failed on the following nodes " + verFailNodeList.toString()));
            }
            if (opFailList.size() > 0) {
                for (String node : opFailList) {
                    opFailNodeList.append(node);
                    if (opFailList.indexOf(node) >= opFailList.size()) continue;
                    opFailNodeList.append(",");
                }
                Trace.out((String)("Check encountered a command failure on the following nodes " + opFailNodeList.toString()));
            }
        }
        this.m_resultSet.addResultSetData(rs);
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
        String status = "";
        Hashtable h = rs.getResultTable();
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String errMsg;
            String node;
            node = (String)e.nextElement();
            Result result = (Result)h.get(node);
            if (result.getStatus() == 1) {
                status = ReportUtil.PASSED;
                Trace.out((String)("Task PASSED on node " + node));
            } else if (result.getStatus() == 3) {
                status = ReportUtil.FAILED;
                errMsg = s_gMsgBundle.getMessage("10958", true, (Object[])new String[]{lrgrp, node, lrgrp, verFailNodeList.toString()});
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                rootEquiv = false;
                Trace.out((String)("Check failed on one or more nodes " + errMsg));
            } else {
                status = ReportUtil.FAILED;
                errMsg = s_gMsgBundle.getMessage("10959", true, (Object[])new String[]{node});
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                rootEquiv = false;
                Trace.out((String)(" Check failed on node because of command failure" + errMsg));
            }
            ReportUtil.writeRecord(node, status);
        }
        if (rootEquiv) {
            ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("10954", false));
        } else {
            if (verFailNodeList.length() > 0) {
                ReportUtil.printError(s_gMsgBundle.getMessage("10952", true, (Object[])new String[]{verFailNodeList.toString()}));
            }
            if (opFailNodeList.length() > 0) {
                ReportUtil.printError(s_gMsgBundle.getMessage("10953", true, (Object[])new String[]{opFailNodeList.toString()}));
            }
        }
        Trace.out((String)"sTaskRootConsistency :: exiting ");
        return rootEquiv;
    }

    private UserInfo filterOutput(String output) {
        String userData = null;
        String primGrpData = null;
        String grpListData = null;
        String[] grpArray = null;
        if (VerificationUtil.isStringGood(output)) {
            String[] grpListArray;
            String[] primGrpArray;
            String[] userArray;
            String[] tokens = VerificationUtil.string2strArr(output, " ");
            if (tokens != null && tokens.length > 2) {
                userData = tokens[0];
                primGrpData = tokens[1];
                grpListData = tokens[2];
            } else if (tokens != null && tokens.length > 1) {
                userData = tokens[0];
                primGrpData = tokens[1];
            }
            if (VerificationUtil.isStringGood(userData) && userData.contains("=") && (userArray = VerificationUtil.string2strArr(userData, "=")) != null && userArray.length > 1) {
                userData = userArray[1];
            }
            if (VerificationUtil.isStringGood(primGrpData) && primGrpData.contains("=") && (primGrpArray = VerificationUtil.string2strArr(primGrpData, "=")) != null && primGrpArray.length > 1) {
                primGrpData = primGrpArray[1];
            }
            if (VerificationUtil.isStringGood(grpListData) && grpListData.contains("=") && (grpListArray = VerificationUtil.string2strArr(grpListData, "=")) != null && grpListArray.length > 1) {
                grpListData = grpListArray[1];
                grpArray = VerificationUtil.string2strArr(grpListData);
            }
        }
        return new UserInfo(userData, primGrpData, grpArray);
    }

    @Override
    public String getTaskID() {
        return "CHECK_ROOT_USER_CONSISTENCY";
    }

    @Override
    public String getTaskName() {
        return this.getTaskID();
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("10955", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("10956", false);
    }

    private class UserInfo {
        String m_name = null;
        String m_primGrp = null;
        String[] m_grpList = null;

        private UserInfo(String userName, String primaryGrp, String[] groupList) {
            this.m_name = userName;
            this.m_primGrp = primaryGrp;
            this.m_grpList = groupList;
        }

        private String getName() {
            return this.m_name;
        }

        private String getPrimaryGroup() {
            return this.m_primGrp;
        }

        private List<String> getAllGroups() {
            ArrayList<String> groupList = new ArrayList<String>();
            if (this.m_grpList != null && this.m_grpList.length > 0) {
                groupList.addAll(Arrays.asList(this.m_grpList));
            }
            if (VerificationUtil.isStringGood(this.m_primGrp) && !groupList.contains(this.m_primGrp)) {
                groupList.add(this.m_primGrp);
            }
            return groupList;
        }
    }
}

