/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.engine.task.TaskNTP;
import oracle.ops.verification.framework.util.VerificationUtil;

class sTaskNTP {
    private boolean m_isNTPQSupported = false;
    final String NTP_DAEMON_NAME = "ntp";
    final String CV_NTP_DAEMON_NAME = "CV_NTP_DAEMON_NAME";
    final String W32TIME_SERVICE_ID = "W32Time";
    final String HYPERV_SERVICE_ID = "vmictimesync";
    private static String m_w32TimeConfigKey = "HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\W32Time\\Config\\";
    private static String[] m_w32TimeConfigParamsIds = new String[]{"MaxPosPhaseCorrection", "MaxNegPhaseCorrection", "MaxAllowedPhaseOffset"};
    private static Integer[] m_w32TimeConfigParamsVal = new Integer[]{600, 600, 600};
    protected static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private TaskNTP m_genTask;
    Vector<String> m_rejectedTimeServerEntries = null;

    sTaskNTP(TaskNTP genTask) {
        this.m_genTask = genTask;
    }

    sTaskNTP() {
    }

    public boolean canServicesCoexist(Set<String> serviceNames) {
        String services = VerificationUtil.strCollection2String(serviceNames);
        if (serviceNames.size() == 2 && serviceNames.contains("W32Time") && serviceNames.contains("vmictimesync")) {
            VerificationUtil.traceAndLog("Services can coexist [%s]", services);
            return true;
        }
        VerificationUtil.traceAndLog("Services can NOT coexist [%s]", services);
        return false;
    }

    private void throwUOException(String method) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation '" + method + "' is not supported on this platform");
    }

    public List<String> getNTPConfigFile() {
        this.throwUOException("getNTPConfigFile");
        return null;
    }

    public List<String> getNTPDaemonNames() {
        ArrayList<String> retList = new ArrayList<String>();
        String dmn = System.getProperty("CV_NTP_DAEMON_NAME");
        if (dmn != null && dmn.trim().length() > 0) {
            retList.add(dmn);
        } else {
            retList.add("ntp");
        }
        retList.add("W32Time");
        retList.add("vmictimesync");
        return retList;
    }

    public String getNTPDaemonName() {
        String ret = this.getNTPDaemonNames().get(0);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    public List<String> getDaemonPidFilePath() {
        this.throwUOException("getDaemonPidFilePathList");
        return null;
    }

    public String getDaemonPidFilePath(String daemonName) {
        this.throwUOException("getDaemonPidFilePath");
        return null;
    }

    public String getNTPQueryCommand() {
        this.throwUOException("getNTPQueryCommand");
        return null;
    }

    public String getNTPDCommandLine(String queryType) {
        this.throwUOException("getNTPCommandLine");
        return null;
    }

    public String getNTPDBootConfigFile() {
        this.throwUOException("getNTPDBootConfigFile");
        return null;
    }

    public String getNTPDSlewingOption() {
        this.throwUOException("getNTPDSlewingOption");
        return null;
    }

    public boolean isDaemonChrony(String daemonName) {
        return false;
    }

    public void doChronyChecks(ResultSet locrs, Vector<String> dmnOkVec) {
        this.throwUOException("doChronyChecks");
    }

    public String[] parseNTPQueryOutput(String ntpqOutput) {
        this.throwUOException("getNTPQueryOutput");
        return null;
    }

    public String getIDFromNTPOutput(String tsline) {
        this.throwUOException("getIDFromNTPOutput");
        return null;
    }

    public Vector<String> getRejectedTimeServerList() {
        return this.m_rejectedTimeServerEntries;
    }

    public void cleanRejectedTimeServerList() {
        this.m_rejectedTimeServerEntries = null;
    }

    public float getNTPOffsetLimit() {
        this.throwUOException("getNTPOffSetLimit");
        return 0.0f;
    }

    public boolean parseNTPDCommandLine(String cmdline, String queryType) {
        this.throwUOException("parseNTPDCommandLine");
        return false;
    }

    public boolean isNTPQSupported() {
        return this.m_isNTPQSupported;
    }

    public String getCfgFileToSearch() {
        this.throwUOException("getCfgFileToSearch");
        return "Unsupported on NT";
    }

    public boolean doCheckRegistryKeys(String srvcName, List<String> registryOKNodes, String[] nlist) {
        ResultSet result = new ResultSet();
        boolean ret = true;
        if (srvcName.equals("W32Time")) {
            registryOKNodes.clear();
            for (int index = 0; index < m_w32TimeConfigParamsIds.length; ++index) {
                ArrayList<String> badRegistryNodesByKey = new ArrayList<String>();
                ArrayList<String> missingRegistryNodesByKey = new ArrayList<String>();
                String regValueId = m_w32TimeConfigParamsIds[index];
                for (String node : nlist) {
                    String errMsg = null;
                    try {
                        Integer currentValue = new ClusterWindows().getRegIntegerDataOnNode(m_w32TimeConfigKey, regValueId, node);
                        if (currentValue != null) {
                            if (currentValue < 0 || currentValue > m_w32TimeConfigParamsVal[index]) {
                                result.addResult(node, 3);
                                badRegistryNodesByKey.add(node);
                                ret = false;
                                continue;
                            }
                            result.addResult(node, 1);
                            registryOKNodes.add(node);
                            continue;
                        }
                        result.addResult(node, 2);
                        missingRegistryNodesByKey.add(node);
                        ret = false;
                    }
                    catch (ClusterException ce) {
                        errMsg = ce.getMessage();
                        ErrorDescription errDes = new ErrorDescription(errMsg);
                        result.addErrorDescription(errDes);
                        result.addResult(node, 2);
                        ret = false;
                    }
                }
                if (badRegistryNodesByKey.size() > 0) {
                    String csBadRegistryNodes = VerificationUtil.strCollection2String(badRegistryNodesByKey);
                    String errMsg = s_gMsgBundle.getMessage("10400", true, (Object[])new String[]{regValueId, Integer.toString(m_w32TimeConfigParamsVal[index]), csBadRegistryNodes});
                    ErrorDescription errDes = new ErrorDescription(errMsg);
                    result.addErrorDescription(errDes);
                }
                if (missingRegistryNodesByKey.size() <= 0) continue;
                String csMissingRegistryNodes = VerificationUtil.strCollection2String(missingRegistryNodesByKey);
                String errMsg = s_gMsgBundle.getMessage("10401", true, (Object[])new String[]{regValueId, Integer.toString(m_w32TimeConfigParamsVal[index]), csMissingRegistryNodes});
                ErrorDescription errDes = new ErrorDescription(errMsg);
                result.addErrorDescription(errDes);
            }
            TaskAnonymousProxy registryCheckTask = new TaskAnonymousProxy(s_gMsgBundle.getMessage("10407", false, (Object[])new String[]{srvcName}), nlist, this.m_genTask, result);
            registryCheckTask.performAnonymousTask(result);
        }
        return ret;
    }

    boolean isGenericDaemonCheck(String[] nodeList, ResultSet locrs) {
        locrs.addResult(nodeList, 1);
        return true;
    }

    public void doSolarisNonGlobalZoneDaemonCheck(String[] nodeList, ResultSet locrs) {
        this.throwUOException("doSolarisNonGlobalZoneDaemonCheck");
    }
}

