/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Map;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WinSecurityUtil;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskClusterNodesNotDomainController
extends Task {
    public sTaskClusterNodesNotDomainController(VerificationTaskContext ctx) {
        super(ctx);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationType.PREREQ_SI_DB_INST.equals((Object)this.m_globalContext.getVerificationType())) {
            String strVirtualAccount = CVUVariables.getValue(CVUVariableConstants.IS_VIRTUAL_ACCOUNT);
            if ("TRUE".equalsIgnoreCase(strVirtualAccount)) {
                Trace.out((String)"virtual user for SIDB install. so adding the task");
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean performTask() {
        boolean ret = false;
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("1800", false, (Object[])new String[]{VerificationUtil.strArr2List(this.m_nodeList)}));
        Map nodeDCMap = null;
        try {
            String srcloc = VerificationUtil.getCVHome();
            String destloc = VerificationUtil.getDestLoc();
            Trace.out((String)"getting winsecurity factory and user");
            WinSecurityFactory wsecFac = WinSecurityFactory.getInstance((String)srcloc, (String)destloc);
            WinSecurityUtil wUtil = wsecFac.getWinSecurityUtil(new Version());
            if (m_localNode != null) {
                nodeDCMap = wUtil.isDomainController(m_localNode, this.m_nodeList);
            } else {
                boolean isHostDC = wUtil.isDomainController();
                nodeDCMap.put(VerificationUtil.getLocalHostName(), isHostDC);
            }
            ret = true;
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_gMsgBundle.getMessage("0415", false), s_msgBundle.getMessage("8018", false));
            ArrayList<String> dcNodesList = new ArrayList<String>();
            for (String node : nodeDCMap.keySet()) {
                String status;
                String isDomainControllerStr;
                if (((Boolean)nodeDCMap.get(node)).booleanValue()) {
                    isDomainControllerStr = ReportUtil.YES;
                    status = ReportUtil.FAILED;
                    this.m_resultSet.addResult(node, 4);
                    dcNodesList.add(node);
                    Trace.out((String)(node + " is a domain controller"));
                } else {
                    Trace.out((String)(node + " is not a domain controller"));
                    isDomainControllerStr = ReportUtil.NO;
                    status = ReportUtil.PASSED;
                    this.m_resultSet.addResult(node, 1);
                }
                ReportUtil.writeRecord(node, isDomainControllerStr, status);
            }
            if (dcNodesList.size() > 0) {
                String errMsg = s_gMsgBundle.getMessage("1801", true, (Object[])new String[]{VerificationUtil.strList2List(dcNodesList)});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(dcNodesList.toArray(new String[dcNodesList.size()]), errDesc);
                ReportUtil.printWarning(errMsg);
            } else {
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("1802", false));
            }
        }
        catch (WindowsSecurityException e) {
            String errMsg = s_gMsgBundle.getMessage("1803", true, (Object[])new String[]{VerificationUtil.strArr2String(this.m_nodeList)}) + LSEP + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.sureprintln(errMsg);
        }
        catch (CompositeOperationException e) {
            String[] errNodeArr = this.getCompositeOperationFailureNodes(e);
            String errMsg = s_gMsgBundle.getMessage("1803", true, (Object[])new String[]{VerificationUtil.strArr2String(errNodeArr)}) + LSEP + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(errNodeArr, 2);
            ReportUtil.sureprintln(errMsg);
        }
        return ret;
    }

    private String[] getCompositeOperationFailureNodes(CompositeOperationException e) {
        ArrayList<String> failedNodeList = new ArrayList<String>();
        for (String node : this.m_nodeList) {
            try {
                if (e.getStatus((Object)node) == CompositeOperationException.Status.SUCCESS) continue;
                failedNodeList.add(node);
            }
            catch (NoSuchIdentifierException ne) {
                failedNodeList.add(node);
            }
        }
        return failedNodeList.toArray(new String[failedNodeList.size()]);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("1804", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("1805", false);
    }
}

