/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;

public class sTaskCheckAutomount
extends Task {
    private String m_regKey = "HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\MountMgr";
    private String m_regValName = "NoAutoMount";
    private static ClusterWindows clusterWindows = null;

    public sTaskCheckAutomount(VerificationTaskContext ctx) {
        super(ctx);
    }

    public sTaskCheckAutomount(String[] nodeList) {
        super(nodeList);
    }

    @Override
    public boolean performTask() {
        boolean result = false;
        boolean defaultAutomountSetting = false;
        int keyValueData = 0;
        String errMsg = null;
        this.setSeverity(SeverityType.IGNORABLE);
        ReportUtil.blankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("5552", false));
        try {
            clusterWindows = new ClusterWindows();
        }
        catch (ClusterException e) {
            Trace.out((String)("sTaskCheckAutomount:: Cannot create ClusterWindows " + e.getMessage()));
            errMsg = s_msgBundle.getMessage("5559", true);
            errMsg = errMsg + LSEP + e.getMessage();
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        Trace.out((String)"sTaskCheckAutomount :: Performing Automount feature verification task for Windows... ");
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            Trace.out((String)("sTaskCheckAutomount:: Performing Automount feature verification on node: " + this.m_nodeList[i]));
            String node = this.m_nodeList[i];
            Result nodeResult = new Result(node);
            try {
                result = clusterWindows.regKeyExistsOnNode(this.m_regKey, node);
            }
            catch (ClusterException ce) {
                Trace.out((String)("sTaskCheckAutomount:: Could not read Registry subkey " + this.m_regKey + " error : " + ce.getMessage()));
                errMsg = s_msgBundle.getMessage("5557", true, (Object[])new String[]{node});
                nodeResult.addErrorDescription(new ErrorDescription(errMsg));
                nodeResult.setStatus(2);
                this.m_resultSet.addResult(node, nodeResult);
                continue;
            }
            if (result) {
                nodeResult.setHasResultValues(true);
                nodeResult.setExpectedValue(s_msgBundle.getMessage("8133", false));
                try {
                    keyValueData = clusterWindows.getRegIntegerDataOnNode(this.m_regKey, this.m_regValName, node);
                }
                catch (ClusterException e) {
                    Trace.out((String)("sTaskCheckAutomount:: Registry Value " + this.m_regValName + " not found under subkey " + this.m_regKey + " error : " + e.getMessage()));
                    defaultAutomountSetting = true;
                }
                if (defaultAutomountSetting) {
                    defaultAutomountSetting = false;
                    nodeResult.setStatus(1);
                    nodeResult.setActualValue(s_msgBundle.getMessage("8133", false));
                } else if (keyValueData == 0) {
                    nodeResult.setStatus(1);
                    nodeResult.setActualValue(s_msgBundle.getMessage("8133", false));
                } else {
                    errMsg = s_msgBundle.getMessage("5556", true, (Object[])new String[]{node});
                    nodeResult.addErrorDescription(new ErrorDescription(errMsg));
                    nodeResult.setStatus(3);
                    nodeResult.setActualValue(s_msgBundle.getMessage("8134", false));
                }
            } else {
                errMsg = s_msgBundle.getMessage("5557", true, (Object[])new String[]{this.m_regKey, node});
                nodeResult.addErrorDescription(new ErrorDescription(errMsg));
                nodeResult.setStatus(2);
            }
            this.m_resultSet.addResult(node, nodeResult);
        }
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, s_msgBundle.getMessage("5207", false), ReportUtil.COMMENT);
        Hashtable ht = this.m_resultSet.getResultTable();
        Enumeration e = ht.keys();
        Vector<String> verFailedNodes = new Vector<String>();
        Vector<String> opFailedNodes = new Vector<String>();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result amResult = (Result)ht.get(node);
            if (amResult.getStatus() == 1) {
                Trace.out((String)("Result.OPERATION_SUCCESSFUL:: AutoMount Feature is enabled on Node " + node));
                ReportUtil.writeRecord(node, ReportUtil.YES, ReportUtil.PASSED);
                continue;
            }
            if (amResult.getStatus() == 3) {
                Trace.out((String)("Result.VERIFICATION_FAILED:: AutoMount Feature is Disabled on Node " + node));
                ReportUtil.writeRecord(node, ReportUtil.NO, ReportUtil.FAILED);
                verFailedNodes.add(node);
                continue;
            }
            Trace.out((String)"Result.OPERATION FAILED:: cannot perform AutoMount Feature status check");
            ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, s_msgBundle.getMessage("5560", false, (Object[])new String[]{this.m_regKey}));
            opFailedNodes.add(node);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("5553", false));
            return true;
        }
        if (verFailedNodes.size() > 0) {
            ReportUtil.printErrorWithNodes(s_msgBundle.getMessage("5555", true), verFailedNodes);
        }
        if (opFailedNodes.size() > 0) {
            ReportUtil.printErrorWithNodes(s_msgBundle.getMessage("5558", true), opFailedNodes);
        }
        ReportUtil.printResult(s_msgBundle.getMessage("5554", false));
        return false;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("5551", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("5550", false);
    }
}

