/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskAdminPrivileges;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

class sAdminPriv
implements VerificationConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private String[] m_nodeList;
    private String m_operation;
    private TaskAdminPrivileges m_taskAdminPriv;
    private String m_oracleHome;
    private ResultSet m_admPrvResultSet;

    protected sAdminPriv(String[] nodeList, String operation, ResultSet admPrvResultSet, TaskAdminPrivileges taskAdminPriv) {
        this.m_nodeList = nodeList;
        this.m_operation = operation;
        this.m_taskAdminPriv = taskAdminPriv;
        this.m_admPrvResultSet = admPrvResultSet;
    }

    protected boolean checkAdminPriv() {
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4012", false));
        this.m_admPrvResultSet.addResult(this.m_nodeList, 1);
        this.performAdminPrivChecks();
        if (this.m_admPrvResultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4300", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4301", false));
        return false;
    }

    private void performAdminPrivChecks() {
        if (this.m_operation.equalsIgnoreCase("db_config")) {
            this.m_oracleHome = this.m_taskAdminPriv.getOracleHome();
            ResultSet ohomeExistRS = new ResultSet();
            VerificationUtil.validateOracleHome(this.m_nodeList, this.m_oracleHome, ohomeExistRS);
            TaskAnonymousProxy valOracleHome = new TaskAnonymousProxy(this.m_oracleHome, this.m_nodeList, this.m_taskAdminPriv, ohomeExistRS);
            valOracleHome.perform();
            this.m_admPrvResultSet.addResultSetData(ohomeExistRS);
            if (ohomeExistRS.anyFailure()) {
                return;
            }
        }
    }
}

