/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskValidateNodeRoles
extends Task
implements VerificationConstants {
    boolean m_isAddNode = false;
    String[] m_newNodes = null;

    public TaskValidateNodeRoles(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case PREREQ_NODE_ADD: {
                ParamPreReqNodeAddDel param = (ParamPreReqNodeAddDel)this.m_globalContext.getParamPrereq();
                if (param != null) {
                    this.setNodeList(param.getValidClusterNodes());
                }
                NodeManager nodeMgr = null;
                try {
                    nodeMgr = NodeManagerFactory.getInstance().getNodeManager();
                    this.addNodes(nodeMgr.getNewNodes(NodeRoleCapability.ALL));
                    break;
                }
                catch (NodeManagerFactoryException nmfe) {
                    Trace.out((String)("NodeManagerFactoryException: " + nmfe.getMessage()));
                    break;
                }
                catch (NoSuchNodesException nsne) {
                    Trace.out((String)("NoSuchNodesException: " + nsne.getMessage()));
                    break;
                }
                catch (NodeManagerException nme) {
                    Trace.out((String)("NodeManagerException: " + nme.getMessage()));
                }
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return false;
    }

    public TaskValidateNodeRoles(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskValidateNodeRoles(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskValidateNodeRoles(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void addNodes(String[] newNodes) {
        this.m_isAddNode = true;
        this.m_newNodes = newNodes;
    }

    @Override
    public boolean performTask() {
        String errMsg = s_gMsgBundle.getMessage("11518", true);
        this.m_resultSet.addResult(this.m_nodeList, 1);
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11512", false));
        String[] hubNodes = new String[]{};
        String[] autoNodes = new String[]{};
        String[] rimNodes = new String[]{};
        try {
            hubNodes = this.m_nodeMgr.getConfiguredHubNodes();
        }
        catch (NoSuchNodesException nsnEx) {
            Trace.out((String)("NoSuchNodesException while getting HUB nodes:" + nsnEx.getMessage()));
        }
        try {
            rimNodes = this.m_nodeMgr.getConfiguredRimNodes();
        }
        catch (NoSuchNodesException nsnEx) {
            Trace.out((String)("NoSuchNodesException while getting RIM nodes:" + nsnEx.getMessage()));
        }
        try {
            autoNodes = this.m_nodeMgr.getConfiguredAutoNodes();
        }
        catch (NoSuchNodesException nsnEx) {
            Trace.out((String)("NoSuchNodesException while getting AUTO nodes:" + nsnEx.getMessage()));
        }
        if (autoNodes.length != 0 && (hubNodes.length != 0 || rimNodes.length != 0)) {
            String errorStr = s_gMsgBundle.getMessage("11515", true);
            ReportUtil.printError(errorStr);
            this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errorStr));
            this.m_resultSet.addResult(this.m_nodeList, 3);
            return false;
        }
        if (this.m_isAddNode) {
            boolean isAutoConfig;
            boolean bl = isAutoConfig = autoNodes.length != 0;
            if (this.performTaskNewNodes(isAutoConfig)) {
                String msg = s_gMsgBundle.getMessage("11519", false);
                ReportUtil.sureprintln(msg);
                this.m_resultSet.addResult(this.m_newNodes, 1);
                this.m_resultSet.addResult(this.m_nodeList, 1);
                return true;
            }
            return false;
        }
        String msg = s_gMsgBundle.getMessage("11519", false);
        ReportUtil.sureprintln(msg);
        this.m_resultSet.addResult(this.m_nodeList, 1);
        return true;
    }

    private boolean performTaskNewNodes(boolean isAutoConfig) {
        if (isAutoConfig) {
            Trace.out((String)"Cluster is auto config cluster. Check for new non auto nodes");
            String[] nonAutoNodes = this.getNewNodes(false);
            if (nonAutoNodes.length != 0) {
                String errorStr = s_gMsgBundle.getMessage("11516", true, (Object[])new String[]{VerificationUtil.strArr2List(nonAutoNodes)});
                ReportUtil.printError(errorStr);
                this.m_resultSet.addErrorDescription(nonAutoNodes, new ErrorDescription(errorStr));
                this.m_resultSet.addResult(nonAutoNodes, 3);
            }
        } else {
            Trace.out((String)"Cluster is auto config cluster. checking for new auto nodes");
            String[] autoNodes = this.getNewNodes(true);
            if (autoNodes.length != 0) {
                String errorStr = s_gMsgBundle.getMessage("11517", true, (Object[])new String[]{VerificationUtil.strArr2List(autoNodes)});
                ReportUtil.printError(errorStr);
                this.m_resultSet.addErrorDescription(autoNodes, new ErrorDescription(errorStr));
                this.m_resultSet.addResult(autoNodes, 3);
            }
        }
        return this.m_resultSet.allSuccess();
    }

    private String[] getNewNodes(boolean isAutoNodes) {
        String[] newAutoNodes = null;
        String[] newNonAutoNodes = null;
        try {
            newAutoNodes = this.m_nodeMgr.getNewNodes(this.m_newNodes, NodeRoleCapability.AUTO);
            ArrayList<String> nonAutoNodesLst = new ArrayList<String>();
            List<String> newAutoNodesLst = Arrays.asList(newAutoNodes);
            for (String node : this.m_newNodes) {
                if (newAutoNodesLst.contains(node)) continue;
                nonAutoNodesLst.add(node);
            }
            newNonAutoNodes = nonAutoNodesLst.toArray(new String[0]);
        }
        catch (NoSuchNodesException nsnEx) {
            Trace.out((String)"NoSuchNodesException occured while getting new AUTO nodes");
            newNonAutoNodes = this.m_newNodes;
            newAutoNodes = new String[]{};
        }
        catch (NodeManagerException nmEx) {
            String msg = nmEx.getMessage();
            Trace.out((String)("NodeManagerException while getting new AUTO nodes:" + msg));
            newNonAutoNodes = new String[]{};
            newAutoNodes = new String[]{};
            this.m_resultSet.addResult(this.m_newNodes, 2);
            this.m_resultSet.addErrorDescription(this.m_newNodes, new ErrorDescription(msg));
            ReportUtil.printError(msg);
        }
        if (isAutoNodes) {
            return newAutoNodes;
        }
        return newNonAutoNodes;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11511", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11510", false);
    }
}

