/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.List;
import oracle.cluster.cmdtools.ASMCMDUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMPresence;
import oracle.ops.verification.framework.util.CVUHelperException;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUpgradeChecksASMAndListener
extends Task {
    private Version m_srcRelease = null;
    private boolean m_isPre112 = false;
    private boolean m_isPre121 = false;

    public TaskUpgradeChecksASMAndListener(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (this.m_srcRelease != null && !Version.isPre112((Version)this.m_srcRelease)) {
            ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil();
            ResultSet asmRsltSet = new ResultSet();
            List<String> asmRunningNodes = asmdg.getASMInstanceRunningNodes(this.m_nodeList, asmRsltSet);
            if (asmRunningNodes != null && !asmRunningNodes.isEmpty()) {
                Trace.out((String)("ASM instance was found running on nodes " + asmRunningNodes + " Adding ASM instance parameter file existence check for upgrade"));
                return true;
            }
            Trace.out((String)"Not adding ASM instance param file related checks for upgrade as ASM instance was not found running on any of the cluster nodes in this upgrade scenario.");
            return false;
        }
        Trace.out((String)"Upgrade from pre 11.2 GI home, Adding ASM instance and default listener check for upgrade");
        return true;
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("ACTIVE_VERSION".equals(argName) && VerificationUtil.isStringGood(argVal)) {
                try {
                    this.m_srcRelease = VerificationUtil.getVersionObject(argVal);
                }
                catch (ConfigurationException e) {
                    Trace.out((String)("Failed to obtain the Version object for " + argVal));
                }
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    public TaskUpgradeChecksASMAndListener(Version srcRelease, String[] nodeList) {
        super(nodeList);
        this.m_srcRelease = srcRelease;
    }

    @Override
    public boolean performTask() {
        boolean retVal = false;
        Trace.out((String)("Source release version : " + this.m_srcRelease));
        if (this.m_srcRelease != null) {
            if (Version.isPre11202((Version)this.m_srcRelease)) {
                this.m_isPre112 = true;
            } else if (Version.isPre12101((Version)this.m_srcRelease)) {
                this.m_isPre121 = true;
            }
        }
        if (this.m_isPre112) {
            Trace.out((String)"Not performing ASM parameter file check as the source CRS home release is pre 11.2");
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("4554", false, (Object[])new String[]{m_localNode}));
            Trace.out((String)"Checking if ASM instance if configured is running from local node");
            ResultSet asmInstanceResultSet = this.checkASMInstanceConfiguredAndRunning();
            this.m_resultSet.addResultSetData(asmInstanceResultSet);
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("4555", false, (Object[])new String[]{m_localNode}));
            Trace.out((String)"Checking if Default listener if configured is running from local node");
            ResultSet defaultListnrResultSet = this.checkDefaultListenerConfiguration();
            this.m_resultSet.addResultSetData(defaultListnrResultSet);
            if (this.m_resultSet.getStatus() != 1) {
                this.m_resultSet.addResult(this.m_nodeList, this.m_resultSet.getStatus());
                ReportUtil.printResult(s_gMsgBundle.getMessage("4553", false));
                return false;
            }
            this.m_resultSet.addResult(this.m_nodeList, 1);
            ReportUtil.printResult(s_gMsgBundle.getMessage("4552", false));
            return true;
        }
        if (this.m_globalContext.isUpgrade()) {
            Trace.out((String)"Upgrade scenario. setting severity to FATAL for ASM parameter file and password file related checks.");
            this.setSeverity(SeverityType.FATAL);
        }
        Trace.out((String)"Performing ASM parameter file check as the source CRS home release is post 11.2");
        retVal = this.checkASMParameterFile();
        if (!this.m_isPre121) {
            Trace.out((String)"Performing ASM password file check as the source CRS home release is post 12.1");
            retVal &= this.checkASMPasswordFile();
        }
        return retVal;
    }

    private boolean checkASMParameterFile() {
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("4565", false));
        String crsHome = VerificationUtil.getCRSHome();
        ASMCMDUtil asmcmd = null;
        String message = null;
        String oracleSID = "";
        boolean spfileExists = false;
        try {
            asmcmd = new ASMCMDUtil(crsHome);
            oracleSID = asmcmd.getOracleSID();
        }
        catch (CmdToolUtilException e) {
            Trace.out((String)("CmdToolUtilException while trying to get Oracle SID" + e.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            ReportUtil.printResult(e.getMessage());
            return false;
        }
        Result result = new Result(m_localNode);
        String spfileLocation = CVUHelperUtil.getASMParameter("spfile", result);
        if (!VerificationUtil.isStringGood(spfileLocation) || spfileLocation.trim().equalsIgnoreCase("null")) {
            if (result.getStatus() == 1) {
                Trace.out((String)"The SPFile is not in use by the ASM instance, Checking for the default PFILE location");
                NativeSystem nativeSystem = new SystemFactory().CreateSystem();
                String pfileLocation = nativeSystem.getPfileName(crsHome, oracleSID);
                if (VerificationUtil.isStringGood(pfileLocation) && new File(pfileLocation).exists()) {
                    Trace.out((String)("PFILE " + pfileLocation + " exists"));
                    this.m_resultSet.addResult(this.m_nodeList, 1);
                    message = s_gMsgBundle.getMessage("4566", true, (Object[])new String[]{pfileLocation, m_localNode});
                    this.m_resultSet.addErrorDescription(new ErrorDescription(message));
                    ReportUtil.printResult(message);
                } else {
                    Trace.out((String)("PFILE " + pfileLocation + " does not exists"));
                    this.m_resultSet.addResult(this.m_nodeList, 3);
                    message = s_gMsgBundle.getMessage("4568", true, (Object[])new String[]{pfileLocation, m_localNode});
                    this.m_resultSet.addErrorDescription(new ErrorDescription(message));
                    ReportUtil.printResult(message);
                }
            } else {
                String errorInGetParamFile = VerificationUtil.errorCollection2String(result.getErrors());
                Trace.out((String)("Failed to obtain the SP file location for current ASM instance. Error is " + errorInGetParamFile));
                this.m_resultSet.addResult(result.getNode(), result);
                ReportUtil.printResult(errorInGetParamFile);
            }
        } else {
            Trace.out((String)("SPFILE location for current ASM instance is (" + spfileLocation + ")"));
            if (VerificationUtil.isASMPath(spfileLocation)) {
                try {
                    if (asmcmd != null) {
                        spfileExists = asmcmd.checkASMFilePathExists(spfileLocation);
                    }
                }
                catch (CmdToolUtilException e) {
                    Trace.out((String)("CmdToolUtilException while checking ASM file existence :" + e.getMessage()));
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
                    ReportUtil.printResult(e.getMessage());
                    return false;
                }
                if (spfileExists) {
                    Trace.out((String)("The parameter spfile " + spfileLocation + " exists"));
                    this.m_resultSet.addResult(this.m_nodeList, 1);
                    message = s_gMsgBundle.getMessage("4571", false, (Object[])new String[]{spfileLocation});
                    ReportUtil.printResult(message);
                }
            } else {
                Trace.out((String)("The parameter file " + spfileLocation + " not on ASM"));
                this.m_resultSet.addResult(this.m_nodeList, 3);
                message = s_gMsgBundle.getMessage("4572", true, (Object[])new String[]{spfileLocation});
                this.m_resultSet.addErrorDescription(new ErrorDescription(message));
                ReportUtil.printResult(message);
            }
        }
        return this.m_resultSet.allSuccess();
    }

    private boolean checkASMPasswordFile() {
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("4573", false));
        String crsHome = VerificationUtil.getCRSHome();
        ASMCMDUtil asmcmd = null;
        String message = null;
        String pwdFileLocation = null;
        boolean pwdfileExists = false;
        try {
            pwdFileLocation = CVUHelperUtil.getASMPWFile();
            Trace.out((String)("ASM Password Fle location is : " + pwdFileLocation));
        }
        catch (CVUHelperException e) {
            Trace.out((String)("CVUHelperException while trying to get ASM PWDFILE location Error is " + e.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 3);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            ReportUtil.printResult(e.getMessage());
            return false;
        }
        if (VerificationUtil.isStringGood(pwdFileLocation) && !pwdFileLocation.trim().equalsIgnoreCase("null")) {
            if (VerificationUtil.isASMPath(pwdFileLocation)) {
                try {
                    asmcmd = new ASMCMDUtil(crsHome);
                    if (asmcmd != null) {
                        pwdfileExists = asmcmd.checkASMFilePathExists(pwdFileLocation);
                    }
                }
                catch (CmdToolUtilException e) {
                    Trace.out((String)("CmdToolUtilException while checking ASM file existence :" + e.getMessage()));
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
                    ReportUtil.printResult(e.getMessage());
                    return false;
                }
                if (pwdfileExists) {
                    Trace.out((String)("The pwdfile " + pwdFileLocation + " exists"));
                    this.m_resultSet.addResult(this.m_nodeList, 1);
                    message = s_gMsgBundle.getMessage("4575", false, (Object[])new String[]{pwdFileLocation});
                    ReportUtil.printResult(message);
                }
            } else {
                Trace.out((String)("The pwdfile " + pwdFileLocation + " not on ASM"));
                this.m_resultSet.addResult(this.m_nodeList, 3);
                message = s_gMsgBundle.getMessage("4574", true, (Object[])new String[]{pwdFileLocation});
                this.m_resultSet.addErrorDescription(new ErrorDescription(message));
                ReportUtil.printResult(message);
            }
        }
        return this.m_resultSet.allSuccess();
    }

    private ResultSet checkASMInstanceConfiguredAndRunning() {
        ResultSet asmRsltSet = new ResultSet();
        Result localNodeRes = new Result(m_localNode);
        String message = null;
        ASMDiskGroupsUtil asmDiskGroup = new ASMDiskGroupsUtil();
        List<String> runningNodeList = asmDiskGroup.getASMInstanceRunningNodes(this.m_nodeList, asmRsltSet);
        if (asmRsltSet.getStatus() == 1) {
            if (!runningNodeList.isEmpty()) {
                if (VerificationUtil.inListIgnoreCase(runningNodeList, m_localNode)) {
                    Trace.out((String)("ASM instance is found configured and running on the local node " + m_localNode));
                    VerificationLogData.log("ASM instance is found configured and running on the local node " + m_localNode);
                    message = s_gMsgBundle.getMessage("4556", false, (Object[])new String[]{m_localNode});
                    localNodeRes.setStatus(1);
                    ReportUtil.sureprintln(message);
                } else {
                    Trace.out((String)("ASM instance was not found running on the local node " + m_localNode));
                    VerificationLogData.log("ASM instance was not found running on the local node " + m_localNode);
                    ASMPresence asmPresence = CVUHelperUtil.getASMPresence();
                    if (asmPresence.equals((Object)ASMPresence.LOCAL)) {
                        Trace.out((String)"ASM presense is local not flex but still no local ASM instance found runinng.");
                        localNodeRes.setStatus(3);
                    } else {
                        localNodeRes.setStatus(4);
                    }
                    message = s_gMsgBundle.getMessage("4558", true, (Object[])new String[]{VerificationUtil.strCollection2String(runningNodeList), m_localNode});
                    ReportUtil.printWarning(message);
                    localNodeRes.addErrorDescription(new ErrorDescription(message));
                }
            } else {
                Trace.out((String)"ASM instance was not found configured on any of the cluster nodes, Its a success case");
                VerificationLogData.log("ASM instance was not found configured on any of the cluster nodes, Its a success case");
                localNodeRes.setStatus(1);
                message = s_gMsgBundle.getMessage("4559", false);
                ReportUtil.println(message);
            }
            asmRsltSet.addResult(m_localNode, localNodeRes);
        } else {
            for (VerificationError err : asmRsltSet.getErrors()) {
                ReportUtil.printError(err.getErrorMessage());
                Trace.out((String)err.getErrorMessage());
                VerificationLogData.log(err.getErrorMessage());
            }
        }
        if (asmRsltSet.anyFailure() && this.m_globalContext.isUpgrade()) {
            Trace.out((String)"UPGRADE CASE: Marking Severity of this task to FATAL");
            this.setSeverity(SeverityType.FATAL);
        }
        return asmRsltSet;
    }

    private ResultSet checkDefaultListenerConfiguration() {
        ResultSet listenerRsltSet = new ResultSet();
        String message = null;
        Result checkLstnrRes = new Result(m_localNode);
        CVUHelperUtil.checkDefaultListener(checkLstnrRes);
        Result localNodeRes = new Result(m_localNode);
        if (checkLstnrRes.getStatus() == 1) {
            Trace.out((String)("Default listener " + m_localNode + " was found configured and running on local node"));
            VerificationLogData.log("Default listener for node " + m_localNode + " was found configured and running on local node");
            message = s_gMsgBundle.getMessage("4557", false, (Object[])new String[]{m_localNode});
            ReportUtil.sureprintln(message);
            localNodeRes.setStatus(1);
        } else if (checkLstnrRes.getStatus() == 4) {
            String resourceRunningNode = "";
            try {
                resourceRunningNode = checkLstnrRes.getActualValue();
            }
            catch (ResultValuesUnavailableException e) {
                Trace.out((String)"Caught ResultValuesUnavailableException: this exception was not expected, Ignoring");
            }
            Trace.out((String)("Default listener for node " + m_localNode + " was found configured but running on node " + resourceRunningNode));
            VerificationLogData.log("Default listener " + m_localNode + " was found configured but running on node " + resourceRunningNode);
            localNodeRes.setStatus(4);
            message = s_gMsgBundle.getMessage("4560", true, (Object[])new String[]{m_localNode, resourceRunningNode});
            ReportUtil.printWarning(message);
            localNodeRes.addErrorDescription(new ErrorDescription(message));
        } else if (checkLstnrRes.getStatus() == 3) {
            Trace.out((String)("Default listener for node " + m_localNode + " was not found configured"));
            VerificationLogData.log("Default listener for node " + m_localNode + " was not found configured");
            localNodeRes.setStatus(4);
            message = s_gMsgBundle.getMessage("4561", false, (Object[])new String[]{m_localNode});
            ReportUtil.printWarning(message);
            localNodeRes.addErrorDescription(new ErrorDescription(message));
        } else {
            String error = "";
            for (VerificationError err : checkLstnrRes.getErrors()) {
                error = error + err.getErrorMessage();
            }
            message = s_gMsgBundle.getMessage("4563", true, (Object[])new String[]{m_localNode, error});
            ReportUtil.printError(message);
            localNodeRes.setStatus(2);
            localNodeRes.addErrorDescription(new ErrorDescription(message));
        }
        listenerRsltSet.addResult(m_localNode, localNodeRes);
        listenerRsltSet.setStatus();
        return listenerRsltSet;
    }

    @Override
    public String getDefaultDescription() {
        return this.m_isPre112 ? s_gMsgBundle.getMessage("4551", false) : s_gMsgBundle.getMessage("4570", false);
    }

    @Override
    public String getDefaultElementName() {
        return this.m_isPre112 ? s_gMsgBundle.getMessage("4550", false) : s_gMsgBundle.getMessage("4569", false);
    }
}

