/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUpgradeCheckPrivilegedGroups
extends Task {
    private static String OSASM_GROUP = "OSASM";
    private static String OSDBA_GROUP = "OSDBA";
    private String m_selectedOSASMGrp = null;
    private String m_selectedOSDBAGrp = null;

    public TaskUpgradeCheckPrivilegedGroups(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("ASM_GROUP".equals(argName)) {
                this.m_selectedOSASMGrp = argVal;
                continue;
            }
            if ("DBA_GROUP".equals(argName)) {
                this.m_selectedOSDBAGrp = argVal;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return VerificationUtil.isStringGood(this.m_selectedOSASMGrp) || VerificationUtil.isStringGood(this.m_selectedOSDBAGrp);
    }

    @Override
    public boolean performTask() {
        Trace.out((int)2, (String)"Entry");
        this.m_resultSet.setStatus(1);
        this.m_resultSet.setHasNodeResults(false);
        boolean usingCRSHome = false;
        boolean isASMConfigured = true;
        Trace.out((String)("Current selection of privileged groups is\nselectedOSASMGrp=" + this.m_selectedOSASMGrp + "\nselectedOSDBAGrp=" + this.m_selectedOSDBAGrp));
        String configuredOSASMGrp = null;
        String configuredOSDBAGrp = null;
        String osdbaHome = null;
        try {
            Trace.out((String)"Calling VerificationUtil.getCRSActiveVersionObj()");
            Version curVer = VerificationUtil.getCRSActiveVersionObj();
            Result result = new Result(m_localNode);
            if (curVer != null && Version.isPre112((Version)curVer)) {
                osdbaHome = CVUHelperUtil.getASMhome(result);
                if (!VerificationUtil.isStringGood(osdbaHome)) {
                    if (result.getStatus() != 2) {
                        Trace.out((String)"There is no ASM configured on any of the cluster nodes, considering RAC/DB home for running osdbagrp utility, Skipping the check for OSASM group");
                        isASMConfigured = false;
                        osdbaHome = CVUVariables.getValue(CVUVariableConstants.CV_RAC_HOME);
                        Trace.out((String)("Using home " + osdbaHome + " to run the osdba utility from"));
                    } else {
                        Trace.out((String)"Failed to retrieve the configured ASM Home using CVU helper.");
                        VerificationLogData.logError("Failed to retrieve the configured ASM Home using CVU helper.");
                    }
                } else {
                    Trace.out((String)("Successfully retrieved the ASM Home using CVU helper as (" + osdbaHome + ")"));
                    VerificationLogData.logFine("Successfully retrieved the ASM Home using CVU helper as (" + osdbaHome + ")");
                }
            } else {
                osdbaHome = VerificationUtil.getCRSHome(m_localNode, result);
                usingCRSHome = true;
            }
            if (VerificationUtil.isStringGood(osdbaHome)) {
                Trace.out((String)("Getting privileged groups from home location " + osdbaHome));
                VerificationLogData.log("Getting privileged groups from home location " + osdbaHome);
                if (isASMConfigured) {
                    configuredOSASMGrp = VerificationUtil.getOSAsmGroup(osdbaHome);
                }
            } else {
                Trace.out((String)"Could not locate the CRS or Oracle/database home to run the osdbagrp utility from.");
                VerificationLogData.log("Could not locate the CRS or Oracle/database home to run the osdbagrp utility from.");
                this.m_resultSet.addResult(m_localNode, result);
                throw new CVUException(s_msgBundle.getMessage(usingCRSHome ? "5301" : "7556", true));
            }
            configuredOSDBAGrp = VerificationUtil.getOSDBAGroup(osdbaHome);
        }
        catch (CVUException ce) {
            Trace.out((String)("Caught CVUException " + ce.getMessage()));
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_plgMsgBundle.getMessage("10125", true, (Object[])new String[]{ce.getMessage()})));
            this.m_resultSet.setStatus(2);
            return false;
        }
        Trace.out((String)("Configured privileged groups are\nconfiguredOSASMGrp=" + configuredOSASMGrp + "\nconfiguredOSDBAGrp=" + configuredOSDBAGrp));
        if (isASMConfigured && !VerificationUtil.isStringGood(this.m_selectedOSASMGrp) && m_isCLImode) {
            this.m_selectedOSASMGrp = configuredOSASMGrp;
        }
        if (!VerificationUtil.isStringGood(this.m_selectedOSDBAGrp) && m_isCLImode) {
            this.m_selectedOSDBAGrp = configuredOSDBAGrp;
        }
        if (isASMConfigured) {
            if (VerificationUtil.isStringGood(this.m_selectedOSASMGrp)) {
                if (VerificationUtil.isStringGood(configuredOSASMGrp)) {
                    if (!configuredOSASMGrp.equals(this.m_selectedOSASMGrp)) {
                        this.m_resultSet.addErrorDescription(new ErrorDescription(s_plgMsgBundle.getMessage(usingCRSHome ? "10123" : "10128", true, (Object[])new String[]{OSASM_GROUP, this.m_selectedOSASMGrp, configuredOSASMGrp, osdbaHome})));
                        this.m_resultSet.setStatus(3);
                    } else {
                        Trace.out((String)"The OS ASM group selection matches with the configured value");
                    }
                } else {
                    this.m_resultSet.addErrorDescription(new ErrorDescription(s_plgMsgBundle.getMessage(usingCRSHome ? "10126" : "10129", true, (Object[])new String[]{OSASM_GROUP, osdbaHome})));
                    this.m_resultSet.setStatus(4);
                }
            } else {
                Trace.out((String)"The current selection of OS ASM group could not be retrieved");
                this.m_resultSet.addErrorDescription(new ErrorDescription(s_plgMsgBundle.getMessage("10124", true, (Object[])new String[]{OSASM_GROUP})));
                this.m_resultSet.setStatus(3);
            }
        }
        if (VerificationUtil.isStringGood(this.m_selectedOSDBAGrp)) {
            if (VerificationUtil.isStringGood(configuredOSDBAGrp)) {
                if (!configuredOSDBAGrp.equals(this.m_selectedOSDBAGrp)) {
                    this.m_resultSet.addErrorDescription(new ErrorDescription(s_plgMsgBundle.getMessage(usingCRSHome ? "10123" : "10128", true, (Object[])new String[]{OSDBA_GROUP, this.m_selectedOSDBAGrp, configuredOSDBAGrp, osdbaHome})));
                    this.m_resultSet.setStatus(3);
                } else {
                    Trace.out((String)"The OS DBA group selection matches with the configured value");
                }
            } else {
                this.m_resultSet.addErrorDescription(new ErrorDescription(s_plgMsgBundle.getMessage(usingCRSHome ? "10126" : "10129", true, (Object[])new String[]{OSDBA_GROUP, osdbaHome})));
                this.m_resultSet.setStatus(4);
            }
        } else {
            Trace.out((String)"The current selection of OS DBA group could not be retrieved");
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_plgMsgBundle.getMessage("10124", true, (Object[])new String[]{OSDBA_GROUP})));
            this.m_resultSet.setStatus(3);
        }
        Trace.out((int)2, (String)"Exit");
        return this.m_resultSet.allSuccess();
    }

    @Override
    public String getDefaultDescription() {
        return s_plgMsgBundle.getMessage("10121", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_plgMsgBundle.getMessage("10120", false);
    }
}

