/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.engine.task.TaskContainerFreeSpace;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskFreeSpace;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskPeerCompatibility
extends Task {
    private String m_referenceNode;
    private String[] m_PCNodeList;
    private ParamPreReq m_paramPreReq = null;

    public TaskPeerCompatibility(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        switch (this.m_globalContext.getVerificationType()) {
            case COMPONENT_PEER_COMPATIBILITY: {
                Trace.out((String)"Initializing for comp peer compat");
                this.setReferenceNode(CVUVariables.getValue(CVUVariableConstants.REFERENCE_NODE));
                this.setParamPreReq(this.m_globalContext.getParamPrereq());
            }
        }
    }

    public TaskPeerCompatibility() {
        this(null, 1);
    }

    public TaskPeerCompatibility(MultiTaskHandler multiTaskHandler) {
        this(multiTaskHandler, 1);
    }

    public TaskPeerCompatibility(MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(multiTaskHandler, actionOnCompletion);
    }

    public void setReferenceNode(String referenceNode) {
        this.m_referenceNode = referenceNode;
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing Peer Compatibility verification task... ");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4600", false));
        if (this.m_referenceNode != null && this.m_referenceNode.trim().length() > 0) {
            if (this.m_nodeList.length == 1 && this.m_referenceNode.equalsIgnoreCase(this.m_nodeList[0])) {
                ReportUtil.printError(s_msgBundle.getMessage("4602", false) + " " + s_msgBundle.getMessage("0007", false));
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(new ErrorDescription("4602", s_msgBundle));
                return false;
            }
            ArrayList<String> tmpNodeList = new ArrayList<String>(Arrays.asList(this.m_nodeList));
            if (!tmpNodeList.contains(this.m_referenceNode)) {
                tmpNodeList.add(this.m_referenceNode);
            }
            this.m_PCNodeList = new String[tmpNodeList.size()];
            this.m_PCNodeList = tmpNodeList.toArray(this.m_PCNodeList);
            Trace.out((String)"==== Reference node added to the effective nodelist");
        } else {
            this.m_PCNodeList = this.m_nodeList;
        }
        List<Task> taskList = null;
        try {
            taskList = TaskFactory.getInstance().getTaskList(VerificationType.SYSREQ_CRS, this.m_PCNodeList, this.m_paramPreReq);
        }
        catch (PreReqNotSupportedException e) {
            Trace.out((Exception)e);
            ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            this.m_resultSet.addResult(this.m_PCNodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            return false;
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            this.m_resultSet.addResult(this.m_PCNodeList, 2);
            return false;
        }
        for (Task task : taskList) {
            this.processTask(task);
        }
        return this.m_resultSet.allSuccess();
    }

    private void processTask(Task task) {
        if (task instanceof TaskContainerFreeSpace) {
            this.performPeerForFreeSpace((TaskContainerFreeSpace)task);
            return;
        }
        if (task.hasSubtasks()) {
            try {
                List<VerificationTask> subTaskList = task.getSubtasks();
                for (VerificationTask subTask : subTaskList) {
                    this.processTask((Task)subTask);
                }
                return;
            }
            catch (SubtasksUnavailableException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_PCNodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_PCNodeList, new ErrorDescription(e.getMessage()));
                ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return;
            }
        }
        if (!(task instanceof PeerCompatibleTask)) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Task " + task.getDefaultElementName() + " is not suitable for peer compatiblity test. Skipping the task."));
            }
            return;
        }
        PeerCompatibleTask pTask = (PeerCompatibleTask)((Object)task);
        try {
            if (this.m_referenceNode == null || this.m_referenceNode.trim().length() == 0) {
                String taskName = pTask.getElementDisplayName();
                TaskAnonymousProxy anonymousProxy = new TaskAnonymousProxy(taskName, this.m_nodeList, this);
                ResultSet pTaskRS = pTask.performPeer();
                anonymousProxy.performAnonymousTask(pTaskRS);
                this.reportCompatibility(pTask.getElementDisplayName(), pTaskRS);
            } else {
                String taskName = pTask.getElementDisplayName();
                TaskAnonymousProxy anonymousProxy = new TaskAnonymousProxy(taskName, this.m_nodeList, this);
                ResultSet pTaskRS = pTask.performPeer();
                pTaskRS = pTask.processResultSetWithReferenceNode(this.m_referenceNode, pTaskRS);
                pTaskRS.addResult(this.m_referenceNode, 1);
                anonymousProxy.performAnonymousTask(pTaskRS);
                this.reportCompatibility(task, pTask.getElementDisplayName(), this.m_referenceNode, pTaskRS);
            }
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            this.m_resultSet.addResult(this.m_PCNodeList, 2);
            return;
        }
    }

    private void reportCompatibility(String taskName, ResultSet rset) {
        ReportUtil.sureblankln();
        String headerMsg = s_msgBundle.getMessage("1005", false, (Object[])new String[]{taskName});
        ReportUtil.sureprintln(headerMsg);
        ReportUtil.verboseReportPrintln(headerMsg);
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
        Hashtable t = rset.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String instStatus;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                instStatus = this.formatValue(result.getResultInfoSet().elementAt(0));
            } else if (result.getStatus() == 3) {
                instStatus = ReportUtil.UNKNOWN;
                if (result.getResultInfoSet().size() > 0) {
                    instStatus = this.formatValue(result.getResultInfoSet().elementAt(0));
                }
            } else {
                instStatus = ReportUtil.UNKNOWN;
            }
            ReportUtil.surewriteRecord(node, instStatus);
        }
        if (t.size() > 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1007", false, (Object[])new String[]{taskName}));
        }
        ReportUtil.reportPrintln(LSEP);
    }

    private void reportCompatibility(Task task, String taskName, String refNode, ResultSet resultSet) {
        boolean match = true;
        boolean status = true;
        ReportUtil.sureblankln();
        String headerMsg = s_msgBundle.getMessage("1009", false, (Object[])new String[]{taskName, refNode});
        ReportUtil.sureprintln(headerMsg);
        ReportUtil.verboseReportPrintln(headerMsg);
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.REF_STATUS, ReportUtil.COMMENT);
        Hashtable ht = resultSet.getResultTable();
        Result refNodeResult = (Result)ht.get(refNode);
        String refNodeValue = ReportUtil.UNKNOWN;
        int refNodeStatus = refNodeResult.getStatus();
        if (refNodeResult.getResultInfoSet().size() > 0) {
            refNodeValue = this.formatValue(refNodeResult.getResultInfoSet().elementAt(0));
        }
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String comment;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (node.equals(refNode)) continue;
            String nodeValue = ReportUtil.UNKNOWN;
            if (result.getResultInfoSet().size() > 0) {
                nodeValue = this.formatValue(result.getResultInfoSet().elementAt(0));
            }
            if (result.getStatus() == 1) {
                comment = ReportUtil.MATCHED;
            } else if (result.getStatus() == 3) {
                match &= false;
                comment = ReportUtil.MISMATCHED;
            } else {
                status = false;
                comment = ReportUtil.NOT_APPLICABLE;
                resultSet.addResult(this.m_nodeList, 2);
            }
            ReportUtil.surewriteRecord(node, nodeValue, refNodeValue, comment);
        }
        String summaryMsg = null;
        if (task.getTaskID().equals("TASKPHYSICALMEMORY") || task.getTaskID().equals("TASKSWAPSIZE") || task.getTaskID().equals("TASKAVAILABLEMEMORY")) {
            if (!status) {
                summaryMsg = s_msgBundle.getMessage("1003", false, (Object[])new String[]{taskName});
                ReportUtil.sureprintln(summaryMsg);
                ReportUtil.verboseReportPrintln(summaryMsg);
            } else if (match) {
                summaryMsg = taskName + " " + s_gMsgBundle.getMessage("8217", false);
                ReportUtil.sureprintln(summaryMsg);
                ReportUtil.verboseReportPrintln(summaryMsg);
            } else {
                summaryMsg = taskName + " " + s_gMsgBundle.getMessage("8218", false);
                ReportUtil.sureprintln(summaryMsg);
                ReportUtil.verboseReportPrintln(summaryMsg);
            }
        } else if (match) {
            summaryMsg = s_msgBundle.getMessage("1001", false, (Object[])new String[]{taskName});
            ReportUtil.sureprintln(summaryMsg);
            ReportUtil.verboseReportPrintln(summaryMsg);
        } else {
            summaryMsg = s_msgBundle.getMessage("1003", false, (Object[])new String[]{taskName});
            ReportUtil.sureprintln(summaryMsg);
            ReportUtil.verboseReportPrintln(summaryMsg);
        }
        ReportUtil.reportPrintln(LSEP);
    }

    private void performPeerForFreeSpace(TaskContainerFreeSpace task) {
        List<VerificationTask> taskFreeSpaceArr;
        ResultSet freeSpaceRsltSet = new ResultSet();
        String taskName = task.getDefaultElementName();
        TaskAnonymousProxy anonymousProxy = new TaskAnonymousProxy(taskName, this.m_nodeList, this);
        try {
            taskFreeSpaceArr = task.getSubtasks();
        }
        catch (SubtasksUnavailableException e) {
            Trace.out((Exception)e);
            ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            freeSpaceRsltSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            freeSpaceRsltSet.addResult(this.m_PCNodeList, 2);
            anonymousProxy.performAnonymousTask(freeSpaceRsltSet);
            return;
        }
        LinkedHashMap<String, List<TaskFreeSpace>> freeSpaceHT = new LinkedHashMap<String, List<TaskFreeSpace>>();
        for (VerificationTask freeSpaceVerificationTask : taskFreeSpaceArr) {
            TaskFreeSpace freeSpaceTask = (TaskFreeSpace)freeSpaceVerificationTask;
            for (TaskContainerFreeSpace.Location location : freeSpaceTask.m_locations) {
                ArrayList<TaskFreeSpace> freeSpaceTaskList = (ArrayList<TaskFreeSpace>)((HashMap)freeSpaceHT).get(location.getOriginalPath());
                if (freeSpaceTaskList == null) {
                    freeSpaceTaskList = new ArrayList<TaskFreeSpace>();
                    freeSpaceHT.put(location.getOriginalPath(), freeSpaceTaskList);
                }
                freeSpaceTaskList.add(freeSpaceTask);
            }
        }
        if (this.m_referenceNode == null || this.m_referenceNode.trim().length() == 0) {
            freeSpaceRsltSet.addResult(this.m_nodeList, 1);
            anonymousProxy.performAnonymousTask(freeSpaceRsltSet);
            this.reportFreeSpaceCompatibility(freeSpaceHT);
        } else {
            freeSpaceRsltSet.addResult(this.m_referenceNode, 1);
            this.processRsltSetWithRefNodeFreeSpace(this.m_referenceNode, freeSpaceHT, freeSpaceRsltSet);
            anonymousProxy.performAnonymousTask(freeSpaceRsltSet);
            this.reportFreeSpaceCompatibility(this.m_referenceNode, freeSpaceHT, freeSpaceRsltSet);
        }
    }

    private void processRsltSetWithRefNodeFreeSpace(String refNode, HashMap<String, List<TaskFreeSpace>> freeSpaceHT, ResultSet freeSpaceRsltSet) {
        for (String location : freeSpaceHT.keySet()) {
            List<TaskFreeSpace> freeSpaceTaskList = freeSpaceHT.get(location);
            StorageSize refNodeSize = null;
            for (TaskFreeSpace freeSpaceTask : freeSpaceTaskList) {
                if (!refNode.equals(freeSpaceTask.m_nodeFreeSpc)) continue;
                if (freeSpaceTask.m_mountPoint.getMountPoint().contentEquals("UNKNOWN")) {
                    Trace.out((String)"Ref node size unknown");
                    break;
                }
                refNodeSize = freeSpaceTask.m_mountPoint.getAvailableSpace();
                break;
            }
            StorageSize nodeSize = null;
            for (TaskFreeSpace freeSpaceTask : freeSpaceTaskList) {
                String node = freeSpaceTask.m_nodeFreeSpc;
                if (node.equals(refNode)) continue;
                if (!freeSpaceTask.m_mountPoint.getMountPoint().contentEquals("UNKNOWN")) {
                    nodeSize = freeSpaceTask.m_mountPoint.getAvailableSpace();
                }
                if (nodeSize == refNodeSize || nodeSize != null && nodeSize.compareTo(refNodeSize) >= 0) {
                    Trace.out((String)"Matched");
                    continue;
                }
                if (nodeSize != null && nodeSize.getSize() > 0.0) {
                    Trace.out((String)"Mismatched");
                    freeSpaceRsltSet.addResult(node, 3);
                    continue;
                }
                Trace.out((String)"Not applicable");
                freeSpaceRsltSet.addResult(this.m_nodeList, 2);
            }
        }
    }

    private void reportFreeSpaceCompatibility(HashMap<String, List<TaskFreeSpace>> freeSpaceHT) {
        for (String location : freeSpaceHT.keySet()) {
            String taskName = s_msgBundle.getMessage("1056", false);
            ReportUtil.sureblankln();
            String headerMsg = s_msgBundle.getMessage("1006", false, (Object[])new String[]{taskName, location});
            ReportUtil.sureprintln(headerMsg);
            ReportUtil.verboseReportPrintln(headerMsg);
            ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.PATH, ReportUtil.MNTPNT, ReportUtil.STATUS);
            List<TaskFreeSpace> freeSpaceTaskList = freeSpaceHT.get(location);
            for (TaskFreeSpace freeSpaceTask : freeSpaceTaskList) {
                String node = freeSpaceTask.m_nodeFreeSpc;
                String mountPoint = freeSpaceTask.m_mountPoint.getMountPoint();
                String instStatus = mountPoint.contentEquals("UNKNOWN") ? ReportUtil.UNKNOWN : this.formatValue(freeSpaceTask.m_mountPoint.getAvailableSpace());
                ReportUtil.surewriteRecord(node, location, mountPoint, instStatus);
            }
            if (freeSpaceTaskList.size() <= 1) continue;
            ReportUtil.sureprintln(s_msgBundle.getMessage("1008", false, (Object[])new String[]{taskName, location}));
        }
        ReportUtil.reportPrintln(LSEP);
    }

    private void reportFreeSpaceCompatibility(String refNode, HashMap<String, List<TaskFreeSpace>> freeSpaceHT, ResultSet freeSpaceRsltSet) {
        for (String location : freeSpaceHT.keySet()) {
            boolean noMismatch = true;
            boolean status = true;
            String taskName = s_msgBundle.getMessage("1056", false);
            ReportUtil.sureblankln();
            String headerMsg = s_msgBundle.getMessage("1010", false, (Object[])new String[]{taskName, location, refNode});
            ReportUtil.sureprintln(headerMsg);
            ReportUtil.verboseReportPrintln(headerMsg);
            ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.PATH, ReportUtil.MNTPNT, ReportUtil.STATUS, ReportUtil.REF_STATUS, ReportUtil.COMMENT);
            List<TaskFreeSpace> freeSpaceTaskList = freeSpaceHT.get(location);
            String refNodeValue = ReportUtil.UNKNOWN;
            StorageSize refNodeSize = null;
            for (TaskFreeSpace freeSpaceTask : freeSpaceTaskList) {
                if (!refNode.equals(freeSpaceTask.m_nodeFreeSpc)) continue;
                if (freeSpaceTask.m_mountPoint.getMountPoint().contentEquals("UNKNOWN")) {
                    refNodeValue = ReportUtil.UNKNOWN;
                    break;
                }
                refNodeValue = this.formatValue(freeSpaceTask.m_mountPoint.getAvailableSpace());
                refNodeSize = freeSpaceTask.m_mountPoint.getAvailableSpace();
                break;
            }
            String nodeValue = null;
            StorageSize nodeSize = null;
            String comment = null;
            String mountPoint = null;
            for (TaskFreeSpace freeSpaceTask : freeSpaceTaskList) {
                String node = freeSpaceTask.m_nodeFreeSpc;
                if (node.equals(refNode)) continue;
                nodeValue = ReportUtil.UNKNOWN;
                mountPoint = freeSpaceTask.m_mountPoint.getMountPoint();
                if (!mountPoint.contentEquals("UNKNOWN")) {
                    nodeValue = this.formatValue(freeSpaceTask.m_mountPoint.getAvailableSpace());
                    nodeSize = freeSpaceTask.m_mountPoint.getAvailableSpace();
                }
                if (nodeSize == refNodeSize || nodeSize != null && nodeSize.compareTo(refNodeSize) >= 0) {
                    comment = ReportUtil.MATCHED;
                } else if (nodeSize != null && nodeSize.getSize() > 0.0) {
                    noMismatch &= false;
                    comment = ReportUtil.MISMATCHED;
                } else {
                    status = false;
                    comment = ReportUtil.NOT_APPLICABLE;
                }
                ReportUtil.surewriteRecord(node, location, mountPoint, nodeValue, refNodeValue, comment);
            }
            String summaryMsg = null;
            if (!status) {
                summaryMsg = s_msgBundle.getMessage("1003", false, (Object[])new String[]{taskName});
                ReportUtil.sureprintln(summaryMsg);
                ReportUtil.verboseReportPrintln(summaryMsg);
                continue;
            }
            if (noMismatch) {
                summaryMsg = taskName + " " + s_msgBundle.getMessage("8217", false);
                ReportUtil.sureprintln(summaryMsg);
                ReportUtil.verboseReportPrintln(summaryMsg);
                continue;
            }
            summaryMsg = taskName + " " + s_msgBundle.getMessage("8218", false);
            ReportUtil.sureprintln(summaryMsg);
            ReportUtil.verboseReportPrintln(summaryMsg);
        }
        ReportUtil.reportPrintln(LSEP);
    }

    private String formatValue(Object nodeValue) {
        if (nodeValue instanceof StorageSize) {
            return ReportUtil.unitizeSize((StorageSize)nodeValue);
        }
        if (nodeValue instanceof RangeOfValue) {
            return ((RangeOfValue)nodeValue).getBoundedRangeString();
        }
        return nodeValue.toString();
    }

    public ResultSet processResultSetWithReferenceNode(String refNode, ResultSet allNodeResultSet) throws VerificationException {
        Hashtable ht = allNodeResultSet.getResultTable();
        Result refNodeResult = (Result)ht.get(refNode);
        Object refNodeValue = null;
        int refNodeStatus = refNodeResult.getStatus();
        if (refNodeResult.getResultInfoSet().size() > 0) {
            refNodeValue = refNodeResult.getResultInfoSet().elementAt(0);
        }
        Object nodeValue = null;
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (node.equals(refNode)) {
                result.setStatus(1);
                allNodeResultSet.setStatus();
                continue;
            }
            if (result.getResultInfoSet().size() > 0) {
                nodeValue = result.getResultInfoSet().elementAt(0);
            }
            if (result.getStatus() == 1) {
                if (this.matchesReferenceNode(nodeValue, refNodeValue)) continue;
                result.setStatus(3);
                allNodeResultSet.setStatus();
                continue;
            }
            if (result.getStatus() != 3 || refNodeStatus != result.getStatus()) continue;
            result.setStatus(1);
            allNodeResultSet.setStatus();
        }
        return allNodeResultSet;
    }

    protected boolean matchesReferenceNode(Object nodeValue, Object referenceNodeValue) {
        if (nodeValue == referenceNodeValue) {
            return true;
        }
        if (nodeValue == null) {
            return false;
        }
        return nodeValue.toString().equals(String.valueOf(referenceNodeValue));
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4433", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4484", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        sb.append("\n    ReferenceNode: " + this.m_referenceNode);
        return sb.toString();
    }

    public void setParamPreReq(ParamPreReq preReq) {
        this.m_paramPreReq = preReq;
    }
}

