/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskOraclePatchCollection
extends Task {
    private String m_softwareComponent;
    private String m_softwareComponentHome;
    private String m_release;

    public TaskOraclePatchCollection(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("COMPONENT".equals(argName)) {
                if ("CRS".equalsIgnoreCase(argVal)) {
                    this.m_softwareComponent = "crs";
                    this.m_softwareComponentHome = this.m_globalContext.getCRSHome();
                    this.m_release = VerificationUtil.getCRSActiveVersion();
                    this.m_collectionGroup = CollectionGroup.CRS_PATCH_COLLECTION;
                    continue;
                }
                if (!"DATABASE".equalsIgnoreCase(argVal)) continue;
                this.m_softwareComponent = "database";
                this.m_softwareComponentHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
                this.m_release = CVUVariables.getValue(CVUVariableConstants.RAC_VERSION);
                this.m_collectionGroup = CollectionGroup.DB_PATCH_COLLECTION;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return VerificationUtil.isStringGood(this.m_softwareComponentHome) && (VerificationUtil.isBaselineCollectionMode() || VerificationUtil.isCVUResource());
    }

    public TaskOraclePatchCollection(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskOraclePatchCollection(String[] nodeList, String configFile, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskOraclePatchCollection(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Performing patch collection... ");
        }
        boolean retVal = true;
        Hashtable<String, Hashtable<String, List<String>>> nodeWisePatchList = CVUHelperUtil.getOraclePatchList(this.m_nodeList, this.m_softwareComponentHome, this.m_release, this.m_resultSet);
        if (this.m_resultSet.anySuccess()) {
            for (String node : nodeWisePatchList.keySet()) {
                Hashtable<String, List<String>> patchTable = nodeWisePatchList.get(node);
                for (String patchId : patchTable.keySet()) {
                    CollectionElement patchCE = new CollectionElement(patchId, null, null, null, patchId, 1);
                    List<String> bugList = patchTable.get(patchId);
                    String bugListStr = "";
                    if (bugList != null && bugList.size() > 0) {
                        Collections.sort(bugList);
                    }
                    bugListStr = VerificationUtil.strCollection2String(bugList);
                    CollectionElement bugListCE = new CollectionElement("BUG_LIST", bugListStr, null, null, "BUG_LIST", 1);
                    patchCE.addChild(bugListCE);
                    this.m_resultSet.addCollectionElement(node, patchCE);
                }
            }
        }
        return retVal;
    }

    public void setSoftwareComponent(String softwareComponent) {
        this.m_softwareComponent = softwareComponent;
    }

    public void setSoftwareComponentHome(String softwareComponentHome) {
        this.m_softwareComponentHome = softwareComponentHome;
    }

    public String getSoftwareComponentHome() {
        return this.m_softwareComponentHome;
    }

    public void setRelease(String release) {
        this.m_release = release;
    }

    @Override
    public String getDefaultElementName() {
        if (this.m_softwareComponent.equalsIgnoreCase("database")) {
            return s_gMsgBundle.getMessage("11669", false, (Object[])new String[]{this.m_softwareComponentHome});
        }
        return s_gMsgBundle.getMessage("11667", false, (Object[])new String[]{this.m_softwareComponentHome});
    }

    @Override
    public String getDefaultDescription() {
        if (this.m_softwareComponent.equalsIgnoreCase("database")) {
            return s_gMsgBundle.getMessage("11670", false, (Object[])new String[]{this.m_softwareComponentHome});
        }
        return s_gMsgBundle.getMessage("11668", false, (Object[])new String[]{this.m_softwareComponentHome});
    }
}

