/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.command.MulticastCommand;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.network.Subnet;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskMulticastCheck
extends Task
implements VerificationAPIConstants {
    private static final String[] MULTICAST_GROUPS = new String[]{"224.0.0.251", "230.0.1.0"};
    private static final String[] MULTICAST_GROUPS_IPV6 = new String[]{"FF0E::FB"};
    private static final int PORT = 42414;
    private static final String TASK_TYPE = "Multicast";
    private Set<NetworkInfo> m_networksToConsider = null;
    private Map<String, String> m_resultMap = new HashMap<String, String>();

    public TaskMulticastCheck(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        VerificationType vType = this.m_globalContext.getVerificationType();
        ParamPreReqNodeAddDel param = null;
        switch (vType) {
            case PREREQ_NODE_ADD: 
            case PREREQ_RACNODE_ADD: 
            case POSTREQ_NODE_ADD: {
                param = (ParamPreReqNodeAddDel)this.m_globalContext.getParamPrereq();
                if (param == null) break;
                this.setNodeList(param.getValidNewClusterNodes());
            }
        }
        try {
            Set<NetworkInfo> clusterNetworks = NetworkUtility.getNetworkInfo(this.m_resultSet);
            if (NetworkUtility.isNetworksSetGood(clusterNetworks)) {
                this.setNetworksToConsider(clusterNetworks);
            }
        }
        catch (CVUException ve) {
            VerificationUtil.traceAndLog("Exception occured while getting network info. msg=" + ve.getMessage());
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationType.PREREQ_CRS_INST.equals((Object)this.m_globalContext.getVerificationType()) && VerificationUtil.isBaselineCollectionMode()) {
            return false;
        }
        if (VerificationUtil.isOPC() || VerificationUtil.isODALiteEnv()) {
            VerificationUtil.traceAndLog("skipping multicast check in  OPC/ODALite environment");
            return false;
        }
        if (VerificationUtil.skipTask(this)) {
            VerificationUtil.traceAndLog("This task " + this.getDefaultTaskID() + " is requested to be skipped" + " and hence not added to the taskList");
            return false;
        }
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case PREREQ_CRS_INST: {
                if (!this.m_globalContext.isCRSSoftwareOnlyInstall()) break;
                VerificationUtil.traceAndLog("Skipping Multicast check as this is a software only install.");
                return false;
            }
        }
        return true;
    }

    public TaskMulticastCheck(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskMulticastCheck(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskMulticastCheck(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setNetworksToConsider(Set<NetworkInfo> networksToConsider) {
        if (NetworkUtility.isNetworksSetGood(networksToConsider)) {
            networksToConsider = NetworkUtility.expandSubnetIPv6Addresses(networksToConsider);
            if (VerificationUtil.isCVUTestEnv()) {
                networksToConsider = NetworkUtility.skipIPv6LinkLocalAndLoopbackAddresses(networksToConsider);
            }
            this.m_networksToConsider = networksToConsider;
            VerificationUtil.logNetworkInterfaces(networksToConsider);
        }
    }

    @Override
    public boolean performTask() {
        boolean haCheck = true;
        HashSet<String> badNodes = new HashSet<String>();
        HashSet<String> badNodes2 = new HashSet<String>();
        this.m_resultSet.addResult(this.m_nodeList, 1);
        String msg = s_gMsgBundle.getMessage("11132", false);
        ReportUtil.sureprintln(msg);
        ReportUtil.sureblankln();
        ResultSet networksResultSet = new ResultSet();
        HashMap<String, Set<NetworkInfo>> nodeNetworksMap = NetworkDataDiscovery.getNodeNetworksMap(this.m_nodeList, networksResultSet);
        nodeNetworksMap = NetworkDataDiscovery.getNetworksOnNodes(nodeNetworksMap, nodeNetworksMap.keySet().toArray(new String[0]), true);
        if (!NetworkUtility.isNetworksMapGood(nodeNetworksMap) || networksResultSet.anyFailure()) {
            Trace.out((String)"Could not discover the network details successfully during multicast checks");
            NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
            return false;
        }
        if (this.m_nodeList == null || this.m_nodeList.length == 0) {
            return false;
        }
        Trace.out((String)"Check network existence on all nodes");
        HashSet<String> validNodeList = new HashSet<String>();
        boolean hasNetworks = NetworkDataDiscovery.checkForNetworkExistenceOnAllNodes(null, this.m_networksToConsider, this.m_nodeList, validNodeList, networksResultSet, TASK_TYPE);
        if (!hasNetworks) {
            NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
            return false;
        }
        List<Object> subnets = new ArrayList();
        String reqRel = this.m_globalContext.getRequestedRelease();
        subnets = reqRel != null && VerificationUtil.isVersionPre(reqRel, "12.2") ? NetworkUtility.getSubnetsFromNodeNetworksMap(nodeNetworksMap, true, networksResultSet) : NetworkUtility.getSubnetsFromNodeNetworksMap(nodeNetworksMap, false, networksResultSet);
        if (subnets == null || subnets.isEmpty()) {
            Trace.out((String)"Could not get the subnet details successfully during multicast checks");
            NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
            return false;
        }
        Vector<Subnet> privSubnets = new Vector<Subnet>();
        Vector<Subnet> nonPrivSubnets = new Vector<Subnet>();
        for (Subnet subnet : subnets) {
            boolean isPrivate = false;
            if (NetworkUtility.isNetworksSetGood(this.m_networksToConsider)) {
                boolean bl = true;
                for (NetworkInfo network : this.m_networksToConsider) {
                    if (!network.getSubnetAsString().equals(subnet.getSubnet())) continue;
                    if ((network.getNetworkType() & NetworkConstants.NetworkType.PRIVATE.getValue()) != 0) {
                        isPrivate = true;
                    }
                    bl = false;
                    break;
                }
                if (bl) continue;
            }
            if (isPrivate) {
                privSubnets.add(subnet);
                continue;
            }
            nonPrivSubnets.add(subnet);
        }
        if (privSubnets.isEmpty() && nonPrivSubnets.isEmpty() && NetworkUtility.isNetworksSetGood(this.m_networksToConsider)) {
            HashSet subnetsToConsider = new HashSet();
            for (NetworkInfo network : this.m_networksToConsider) {
                subnetsToConsider.add(network.getSubnetAsString());
            }
            if (subnetsToConsider.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Subnet subnet : subnets) {
                    if (!VerificationUtil.isStringGood(subnet.getSubnet())) continue;
                    arrayList.add(subnet.getSubnet());
                }
                this.m_resultSet.addResult(this.m_nodeList, 3);
                String errMsg = s_gMsgBundle.getMessage("11139", true, (Object[])new String[]{VerificationUtil.strList2List(new ArrayList<String>(subnetsToConsider)), VerificationUtil.strCollection2String(arrayList)});
                this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg));
                Trace.out((String)("Following error occured while checking multicast connectivity " + LSEP + errMsg));
                ReportUtil.sureprintln(errMsg);
                return false;
            }
            msg = s_gMsgBundle.getMessage("11136", false);
            ReportUtil.sureprintln(msg);
            return true;
        }
        Trace.out((String)"Performing multicast connectivity on private subnets");
        for (Subnet subnet : privSubnets) {
            Trace.out((String)("Checking multicast on subnet " + subnet.getSubnet()));
            badNodes.clear();
            boolean isIPv4Network2 = IPAddressUtil.isIPv4AddressString((String)subnet.getSubnet());
            if (!this.performMulticastCheck(subnet, true, badNodes, isIPv4Network2)) {
                if (isIPv4Network2) {
                    Trace.out((String)("multicast on subnet " + subnet + " has failed. trying " + " to perform broadcast check  on the subent"));
                    badNodes2.clear();
                    if (!this.performBroadcastCheck(subnet, badNodes2)) {
                        badNodes.addAll(badNodes2);
                        this.m_resultSet.addResult(badNodes.toArray(new String[0]), 3);
                        haCheck = false;
                    }
                } else {
                    Trace.out((String)("multicast on subnet " + subnet + " has failed"));
                    this.m_resultSet.addResult(badNodes.toArray(new String[0]), 3);
                    haCheck = false;
                }
            }
            if (!Utils.isDevelopmentEnv() || !"TRUE".equals(CVUVariables.getValue("_FORCE_BROADCAST_"))) continue;
            Trace.out((String)"******THIS BLOCK EXECUTES ONLY by srg and lrgs but not  in shiphome lrgs and customer env*******");
            badNodes2.clear();
            if (!isIPv4Network2 || this.performBroadcastCheck(subnet, badNodes2)) continue;
            badNodes.addAll(badNodes2);
            this.m_resultSet.addResult(badNodes.toArray(new String[0]), 3);
            haCheck = false;
        }
        if (!haCheck) {
            return false;
        }
        boolean mDNSCheck = false;
        Trace.out((String)("check if multicast check is passed on any of the private subnets on mulicast group " + MULTICAST_GROUPS[0]));
        for (String strSubnet : this.m_resultMap.keySet()) {
            boolean bl = IPAddressUtil.isIPv4AddressString((String)strSubnet);
            if (bl && MULTICAST_GROUPS[0].equals(this.m_resultMap.get(strSubnet))) {
                Trace.out((String)("multicast check passed on private subnet " + strSubnet + " on multicast group " + MULTICAST_GROUPS[0]));
                mDNSCheck = true;
                break;
            }
            if (!MULTICAST_GROUPS_IPV6[0].equals(this.m_resultMap.get(strSubnet))) continue;
            Trace.out((String)("multicast check passed on private subnet " + strSubnet + " on multicast group " + MULTICAST_GROUPS_IPV6[0]));
            mDNSCheck = true;
            break;
        }
        if (!mDNSCheck) {
            Trace.out((String)"Checking multicast connectivity on other networks");
            badNodes.clear();
            for (Subnet subnet : nonPrivSubnets) {
                Trace.out((String)("Checking multicast on subnet " + subnet.getSubnet()));
                boolean bl = IPAddressUtil.isIPv4AddressString((String)subnet.getSubnet());
                if (!this.performMulticastCheck(subnet, false, badNodes, bl)) continue;
                mDNSCheck = true;
                break;
            }
            if (!mDNSCheck) {
                this.m_resultSet.addResult(badNodes.toArray(new String[0]), 3);
            }
        }
        if (haCheck && mDNSCheck) {
            msg = s_gMsgBundle.getMessage("11136", false);
            ReportUtil.sureprintln(msg);
            return true;
        }
        return false;
    }

    private boolean performMulticastCheck(Subnet subnet, boolean isPrivate, Set<String> badNodes, boolean isIPv4Network) {
        boolean retVal = true;
        HashSet<String> badNodes1 = new HashSet<String>();
        HashSet<String> badNodes2 = new HashSet<String>();
        if (isIPv4Network) {
            retVal = this.performMulticastCheck(subnet, MULTICAST_GROUPS[0], badNodes1);
            if (retVal) {
                this.m_resultMap.put(subnet.getSubnet(), MULTICAST_GROUPS[0]);
            } else if (isPrivate && (retVal = this.performMulticastCheck(subnet, MULTICAST_GROUPS[1], badNodes2))) {
                this.m_resultMap.put(subnet.getSubnet(), MULTICAST_GROUPS[1]);
            }
        } else {
            retVal = this.performMulticastCheck(subnet, MULTICAST_GROUPS_IPV6[0], badNodes1);
            if (retVal) {
                this.m_resultMap.put(subnet.getSubnet(), MULTICAST_GROUPS_IPV6[0]);
            }
        }
        if (!retVal) {
            badNodes.addAll(badNodes1);
            badNodes.addAll(badNodes2);
        }
        return retVal;
    }

    private boolean performMulticastCheck(Subnet subnet, String mcGroup, Set<String> badNodes) {
        boolean retVal = true;
        String message = s_gMsgBundle.getMessage("11133", false, (Object[])new String[]{subnet.getSubnet(), mcGroup});
        ReportUtil.sureprintln(message);
        ReportUtil.verboseReportPrintln(LSEP + message.substring(0, message.lastIndexOf("...")));
        Trace.out((String)("Checking subnet " + subnet.getSubnet() + " for multicast communication..."));
        MulticastServer mcServer = new MulticastServer(mcGroup, 42414, subnet);
        Trace.out((String)("Trying with multicast group " + mcGroup));
        ResultSet srvRs = new ResultSet();
        Trace.out((String)"starting mcServer");
        mcServer.startServer(srvRs);
        if (srvRs.anyFailure()) {
            Trace.out((String)"mcServer.startServer() failed");
            this.printAndUploadRSErrors(srvRs, true);
            Trace.out((String)"stoping mcServer");
            ResultSet rs = new ResultSet();
            mcServer.stopServer(rs);
            if (rs.anyFailure()) {
                this.printAndUploadRSErrors(rs, true);
            }
            return false;
        }
        Trace.out((String)("multicast server started with mcGroup=" + mcGroup));
        List networksWithinSubnet = (List)subnet.getNetworks();
        ResultSet multicastResultSet = new ResultSet();
        Collection notReachableNetworks = mcServer.getNotReachableInterfaces(networksWithinSubnet, multicastResultSet);
        if (multicastResultSet.allSuccess()) {
            if (notReachableNetworks.size() == 0) {
                Trace.out((String)"Reachability of mutlicast packets via all the IPs  from all the nodes passed.");
            } else {
                for (NetworkInfo notReachnetwork : notReachableNetworks) {
                    String node2 = notReachnetwork.getNodeName();
                    String ipAddress2 = notReachnetwork.getIPAsString();
                    String if2 = notReachnetwork.getInterfaceName();
                    for (NetworkInfo networkToBeChecked : networksWithinSubnet) {
                        String node1 = networkToBeChecked.getNodeName();
                        String ipAddress1 = networkToBeChecked.getIPAsString();
                        String if1 = networkToBeChecked.getInterfaceName();
                        Trace.out((String)("No response for multicast packets send from (" + if1 + "," + ipAddress1 + "," + node1 + ") to (" + if2 + "," + ipAddress2 + "," + node2 + ")"));
                        String errMsg = s_gMsgBundle.getMessage("11138", true, (Object[])new String[]{if1, node1, if2, node2, mcGroup});
                        VerificationUtil.traceAndLogError(errMsg);
                        ErrorDescription errDesc = new ErrorDescription(errMsg);
                        this.m_resultSet.addErrorDescription(node2, errDesc);
                        if (!badNodes.contains(node2)) {
                            badNodes.add(node2);
                        }
                        retVal = false;
                    }
                }
            }
        } else {
            this.printAndUploadRSErrors(multicastResultSet, true);
            retVal = false;
        }
        if (retVal) {
            String msg = s_gMsgBundle.getMessage("11135", false, (Object[])new String[]{subnet.getSubnet(), mcGroup});
            ReportUtil.sureprintln(msg);
            ReportUtil.sureblankln();
        }
        ResultSet rs = new ResultSet();
        mcServer.stopServer(rs);
        if (rs.anyFailure()) {
            this.printAndUploadRSErrors(rs, true);
            retVal = false;
        }
        return retVal;
    }

    boolean performBroadcastCheck(Subnet subnet, Set<String> badNodes) {
        String msg;
        boolean retVal = true;
        String bcAddr = "255.255.255.255";
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11351", false, (Object[])new String[]{subnet.getSubnet(), bcAddr}));
        Trace.out((String)("Checking subnet " + subnet.getSubnet() + " for broadcast communication..."));
        MulticastServer bcServer = new MulticastServer(false, bcAddr, 42414, subnet);
        ResultSet srvRs = new ResultSet();
        Trace.out((String)"starting bcServer");
        bcServer.startServer(srvRs);
        if (srvRs.anyFailure()) {
            Trace.out((String)"bcServer.startServer() failed");
            this.printAndUploadRSErrors(srvRs, false);
            Trace.out((String)"stoping bcServer");
            ResultSet rs = new ResultSet();
            bcServer.stopServer(rs);
            if (rs.anyFailure()) {
                this.printAndUploadRSErrors(rs, false);
            }
            return false;
        }
        Trace.out((String)("broadcast server started with bcAddr =" + bcAddr));
        boolean bFailedAllover = true;
        List networksWithinSubnet = (List)subnet.getNetworks();
        ResultSet broadcastResultSet = new ResultSet();
        Collection notReachableNetworks = bcServer.getNotReachableInterfaces(networksWithinSubnet, broadcastResultSet);
        if (broadcastResultSet.allSuccess()) {
            if (notReachableNetworks.size() == 0) {
                Trace.out((String)"Reachability of broadcast packetets via all the IPs  from all the nodes passed.");
                bFailedAllover = false;
            } else {
                if (notReachableNetworks.size() != networksWithinSubnet.size()) {
                    bFailedAllover = false;
                }
                for (NetworkInfo notReachnetwork : notReachableNetworks) {
                    String node2 = notReachnetwork.getNodeName();
                    String if2 = notReachnetwork.getIPAsString();
                    for (NetworkInfo networkToBeChecked : networksWithinSubnet) {
                        String node1 = networkToBeChecked.getNodeName();
                        String if1 = networkToBeChecked.getIPAsString();
                        VerificationUtil.traceAndLogError("No response for broadcast packets sent from (" + if1 + "," + node1 + ") to (" + if2 + "," + node2 + ")");
                        String errMsg = s_gMsgBundle.getMessage("11352", true, (Object[])new String[]{if1, node1, if2, node2, bcAddr});
                        ErrorDescription errDesc = new ErrorDescription(errMsg);
                        this.m_resultSet.addErrorDescription(node2, errDesc);
                        if (!badNodes.contains(node2)) {
                            badNodes.add(node1);
                        }
                        retVal = false;
                    }
                }
            }
        } else {
            this.printAndUploadRSErrors(broadcastResultSet, false);
            retVal = false;
        }
        if (retVal) {
            msg = s_gMsgBundle.getMessage("11354", false, (Object[])new String[]{subnet.getSubnet(), bcAddr});
            ReportUtil.sureprintln(msg);
            ReportUtil.sureblankln();
        } else if (bFailedAllover) {
            msg = s_gMsgBundle.getMessage("11353", false, (Object[])new String[]{subnet.getSubnet(), bcAddr});
            ReportUtil.sureprintln(msg);
            ReportUtil.sureblankln();
        }
        ResultSet rs = new ResultSet();
        Trace.out((String)"stoping bcServer");
        bcServer.stopServer(rs);
        if (rs.anyFailure()) {
            this.printAndUploadRSErrors(rs, false);
            retVal = false;
        }
        return retVal;
    }

    private void printAndUploadRSErrors(ResultSet rs, boolean isMulticast) {
        String errMsg = "";
        errMsg = isMulticast ? s_gMsgBundle.getMessage("11137", true) : s_gMsgBundle.getMessage("11356", true);
        ErrorDescription errDesc = new ErrorDescription(errMsg);
        this.m_resultSet.addErrorDescription(rs.getFailureNodes(), errDesc);
        this.m_resultSet.addResultSetData(rs);
        this.m_resultSet.addResult(rs.getFailureNodes(), 2);
        errMsg = errMsg + VerificationUtil.errorCollection2String(rs.getErrors());
        ReportUtil.sureprintln(errMsg);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11131", false);
    }

    @Override
    public String getTaskID() {
        return "MULTICAST";
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11130", false);
    }

    private class MulticastServer {
        String m_mcGroup;
        int m_port;
        Subnet m_subnet = null;
        int[] m_pids;
        boolean m_isMulticast = true;

        MulticastServer(String mcGroup, int port, Subnet subnet) {
            this.m_mcGroup = mcGroup;
            this.m_port = port;
            this.m_subnet = subnet;
            this.m_pids = new int[0];
        }

        MulticastServer(boolean isMulticast, String mcGroup, int port, Subnet subnet) {
            this.m_mcGroup = mcGroup;
            this.m_port = port;
            this.m_subnet = subnet;
            this.m_pids = new int[0];
            this.m_isMulticast = isMulticast;
        }

        private void startServer(ResultSet rs) {
            Collection networks = this.m_subnet.getNetworks();
            MulticastCommand[] mcCmds = new MulticastCommand[networks.size()];
            int i = 0;
            for (NetworkInfo network : networks) {
                mcCmds[i] = this.m_isMulticast ? MulticastCommand.getListnerMulticastCommand(network.getNodeName(), network.getIPAsString(), this.m_mcGroup, this.m_port, network.getInterfaceName()) : MulticastCommand.getListnerBroadcastCommand(network.getNodeName(), network.getIPAsString(), this.m_mcGroup, this.m_port);
                ++i;
            }
            new GlobalHandler().submit((Command[])mcCmds, 0, rs);
            this.m_pids = new int[mcCmds.length];
            i = 0;
            for (MulticastCommand cmd : mcCmds) {
                this.m_pids[i] = cmd.getPid();
                ++i;
            }
        }

        private void stopServer(ResultSet rs) {
            Collection networks = this.m_subnet.getNetworks();
            MulticastCommand[] mcCmds = new MulticastCommand[networks.size()];
            int i = 0;
            for (NetworkInfo network : networks) {
                mcCmds[i] = MulticastCommand.getKillMulticastCommand(network.getNodeName(), this.m_pids[i]);
                ++i;
            }
            new GlobalHandler().submit((Command[])mcCmds, 0, rs);
        }

        private Collection<NetworkInfo> getNotReachableInterfaces(List<NetworkInfo> networks, ResultSet rs) {
            ArrayList<MulticastCommand> mcCmds = new ArrayList<MulticastCommand>();
            for (NetworkInfo networkInfo : networks) {
                if (this.m_isMulticast) {
                    mcCmds.add(MulticastCommand.getGroupIpMulticastCommand(networkInfo.getNodeName(), networkInfo.getIPAsString(), this.m_mcGroup, this.m_port, networkInfo.getInterfaceName()));
                    continue;
                }
                mcCmds.add(MulticastCommand.getGroupIpBroadcastCommand(networkInfo.getNodeName(), networkInfo.getIPAsString(), this.m_mcGroup, this.m_port));
            }
            new GlobalHandler().submit((Command[])mcCmds.toArray(new MulticastCommand[0]), 0, rs);
            HashSet<String> reachableIPs = new HashSet<String>();
            for (MulticastCommand mcCmd : mcCmds) {
                reachableIPs.addAll(Arrays.asList(mcCmd.getGroupIps()));
            }
            Vector<NetworkInfo> vector = new Vector<NetworkInfo>();
            for (NetworkInfo network1 : networks) {
                if (reachableIPs.contains(network1.getIPAsString())) continue;
                vector.add(network1);
            }
            return vector;
        }
    }
}

