/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.fixup.FixupData;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.ContainerTaskInterface;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskGroupExistence;
import oracle.ops.verification.framework.engine.task.TaskPeerCompatibility;
import oracle.ops.verification.framework.engine.task.sTaskGroupMembership;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskGroupMembership
extends TaskPeerCompatibility
implements ContainerTaskInterface,
PeerCompatibleTask {
    private String m_user;
    private String m_group;
    private boolean m_primary;
    private boolean m_useEtcGroup = false;
    private static Hashtable<String, List<String>> m_alreadyAddedPrimaryMemberShipCheckTable = new Hashtable();
    private static Hashtable<String, List<String>> m_alreadyAddedSecondaryMemberShipCheckTable = new Hashtable();
    private static TaskGroupMembership m_containerObj = null;
    private List<Task> m_subTaskList = new ArrayList<Task>();
    private boolean m_returnVal = true;
    private boolean m_isInitialized = false;
    private sTaskGroupMembership s_sTaskGroupMembership;

    public TaskGroupMembership(VerificationTaskContext ctx) {
        super(ctx);
        if (m_containerObj == null) {
            m_containerObj = new TaskGroupMembership();
        }
    }

    @Override
    protected void init() {
        if (!this.m_isInitialized) {
            this.s_sTaskGroupMembership = new sTaskGroupMembership();
            if (this.m_ctx != null) {
                ExecutableInfo execInfo = this.m_ctx.getExecInfo();
                if (execInfo != null) {
                    this.m_primary = false;
                    for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
                        String argName = arg.getArgName();
                        String argVal = arg.getArgVal(true);
                        if ("USER".equals(argName)) {
                            this.m_user = argVal;
                            continue;
                        }
                        if ("GROUP".equals(argName)) {
                            this.m_group = argVal;
                            continue;
                        }
                        if ("TYPE".equals(argName) && VerificationUtil.isStringGood(argVal) && argVal.trim().equalsIgnoreCase("PRIMARY")) {
                            this.m_primary = true;
                            continue;
                        }
                        if ("USE_ETC_GROUP".equals(argName) && VerificationUtil.isStringGood(argVal) && argVal.trim().equalsIgnoreCase("TRUE")) {
                            this.setUseEtcGroup();
                            continue;
                        }
                        Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
                    }
                }
                VerificationType vType = this.m_globalContext.getVerificationType();
                switch (vType) {
                    case PREREQ_NODE_ADD: {
                        Trace.out((String)"Node add scenario, considering the newly being added nodes for the group membership check");
                        this.m_ctx.setNodeList(VerificationUtil.addLocalNodeToNodeList(this.m_nodeList));
                    }
                }
                if (VerificationUtil.isStringGood(this.m_user) && VerificationUtil.isStringGood(this.m_group)) {
                    m_containerObj.addTaskToContainer(new TaskGroupMembership(this.m_ctx, this.m_user, this.m_group, this.m_primary));
                } else {
                    VerificationUtil.traceAndLogWarning("Not adding this check. Either the user ( " + this.m_user + ") or group (" + this.m_group + ") is invalid.");
                }
            } else {
                this.m_ctx = new VerificationTaskContext(this.m_nodeList);
            }
            this.m_isInitialized = true;
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (!this.m_subTaskList.isEmpty()) {
            ArrayList<Task> applicableList = new ArrayList<Task>();
            for (Task t : this.m_subTaskList) {
                if (t.isApplicable()) {
                    Trace.out((String)(t.getTaskName() + " is applicable from this container."));
                    applicableList.add(t);
                    continue;
                }
                Trace.out((String)(t.getTaskName() + " is NOT applicable from this container."));
            }
            this.m_subTaskList.clear();
            this.m_subTaskList.addAll(applicableList);
            return !this.m_subTaskList.isEmpty();
        }
        if (VerificationUtil.isStringGood(this.m_user) && VerificationUtil.isStringGood(this.m_group)) {
            Hashtable<String, List<String>> addedMembershipTable;
            Hashtable<String, List<String>> hashtable = addedMembershipTable = this.m_primary ? m_alreadyAddedPrimaryMemberShipCheckTable : m_alreadyAddedSecondaryMemberShipCheckTable;
            if (addedMembershipTable.containsKey(this.m_user) && addedMembershipTable.get(this.m_user).contains(this.m_group)) {
                Trace.out((String)("The m_group membership type (" + (this.m_primary ? "Primary" : "Secondary") + " check for user (" + this.m_user + ") in group (" + this.m_group + ") is already added."));
                return false;
            }
            Trace.out((String)("The group membership type (" + (this.m_primary ? "Primary" : "Secondary") + " check for user (" + this.m_user + ") in group (" + this.m_group + ") is not yet added." + " Adding it."));
            if (!addedMembershipTable.containsKey(this.m_user)) {
                ArrayList groupList = new ArrayList();
                addedMembershipTable.put(this.m_user, groupList);
            }
            addedMembershipTable.get(this.m_user).add(this.m_group);
            return true;
        }
        return false;
    }

    private TaskGroupMembership(VerificationTaskContext ctx, String user, String group, boolean primary) {
        super(ctx);
        this.m_user = user;
        this.m_group = group;
        this.m_primary = primary;
        this.s_sTaskGroupMembership = new sTaskGroupMembership();
    }

    private TaskGroupMembership(String user, String group, boolean primary, String[] nodeList) {
        this(new VerificationTaskContext(nodeList), user, group, primary);
    }

    private TaskGroupMembership() {
    }

    private TaskGroupMembership(Collection<Task> subTaskList) {
        this.m_subTaskList.addAll(subTaskList);
    }

    public static TaskGroupMembership generate(String user, String group, boolean primary, String[] nodeList) {
        return TaskGroupMembership.generate(user, group, primary, nodeList, true);
    }

    public static TaskGroupMembership generate(String user, String group, boolean primary, String[] nodeList, boolean addToContainer) {
        if (!VerificationUtil.isStringGood(user) || !VerificationUtil.isStringGood(group)) {
            VerificationUtil.traceAndLogError("An attempt was made to instantiate group membership check with null user (" + user + ") or group (" + group + ")");
            return null;
        }
        if (!addToContainer) {
            return new TaskGroupMembership(user, group, primary, nodeList);
        }
        if (m_containerObj == null) {
            m_containerObj = new TaskGroupMembership();
        }
        return (TaskGroupMembership)m_containerObj.addTaskToContainer(new TaskGroupMembership(user, group, primary, nodeList));
    }

    public void setUseEtcGroup() {
        this.m_useEtcGroup = true;
    }

    @Override
    public boolean performTask() {
        if (this.m_resultSet.getStatus() == 5) {
            this.m_returnVal = this.performTaskInternal();
        } else {
            Trace.out((String)"This task was performed earlier, returning based on earlier result");
            this.m_resultSet.traceResultSet("RESULT From earlier execution of this task");
        }
        return this.m_returnVal;
    }

    private boolean performTaskInternal() {
        ErrorDescription errDesc;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet usrGrpRsltSet = new ResultSet();
        boolean testFailed = false;
        globalExec.checkUsrInGrp(this.m_nodeList, this.m_user, this.m_group, this.m_primary ? 1 : 3, this.m_useEtcGroup, usrGrpRsltSet);
        this.m_resultSet.addResultSetData(usrGrpRsltSet);
        if (!this.m_primary) {
            ReportUtil.println(LSEP + s_msgBundle.getMessage("4302", false, (Object[])new String[]{this.m_user, this.m_group}));
        } else {
            ReportUtil.println(LSEP + s_msgBundle.getMessage("4022", false, (Object[])new String[]{this.m_user, this.m_group, s_msgBundle.getMessage("8500", false)}));
        }
        if (this.m_primary) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8013", false), s_msgBundle.getMessage("8014", false), s_msgBundle.getMessage("8015", false), s_msgBundle.getMessage("8016", false), s_msgBundle.getMessage("8018", false));
        } else {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8013", false), s_msgBundle.getMessage("8014", false), s_msgBundle.getMessage("8015", false), s_msgBundle.getMessage("8018", false));
        }
        Hashtable ht = usrGrpRsltSet.getResultTable();
        Enumeration e = ht.keys();
        List<String> nodesWithGrp = TaskGroupExistence.getNodesWithGroup(this.m_group);
        while (e.hasMoreElements()) {
            String nstatus;
            String primeG;
            String uInG;
            String grp;
            String usr;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                usr = ReportUtil.YES;
                grp = ReportUtil.YES;
                uInG = ReportUtil.YES;
                primeG = ReportUtil.YES;
                nstatus = ReportUtil.PASSED;
            } else if (result.getStatus() == 3) {
                boolean primaryGrp;
                boolean usrExists = ((String)result.getResultInfoSet().get(0)).equals(this.m_user);
                boolean usrInGrp = ((String)result.getResultInfoSet().get(1)).equals(this.m_group);
                boolean bl = primaryGrp = ((String)result.getResultInfoSet().get(2)).length() != 0;
                if (!usrExists) {
                    usr = ReportUtil.NO;
                    grp = ReportUtil.NOT_APPLICABLE;
                    uInG = ReportUtil.NOT_APPLICABLE;
                    primeG = ReportUtil.NOT_APPLICABLE;
                    nstatus = ReportUtil.FAILED;
                    errDesc = new ErrorDescription(VerificationUtil.getMsgWithExecutionDetails(s_msgBundle.getMessage("7537", true, (Object[])new String[]{this.m_user, node}), result));
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                } else if (!usrInGrp) {
                    usr = ReportUtil.YES;
                    grp = nodesWithGrp == null ? ReportUtil.UNKNOWN : (nodesWithGrp.contains(node) ? ReportUtil.YES : ReportUtil.NO);
                    uInG = ReportUtil.NO;
                    primeG = ReportUtil.NOT_APPLICABLE;
                    nstatus = ReportUtil.FAILED;
                    String errMsg = s_msgBundle.getMessage("7566", true, (Object[])new String[]{this.m_user, this.m_group, node});
                    String csGroupPrivileges = VerificationUtil.getGroupPrivileges(this.m_group);
                    if (VerificationUtil.isStringGood(csGroupPrivileges)) {
                        errMsg = s_gMsgBundle.getMessage("10460", true, (Object[])new String[]{this.m_user, this.m_group, csGroupPrivileges, node});
                    }
                    errDesc = new ErrorDescription(VerificationUtil.getMsgWithExecutionDetails(errMsg, result));
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                } else {
                    usr = ReportUtil.YES;
                    grp = ReportUtil.YES;
                    uInG = ReportUtil.YES;
                    nstatus = ReportUtil.PASSED;
                    primeG = ReportUtil.YES;
                    if (this.m_primary && !primaryGrp) {
                        primeG = ReportUtil.NO;
                        nstatus = ReportUtil.FAILED;
                        errDesc = new ErrorDescription(VerificationUtil.getMsgWithExecutionDetails(s_msgBundle.getMessage("7567", true, (Object[])new String[]{this.m_group, this.m_user, node}), result));
                        this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    } else {
                        this.m_resultSet.addResult(node, 1);
                    }
                }
            } else {
                usr = ReportUtil.UNKNOWN;
                grp = ReportUtil.UNKNOWN;
                uInG = ReportUtil.NOT_APPLICABLE;
                primeG = ReportUtil.NOT_APPLICABLE;
                nstatus = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(VerificationUtil.getMsgWithExecutionDetails(s_msgBundle.getMessage("7568", true, (Object[])new String[]{this.m_user, this.m_group, node}), result));
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            }
            if (this.m_primary) {
                ReportUtil.writeRecord(node, usr, grp, uInG, primeG, nstatus);
            } else {
                ReportUtil.writeRecord(node, usr, grp, uInG, nstatus);
            }
            if (nstatus.equalsIgnoreCase(ReportUtil.PASSED)) continue;
            testFailed = true;
        }
        if (testFailed) {
            if (this.isFixupReqd()) {
                this.generateFixups();
            }
            if (!this.m_primary) {
                ReportUtil.printResult(s_msgBundle.getMessage("4304", false, (Object[])new String[]{this.m_user, this.m_group}));
                this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0321", false, (Object[])new String[]{this.m_user, this.m_group, VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
            } else {
                ReportUtil.printResult(s_msgBundle.getMessage("4024", false, (Object[])new String[]{this.m_user, this.m_group, s_msgBundle.getMessage("8500", false)}));
                this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0323", false, (Object[])new String[]{this.m_user, this.m_group, s_msgBundle.getMessage("8500", false), VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
            }
            ReportUtil.printErrorNodes(this.m_resultSet);
            return false;
        }
        if (!this.m_primary) {
            ReportUtil.printResult(s_msgBundle.getMessage("4303", false, (Object[])new String[]{this.m_user, this.m_group}));
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0320", false, (Object[])new String[]{this.m_user, this.m_group}));
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("4023", false, (Object[])new String[]{this.m_user, this.m_group, s_msgBundle.getMessage("8500", false)}));
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0322", false, (Object[])new String[]{this.m_user, this.m_group, s_msgBundle.getMessage("8500", false), VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        }
        try {
            String strCurrentGrp = VerificationUtil.getCurrentGroup();
            if (this.m_primary && VerificationUtil.isStringGood(strCurrentGrp) && !strCurrentGrp.equalsIgnoreCase(this.m_group)) {
                ReportUtil.printWarning(s_msgBundle.getMessage("4309", true, (Object[])new String[]{strCurrentGrp, this.m_group, this.m_user}));
            }
        }
        catch (InvalidEnvironmentException iee) {
            String errorMsg = iee.getMessage();
            VerificationUtil.traceAndLogWarning(errorMsg);
            this.m_resultSet.addResult(this.m_nodeList, 4);
            errDesc = new ErrorDescription(errorMsg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            ReportUtil.printWarning(errorMsg);
        }
        return true;
    }

    private void generateFixups() {
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            return;
        }
        FixupData fixGrpMemShpData = new FixupData(null);
        HashMap<String, ErrorDescription> fixupGenFailedNodeListWithError = new HashMap<String, ErrorDescription>();
        Hashtable ht = this.m_resultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() != 3) continue;
            NonLocalEntity nonLocal = this.isUserAndGroupLocal(node);
            Trace.out((String)("Non locality says " + nonLocal.toString()));
            if (nonLocal == NonLocalEntity.NONE) {
                Trace.out((String)("Generating fixup for " + (this.m_primary ? "Primary" : "Non-primary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ") on node '" + node + "'"));
                VerificationLogData.logInfo("Generating fixup for " + (this.m_primary ? "Primary" : "Non-primary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ") on node '" + node + "'");
                fixGrpMemShpData.addParticipatingNode(node);
                fixGrpMemShpData.setExpectedValue(node, this.m_primary ? "PRIMARY_GROUP" : "SUPPLEMENTARY_GROUP");
                continue;
            }
            Trace.out((String)("User OR Group is not local and hence not generating fixup for " + (this.m_primary ? "Primary" : "Non-primary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ") on node '" + node + "'"));
            VerificationLogData.logInfo("User OR Group is not local and hence not generating fixup for " + (this.m_primary ? "Primary" : "Non-primary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ") on node '" + node + "'");
            ErrorDescription fixupGenFailedErrorDesc = null;
            fixupGenFailedErrorDesc = nonLocal == NonLocalEntity.USER ? new ErrorDescription(s_msgBundle.getMessage("7729", true, (Object[])new String[]{this.m_user, this.m_group, node})) : new ErrorDescription(s_msgBundle.getMessage("7730", true, (Object[])new String[]{this.m_user, this.m_group, node}));
            fixupGenFailedNodeListWithError.put(node, fixupGenFailedErrorDesc);
        }
        if (fixupGenFailedNodeListWithError.size() == 0) {
            Trace.out((String)("Generating fixup for " + (this.m_primary ? "Primary" : "Supplementary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ")"));
            VerificationLogData.logInfo("Generating fixup for " + (this.m_primary ? "Primary" : "Supplementary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ")");
            fixGrpMemShpData.addFixupInstruction("USER", this.m_user);
            fixGrpMemShpData.addFixupInstruction("GROUP", this.m_group);
        } else {
            fixGrpMemShpData = new FixupData(null);
            for (String node : fixupGenFailedNodeListWithError.keySet()) {
                fixGrpMemShpData.addFixupGenerationFailedNode(node, (ErrorDescription)fixupGenFailedNodeListWithError.get(node));
            }
            Trace.out((String)("Not Generating fixup for " + (this.m_primary ? "Primary" : "Supplementary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ") as either" + " the user or the group is not local on nodes " + VerificationUtil.strCollection2String(fixupGenFailedNodeListWithError.keySet())));
            VerificationLogData.logInfo("Not Generating fixup for " + (this.m_primary ? "Primary" : "Supplementary") + " group membership of user (" + this.m_user + ") in a group (" + this.m_group + ") as either" + " the user or the group is not local on nodes." + VerificationUtil.strCollection2String(fixupGenFailedNodeListWithError.keySet()));
        }
        this.setFixupData(fixGrpMemShpData);
    }

    private NonLocalEntity isUserAndGroupLocal(String node) {
        NonLocalEntity noLo = NonLocalEntity.USER;
        do {
            ResultSet isLocalRsltSet = new ResultSet();
            VerificationCommand[] vfyCmd = new VerificationCommand[1];
            String checkCommand = noLo == NonLocalEntity.USER ? this.s_sTaskGroupMembership.getLocalCheckCommand("user", this.m_user) : this.s_sTaskGroupMembership.getLocalCheckCommand("group", this.m_group);
            if (checkCommand == null) {
                Trace.out((String)"command is empty");
                return noLo;
            }
            String[] arg = new String[]{"-rungencmd", checkCommand};
            String[] env = null;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Command args: " + Arrays.asList(arg)));
            }
            vfyCmd[0] = new VerificationCommand(node, arg, env);
            Trace.out((String)("executing " + checkCommand));
            new GlobalHandler().submit((Command[])vfyCmd, 0, isLocalRsltSet);
            if (vfyCmd[0].getResult().getStatus() != 1) {
                Trace.out((String)("existance check failed on " + node + " with " + vfyCmd[0].getResult().getStatus()));
                return noLo;
            }
            if (vfyCmd[0].getVfyCode() != 0) {
                Trace.out((String)"User/group not found");
                return noLo;
            }
            switch (noLo) {
                case USER: {
                    noLo = NonLocalEntity.GROUP;
                    break;
                }
                default: {
                    noLo = NonLocalEntity.NONE;
                }
            }
        } while (noLo != NonLocalEntity.NONE);
        return noLo;
    }

    @Override
    public String getTaskID() {
        return "CHECK_GROUP_MEMBERSHIP";
    }

    @Override
    public String getTaskName() {
        return this.getTaskID() + "_" + this.m_user + "_" + this.m_group;
    }

    @Override
    public String getDefaultElementName() {
        if (VerificationUtil.isStringGood(this.m_group)) {
            StringBuilder elementName = new StringBuilder();
            elementName.append(s_msgBundle.getMessage("4410", false) + ": " + this.m_group);
            if (this.m_primary) {
                elementName.append("(" + s_msgBundle.getMessage("8500", false) + ")");
            }
            return elementName.toString();
        }
        return s_msgBundle.getMessage("4410", false);
    }

    @Override
    public String getDefaultDescription() {
        if (this.m_primary) {
            return s_msgBundle.getMessage("4461", false, (Object[])new String[]{this.m_user, this.m_group});
        }
        return s_msgBundle.getMessage("4460", false, (Object[])new String[]{this.m_user, this.m_group});
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet usrGrpRsltSet = new ResultSet();
        boolean testFailed = false;
        globalExec.checkUsrInGrp(this.m_nodeList, this.m_user, this.m_group, this.m_primary ? 1 : 3, usrGrpRsltSet);
        Hashtable ht = usrGrpRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                result.getResultInfoSet().add(0, ReportUtil.YES);
                continue;
            }
            if (result.getStatus() != 3) continue;
            result.getResultInfoSet().add(0, ReportUtil.NO);
            result.setStatus(1);
        }
        return usrGrpRsltSet;
    }

    @Override
    public String getElementDisplayName() {
        String group = this.m_group;
        if (this.m_primary) {
            group = group + " (" + s_msgBundle.getMessage("8500", false) + ")";
        }
        return s_msgBundle.getMessage("9973", false, (Object[])new String[]{this.m_user, group});
    }

    public String getGroupName() {
        return this.m_group;
    }

    public String getUserName() {
        return this.m_user;
    }

    public boolean checkPrimary() {
        return this.m_primary;
    }

    @Override
    public Task addTaskToContainer(Task t) {
        TaskGroupMembership taskToAdd = (TaskGroupMembership)t;
        boolean addTask = true;
        Task taskObjToReplace = null;
        Task taskObjAdded = t;
        for (Task ugt : this.m_subTaskList) {
            if (!this.compare(taskToAdd, (TaskGroupMembership)ugt)) continue;
            if (taskToAdd.checkPrimary() && !((TaskGroupMembership)ugt).checkPrimary()) {
                Trace.out((String)("Secondary group membership check for user (" + taskToAdd.getUserName() + ") in group (" + taskToAdd.getGroupName() + ") is already added. Replacing it " + "with this one which checks for primary group membership."));
                taskObjToReplace = ugt;
                break;
            }
            if (!taskToAdd.checkPrimary() && ((TaskGroupMembership)ugt).checkPrimary()) {
                Trace.out((String)("Primary group membership check for user (" + taskToAdd.getUserName() + ") in group (" + taskToAdd.getGroupName() + ") is already added." + " Skipping this task which checks the secondary " + "group membership for the same user in the same group."));
            } else {
                Trace.out((String)((((TaskGroupMembership)ugt).checkPrimary() ? "Primary" : "Secondary") + " Group membership check for user (" + taskToAdd.getUserName() + ") in group (" + taskToAdd.getGroupName() + ") is already added on nodes " + VerificationUtil.strArr2List(ugt.getNodeList())));
            }
            taskObjAdded = ugt;
            addTask = false;
        }
        if (addTask) {
            if (taskObjToReplace == null) {
                this.m_subTaskList.add(t);
            } else {
                ArrayList<Task> tempTaskList = new ArrayList<Task>();
                for (Task task : this.m_subTaskList) {
                    if (task == taskObjToReplace) {
                        tempTaskList.add(t);
                        continue;
                    }
                    tempTaskList.add(task);
                }
                this.m_subTaskList.clear();
                this.m_subTaskList.addAll(tempTaskList);
            }
        }
        return taskObjAdded;
    }

    @Override
    public void setNodeList(String[] nodeList) {
        this.m_nodeList = nodeList;
        for (Task t : this.m_subTaskList) {
            t.setNodeList(this.m_nodeList);
        }
    }

    @Override
    public boolean hasSubtasks() {
        return !this.m_subTaskList.isEmpty();
    }

    @Override
    public List<VerificationTask> getSubtasks() throws SubtasksUnavailableException {
        ArrayList<VerificationTask> listOfSubtasks = new ArrayList<VerificationTask>();
        if (this.m_subTaskList.isEmpty()) {
            throw new SubtasksUnavailableException(s_msgBundle.getMessage("7504", false));
        }
        for (Task t : this.m_subTaskList) {
            listOfSubtasks.add(t);
        }
        return listOfSubtasks;
    }

    @Override
    public boolean isContainerTask() {
        if (m_containerObj != null) {
            this.init();
            return true;
        }
        return false;
    }

    private boolean compare(TaskGroupMembership t1, TaskGroupMembership t2) {
        if (t1.getGroupName().equals(t2.getGroupName()) && t1.getUserName().equals(t2.getUserName())) {
            return VerificationUtil.compareStringCollections(t1.getNodeList(), t2.getNodeList(), true, true);
        }
        return false;
    }

    private Collection<Task> getSubtaskList() {
        HashMap<String, Task> finalSubTaskList = new HashMap<String, Task>();
        for (Task t : this.m_subTaskList) {
            String groupName = ((TaskGroupMembership)t).getGroupName();
            String userName = ((TaskGroupMembership)t).getUserName();
            boolean isPrimary = ((TaskGroupMembership)t).checkPrimary();
            String key = groupName + ":" + userName + ":" + Boolean.toString(isPrimary);
            if (finalSubTaskList.containsKey(key)) {
                String[] addedTaskNodeList = ((Task)finalSubTaskList.get(key)).getNodeList();
                String[] currentTaskNodeList = t.getNodeList();
                Trace.out((String)("The group membership check for user (" + userName + ") in group (" + groupName + ") as (" + (isPrimary ? "Primary" : "Secondary") + ") has multiple instances with node set as following:\n" + VerificationUtil.strArr2List(addedTaskNodeList) + "\n" + VerificationUtil.strArr2List(currentTaskNodeList) + "\n Consolidating the multiple instances with their node list" + " to generate one instance of this group membership check."));
                HashSet<String> consolidatesNodes = new HashSet<String>();
                consolidatesNodes.addAll(Arrays.asList(addedTaskNodeList));
                consolidatesNodes.addAll(Arrays.asList(currentTaskNodeList));
                finalSubTaskList.put(key, new TaskGroupMembership(userName, groupName, isPrimary, consolidatesNodes.toArray(new String[0])));
                continue;
            }
            finalSubTaskList.put(key, t);
        }
        return finalSubTaskList.values();
    }

    @Override
    public Task getContainerObject() {
        return m_containerObj;
    }

    @Override
    public Task finalizeContainer() {
        Trace.out((String)"Finalizing the container.");
        TaskGroupMembership container = new TaskGroupMembership(m_containerObj.getSubtaskList());
        m_containerObj = null;
        return container;
    }

    private static enum NonLocalEntity {
        USER,
        GROUP,
        NONE;

    }
}

