/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.fixup.FixupData;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.ContainerTaskInterface;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskPeerCompatibility;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskGroupExistence
extends TaskPeerCompatibility
implements ContainerTaskInterface,
PeerCompatibleTask {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1052", false);
    private static TaskGroupExistence m_containerObj = null;
    private List<Task> m_subTaskList = new ArrayList<Task>();
    private boolean m_returnVal = true;
    private boolean m_isInitialized = false;
    private String m_group;
    private Hashtable<Object, Vector<Object>> grpIdTable;
    private static Hashtable<Object, Vector<Object>> m_grpTable = new Hashtable();
    private static List<String> m_groupExistenceCheckAddedGroupsList = new ArrayList<String>();
    private static List<String> m_groupExistenceCheckPerformedGroupsList = new ArrayList<String>();

    public TaskGroupExistence(VerificationTaskContext ctx) {
        super(ctx);
        if (m_containerObj == null) {
            m_containerObj = new TaskGroupExistence();
        }
    }

    @Override
    protected void init() {
        if (!this.m_isInitialized) {
            if (this.m_ctx != null) {
                ExecutableInfo execInfo = this.m_ctx.getExecInfo();
                if (execInfo != null) {
                    for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
                        String argName = arg.getArgName();
                        String argVal = arg.getArgVal(true);
                        if ("GROUP".equals(argName)) {
                            this.m_group = argVal;
                            continue;
                        }
                        Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
                    }
                }
                VerificationType vType = this.m_globalContext.getVerificationType();
                switch (vType) {
                    case PREREQ_NODE_ADD: 
                    case PREREQ_RACNODE_ADD: {
                        Trace.out((String)"Node add scenario, considering the newly being added nodes for the group existence check");
                        this.m_ctx.setNodeList(VerificationUtil.addLocalNodeToNodeList(this.m_nodeList));
                    }
                }
                if (VerificationUtil.isStringGood(this.m_group)) {
                    m_containerObj.addTaskToContainer(new TaskGroupExistence(this.m_ctx, this.m_group));
                } else {
                    VerificationUtil.traceAndLogWarning("Not adding this check. The group (" + this.m_group + ") is invalid.");
                }
            } else {
                this.m_ctx = new VerificationTaskContext(this.m_nodeList);
            }
            this.m_isInitialized = true;
        }
    }

    private TaskGroupExistence(VerificationTaskContext ctx, String group) {
        super(ctx);
        this.m_group = group;
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (!this.m_subTaskList.isEmpty()) {
            ArrayList<Task> applicableList = new ArrayList<Task>();
            for (Task t : this.m_subTaskList) {
                if (t.isApplicable()) {
                    Trace.out((String)(t.getTaskName() + " is applicable from this container."));
                    applicableList.add(t);
                    continue;
                }
                Trace.out((String)(t.getTaskName() + " is NOT applicable from this container."));
            }
            this.m_subTaskList.clear();
            this.m_subTaskList.addAll(applicableList);
            return !this.m_subTaskList.isEmpty();
        }
        if (VerificationUtil.isStringGood(this.m_group)) {
            if (m_groupExistenceCheckAddedGroupsList.contains(this.m_group)) {
                Trace.out((String)"Group existence check is already added for this group.");
                return false;
            }
            m_groupExistenceCheckAddedGroupsList.add(this.m_group);
            return true;
        }
        return false;
    }

    private TaskGroupExistence(String group, String[] nodeList) {
        this(new VerificationTaskContext(nodeList), group);
    }

    private TaskGroupExistence() {
    }

    private TaskGroupExistence(Collection<Task> subTaskList) {
        this.m_subTaskList.addAll(subTaskList);
    }

    public static TaskGroupExistence generate(String group, String[] nodeList) {
        return TaskGroupExistence.generate(group, nodeList, true);
    }

    public static TaskGroupExistence generate(String group, String[] nodeList, boolean addToContainer) {
        if (!VerificationUtil.isStringGood(group)) {
            VerificationUtil.traceAndLogError("An attempt was made to instantiate group existence check with null group (" + group + ") name");
            return null;
        }
        if (!addToContainer) {
            return new TaskGroupExistence(group, nodeList);
        }
        if (m_containerObj == null) {
            m_containerObj = new TaskGroupExistence();
        }
        return (TaskGroupExistence)m_containerObj.addTaskToContainer(new TaskGroupExistence(group, nodeList));
    }

    @Override
    public boolean performTask() {
        if (this.m_resultSet.getStatus() == 5) {
            this.m_returnVal = this.performTaskInternal();
        } else {
            Trace.out((String)"This task was performed earlier, returning based on earlier result");
            this.m_resultSet.traceResultSet("RESULT From earlier execution of this task");
        }
        return this.m_returnVal;
    }

    private boolean performTaskInternal() {
        ErrorDescription errDesc;
        this.grpIdTable = new Hashtable();
        boolean isFixable = this.isFixupReqd();
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet grpRsltSet = new ResultSet();
        globalExec.checkGroup(this.m_nodeList, this.m_group, grpRsltSet);
        this.m_resultSet.addResultSetData(grpRsltSet);
        m_groupExistenceCheckPerformedGroupsList.add(this.m_group);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_group}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
        Hashtable ht = grpRsltSet.getResultTable();
        Enumeration<Object> e = ht.keys();
        while (e.hasMoreElements()) {
            String grpStatus;
            String comment;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            result.setHasResultValues(true);
            result.setExpectedValue(Boolean.toString(true));
            if (result.getStatus() == 1) {
                comment = ReportUtil.EXIST;
                grpStatus = ReportUtil.PASSED;
                Vector groupInfoVector = result.getResultInfoSet();
                String grpID = (String)groupInfoVector.elementAt(1);
                if (groupInfoVector.size() > 2) {
                    String grpIDLocal = (String)groupInfoVector.elementAt(2);
                    VerificationUtil.traceAndLogError("The group (" + this.m_group + ") is locally defined with group id (" + grpIDLocal + ") which is different than the NIS/LDAP group ID (" + grpID + ") for the same group visible on node " + node);
                    comment = ReportUtil.MISMATCHED;
                    grpStatus = ReportUtil.FAILED;
                    errDesc = new ErrorDescription(VerificationUtil.getMsgWithExecutionDetails(s_gMsgBundle.getMessage("0280", true, (Object[])new String[]{this.m_group, grpIDLocal, node, grpID}), result));
                    this.m_resultSet.addErrorDescription(node, errDesc);
                    this.m_resultSet.addResult(node, 3);
                    isFixable = false;
                } else {
                    VerificationUtil.updateResultMap(m_grpTable, this.m_group, node);
                    VerificationUtil.updateResultMap(this.grpIdTable, grpID, node);
                    result.setExpectedValue(Boolean.toString(true));
                }
            } else if (result.getStatus() == 3) {
                comment = ReportUtil.NOTEXIST;
                grpStatus = ReportUtil.FAILED;
                String errMsg = s_msgBundle.getMessage("7539", true, (Object[])new String[]{this.m_group, node});
                String csGroupPrivileges = VerificationUtil.getGroupPrivileges(this.m_group);
                if (VerificationUtil.isStringGood(csGroupPrivileges)) {
                    errMsg = s_gMsgBundle.getMessage("10461", true, (Object[])new String[]{this.m_group, csGroupPrivileges, node});
                }
                errDesc = new ErrorDescription(VerificationUtil.getMsgWithExecutionDetails(errMsg, result));
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                result.setExpectedValue(Boolean.toString(false));
            } else {
                grpStatus = ReportUtil.UNKNOWN;
                comment = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(VerificationUtil.getMsgWithExecutionDetails(s_msgBundle.getMessage("7540", true, (Object[])new String[]{node}), result));
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            }
            ReportUtil.writeRecord(node, grpStatus, comment);
        }
        if (this.grpIdTable.size() > 1) {
            String errorMsg = s_msgBundle.getMessage("4020", true, (Object[])new String[]{this.m_group});
            ReportUtil.printError(errorMsg);
            errDesc = new ErrorDescription(errorMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            e = this.grpIdTable.keys();
            StringBuffer grpIdsDisplayString = new StringBuffer();
            boolean first = true;
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Vector<Object> nodeVector = this.grpIdTable.get(key);
                String nodes = VerificationUtil.strVect2List(nodeVector);
                if (first) {
                    first = false;
                    grpIdsDisplayString.append("[");
                } else {
                    grpIdsDisplayString.append("; ");
                }
                grpIdsDisplayString.append(key + ":" + nodes);
                String errorMessage = s_msgBundle.getMessage("4021", false, (Object[])new String[]{key, nodes});
                ReportUtil.sureprintln(errorMessage);
            }
            grpIdsDisplayString.append("]");
            ErrorDescription grpIdsED = new ErrorDescription(errorMsg + " " + grpIdsDisplayString.toString(), s_msgBundle, "4020");
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, grpIdsED);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_group}));
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0308", false, (Object[])new String[]{this.m_group}));
            return true;
        }
        if (isFixable) {
            this.generateFixups();
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_group}));
        this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0309", false, (Object[])new String[]{this.m_group, VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        ReportUtil.reportAllerrors(this.m_resultSet);
        return false;
    }

    private void generateFixups() {
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            return;
        }
        Trace.out((String)"Generating fixups");
        FixupData fixData = null;
        String uniqueIDOfInterest = null;
        if (this.grpIdTable.size() > 0) {
            Set<Object> idSet = this.grpIdTable.keySet();
            int maxNumOfnodesWithID = 0;
            for (Object id : idSet) {
                if (this.grpIdTable.get(id).size() <= maxNumOfnodesWithID) continue;
                maxNumOfnodesWithID = this.grpIdTable.get(id).size();
                uniqueIDOfInterest = (String)id;
            }
        }
        if (null != (fixData = this.createFixupData(uniqueIDOfInterest))) {
            this.setFixupData(fixData);
        }
    }

    private FixupData createFixupData(String groupID) {
        FixupData fixGroupData = new FixupData(null);
        ArrayList<String> createGroupNodeList = new ArrayList<String>();
        ArrayList<String> updateGroupNodeList = new ArrayList<String>();
        ArrayList groupExistsNodeList = new ArrayList();
        if (VerificationUtil.isStringGood(groupID) && this.grpIdTable.size() > 0 && this.grpIdTable.containsKey(groupID)) {
            groupExistsNodeList.addAll(this.grpIdTable.get(groupID));
        }
        for (String node : this.m_nodeList) {
            if (groupExistsNodeList.contains(node)) continue;
            if (this.grpIdTable.containsValue(node)) {
                updateGroupNodeList.add(node);
                continue;
            }
            createGroupNodeList.add(node);
        }
        if (!VerificationUtil.isStringGood(groupID)) {
            GlobalExecution global = new GlobalExecution();
            ResultSet getIDResultSet = new ResultSet();
            List<String> uniqueIDList = global.getUniqueGID(createGroupNodeList.toArray(new String[0]), 1, getIDResultSet);
            if (uniqueIDList.size() > 0) {
                groupID = uniqueIDList.get(0);
            }
            if (!VerificationUtil.isStringGood(groupID)) {
                for (String node : createGroupNodeList) {
                    fixGroupData.addFixupGenerationFailedNode(node, new ErrorDescription(s_gMsgBundle.getMessage("9041", true, (Object[])new String[]{node})));
                }
                return fixGroupData;
            }
        }
        fixGroupData.addParticipatingNodes(createGroupNodeList);
        fixGroupData.addParticipatingNodes(updateGroupNodeList);
        fixGroupData.addFixupInstruction("GROUP", this.m_group);
        fixGroupData.addFixupInstruction("GID", groupID);
        String message = "Created fixup with \n Group name (" + this.m_group + ")" + "\n Group ID (" + groupID + ")" + (createGroupNodeList.size() > 0 ? "\n to create the group on nodes " + createGroupNodeList : "") + (updateGroupNodeList.size() > 0 ? "\n to update the group on nodes " + updateGroupNodeList : "");
        Trace.out((String)message);
        VerificationLogData.logInfo(message);
        return fixGroupData;
    }

    public static List<String> getNodesWithGroup(String grpName) {
        if (!m_groupExistenceCheckPerformedGroupsList.contains(grpName)) {
            return null;
        }
        ArrayList<String> nodesWithGrp = new ArrayList<String>();
        if (m_grpTable.containsKey(grpName)) {
            nodesWithGrp.addAll(m_grpTable.get(grpName));
        }
        return nodesWithGrp;
    }

    @Override
    public String getTaskID() {
        return "CHECK_GROUP_EXISTENCE";
    }

    @Override
    public String getTaskName() {
        return this.getTaskID() + "_" + this.m_group;
    }

    @Override
    public String getDefaultElementName() {
        if (VerificationUtil.isStringGood(this.m_group)) {
            return s_msgBundle.getMessage("4409", false) + ": " + this.m_group;
        }
        return s_msgBundle.getMessage("4409", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4459", false, (Object[])new String[]{this.m_group});
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet grpRsltSet = new ResultSet();
        globalExec.checkGroup(this.m_nodeList, this.m_group, grpRsltSet);
        Hashtable ht = grpRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                String grpID = (String)result.getResultInfoSet().elementAt(1);
                result.getResultInfoSet().add(0, this.m_group + "(" + grpID + ")");
                continue;
            }
            if (result.getStatus() != 3) continue;
            result.getResultInfoSet().add(0, ReportUtil.NOTEXIST);
            result.setStatus(1);
        }
        return grpRsltSet;
    }

    @Override
    public String getElementDisplayName() {
        return s_msgBundle.getMessage("9972", false, (Object[])new String[]{this.m_group});
    }

    @Override
    public Task addTaskToContainer(Task t) {
        Task taskObj = t;
        boolean addTask = true;
        for (Task uet : this.m_subTaskList) {
            if (!TaskGroupExistence.compare((TaskGroupExistence)t, (TaskGroupExistence)uet)) continue;
            Trace.out((String)("Found an existing instance of group existence check for group (" + ((TaskGroupExistence)t).getGroupName() + ") on nodes " + VerificationUtil.strArr2List(t.getNodeList())));
            taskObj = uet;
            addTask = false;
        }
        if (addTask) {
            this.m_subTaskList.add(t);
        }
        return taskObj;
    }

    public String getGroupName() {
        return this.m_group;
    }

    private static boolean compare(TaskGroupExistence t1, TaskGroupExistence t2) {
        return t1.getGroupName().trim().equalsIgnoreCase(t2.getGroupName().trim()) && VerificationUtil.compareStringCollections(t1.getNodeList(), t2.getNodeList(), true, true);
    }

    @Override
    public boolean hasSubtasks() {
        return !this.m_subTaskList.isEmpty();
    }

    @Override
    public List<VerificationTask> getSubtasks() throws SubtasksUnavailableException {
        ArrayList<VerificationTask> listOfSubtasks = new ArrayList<VerificationTask>();
        if (this.m_subTaskList.isEmpty()) {
            throw new SubtasksUnavailableException(s_msgBundle.getMessage("7504", false));
        }
        for (Task t : this.m_subTaskList) {
            listOfSubtasks.add(t);
        }
        return listOfSubtasks;
    }

    @Override
    public void setNodeList(String[] nodeList) {
        this.m_nodeList = nodeList;
        for (Task t : this.m_subTaskList) {
            t.setNodeList(this.m_nodeList);
        }
    }

    @Override
    public boolean isContainerTask() {
        if (m_containerObj != null) {
            this.init();
            return true;
        }
        return false;
    }

    private Collection<Task> getSubtaskList() {
        HashMap<String, Task> finalSubTaskList = new HashMap<String, Task>();
        for (Task t : this.m_subTaskList) {
            String groupName = ((TaskGroupExistence)t).getGroupName();
            if (finalSubTaskList.containsKey(groupName)) {
                String[] addedTaskNodeList = ((Task)finalSubTaskList.get(groupName)).getNodeList();
                String[] currentTaskNodeList = t.getNodeList();
                Trace.out((String)("The group existence check for group (" + groupName + ") has multiple instances with node set as following:\n" + VerificationUtil.strArr2List(addedTaskNodeList) + "\n" + VerificationUtil.strArr2List(currentTaskNodeList) + "\n Consolidating the multiple instances with their node list" + " to generate one instance of the group existence."));
                HashSet<String> consolidatesNodes = new HashSet<String>();
                consolidatesNodes.addAll(Arrays.asList(addedTaskNodeList));
                consolidatesNodes.addAll(Arrays.asList(currentTaskNodeList));
                finalSubTaskList.put(groupName, new TaskGroupExistence(groupName, consolidatesNodes.toArray(new String[0])));
                continue;
            }
            finalSubTaskList.put(groupName, t);
        }
        return finalSubTaskList.values();
    }

    @Override
    public Task getContainerObject() {
        return m_containerObj;
    }

    @Override
    public Task finalizeContainer() {
        Trace.out((String)"Finalizing the container.");
        TaskGroupExistence container = new TaskGroupExistence(m_containerObj.getSubtaskList());
        m_containerObj = null;
        return container;
    }
}

